# WebService::Fastly::ObjectStoreItemApi

## Load the API package
```perl
use WebService::Fastly::Object::ObjectStoreItemApi;
```

All URIs are relative to *https://api.fastly.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**delete_key_from_store**](ObjectStoreItemApi.md#delete_key_from_store) | **DELETE** /resources/stores/object/{store_id}/keys/{key_name} | Delete object store item.
[**get_keys**](ObjectStoreItemApi.md#get_keys) | **GET** /resources/stores/object/{store_id}/keys | List object store keys.
[**get_value_for_key**](ObjectStoreItemApi.md#get_value_for_key) | **GET** /resources/stores/object/{store_id}/keys/{key_name} | Get the value of an object store item
[**set_value_for_key**](ObjectStoreItemApi.md#set_value_for_key) | **PUT** /resources/stores/object/{store_id}/keys/{key_name} | Insert an item into an object store


# **delete_key_from_store**
> delete_key_from_store(store_id => $store_id, key_name => $key_name)

Delete object store item.

Delete an item from an object store

### Example
```perl
use Data::Dumper;
use WebService::Fastly::ObjectStoreItemApi;
my $api_instance = WebService::Fastly::ObjectStoreItemApi->new(

    # Configure API key authorization: token
    api_key => {'Fastly-Key' => 'YOUR_API_KEY'},
    # uncomment below to setup prefix (e.g. Bearer) for API key, if needed
    #api_key_prefix => {'Fastly-Key' => 'Bearer'},
);

my $store_id = "store_id_example"; # string | 
my $key_name = "key_name_example"; # string | 

eval {
    $api_instance->delete_key_from_store(store_id => $store_id, key_name => $key_name);
};
if ($@) {
    warn "Exception when calling ObjectStoreItemApi->delete_key_from_store: $@\n";
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **store_id** | **string**|  | 
 **key_name** | **string**|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_keys**
> InlineResponse2004 get_keys(store_id => $store_id, cursor => $cursor, limit => $limit)

List object store keys.

List the keys of all items within an object store.

### Example
```perl
use Data::Dumper;
use WebService::Fastly::ObjectStoreItemApi;
my $api_instance = WebService::Fastly::ObjectStoreItemApi->new(

    # Configure API key authorization: token
    api_key => {'Fastly-Key' => 'YOUR_API_KEY'},
    # uncomment below to setup prefix (e.g. Bearer) for API key, if needed
    #api_key_prefix => {'Fastly-Key' => 'Bearer'},
);

my $store_id = "store_id_example"; # string | 
my $cursor = "cursor_example"; # string | 
my $limit = 100; # int | 

eval {
    my $result = $api_instance->get_keys(store_id => $store_id, cursor => $cursor, limit => $limit);
    print Dumper($result);
};
if ($@) {
    warn "Exception when calling ObjectStoreItemApi->get_keys: $@\n";
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **store_id** | **string**|  | 
 **cursor** | **string**|  | [optional] 
 **limit** | **int**|  | [optional] [default to 100]

### Return type

[**InlineResponse2004**](InlineResponse2004.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_value_for_key**
> string get_value_for_key(store_id => $store_id, key_name => $key_name)

Get the value of an object store item

Get the value associated with a key.

### Example
```perl
use Data::Dumper;
use WebService::Fastly::ObjectStoreItemApi;
my $api_instance = WebService::Fastly::ObjectStoreItemApi->new(

    # Configure API key authorization: token
    api_key => {'Fastly-Key' => 'YOUR_API_KEY'},
    # uncomment below to setup prefix (e.g. Bearer) for API key, if needed
    #api_key_prefix => {'Fastly-Key' => 'Bearer'},
);

my $store_id = "store_id_example"; # string | 
my $key_name = "key_name_example"; # string | 

eval {
    my $result = $api_instance->get_value_for_key(store_id => $store_id, key_name => $key_name);
    print Dumper($result);
};
if ($@) {
    warn "Exception when calling ObjectStoreItemApi->get_value_for_key: $@\n";
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **store_id** | **string**|  | 
 **key_name** | **string**|  | 

### Return type

**string**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/octet-stream

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **set_value_for_key**
> string set_value_for_key(store_id => $store_id, key_name => $key_name, body => $body)

Insert an item into an object store

Set a new value for a new or existing key in an object store.

### Example
```perl
use Data::Dumper;
use WebService::Fastly::ObjectStoreItemApi;
my $api_instance = WebService::Fastly::ObjectStoreItemApi->new(

    # Configure API key authorization: token
    api_key => {'Fastly-Key' => 'YOUR_API_KEY'},
    # uncomment below to setup prefix (e.g. Bearer) for API key, if needed
    #api_key_prefix => {'Fastly-Key' => 'Bearer'},
);

my $store_id = "store_id_example"; # string | 
my $key_name = "key_name_example"; # string | 
my $body = WebService::Fastly::Object::string->new(); # string | 

eval {
    my $result = $api_instance->set_value_for_key(store_id => $store_id, key_name => $key_name, body => $body);
    print Dumper($result);
};
if ($@) {
    warn "Exception when calling ObjectStoreItemApi->set_value_for_key: $@\n";
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **store_id** | **string**|  | 
 **key_name** | **string**|  | 
 **body** | **string****string**|  | [optional] 

### Return type

**string**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/octet-stream
 - **Accept**: application/octet-stream

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

