#!perl -w -I../lib -I../blib/arch 
use feature ':5.12';
use strict;
use Data::Dumper;
use warnings all=>'FATAL';

use Test::More;
use DBM::Deep::Blue;

#gdb --args c:/strawberry/perl/bin/perl.exe load1.t
#-----------------------------------------------------------------------
# Load a large structure and test retrieval of values in this structure.
#-----------------------------------------------------------------------

mkdir("memory");
my $f= "memory/load.data";
unlink $f;

my $m = DBM::Deep::Blue::file($f);
my $h = $m->allocGlobalHash();

$h->{data} = &data();
$h->{DATA} = &data();

ok is  Dumper($h->{DATA}), Dumper($h->{data}), "Dumps match";
 
done_testing;

#-----------------------------------------------------------------------
# Data structure
#-----------------------------------------------------------------------

sub data()
 {return
{
  "../images/images/Ethiopia.PNG"        => {
                                              height  => 535,
                                              objects => {
                                                           eyes  => [[100, 125, 20, "Square"], [142, 124, 20, "Square"]],
                                                           feet  => [[192, 491, 30, "Square"], [241, 512, 30, "Square"]],
                                                           hair  => [[127, 52, 45, "Square"]],
                                                           head  => [[124, 98, 90, "Square"]],
                                                           mouth => [[124, 166, 20, "Square"]],
                                                           nose  => [[122, 148, 20, "Square"]],
                                                           toes  => [
                                                                      [194, 522, 20, "Square"],
                                                                      [208, 512, 20, "Square"],
                                                                      [244, 520, 20, "Square"],
                                                                    ],
                                                         },
                                              width   => 285,
                                            },
  "../images/images/TV.PNG"              => {
                                              height  => 864,
                                              objects => {
                                                           television                                                                         => [
                                                                                                                                                   [708, 127, 120, "Square"],
                                                                                                                                                   [948, 125, 120, "Square"],
                                                                                                                                                   [825, 291, 45, "Square"],
                                                                                                                                                   [919, 292, 45, "Square"],
                                                                                                                                                   [1010, 287, 45, "Square"],
                                                                                                                                                   [1004, 348, 45, "Square"],
                                                                                                                                                 ],
                                                           "the CD on top of the table"                                                       => [[577, 312, 45, "Square"]],
                                                           "the axle of the castor wheel nearest the skirting board"                          => [[1019, 795, 8, "Circle"], [1041, 795, 8, "Circle"]],
                                                           "the castor wheel of the television table nearest the glass vase"                  => [[517, 657, 12, "Circle"]],
                                                           "the drawer handle with the most white inside it"                                  => [[13, 572, 12, "Circle"]],
                                                           "the highest point of the white book in the basket"                                => [[356, 680, 12, "Circle"]],
                                                           "the large plug in the wall"                                                       => [[1092, 620, 12, "Circle"]],
                                                           "the left handle of the basket"                                                    => [[206, 659, 45, "Circle"]],
                                                           "the logo on the television"                                                       => [
                                                                                                                                                   [760, 252, 8, "Square"],
                                                                                                                                                   [773, 256, 8, "Square"],
                                                                                                                                                   [786, 262, 8, "Square"],
                                                                                                                                                 ],
                                                           "the photo on the bookshelf"                                                       => [[79, 377, 45, "Square"], [95, 422, 45, "Square"]],
                                                           "the remote control"                                                               => [
                                                                                                                                                   [688, 348, 20, "Square"],
                                                                                                                                                   [726, 361, 20, "Square"],
                                                                                                                                                   [743, 385, 20, "Square"],
                                                                                                                                                 ],
                                                           "the skirting board where it goes behind the vase"                                 => [
                                                                                                                                                   [338, 531, 12, "Square"],
                                                                                                                                                   [352, 523, 12, "Square"],
                                                                                                                                                   [373, 516, 12, "Square"],
                                                                                                                                                   [395, 506, 12, "Square"],
                                                                                                                                                   [407, 500, 12, "Square"],
                                                                                                                                                 ],
                                                           "the sounding hole in the guitar in the picture on the CD on the television table" => [[590, 314, 8, "Circle"]],
                                                           "the spine of the small dark blue book above the photo"                            => [[57, 311, 8, "Square"]],
                                                           "the top of the glass vase"                                                        => [[365, 494, 45, "Circle"]],
                                                           "the white bit of wall visible under the television table"                         => [[1012, 730, 8, "Circle"]],
                                                           "the yellow on the packet inside the small basket in the lower right corner"       => [[973, 859, 12, "Square"], [980, 835, 12, "Square"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/appletree.PNG"       => {
                                              height  => 864,
                                              objects => {
                                                           "the back of the garden chair"                                                                                 => [[198, 405, 45, "Square"]],
                                                           "the back wheel of the silver car"                                                                             => [[286, 376, 30, "Circle"]],
                                                           "the blossom nearest the handle of the rear door of the silver car and the garden table"                       => [[343, 365, 20, "Circle"]],
                                                           "the bottom of the lamp post"                                                                                  => [[216, 302, 8, "Circle"]],
                                                           "the bottom of the trunk of the white flowering tree where it enters the earth"                                => [[533, 615, 20, "Circle"]],
                                                           "the green shrub in the flower bed seen under the table"                                                       => [[35, 443, 30, "Square"], [79, 444, 30, "Square"]],
                                                           "the handle of the rear door of the silver car"                                                                => [[312, 312, 12, "Circle"]],
                                                           "the intersection of the curving sections of the bird cage"                                                    => [[917, 216, 8, "Circle"]],
                                                           "the large stone in the flower bed"                                                                            => [[245, 457, 20, "Circle"]],
                                                           "the largest petal lying on the lawn between the tree in blossom and the bird cage"                            => [[712, 709, 12, "Circle"]],
                                                           "the point of the picket fence seen to the right of the branch of the red tree"                                => [[69, 285, 12, "Circle"]],
                                                           "the point where the left most branch of the red tree crosses the lower horizontal branch of the picket fence" => [[51, 348, 12, "Circle"]],
                                                           "the red tail light of the car at the back"                                                                    => [[274, 263, 8, "Square"]],
                                                           "the right most window of the house with a light blue roof seen through the twigs and green leaves of a bush"  => [[709, 143, 12, "Square"]],
                                                           "the silver clamp holding the drain pipe to the side of the house"                                             => [[795, 209, 12, "Circle"]],
                                                           "the small rock in the flower bed"                                                                             => [[158, 434, 20, "Circle"]],
                                                           "the soil in the flower bed seen through the frame of the table stand"                                         => [[89, 461, 12, "Circle"]],
                                                           "the tip of the bird cage"                                                                                     => [[920, 177, 12, "Circle"]],
                                                           "the top of the wrought iron table"                                                                            => [
                                                                                                                                                                               [30, 401, 30, "Circle"],
                                                                                                                                                                               [80, 401, 30, "Circle"],
                                                                                                                                                                               [119, 398, 30, "Circle"],
                                                                                                                                                                             ],
                                                           "the window in the white wall seen through the branches of the red tree"                                       => [[20, 151, 12, "Square"]],
                                                           "the windscreen of the yellow car"                                                                             => [[75, 257, 20, "Square"], [59, 256, 20, "Square"]],
                                                           "the yellow flower in the lawn"                                                                                => [[66, 737, 8, "Circle"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/bathroomSink.PNG"    => {
                                              height  => 270,
                                              objects => {
                                                           bottle => [[39, 151, 30, "Circle"]],
                                                           candle => [[84, 143, 20, "Circle"]],
                                                           mirror => [
                                                                 [43, 26, 30, "Square"],
                                                                 [106, 28, 30, "Square"],
                                                                 [177, 20, 30, "Square"],
                                                                 [214, 15, 30, "Square"],
                                                                 [44, 57, 30, "Square"],
                                                                 [100, 43, 30, "Square"],
                                                               ],
                                                           sink => [
                                                                 [242, 130, 30, "Square"],
                                                                 [181, 129, 30, "Square"],
                                                                 [294, 126, 30, "Square"],
                                                               ],
                                                           soap => [[123, 137, 20, "Circle"]],
                                                           tap => [[194, 93, 30, "Square"]],
                                                           "the counter top between the candle and the soap" => [[101, 145, 8, "Circle"]],
                                                           "the edge of the counter top between the two black spots near the sink" => [[359, 141, 12, "Circle"]],
                                                           "the relection of the outlet of the tap" => [[74, 65, 8, "Circle"]],
                                                           "the relection of the overflow outlet" => [[26, 93, 8, "Circle"]],
                                                           "the relection of the right hand end of the tap handle" => [[138, 59, 8, "Circle"]],
                                                           "the top right corner of the drawer which is just a little open" => [[277, 230, 12, "Circle"]],
                                                           wall => [
                                                                 [287, 10, 30, "Square"],
                                                                 [345, 16, 30, "Square"],
                                                                 [409, 27, 30, "Square"],
                                                               ],
                                                         },
                                              width   => 440,
                                            },
  "../images/images/bigSmall.PNG"        => {
                                              height  => 700,
                                              objects => {
                                                           big => [
                                                                 [122, 125, 120, "Square"],
                                                                 [449, 125, 120, "Square"],
                                                                 [282, 121, 120, "Square"],
                                                                 [113, 312, 120, "Square"],
                                                                 [454, 311, 120, "Square"],
                                                                 [280, 311, 120, "Square"],
                                                               ],
                                                           small => [[647, 485, 60, "Square"]],
                                                         },
                                              width   => 800,
                                            },
  "../images/images/bike.PNG"            => {
                                              height  => 864,
                                              objects => {
                                                           "back light"                                                                                               => [[78, 336, 20, "Square"]],
                                                           basket                                                                                                     => [[883, 287, 120, "Circle"]],
                                                           bell                                                                                                       => [[763, 96, 20, "Circle"]],
                                                           "bike lock sitting on top of the saddle"                                                                   => [[317, 214, 30, "Square"]],
                                                           "front axle inside the wheel"                                                                              => [
                                                                                                                                                                           [877, 615, 8, "Square"],
                                                                                                                                                                           [880, 605, 8, "Square"],
                                                                                                                                                                           [886, 598, 8, "Square"],
                                                                                                                                                                         ],
                                                           "front light"                                                                                              => [[979, 378, 20, "Square"]],
                                                           "highest point of the white frame"                                                                         => [[728, 257, 20, "Square"]],
                                                           "left pedal"                                                                                               => [[582, 612, 30, "Square"]],
                                                           "lowest derailleur wheel"                                                                                  => [[181, 661, 20, "Circle"]],
                                                           "quick release lever for the saddle"                                                                       => [
                                                                                                                                                                           [326, 373, 8, "Square"],
                                                                                                                                                                           [342, 369, 8, "Square"],
                                                                                                                                                                           [358, 365, 8, "Square"],
                                                                                                                                                                           [376, 359, 8, "Square"],
                                                                                                                                                                         ],
                                                           "rear brake block"                                                                                         => [[287, 431, 8, "Square"], [294, 437, 8, "Square"]],
                                                           "rear brake calliper"                                                                                      => [
                                                                                                                                                                           [306, 415, 8, "Square"],
                                                                                                                                                                           [317, 405, 8, "Square"],
                                                                                                                                                                           [328, 398, 8, "Square"],
                                                                                                                                                                           [338, 386, 8, "Square"],
                                                                                                                                                                         ],
                                                           "rear brake lever"                                                                                         => [
                                                                                                                                                                           [667, 180, 8, "Square"],
                                                                                                                                                                           [675, 169, 8, "Square"],
                                                                                                                                                                           [691, 164, 8, "Square"],
                                                                                                                                                                           [707, 159, 8, "Square"],
                                                                                                                                                                         ],
                                                           "rear rack"                                                                                                => [
                                                                                                                                                                           [73, 316, 20, "Square"],
                                                                                                                                                                           [115, 318, 20, "Square"],
                                                                                                                                                                           [156, 322, 20, "Square"],
                                                                                                                                                                           [198, 322, 20, "Square"],
                                                                                                                                                                           [236, 323, 20, "Square"],
                                                                                                                                                                           [279, 323, 20, "Square"],
                                                                                                                                                                         ],
                                                           "right crank"                                                                                              => [
                                                                                                                                                                           [345, 622, 12, "Square"],
                                                                                                                                                                           [370, 625, 12, "Square"],
                                                                                                                                                                           [397, 628, 12, "Square"],
                                                                                                                                                                           [424, 629, 12, "Square"],
                                                                                                                                                                           [449, 635, 12, "Square"],
                                                                                                                                                                         ],
                                                           "right pedal"                                                                                              => [[332, 637, 30, "Square"]],
                                                           saddle                                                                                                     => [
                                                                                                                                                                           [271, 248, 30, "Square"],
                                                                                                                                                                           [333, 247, 30, "Square"],
                                                                                                                                                                           [383, 233, 20, "Square"],
                                                                                                                                                                         ],
                                                           "the C on the chain guard"                                                                                 => [[315, 559, 12, "Circle"]],
                                                           "the black part of the saddle post"                                                                        => [
                                                                                                                                                                           [348, 294, 12, "Square"],
                                                                                                                                                                           [357, 317, 12, "Square"],
                                                                                                                                                                           [364, 343, 12, "Square"],
                                                                                                                                                                         ],
                                                           "the blue ball standing on a post in the green lawn at the back"                                           => [[389, 50, 8, "Circle"]],
                                                           "the brown clay ball behind the saddle"                                                                    => [
                                                                                                                                                                           [282, 211, 8, "Square"],
                                                                                                                                                                           [297, 203, 8, "Square"],
                                                                                                                                                                           [311, 197, 8, "Square"],
                                                                                                                                                                         ],
                                                           "the chain where it meets the lower derailleur wheel"                                                      => [[194, 678, 8, "Circle"]],
                                                           "the largest C on the frame"                                                                               => [[613, 462, 20, "Circle"]],
                                                           "the lower K on the rim of the front wheel"                                                                => [[778, 737, 8, "Circle"]],
                                                           "the lower silver steering race"                                                                           => [[762, 359, 20, "Circle"]],
                                                           "the lowest bolt securing the front mudguard"                                                              => [[656, 571, 8, "Circle"]],
                                                           "the lowest tooth of the front gear wheel"                                                                 => [[458, 684, 8, "Square"]],
                                                           "the mud flap of the front mud guard"                                                                      => [[657, 610, 8, "Square"], [659, 626, 8, "Square"]],
                                                           "the nearest bolt in the shiny metal bar at the bottom of the basket"                                      => [[891, 361, 8, "Circle"]],
                                                           "the nut on the bolt holding the saddle onto the saddle post"                                              => [[327, 281, 8, "Circle"]],
                                                           "the place on the terrace where the shadow of the kick stand crosses the cement between the paving stones" => [[443, 786, 12, "Square"]],
                                                           "the place where the rear tyre meets the line separating the lawn from the terrace"                        => [[26, 637, 8, "Circle"], [52, 615, 8, "Circle"]],
                                                           "the point where the gear change cable enters the derailleur"                                              => [[129, 605, 20, "Circle"]],
                                                           "the post with no point in the middle of the shadow of a fence at the top of the terrace"                  => [[1003, 48, 8, "Square"]],
                                                           "the rear wheel tire where it touches the ground"                                                          => [
                                                                                                                                                                           [185, 754, 12, "Square"],
                                                                                                                                                                           [211, 757, 12, "Square"],
                                                                                                                                                                           [238, 759, 12, "Square"],
                                                                                                                                                                         ],
                                                           "the right handlebar grip"                                                                                 => [
                                                                                                                                                                           [597, 147, 12, "Square"],
                                                                                                                                                                           [614, 141, 12, "Square"],
                                                                                                                                                                           [638, 137, 12, "Square"],
                                                                                                                                                                         ],
                                                           "the rubber foot of the kick stand"                                                                        => [[498, 717, 8, "Circle"]],
                                                           "the security tag on the frame"                                                                            => [[409, 471, 12, "Square"], [417, 496, 12, "Square"]],
                                                           "the shadow of the front mud guard"                                                                        => [[595, 862, 12, "Square"]],
                                                           "the shadow of the left pedal"                                                                             => [[509, 848, 30, "Square"]],
                                                           "the silver steering race where the black handle bars enter the white frame"                               => [[724, 241, 20, "Circle"]],
                                                           "the smallest C on the frame"                                                                              => [[573, 425, 12, "Circle"]],
                                                           "the stepping stone to the left in the lower lawn"                                                         => [[209, 162, 20, "Square"]],
                                                           "the tap above the daffodils"                                                                              => [[661, 46, 20, "Square"]],
                                                           "the top of the highest spoke of the front wheel"                                                          => [
                                                                                                                                                                           [840, 430, 8, "Circle"],
                                                                                                                                                                           [876, 430, 8, "Circle"],
                                                                                                                                                                           [911, 435, 8, "Circle"],
                                                                                                                                                                         ],
                                                           "the top of the light brown stick supporting the right clay pot"                                           => [[494, 70, 8, "Square"]],
                                                           "the yellow flowers just below the tip of the saddle"                                                      => [[453, 260, 20, "Circle"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/blocks.PNG"          => {
                                              height  => 400,
                                              objects => {
                                                           black => [
                                                                 [373, 50, 20, "Square"],
                                                                 [371, 60, 20, "Square"],
                                                                 [372, 74, 20, "Square"],
                                                                 [372, 90, 20, "Square"],
                                                                 [372, 108, 20, "Square"],
                                                                 [373, 129, 20, "Square"],
                                                                 [373, 144, 20, "Square"],
                                                                 [372, 160, 20, "Square"],
                                                                 [372, 180, 20, "Square"],
                                                                 [372, 200, 20, "Square"],
                                                                 [372, 219, 20, "Square"],
                                                                 [372, 230, 20, "Square"],
                                                               ],
                                                           blue => [
                                                                 [103, 109, 20, "Square"],
                                                                 [36, 299, 20, "Square"],
                                                                 [229, 368, 20, "Square"],
                                                               ],
                                                           "dark green" => [[277, 210, 45, "Square"]],
                                                           "light green" => [[161, 361, 20, "Square"], [354, 309, 20, "Square"]],
                                                           orange => [
                                                                 [294, 361, 20, "Square"],
                                                                 [102, 302, 20, "Square"],
                                                                 [25, 45, 30, "Square"],
                                                                 [81, 45, 30, "Square"],
                                                                 [21, 105, 30, "Square"],
                                                                 [127, 25, 12, "Square"],
                                                                 [64, 86, 12, "Square"],
                                                                 [6, 143, 12, "Square"],
                                                               ],
                                                           pink => [
                                                                 [207, 126, 20, "Square"],
                                                                 [241, 126, 20, "Square"],
                                                                 [270, 125, 20, "Square"],
                                                                 [293, 125, 20, "Square"],
                                                                 [244, 108, 20, "Square"],
                                                               ],
                                                           purple => [[358, 363, 20, "Square"], [170, 301, 20, "Square"]],
                                                           red => [
                                                                 [40, 239, 20, "Square"],
                                                                 [101, 242, 20, "Square"],
                                                                 [169, 244, 20, "Square"],
                                                                 [35, 364, 20, "Square"],
                                                                 [239, 309, 20, "Square"],
                                                               ],
                                                           "the black line on the right hand side" => [
                                                                 [370, 44, 20, "Square"],
                                                                 [371, 65, 20, "Square"],
                                                                 [373, 84, 20, "Square"],
                                                                 [373, 101, 20, "Square"],
                                                                 [371, 119, 20, "Square"],
                                                                 [374, 138, 20, "Square"],
                                                                 [371, 156, 20, "Square"],
                                                                 [371, 178, 20, "Square"],
                                                                 [372, 197, 20, "Square"],
                                                                 [373, 217, 20, "Square"],
                                                                 [372, 230, 20, "Square"],
                                                               ],
                                                           "the block in the top left corner of the grey square" => [[168, 305, 20, "Square"]],
                                                           "the blue block in the lower right corner of the grey square" => [[228, 363, 20, "Square"]],
                                                           "the blue square above the yellow oblong" => [[104, 106, 20, "Square"]],
                                                           "the blue square at the bottom" => [[232, 365, 20, "Square"]],
                                                           "the blue square on the left hand side" => [[41, 303, 20, "Square"]],
                                                           "the blue square on top of the yellow block" => [[108, 112, 20, "Square"]],
                                                           "the green block in the bottom row" => [[163, 366, 20, "Square"]],
                                                           "the green block in the lower left corner of the grey square" => [[161, 365, 20, "Square"]],
                                                           "the green block on top of the purple block" => [[359, 308, 20, "Square"]],
                                                           "the green circle under the pink triangle" => [
                                                                 [270, 178, 20, "Square"],
                                                                 [296, 183, 20, "Square"],
                                                                 [309, 206, 20, "Square"],
                                                                 [309, 236, 20, "Square"],
                                                                 [279, 244, 20, "Square"],
                                                                 [247, 232, 20, "Square"],
                                                                 [239, 199, 20, "Square"],
                                                               ],
                                                           "the left most square in the second row from the bottom" => [[43, 304, 20, "Square"]],
                                                           "the lower green block in the grey square" => [[169, 366, 20, "Square"]],
                                                           "the orange block under the yellow square" => [[296, 368, 20, "Square"]],
                                                           "the orange triangle in the upper left corner" => [
                                                                 [11, 40, 20, "Square"],
                                                                 [41, 40, 20, "Square"],
                                                                 [75, 40, 20, "Square"],
                                                                 [111, 33, 20, "Square"],
                                                                 [12, 82, 20, "Square"],
                                                                 [12, 113, 20, "Square"],
                                                                 [49, 74, 20, "Square"],
                                                                 [37, 100, 20, "Square"],
                                                               ],
                                                           "the pink triangle under the yellow block" => [
                                                                 [201, 128, 20, "Square"],
                                                                 [236, 128, 20, "Square"],
                                                                 [275, 125, 20, "Square"],
                                                                 [293, 123, 20, "Square"],
                                                                 [245, 91, 20, "Square"],
                                                               ],
                                                           "the purple block in the lower right corner" => [[355, 361, 20, "Square"]],
                                                           "the purple square to the left of the red square" => [[164, 301, 20, "Square"]],
                                                           "the red block in front of the grey square" => [[233, 304, 20, "Square"]],
                                                           "the red block in the lower left corner" => [[40, 359, 20, "Square"]],
                                                           "the red square to the right of the purple square" => [[229, 300, 20, "Square"]],
                                                           "the upper red block in the grey square" => [[232, 305, 20, "Square"]],
                                                           "the white circle in the middle of the green circle" => [[277, 211, 20, "Square"]],
                                                           "the yellow block above the pink triangle" => [
                                                                 [192, 41, 20, "Square"],
                                                                 [231, 42, 20, "Square"],
                                                                 [270, 42, 20, "Square"],
                                                                 [316, 42, 20, "Square"],
                                                               ],
                                                           "the yellow block above the three red blocks" => [
                                                                 [43, 180, 30, "Square"],
                                                                 [98, 181, 30, "Square"],
                                                                 [165, 181, 30, "Square"],
                                                                 [131, 181, 30, "Square"],
                                                               ],
                                                           "three red squares in a line" => [
                                                                 [40, 241, 20, "Square"],
                                                                 [93, 242, 20, "Square"],
                                                                 [129, 240, 20, "Square"],
                                                                 [168, 240, 20, "Square"],
                                                               ],
                                                         },
                                              width   => 400,
                                            },
  "../images/images/blocks3d.PNG"        => {
                                              height  => 400,
                                              objects => {
                                                           blue => [[181, 294, 60, "Square"]],
                                                           green => [[24, 227, 60, "Square"]],
                                                           red => [[230, 86, 60, "Square"], [230, 86, 60, "Square"]],
                                                           "the block above the grey square" => [[233, 72, 60, "Square"]],
                                                           "the block in front of the grey square" => [[187, 281, 60, "Square"]],
                                                           "the block to the left of the grey square" => [[25, 215, 60, "Square"]],
                                                           "the block to the right of the grey square" => [[384, 218, 60, "Square"]],
                                                           "the block under the red block" => [
                                                                 [190, 181, 45, "Square"],
                                                                 [275, 183, 45, "Square"],
                                                                 [288, 254, 30, "Square"],
                                                               ],
                                                           yellow => [[374, 231, 45, "Square"]],
                                                         },
                                              width   => 400,
                                            },
  "../images/images/cableCar.PNG"        => {
                                              height  => 190,
                                              objects => {
                                                           "blue jeans" => [[84, 105, 30, "Square"]],
                                                           "red ski boots" => [[240, 138, 8, "Square"]],
                                                           sign => [[41, 21, 30, "Square"]],
                                                           "the logo on the side of the cable car" => [[123, 93, 8, "Square"], [134, 96, 8, "Square"]],
                                                         },
                                              width   => 300,
                                            },
  "../images/images/chandelier.PNG"      => {
                                              height  => 606,
                                              objects => {
                                                           "the corner where the ceiling meets both walls"            => [[179, 124, 12, "Circle"]],
                                                           "the flower pot reflected in the mirror"                   => [[646, 524, 8, "Square"]],
                                                           "the left most curtain ring"                               => [[24, 171, 12, "Circle"]],
                                                           "the left most mug in the dresser reflected in the mirror" => [[525, 539, 12, "Square"]],
                                                           "the lower left corner of the mirror frame"                => [[420, 552, 12, "Square"]],
                                                           "the picture reflected in the mirror"                      => [[667, 431, 20, "Square"]],
                                                           "the right hand end of the curtain rail"                   => [[97, 190, 12, "Circle"]],
                                                           "the right most light bulb"                                => [[701, 233, 30, "Circle"]],
                                                           "the ring near the top through which the cable goes"       => [[575, 70, 12, "Circle"]],
                                                           "the top most link of the chain"                           => [[575, 12, 8, "Circle"]],
                                                           "the top of the left most glass pendant"                   => [[433, 321, 8, "Circle"]],
                                                         },
                                              width   => 785,
                                            },
  "../images/images/cooker.PNG"          => {
                                              height  => 864,
                                              objects => {
                                                           "the base of the stand used to hold spoons"                                => [[490, 584, 20, "Circle"]],
                                                           "the biggest burner on the cooker"                                         => [[555, 707, 20, "Circle"]],
                                                           "the bowl of the spoon"                                                    => [[504, 344, 12, "Circle"], [488, 570, 12, "Circle"]],
                                                           "the clock on the cooker front"                                            => [[566, 774, 8, "Square"], [580, 770, 8, "Square"]],
                                                           "the contents of the top shelf of the right most glass fronted cupboard"   => [[990, 219, 30, "Square"], [1051, 218, 30, "Square"]],
                                                           "the cooker top"                                                           => [
                                                                                                                                           [566, 689, 45, "Square"],
                                                                                                                                           [654, 690, 45, "Square"],
                                                                                                                                           [476, 687, 45, "Square"],
                                                                                                                                         ],
                                                           "the counter under the cupboard with glass doors"                          => [
                                                                                                                                           [790, 657, 45, "Square"],
                                                                                                                                           [879, 658, 45, "Square"],
                                                                                                                                           [969, 658, 45, "Square"],
                                                                                                                                           [1047, 659, 45, "Square"],
                                                                                                                                         ],
                                                           "the glass fronted cupboard"                                               => [[873, 289, 120, "Square"], [997, 289, 120, "Square"]],
                                                           "the left end of the nearest handle where it joins the cupboard"           => [[81, 200, 12, "Circle"]],
                                                           "the lid on the top of the green plastic bottle"                           => [[1131, 537, 8, "Circle"]],
                                                           "the portrait on the mug"                                                  => [[697, 332, 12, "Circle"]],
                                                           "the reflection of the photographer's hand"                                => [[799, 368, 12, "Circle"]],
                                                           "the right most knob on the cooker front"                                  => [[740, 739, 12, "Circle"]],
                                                           "the socket nearest the yellow bottle"                                     => [[990, 571, 8, "Circle"]],
                                                           "the switch of the extractor fan between the mug and the spoon"            => [[615, 385, 12, "Square"]],
                                                           "the top drawer in the stack of drawers by the cooker"                         => [[789, 733, 30, "Square"], [849, 735, 30, "Square"]],
                                                           "the top of the green plastic bottle"                                      => [[1117, 547, 8, "Circle"]],
                                                           "the top right corner of the glass in the oven door"                       => [[716, 823, 12, "Circle"]],
                                                           "the two vertical handles on the glass fronted cupboard above the counter" => [[934, 370, 30, "Square"]],
                                                           "the yellow lid on the resealable box"                                     => [
                                                                                                                                           [289, 677, 12, "Square"],
                                                                                                                                           [313, 679, 12, "Square"],
                                                                                                                                           [320, 679, 12, "Square"],
                                                                                                                                         ],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/crane.PNG"           => {
                                              height  => 525,
                                              objects => {
                                                           "the arm of the crane"                                             => [[566, 12, 20, "Square"]],
                                                           "the balcony of the white house"                                   => [[139, 422, 12, "Square"]],
                                                           "the brown shed"                                                   => [[13, 434, 45, "Square"]],
                                                           "the chimney on the white house"                                   => [[160, 383, 20, "Square"]],
                                                           "the concrete at the base of the crane"                            => [[303, 438, 45, "Square"]],
                                                           "the dot on the beam of the window under the crane"                => [[542, 412, 5, "Circle"]],
                                                           "the gate by the brown shed"                                       => [[44, 478, 20, "Square"]],
                                                           "the gate by the tree that has no branches"                        => [[191, 498, 20, "Square"]],
                                                           "the hook of the crane"                                            => [[524, 209, 30, "Circle"]],
                                                           "the joint of the crane"                                           => [[366, 177, 12, "Square"]],
                                                           "the label on the pallets of bricks"                               => [
                                                                                                                                   [383, 465, 30, "Square"],
                                                                                                                                   [485, 462, 30, "Square"],
                                                                                                                                   [414, 516, 30, "Square"],
                                                                                                                                 ],
                                                           "the line of the crest of the mountain where it touches the crane" => [[375, 312, 8, "Square"]],
                                                           "the mirror of the truck"                                          => [[9, 481, 5, "Circle"]],
                                                           "the pulley of the crane"                                          => [[520, 85, 8, "Circle"]],
                                                           "the red house"                                                    => [[76, 427, 30, "Square"]],
                                                           "the top of the highest tree with no leaves"                       => [[6, 159, 45, "Square"]],
                                                           "the top of the highest tree with snow behind it"                  => [[387, 314, 20, "Square"], [461, 317, 20, "Square"]],
                                                           "the top of the ladder"                                            => [[361, 12, 20, "Circle"]],
                                                           "the top of the left hand cable of the crane"                      => [[323, 2, 8, "Square"]],
                                                           "the wheel of the truck"                                           => [[26, 513, 8, "Circle"]],
                                                           "white truck"                                                      => [[12, 496, 30, "Square"]],
                                                         },
                                              width   => 580,
                                            },
  "../images/images/digger.PNG"          => {
                                              height  => 864,
                                              objects => {
                                                           "the bit of white cloud seen through the leaves of the tree above the iron mesh at the back"                           => [[1126, 267, 20, "Square"]],
                                                           "the bundle of black pipes hanging from the digger arm silhouetted against the green leaves"                           => [
                                                                                                                                                                                       [462, 200, 12, "Square"],
                                                                                                                                                                                       [479, 207, 12, "Square"],
                                                                                                                                                                                       [505, 217, 12, "Square"],
                                                                                                                                                                                     ],
                                                           "the digger bucket"                                                                                                    => [[350, 698, 120, "Square"], [527, 758, 60, "Square"]],
                                                           "the fence visible between the hydraulic ram and the arm of the digger just above the bucket"                          => [[275, 396, 20, "Square"]],
                                                           "the front end of the shiny bit of metal under the cab door"                                                           => [[888, 523, 12, "Square"]],
                                                           "the green K on the far end of the digger arm"                                                                         => [[587, 147, 12, "Square"]],
                                                           "the hole for putting stuff in the blue bin"                                                                           => [[71, 473, 20, "Circle"]],
                                                           "the left hand claw of the bucket"                                                                                     => [[593, 730, 20, "Square"]],
                                                           "the left head light"                                                                                                  => [[862, 235, 12, "Square"]],
                                                           "the left side mirror"                                                                                                 => [[892, 292, 20, "Square"]],
                                                           "the light behind the grill in the lowest step"                                                                        => [[568, 488, 12, "Square"]],
                                                           "the light just above the hydraulic ram nearest the cab"                                                               => [[633, 204, 12, "Circle"]],
                                                           "the line where the green label and the red label meet on the blue bin"                                                => [[52, 507, 8, "Square"]],
                                                           "the loop on top of the blue bin used for picking the bin up"                                                          => [[66, 413, 20, "Circle"]],
                                                           "the loop on top of the yello bin used for picking the bin up"                                                         => [[263, 410, 20, "Circle"]],
                                                           "the mass of black pipes between the cab and the steps"                                                                => [[666, 460, 45, "Square"]],
                                                           "the middle of the windscreen wiper blade"                                                                             => [[722, 319, 8, "Circle"]],
                                                           "the mirror by the steps"                                                                                              => [[538, 411, 20, "Circle"]],
                                                           "the mountain top visible between the top of the digger arm and the blue recycling bin"                                => [[110, 199, 45, "Square"]],
                                                           "the number 145 on the engine cover"                                                                                   => [[986, 480, 20, "Circle"]],
                                                           "the orange cap covering the end of the pipe used to power a jack hammer"                                              => [[359, 354, 12, "Circle"]],
                                                           "the part of the track nearest the recycling bin"                                                                      => [[493, 591, 20, "Square"]],
                                                           "the picture of a girl's face on the side of a recycling bin"                                                          => [[140, 560, 20, "Circle"]],
                                                           "the pivot of the extremely powerful hydraulic ram which drives the bucket"                                            => [[145, 46, 30, "Square"]],
                                                           "the point where the hand rail by the steps meets the yellow base of the digger"                                       => [[545, 522, 8, "Circle"]],
                                                           "the point where the hydraulic ram nearest the cab enters its yellow cylinder"                                         => [[665, 329, 20, "Circle"]],
                                                           "the point where the hydraulic ram opposite the one nearest the cab enters its yellow cylinder"                        => [[598, 333, 20, "Circle"]],
                                                           "the point where the small yellow pipe enters the cylinder of the hydraulic ram which drives the bucket of the digger" => [[242, 327, 12, "Circle"]],
                                                           "the polished steel tube furthest from the cab"                                                                        => [[237, 375, 20, "Square"], [251, 411, 20, "Square"]],
                                                           "the red visible under the cab of the digger"                                                                          => [
                                                                                                                                                                                       [847, 550, 12, "Square"],
                                                                                                                                                                                       [870, 548, 12, "Square"],
                                                                                                                                                                                       [904, 540, 12, "Square"],
                                                                                                                                                                                     ],
                                                           "the reflection of the back light of the silver car reflected in the windscreen of the digger"                         => [[800, 473, 12, "Circle"]],
                                                           "the reflection of the back wheel of the silver car reflected in the windscreen of the digger"                         => [[752, 481, 12, "Square"], [774, 481, 12, "Square"]],
                                                           "the shadow by the blue bin of the mirror by the driver's door"                                                        => [[115, 754, 12, "Square"]],
                                                           "the small hole in the side of the bull dozer blade near the top left corner of same"                                  => [[822, 648, 12, "Circle"]],
                                                           "the steel loop in the back of the digger bucket"                                                                      => [[309, 686, 20, "Square"]],
                                                           "the tree with white flowers"                                                                                          => [[72, 342, 60, "Square"]],
                                                           "the trunk of the tree where it meets the line of the digger arm"                                                      => [[397, 164, 20, "Circle"]],
                                                           "the upper big bolt which connects the bucket to the arm"                                                              => [[404, 484, 12, "Circle"]],
                                                           "the very small hole in the sun lit face of the bucket"                                                                => [[459, 741, 8, "Circle"]],
                                                           "the white splash of paint on the back of the bucket"                                                                  => [[389, 753, 20, "Square"]],
                                                           "the windscreen"                                                                                                       => [[793, 318, 90, "Square"], [791, 419, 90, "Square"]],
                                                           "the word new on the arm of the digger"                                                                                => [[377, 88, 20, "Square"], [400, 106, 20, "Square"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/digger2.PNG"         => {
                                              height  => 864,
                                              objects => {
                                                           OK                                                                                                                 => [[644, 457, 30, "Square"]],
                                                           "click on the green dot if you cannot find the letter J on the digger"                                             => [[575, 475, 8, "Circle"]],
                                                           "if you think the digger could easily pick up the car click on OK else click on the lifting loops of the blue bin" => [[461, 393, 20, "Square"]],
                                                           "the antenna on the cab"                                                                                           => [[902, 112, 30, "Square"], [891, 52, 30, "Square"]],
                                                           "the bottom of the letter V made by the trunk of the tree seen above the car"                                      => [[24, 366, 20, "Circle"]],
                                                           "the car that might be damaged if the driver drives forwards without taking proper care"                           => [[65, 508, 90, "Square"]],
                                                           "the car that would be damaged if the driver drove forwards without taking proper care"                            => [[71, 511, 90, "Square"]],
                                                           "the center of the car wheel"                                                                                      => [[29, 567, 8, "Circle"]],
                                                           "the corner of the window visible under the digger arm through the branches of the tree"                           => [[233, 285, 12, "Square"]],
                                                           "the double L on the digger arm"                                                                                   => [[289, 138, 12, "Square"]],
                                                           "the engine cover lock"                                                                                            => [[1050, 399, 30, "Square"]],
                                                           "the green dot on the cab"                                                                                         => [[576, 475, 8, "Circle"]],
                                                           "the head of the big rusty bolt that connects the bucket to the arm"                                               => [[200, 513, 8, "Circle"]],
                                                           "the head rest of the driver's seat"                                                                               => [[828, 191, 30, "Square"]],
                                                           "the hydraulic ram visible through the side window of the digger"                                                  => [[734, 258, 20, "Square"]],
                                                           "the hydraulic ram visible through the windscreen of the digger"                                                   => [[574, 272, 12, "Square"], [581, 295, 12, "Square"]],
                                                           "the intense reflection of the sun on the side of the engine cover"                                                => [[1105, 435, 12, "Circle"]],
                                                           "the intersection of the bottom edge of the silver stripe and the gap between the cab and the engine cover"        => [[991, 430, 8, "Circle"]],
                                                           "the intersection of the top edge of the silver stripe and the gap between the cab and the engine cover"           => [[990, 343, 8, "Circle"]],
                                                           "the key hole in the cab door"                                                                                     => [[550, 432, 8, "Circle"]],
                                                           "the largest letter I"                                                                                             => [[536, 88, 12, "Square"]],
                                                           "the largest letter U"                                                                                             => [[494, 90, 12, "Square"]],
                                                           "the largest letter a"                                                                                             => [[312, 138, 12, "Square"]],
                                                           "the largest patch of blue sky visible through the twigs of the tree to the right of the digger"                   => [[1055, 69, 30, "Circle"]],
                                                           "the left most letter N in the photo"                                                                              => [[189, 135, 12, "Square"]],
                                                           "the letter B on the cab"                                                                                          => [[821, 521, 8, "Square"]],
                                                           "the letter C on the cab"                                                                                          => [[852, 522, 8, "Square"]],
                                                           "the letter D hidden behind the black tubes"                                                                       => [[349, 142, 12, "Square"]],
                                                           "the letter F on the silver plate"                                                                                 => [[419, 114, 8, "Square"]],
                                                           "the letter G"                                                                                                     => [[557, 89, 12, "Square"]],
                                                           "the letter H under the yellow cylinder of the upper hydraulic ram"                                                => [[250, 137, 12, "Square"]],
                                                           "the letter P"                                                                                                     => [[433, 127, 8, "Square"]],
                                                           "the letter R"                                                                                                     => [[418, 126, 8, "Circle"]],
                                                           "the letter T"                                                                                                     => [[430, 112, 8, "Circle"]],
                                                           "the letter on the digger arm that looks like the letter M upside down"                                            => [[225, 136, 12, "Square"]],
                                                           "the letter smallest letter W on the digger cab door"                                                              => [[663, 520, 12, "Square"]],
                                                           "the lowest Q on the digger window"                                                                                => [[830, 268, 8, "Circle"]],
                                                           "the middle letter Q"                                                                                              => [[837, 259, 8, "Circle"]],
                                                           "the middle window visible under the digger arm"                                                                   => [[326, 284, 30, "Square"]],
                                                           "the number five written on the side of the engine cover"                                                          => [[1143, 507, 20, "Square"]],
                                                           "the number four written on the side of the engine cover"                                                          => [[1091, 508, 30, "Square"]],
                                                           "the number one written on the side of the engine cover"                                                           => [[1046, 506, 20, "Square"]],
                                                           "the pivot at the highest point of the digger"                                                                     => [[51, 62, 20, "Circle"]],
                                                           "the point where the antenna crosses the line of the roof"                                                         => [[886, 38, 8, "Circle"]],
                                                           "the point where the mirror clips to the safety rail"                                                              => [[506, 237, 12, "Square"]],
                                                           "the point where the spring covered tubes connect with the horizontal yellow pipe"                                 => [[108, 102, 20, "Circle"]],
                                                           "the polished steel visible through the safety rail"                                                               => [[524, 210, 12, "Square"]],
                                                           "the rectangular hole in the bin"                                                                                  => [[459, 446, 12, "Square"], [470, 446, 12, "Square"]],
                                                           "the reflection of the sun in the window of the car behind the car nearest the bucket of the digger"               => [[96, 472, 8, "Circle"]],
                                                           "the safety chevron on the side of the green bin"                                                                  => [[333, 533, 20, "Square"]],
                                                           "the scuff marks where the driver gets in and out"                                                                 => [
                                                                                                                                                                                   [551, 545, 20, "Square"],
                                                                                                                                                                                   [551, 545, 20, "Square"],
                                                                                                                                                                                   [591, 548, 20, "Square"],
                                                                                                                                                                                   [633, 548, 20, "Square"],
                                                                                                                                                                                   [672, 549, 20, "Square"],
                                                                                                                                                                                 ],
                                                           "the shadow of the bull dozer blade"                                                                               => [[271, 756, 20, "Circle"]],
                                                           "the silver plate on the digger arm with the words fiat group written on it"                                       => [[425, 118, 20, "Square"]],
                                                           "the small orange cap on the end of a pipe above the bucket"                                                       => [[173, 355, 8, "Circle"]],
                                                           "the small steel loop in the door of the digger"                                                                   => [[637, 341, 12, "Square"]],
                                                           "the smallest letter a on the digger arm"                                                                          => [[426, 114, 8, "Circle"]],
                                                           "the top of the drain pipe which drains water from the balcony"                                                    => [[1014, 221, 8, "Circle"]],
                                                           "the top of the gap between the cab and the engine cover"                                                          => [[978, 281, 20, "Square"]],
                                                           "the top of the shadow of the digger arm on the car door"                                                          => [[76, 509, 20, "Circle"]],
                                                           "the top of the small tree which is growing behind the fence"                                                      => [[377, 358, 90, "Square"]],
                                                           "the tubes that make a not very good letter S"                                                                     => [[90, 158, 60, "Square"]],
                                                           "the upper floor window seen through the leaves of the dark green tree"                                            => [[1025, 172, 45, "Square"]],
                                                           "the upper right trunion wheel"                                                                                    => [[940, 671, 20, "Circle"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/dresser.PNG"         => {
                                              height  => 864,
                                              objects => {
                                                           plant                                                                                                                          => [[633, 522, 120, "Square"], [687, 673, 120, "Square"]],
                                                           "the dresser"                                                                                                                  => [
                                                                                                                                                                                               [125, 118, 120, "Square"],
                                                                                                                                                                                               [216, 125, 120, "Square"],
                                                                                                                                                                                               [230, 361, 120, "Square"],
                                                                                                                                                                                               [235, 606, 120, "Square"],
                                                                                                                                                                                               [121, 360, 120, "Square"],
                                                                                                                                                                                               [115, 603, 120, "Square"],
                                                                                                                                                                                             ],
                                                           "the glass door of the dresser"                                                                                                => [[162, 118, 120, "Square"], [181, 358, 120, "Square"]],
                                                           "the glass on the lower shelf"                                                                                                 => [[170, 400, 30, "Circle"]],
                                                           "the glass used to make the door of the dresser"                                                                               => [
                                                                                                                                                                                               [159, 125, 120, "Square"],
                                                                                                                                                                                               [177, 363, 120, "Square"],
                                                                                                                                                                                               [23, 23, 20, "Square"],
                                                                                                                                                                                               [23, 62, 20, "Square"],
                                                                                                                                                                                               [23, 103, 20, "Square"],
                                                                                                                                                                                               [21, 145, 20, "Square"],
                                                                                                                                                                                               [20, 185, 20, "Square"],
                                                                                                                                                                                               [24, 228, 20, "Square"],
                                                                                                                                                                                               [38, 266, 20, "Square"],
                                                                                                                                                                                               [40, 308, 20, "Square"],
                                                                                                                                                                                               [40, 353, 20, "Square"],
                                                                                                                                                                                               [44, 396, 20, "Square"],
                                                                                                                                                                                               [60, 441, 20, "Square"],
                                                                                                                                                                                               [61, 473, 20, "Square"],
                                                                                                                                                                                             ],
                                                           "the handle of the lower drawer"                                                                                               => [[193, 660, 20, "Circle"]],
                                                           "the handle of the middle cup on the middle shelf"                                                                             => [[181, 238, 20, "Circle"]],
                                                           "the handle of the tea cup sitting on a saucer"                                                                                => [[274, 429, 8, "Circle"]],
                                                           "the handle of the upper drawer"                                                                                               => [[183, 571, 20, "Circle"]],
                                                           "the largest silver ball"                                                                                                      => [[713, 166, 30, "Circle"]],
                                                           "the pink rose on the cup on the middle shelf"                                                                                 => [[240, 242, 20, "Circle"]],
                                                           "the point where the shadow of the right hand dresser leg crosses the crack between the two short planks with the same length" => [[434, 701, 20, "Circle"]],
                                                           "the radiator knob"                                                                                                            => [[605, 299, 12, "Circle"]],
                                                           "the reflection in the glass door of a pot on a lower shelf"                                                                   => [[207, 175, 12, "Circle"]],
                                                           "the smallest silver ball"                                                                                                     => [[674, 187, 12, "Circle"]],
                                                           "the stem of the middle glass on the top shelf"                                                                                => [[138, 13, 12, "Square"]],
                                                           "the upper hinge of the glass door"                                                                                            => [[310, 35, 12, "Square"], [312, 47, 12, "Square"]],
                                                           "the wall under the largest silver ball between the radiator and the window shelf"                                             => [[715, 246, 20, "Square"]],
                                                           "the white cushions on the sofa"                                                                                               => [[911, 483, 90, "Square"], [1065, 521, 90, "Square"]],
                                                           "the yellow flower outside the window on the right"                                                                            => [[1008, 74, 12, "Circle"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/globe.PNG"           => {
                                              height  => 660,
                                              objects => {
                                                           Africa  => [[500, 199, 90, "Circle"]],
                                                           England => [[360, 66, 20, "Circle"]],
                                                           France  => [[407, 82, 20, "Circle"]],
                                                           Germany => [[402, 64, 20, "Circle"]],
                                                           Iceland => [[288, 56, 12, "Circle"]],
                                                           Italy   => [[439, 83, 20, "Circle"]],
                                                           Spain   => [[411, 119, 20, "Circle"]],
                                                           Texas   => [[85, 272, 30, "Circle"]],
                                                         },
                                              width   => 590,
                                            },
  "../images/images/handbag.png"         => {
                                              height  => 864,
                                              objects => {
                                                           "handbag strap"                                                                             => [
                                                                                                                                                            [189, 656, 30, "Square"],
                                                                                                                                                            [198, 597, 30, "Square"],
                                                                                                                                                            [204, 536, 30, "Square"],
                                                                                                                                                            [204, 473, 30, "Square"],
                                                                                                                                                            [194, 415, 30, "Square"],
                                                                                                                                                            [267, 465, 30, "Square"],
                                                                                                                                                            [308, 504, 30, "Square"],
                                                                                                                                                            [350, 550, 30, "Square"],
                                                                                                                                                            [379, 590, 30, "Square"],
                                                                                                                                                          ],
                                                           mat                                                                                         => [[1071, 792, 120, "Square"]],
                                                           "the corner where the door and the floor meet the skirting board at the bottom of the wall" => [[1036, 622, 30, "Square"]],
                                                           "the curtain by the window"                                                                 => [[147, 98, 120, "Square"]],
                                                           "the cushion between the straps of the handbag"                                             => [[283, 597, 90, "Square"]],
                                                           "the drawer handle closest to the statue"                                                   => [[528, 287, 20, "Circle"]],
                                                           "the floor visible through the back of the chair"                                           => [[31, 717, 45, "Circle"], [52, 786, 12, "Square"]],
                                                           "the handbag"                                                                               => [
                                                                                                                                                            [235, 763, 90, "Square"],
                                                                                                                                                            [422, 769, 90, "Square"],
                                                                                                                                                            [459, 644, 45, "Square"],
                                                                                                                                                            [393, 655, 20, "Square"],
                                                                                                                                                          ],
                                                           "the hinge of the window"                                                                   => [[15, 75, 20, "Square"], [10, 33, 20, "Square"]],
                                                           "the ivy between the statue and the wall"                                                   => [[358, 130, 30, "Square"], [413, 148, 30, "Square"]],
                                                           "the large rivet on the handbag strap"                                                      => [[190, 662, 8, "Circle"]],
                                                           "the left hand buckle on the handbag strap"                                                 => [[201, 464, 20, "Square"]],
                                                           "the red tassel hanging from the mat on the chest of drawers"                               => [[306, 309, 12, "Square"], [301, 282, 12, "Square"]],
                                                           "the right hand cupboard door"                                                              => [[715, 381, 90, "Square"], [711, 521, 90, "Square"]],
                                                           "the ring on the front of the handbag"                                                      => [[371, 767, 30, "Circle"]],
                                                           "the white chevron on the handbag"                                                          => [[465, 767, 20, "Circle"]],
                                                           "white statue"                                                                              => [[471, 151, 30, "Square"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/jug.PNG"             => {
                                              height  => 864,
                                              objects => {
                                                           "the apex of the house with two visible chimneys"                               => [[308, 12, 20, "Square"]],
                                                           "the apex of the roof of the red house"                                         => [[1144, 30, 20, "Square"]],
                                                           "the base of the right hand glass"                                              => [[311, 797, 20, "Circle"]],
                                                           "the bottom of the handle for opening the left window"                          => [[721, 367, 12, "Circle"]],
                                                           "the bowl on the counter"                                                       => [
                                                                                                                                                [527, 792, 60, "Square"],
                                                                                                                                                [647, 792, 60, "Square"],
                                                                                                                                                [699, 792, 60, "Square"],
                                                                                                                                              ],
                                                           "the break in the left hand vertical edge of the tiles"                         => [[34, 288, 20, "Square"]],
                                                           "the cherry blossom near the red house"                                         => [[1006, 233, 30, "Circle"]],
                                                           "the flower pot holding the light green plant with no flowers"                  => [[522, 651, 60, "Square"]],
                                                           "the green hedge above the grey fence on top of the white wall across the road" => [[242, 318, 20, "Square"]],
                                                           "the green saucer on which one of the flower pots is standing"                  => [
                                                                                                                                                [1099, 789, 20, "Square"],
                                                                                                                                                [1058, 802, 20, "Square"],
                                                                                                                                                [1014, 803, 20, "Square"],
                                                                                                                                                [984, 775, 20, "Square"],
                                                                                                                                              ],
                                                           "the handle of the jug"                                                         => [
                                                                                                                                                [383, 656, 12, "Square"],
                                                                                                                                                [398, 665, 12, "Square"],
                                                                                                                                                [400, 690, 12, "Square"],
                                                                                                                                                [402, 717, 12, "Square"],
                                                                                                                                                [386, 731, 12, "Square"],
                                                                                                                                              ],
                                                           "the left most window of the upper balcony of the brown house"                  => [[334, 84, 12, "Square"]],
                                                           "the light yellow inside the kitchen"                                           => [[153, 445, 45, "Square"]],
                                                           "the light yellow outside the window"                                           => [[1109, 360, 60, "Square"]],
                                                           "the lowest petal of the lowest purple flower"                                  => [[1081, 380, 12, "Circle"]],
                                                           "the lowest purple flower"                                                      => [[1060, 363, 45, "Circle"]],
                                                           "the moss on the white wall just outside the kitchen window"                    => [
                                                                                                                                                [625, 540, 20, "Square"],
                                                                                                                                                [661, 548, 20, "Square"],
                                                                                                                                                [678, 553, 20, "Square"],
                                                                                                                                              ],
                                                           "the reddest mango in the bowl"                                                 => [[653, 783, 30, "Square"], [693, 795, 30, "Square"]],
                                                           "the silver point where the left hand edge of the counter meets the wall"       => [[101, 682, 20, "Circle"]],
                                                           "the tip of the lowest leaf of the purple flower"                               => [[922, 704, 20, "Circle"]],
                                                           "the top of the left hand glass"                                                => [[227, 693, 30, "Circle"]],
                                                           "the top of the tallest green tree"                                             => [[707, 47, 20, "Square"]],
                                                           "the top of the telegraph pole"                                                 => [[605, 19, 12, "Circle"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/lake.PNG"            => {
                                              height  => 864,
                                              objects => {
                                                           "silage bags"                                                                                                                   => [[828, 231, 30, "Square"], [890, 230, 30, "Square"]],
                                                           "the beak of the nearest duck"                                                                                                  => [[333, 620, 8, "Square"]],
                                                           "the bench by the outlet by the lake"                                                                                           => [[1104, 285, 30, "Square"]],
                                                           "the bench under the staircase"                                                                                                 => [[971, 228, 20, "Square"]],
                                                           "the bit of roof visible to the left of the trunk of the nearest tree"                                                          => [[569, 68, 20, "Square"]],
                                                           "the brown shed by the silage"                                                                                                  => [[757, 216, 45, "Square"]],
                                                           "the doorway behind the silage"                                                                                                 => [[911, 200, 20, "Square"]],
                                                           "the ducks"                                                                                                                     => [[284, 627, 60, "Square"], [393, 598, 60, "Square"]],
                                                           "the grass between the trees by the silage"                                                                                     => [[908, 255, 20, "Square"]],
                                                           "the green foliage at the back between the largest building and the barn"                                                       => [[555, 144, 30, "Square"]],
                                                           "the green stripe on the truck door"                                                                                            => [[529, 212, 8, "Square"]],
                                                           "the harrow"                                                                                                                    => [[1011, 247, 60, "Square"]],
                                                           "the long grass at the bottom of the tree nearest to the ducks"                                                                 => [
                                                                                                                                                                                                [641, 518, 45, "Square"],
                                                                                                                                                                                                [708, 512, 45, "Square"],
                                                                                                                                                                                                [767, 486, 45, "Square"],
                                                                                                                                                                                              ],
                                                           "the lowest completely visible window"                                                                                          => [[837, 190, 20, "Square"]],
                                                           "the middle wheel of the three rear wheels of the harrow"                                                                       => [],
                                                           "the middle window on the first floor"                                                                                          => [[839, 120, 20, "Square"]],
                                                           "the open doorway into the barn"                                                                                                => [[300, 215, 20, "Square"]],
                                                           "the outlet of the lake"                                                                                                        => [[1002, 305, 45, "Square"]],
                                                           "the patch of sunlight on the bank of the pond nearest the truck"                                                               => [[537, 255, 45, "Square"]],
                                                           "the path to the white building"                                                                                                => [[64, 225, 20, "Square"]],
                                                           "the point where the line of the truck bed meets the bark of the nearest tree"                                                  => [[611, 210, 8, "Square"]],
                                                           "the point where the reflection in the pond of the tree trunk nearest the harrow meets the bank that the ducks are sitting on"  => [[928, 453, 12, "Circle"]],
                                                           "the point where the shadow of the tree nearest the harrow curves over the bank of the pond and merges into darkness"           => [[859, 277, 12, "Circle"]],
                                                           "the red roof"                                                                                                                  => [[26, 88, 20, "Square"], [67, 80, 20, "Square"]],
                                                           "the rightmost wheel of the harrow"                                                                                             => [[1067, 269, 8, "Circle"]],
                                                           "the ripples nearest the bench"                                                                                                 => [[1056, 355, 30, "Circle"]],
                                                           "the ripples on the surface of the pond at the end of the reflection of the sunlit wall of the shed furthest from the far bank" => [[784, 394, 20, "Square"]],
                                                           "the start of the steps"                                                                                                        => [[1014, 223, 20, "Square"]],
                                                           "the track behind the harrow"                                                                                                   => [[1077, 228, 45, "Square"]],
                                                           "the track nearest the ducks"                                                                                                   => [
                                                                                                                                                                                                [1032, 745, 120, "Square"],
                                                                                                                                                                                                [852, 803, 60, "Square"],
                                                                                                                                                                                                [765, 832, 30, "Square"],
                                                                                                                                                                                              ],
                                                           "the tree stump nearest the bench"                                                                                              => [[1126, 308, 20, "Circle"]],
                                                           "the truck bed"                                                                                                                 => [
                                                                                                                                                                                                [560, 207, 8, "Square"],
                                                                                                                                                                                                [578, 207, 8, "Square"],
                                                                                                                                                                                                [595, 208, 8, "Square"],
                                                                                                                                                                                              ],
                                                           "the white truck"                                                                                                               => [[566, 220, 60, "Square"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/officeComputer.PNG"  => {
                                              height  => 864,
                                              objects => {
                                                           "the USB connector of the black memory stick between the printer and the computer"                                        => [[477, 576, 8, "Square"]],
                                                           "the USB socket in the computer next to the white cable"                                                                  => [[429, 509, 12, "Circle"]],
                                                           "the black memory stick between the printer and the computer"                                                             => [[507, 585, 30, "Square"]],
                                                           "the black tip of the pencil by the memory stick"                                                                         => [[480, 615, 8, "Circle"]],
                                                           "the corner of the curtain nearest the lamp stand"                                                                        => [[291, 253, 20, "Square"], [300, 244, 20, "Square"]],
                                                           "the corner of the pink piece of paper underneath the printer"                                                            => [[1019, 729, 20, "Square"]],
                                                           "the corner of the radiator"                                                                                              => [[48, 768, 20, "Circle"]],
                                                           "the corner of the window frame reflected in the cover of the printer"                                                    => [[714, 445, 20, "Circle"]],
                                                           "the green part of the pen closest to the printer"                                                                        => [[1093, 715, 12, "Square"], [1100, 705, 12, "Square"]],
                                                           "the green power light on the control panel of the printer"                                                               => [[1061, 636, 8, "Circle"]],
                                                           "the knot in the wood closest to the mouse"                                                                               => [[1010, 846, 12, "Circle"]],
                                                           "the knot in the wood of the desktop close to the computer and the curtain"                                               => [[53, 417, 8, "Circle"]],
                                                           "the knot in the wood on the upper left corner of the face of the drawer"                                                 => [[543, 760, 12, "Circle"]],
                                                           "the label on the side of the power supply"                                                                               => [[461, 285, 12, "Circle"]],
                                                           "the label on the top of the power supply"                                                                                => [
                                                                                                                                                                                          [457, 261, 12, "Square"],
                                                                                                                                                                                          [480, 261, 12, "Square"],
                                                                                                                                                                                          [493, 258, 12, "Square"],
                                                                                                                                                                                        ],
                                                           "the left most plug in the plug board"                                                                                    => [[627, 265, 20, "Circle"]],
                                                           "the left mouse button"                                                                                                   => [[917, 740, 20, "Square"]],
                                                           "the logo in the middle of the printer"                                                                                   => [[784, 468, 20, "Circle"]],
                                                           "the logo on the notebook computer"                                                                                       => [[289, 310, 20, "Square"]],
                                                           "the mouse wheel"                                                                                                         => [[937, 732, 8, "Square"]],
                                                           "the point where the cable hanging from the desk intersects its shadow on the floor closest to the bottom of the picture" => [[406, 823, 12, "Circle"]],
                                                           "the point where the white USB cable enters the computer"                                                                 => [[420, 527, 12, "Square"]],
                                                           "the power supply for the computer"                                                                                       => [[450, 274, 30, "Square"], [499, 267, 30, "Square"]],
                                                           "the power switch on the base of the lamp"                                                                                => [[387, 252, 8, "Square"]],
                                                           "the right lens of the glasses"                                                                                           => [[308, 377, 20, "Square"]],
                                                           "the right mouse button"                                                                                                  => [[958, 747, 20, "Square"]],
                                                           "the shadow of the cable hanging from the desk where it lies on the side of the desk under the computer"                  => [[343, 736, 20, "Circle"]],
                                                           "the upper button on the control panel of the printer"                                                                    => [[1054, 577, 20, "Circle"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/officeFurniture.PNG" => {
                                              height  => 864,
                                              objects => {
                                                           "the area of the green stripe where it goes behind the rim of the mug"                                                 => [
                                                                                                                                                                                       [359, 342, 12, "Square"],
                                                                                                                                                                                       [381, 332, 12, "Square"],
                                                                                                                                                                                       [405, 328, 12, "Square"],
                                                                                                                                                                                     ],
                                                           "the bit of curtain visible at the back"                                                                               => [[11, 30, 30, "Square"]],
                                                           "the blue area on the spine of one of the books in the block of books with white covers"                               => [[1067, 214, 8, "Square"], [1083, 219, 8, "Square"]],
                                                           "the bottom of the gap between the open drawer and the side of the bookcase"                                           => [[421, 656, 8, "Square"]],
                                                           "the bottom of the left hand column of Japanese characters on the mug"                                                 => [[425, 503, 12, "Circle"]],
                                                           "the box in the open drawer with a red top"                                                                              => [
                                                                                                                                                                                       [622, 640, 30, "Square"],
                                                                                                                                                                                       [680, 628, 30, "Square"],
                                                                                                                                                                                       [719, 610, 30, "Square"],
                                                                                                                                                                                     ],
                                                           "the brass collar around the bolt"                                                                                     => [[793, 410, 20, "Square"]],
                                                           "the corner of the box with a snowflake on its cover closest to the bookcase"                                          => [[829, 266, 12, "Circle"]],
                                                           "the edge of the lid of the black box where it disappears behind a book"                                               => [[797, 153, 8, "Circle"]],
                                                           "the gap between the chest of drawers and the side of the desk"                                                        => [[418, 828, 12, "Square"], [427, 850, 12, "Square"]],
                                                           "the handle of the mug"                                                                                                => [[488, 457, 45, "Circle"]],
                                                           "the head of the bolt"                                                                                                 => [[791, 432, 20, "Circle"]],
                                                           "the hole in the spine of the folder on top of the stack of papers"                                                    => [[559, 11, 30, "Circle"]],
                                                           "the knob of the closed drawer"                                                                                        => [[700, 813, 20, "Circle"]],
                                                           "the knob of the open drawer"                                                                                          => [[772, 731, 30, "Circle"]],
                                                           "the large knot in the wood close to the stack of green pads"                                                          => [[669, 420, 20, "Circle"]],
                                                           "the largest snowflake on the cover of the red box"                                                                    => [[787, 267, 12, "Circle"]],
                                                           "the left hand corner of the lightest plank in the floor"                                                              => [[1046, 787, 12, "Circle"]],
                                                           "the light red corner of the folder lying directly on the top surface of the bookcase"                                 => [[829, 128, 12, "Square"]],
                                                           "the logo on the mouse"                                                                                                => [[64, 674, 12, "Circle"]],
                                                           "the lower corner of the lid of the stellated pentagonal box closest to the bolt"                                      => [[810, 304, 8, "Circle"]],
                                                           "the lower silver fleck in the thread of the bolt"                                                                     => [[796, 385, 8, "Circle"]],
                                                           "the nut on the bolt"                                                                                                  => [[799, 343, 20, "Circle"]],
                                                           "the place where the base of the mug touches the side of the chest of drawers"                                         => [[354, 502, 12, "Square"], [364, 516, 12, "Square"]],
                                                           "the point where the blue strip on the paper in the drawer meets the side of the drawer"                               => [[872, 517, 12, "Circle"]],
                                                           "the point where the dark green stripe on the tea towel goes behind the mouse wheel"                                   => [[109, 594, 12, "Circle"]],
                                                           "the point where the edge of the desktop goes under the green stripe of the tea towel"                                 => [[333, 531, 12, "Square"]],
                                                           "the red on the spine of the lower horizontal book in the middle shelf of the bookcase"                                => [[970, 215, 8, "Square"], [978, 220, 8, "Square"]],
                                                           "the right hand corner of the book resting on the lid of the black box"                                                => [[776, 178, 8, "Square"]],
                                                           "the righthand corner of the tea towel"                                                                                => [[361, 599, 30, "Circle"]],
                                                           "the righthand end of the line where the green book in the bookcase meets the two horizontal books lying on top of it" => [[1005, 229, 8, "Circle"]],
                                                           "the upper bit of red on the cover of the book sandwiched between the book case and the stack on the black box"        => [[700, 8, 12, "Circle"]],
                                                           "the upper of the two white and purple spots in the spines of the horizontal books on the black box"                   => [[483, 204, 8, "Circle"]],
                                                           "the white arrow on the red background in the drawer"                                                                  => [[804, 593, 20, "Circle"]],
                                                           "the white square thing on the lowest shelf of the bookcase"                                                           => [[1133, 520, 12, "Square"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/pasta.PNG"           => {
                                              height  => 864,
                                              objects => {
                                                           "a lot of pasta in a big frying pan"  => [
                                                                                                      [436, 532, 90, "Circle"],
                                                                                                      [528, 533, 90, "Circle"],
                                                                                                      [596, 529, 90, "Circle"],
                                                                                                    ],
                                                           "some potatoes in a small frying pan" => [
                                                                                                      [820, 545, 60, "Circle"],
                                                                                                      [882, 551, 60, "Circle"],
                                                                                                      [932, 556, 60, "Circle"],
                                                                                                    ],
                                                           "the lid of the saucepan"             => [
                                                                                                      [711, 371, 45, "Circle"],
                                                                                                      [780, 378, 45, "Circle"],
                                                                                                      [833, 384, 45, "Circle"],
                                                                                                    ],
                                                           "the top of the wooden spoon"         => [[687, 15, 12, "Circle"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/pineapple.PNG"       => {
                                              height  => 864,
                                              objects => {
                                                           "the blue mark on the right corner of the pad of paper"            => [[688, 549, 8, "Square"]],
                                                           "the button press at the end of the pen"                           => [[702, 524, 8, "Square"]],
                                                           "the grey gate"                                                    => [[190, 56, 30, "Square"]],
                                                           "the left finger loop of the scissors"                             => [[551, 844, 20, "Circle"]],
                                                           "the point of the scissors"                                        => [[467, 769, 8, "Square"]],
                                                           "the right hand bunch of flowers"                                  => [[854, 138, 120, "Square"], [883, 207, 120, "Square"]],
                                                           "the rivet in the scissors which holds the blades together"        => [[513, 798, 12, "Circle"]],
                                                           "the silver band around the middle of the pen"                     => [[627, 534, 8, "Square"]],
                                                           "the stalk of the pineapple"                                       => [
                                                                                                                                   [923, 533, 45, "Square"],
                                                                                                                                   [956, 496, 45, "Square"],
                                                                                                                                   [997, 465, 45, "Square"],
                                                                                                                                 ],
                                                           "the stem in the mass of purple flowers where it divides in two"   => [[864, 141, 12, "Circle"]],
                                                           "the tip of the petal nearest the pineapple"                       => [[967, 305, 20, "Circle"]],
                                                           "the tip of the tendril between the bowl and the brown flower pot" => [[578, 603, 20, "Circle"]],
                                                           "the top of the cane standing in the center of the flower pot"     => [[401, 273, 20, "Circle"]],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/rucksack.PNG"        => {
                                              height  => 500,
                                              objects => {
                                                           "the black toggle on the end of the yellow string" => [[251, 344, 12, "Square"]],
                                                           "the end of the red string furthest from the key" => [[232, 489, 20, "Square"]],
                                                           "the key" => [[94, 444, 20, "Square"], [90, 480, 20, "Square"]],
                                                           "the knot on the end of the white string" => [[331, 210, 8, "Circle"], [270, 171, 8, "Circle"]],
                                                           "the lowest grape on the carton of wine" => [[126, 393, 8, "Circle"]],
                                                           "the plastic cap on the carton" => [[140, 230, 20, "Circle"]],
                                                           "the shoulder strap of the rucksack" => [
                                                                 [244, 67, 20, "Square"],
                                                                 [217, 87, 20, "Square"],
                                                                 [189, 117, 20, "Square"],
                                                                 [219, 114, 8, "Square"],
                                                                 [242, 91, 8, "Square"],
                                                               ],
                                                           "the sun glasses" => [
                                                                 [203, 415, 20, "Square"],
                                                                 [241, 434, 20, "Square"],
                                                                 [281, 441, 20, "Square"],
                                                               ],
                                                           "the whistle" => [[49, 419, 20, "Square"]],
                                                         },
                                              width   => 465,
                                            },
  "../images/images/sofa.PNG"            => {
                                              height  => 864,
                                              objects => {
                                                           "green book"                                                                                          => [[534, 638, 30, "Square"]],
                                                           "the black tip of the pen"                                                                            => [[464, 590, 8, "Square"]],
                                                           "the book under the table"                                                                            => [
                                                                                                                                                                      [555, 788, 12, "Square"],
                                                                                                                                                                      [579, 794, 12, "Square"],
                                                                                                                                                                      [603, 796, 12, "Square"],
                                                                                                                                                                    ],
                                                           "the corner of the wall closest to the top of the sofa back"                                          => [[562, 79, 20, "Circle"]],
                                                           "the head line of the newspaper"                                                                      => [
                                                                                                                                                                      [392, 363, 12, "Square"],
                                                                                                                                                                      [416, 359, 12, "Square"],
                                                                                                                                                                      [442, 356, 12, "Square"],
                                                                                                                                                                      [453, 355, 12, "Square"],
                                                                                                                                                                    ],
                                                           "the illustration under the title of the white book"                                                  => [[627, 676, 20, "Circle"]],
                                                           "the left most bowl on the window shelf"                                                              => [[148, 58, 20, "Circle"]],
                                                           "the point at which the gap between the two sofa cushions by the radiator meets the seat of the sofa" => [[219, 363, 30, "Circle"]],
                                                           "the point where the red table cloth meets the yellow wrapping paper of the plant"                    => [[880, 517, 12, "Circle"]],
                                                           "the point where the right most leg of the table touches the floor"                                   => [[885, 789, 20, "Circle"]],
                                                           "the point where the window shelf touches the curtain"                                                => [[365, 65, 12, "Circle"]],
                                                           "the red bud nearest the white sofa cushion"                                                          => [[838, 338, 12, "Circle"]],
                                                           "the red circle on the front of the magazine"                                                         => [[322, 420, 20, "Circle"], [353, 417, 20, "Circle"]],
                                                           "the red ribbon hanging down the side of the table"                                                   => [
                                                                                                                                                                      [433, 764, 12, "Square"],
                                                                                                                                                                      [438, 732, 12, "Square"],
                                                                                                                                                                      [434, 745, 12, "Square"],
                                                                                                                                                                    ],
                                                           "the right hand end of the radiator behind the sofa"                                                  => [[245, 129, 20, "Circle"]],
                                                           "the right most candle holder on the table"                                                           => [[680, 584, 30, "Circle"]],
                                                           "the saucer under the plant"                                                                          => [
                                                                                                                                                                      [774, 533, 12, "Square"],
                                                                                                                                                                      [798, 530, 12, "Square"],
                                                                                                                                                                      [815, 515, 12, "Square"],
                                                                                                                                                                    ],
                                                           "the top most leaf of the plant"                                                                      => [[803, 308, 20, "Circle"]],
                                                           "the top of the red cushion at the back"                                                              => [
                                                                                                                                                                      [534, 128, 20, "Square"],
                                                                                                                                                                      [577, 129, 20, "Square"],
                                                                                                                                                                      [617, 132, 20, "Square"],
                                                                                                                                                                      [661, 130, 20, "Square"],
                                                                                                                                                                    ],
                                                           "the white cushion standing at the back of the sofa"                                                  => [[704, 231, 60, "Square"]],
                                                           "the yellow Easter egg in the flower pot"                                                             => [[756, 448, 20, "Circle"]],
                                                           "where the white curtain meets the sofa"                                                              => [
                                                                                                                                                                      [378, 111, 20, "Square"],
                                                                                                                                                                      [419, 103, 20, "Square"],
                                                                                                                                                                      [451, 97, 20, "Square"],
                                                                                                                                                                    ],
                                                           "window shelf"                                                                                        => [
                                                                                                                                                                      [24, 102, 20, "Square"],
                                                                                                                                                                      [64, 101, 20, "Square"],
                                                                                                                                                                      [109, 99, 20, "Square"],
                                                                                                                                                                      [153, 86, 20, "Square"],
                                                                                                                                                                      [195, 83, 20, "Square"],
                                                                                                                                                                      [238, 76, 20, "Square"],
                                                                                                                                                                      [281, 69, 20, "Square"],
                                                                                                                                                                      [322, 60, 20, "Square"],
                                                                                                                                                                      [345, 61, 20, "Square"],
                                                                                                                                                                    ],
                                                         },
                                              width   => 1152,
                                            },
  "../images/images/some.PNG"            => {
                                              height  => 700,
                                              objects => {
                                                           "a bit of sunshine on the snow"   => [[320, 631, 45, "Square"], [383, 633, 45, "Square"]],
                                                           "a couple of glasses"             => [[332, 453, 60, "Square"], [369, 457, 60, "Square"]],
                                                           "a few flowers"                   => [[128, 502, 120, "Square"], [123, 571, 120, "Square"]],
                                                           "a little sky"                    => [[331, 615, 60, "Square"], [372, 618, 60, "Square"]],
                                                           "a lot of bikes"                  => [
                                                                                                  [129, 122, 120, "Square"],
                                                                                                  [371, 121, 120, "Square"],
                                                                                                  [366, 242, 120, "Square"],
                                                                                                  [121, 243, 120, "Square"],
                                                                                                ],
                                                           "a lot of mist"                   => [[574, 570, 120, "Square"], [722, 572, 120, "Square"]],
                                                           "a plant"                         => [[571, 55, 60, "Square"]],
                                                           "quite a lot of snow"             => [[321, 637, 45, "Square"], [381, 633, 45, "Square"]],
                                                           "several bits of fruit in a bowl" => [[705, 331, 90, "Circle"]],
                                                           "some fruit"                      => [[695, 314, 120, "Circle"]],
                                                           "some light green leaves"         => [[570, 53, 60, "Square"]],
                                                           "some very beautiful flowers"     => [[111, 478, 90, "Square"], [148, 594, 90, "Square"]],
                                                         },
                                              width   => 850,
                                            },
  "../images/images/someNone.PNG"        => {
                                              height  => 333,
                                              objects => {
                                                           "a bit of fruit"               => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           "a couple of plants"           => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           "a few leaves on the plants"   => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           "a lot of leaves on the trees" => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           "a lot of trees"               => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           "a lot of wind"                => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           "a window"                     => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           calm                           => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           cold                           => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           indoors                        => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           "little blue"                  => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           "little cold"                  => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           "little warmth"                => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           "lots of blue sky"             => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           "lots of snow"                 => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           "no clouds"                    => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           "no fruit"                     => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           "no glass"                     => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           "no snow"                      => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           "no wind"                      => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           "no window"                    => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           "not a bit of red"             => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           outdoors                       => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           snowy                          => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           "some clouds"                  => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                           "some fruit"                   => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           "some glass"                   => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           "some red"                     => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           warm                           => [
                                                                                               [274, 91, 90, "Square"],
                                                                                               [332, 90, 90, "Square"],
                                                                                               [271, 240, 90, "Square"],
                                                                                               [332, 240, 90, "Square"],
                                                                                             ],
                                                           windy                          => [[83, 78, 90, "Square"], [84, 256, 90, "Square"]],
                                                         },
                                              width   => 424,
                                            },
  "../images/images/street.PNG"          => {
                                              height  => 864,
                                              objects => {
                                                           "the apex of the furthest arch"                                                                                                   => [[713, 378, 12, "Square"]],
                                                           "the bark of the trunk of the large tree behind the light brown fence"                                                            => [[531, 392, 12, "Square"]],
                                                           "the bush with red leaves just visible next to the car parked in the courtyard behind the dark green tree near the give way sign" => [[404, 404, 12, "Square"]],
                                                           "the car parked in the courtyard behind the black car in the foreground"                                                          => [[163, 408, 8, "Circle"]],
                                                           "the forest visible between the furthest chestnut tree and the building on the right"                                             => [[658, 193, 60, "Square"]],
                                                           "the front wheel of the car parked in the courtyard behind the dark green tree near the give way sign"                            => [[382, 421, 8, "Circle"]],
                                                           "the front wheel of the child's bike"                                                                                             => [[530, 434, 8, "Circle"]],
                                                           "the give way sign"                                                                                                               => [[393, 354, 12, "Circle"]],
                                                           "the helmet of the child who is biking along the street"                                                                          => [[522, 405, 8, "Circle"]],
                                                           "the joint between the two kerb stones running parallel to the yellow line nearest the sign post"                                 => [[695, 673, 12, "Square"]],
                                                           "the largest chevron on the rubbish bin"                                                                                          => [[359, 528, 12, "Square"]],
                                                           "the left heel of the pedestrian"                                                                                                 => [[680, 445, 8, "Circle"]],
                                                           "the left most window of the line of four windows above the pedestrian crossing sign"                                             => [[662, 279, 8, "Square"]],
                                                           "the license plate of the car"                                                                                                    => [[252, 459, 8, "Square"]],
                                                           "the little window under the balcony with the wooden fence"                                                                       => [[185, 337, 12, "Square"]],
                                                           "the nearest wheel of the rubbish bin"                                                                                            => [[355, 591, 8, "Circle"]],
                                                           "the orange sign on the wall"                                                                                                     => [[734, 440, 20, "Square"], [734, 402, 20, "Square"]],
                                                           "the patch of grass between the two bikers"                                                                                       => [
                                                                                                                                                                                                  [551, 426, 12, "Square"],
                                                                                                                                                                                                  [579, 425, 12, "Square"],
                                                                                                                                                                                                  [598, 425, 12, "Square"],
                                                                                                                                                                                                ],
                                                           "the pedestrian crossing sign"                                                                                                    => [[661, 353, 12, "Square"]],
                                                           "the picture of a frog in the window"                                                                                             => [[814, 363, 12, "Square"]],
                                                           "the tip of the candle of chestnut flowers silhouetted against the trunk of the tree"                                             => [[397, 87, 8, "Circle"]],
                                                           "the top of the drain pipe visible between the cyclist and the pedestrian where it meets the gutter"                              => [[683, 311, 8, "Circle"]],
                                                           "the top of the fire hydrant where it is colored blue"                                                                            => [[532, 504, 20, "Square"]],
                                                           "the white letter P on the blue background on the nearest sign"                                                                   => [[818, 257, 8, "Square"]],
                                                           "the white shirt of the man walking along the street"                                                                             => [[690, 407, 8, "Square"]],
                                                         },
                                              width   => 1152,
                                            },
}
}

