/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.real;

import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealLine;
import net.sourceforge.plantuml.real.RealMoveable;

class RealDelta
extends RealMoveable {
    private final Real delegated;
    private final double diff;

    RealDelta(Real real, double d) {
        super("[Delegated {" + real.getName() + "} d=" + d + "]");
        this.delegated = real;
        this.diff = d;
    }

    public double getCurrentValue() {
        return this.delegated.getCurrentValue() + this.diff;
    }

    public Real addAtLeast(double d) {
        return new RealDelta(this.delegated.addAtLeast(d), this.diff);
    }

    public void ensureBiggerThan(Real real) {
        this.delegated.ensureBiggerThan(new RealDelta(real, -this.diff));
    }

    public void compile() {
        this.delegated.compile();
    }

    void move(double d) {
        ((RealMoveable)this.delegated).move(d);
    }

    RealLine getLine() {
        return ((RealMoveable)this.delegated).getLine();
    }
}

