# Generated by default/object.tt
package Paws::Quicksight::DataColorPalette;
  use Moose;
  has Colors => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has EmptyFillColor => (is => 'ro', isa => 'Str');
  has MinMaxGradient => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::DataColorPalette

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::DataColorPalette object:

  $service_obj->Method(Att1 => { Colors => $value, ..., MinMaxGradient => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::DataColorPalette object:

  $result = $service_obj->Method(...);
  $result->Att1->Colors

=head1 DESCRIPTION

The theme colors that are used for data colors in charts. The colors
description is a hexadecimal color code that consists of six
alphanumerical characters, prefixed with C<#>, for example #37BFF5.

=head1 ATTRIBUTES


=head2 Colors => ArrayRef[Str|Undef]

The hexadecimal codes for the colors.


=head2 EmptyFillColor => Str

The hexadecimal code of a color that applies to charts where a lack of
data is highlighted.


=head2 MinMaxGradient => ArrayRef[Str|Undef]

The minimum and maximum hexadecimal codes that describe a color
gradient.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

