# Generated by default/object.tt
package Paws::ECS::ExecuteCommandConfiguration;
  use Moose;
  has KmsKeyId => (is => 'ro', isa => 'Str', request_name => 'kmsKeyId', traits => ['NameInRequest']);
  has LogConfiguration => (is => 'ro', isa => 'Paws::ECS::ExecuteCommandLogConfiguration', request_name => 'logConfiguration', traits => ['NameInRequest']);
  has Logging => (is => 'ro', isa => 'Str', request_name => 'logging', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECS::ExecuteCommandConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECS::ExecuteCommandConfiguration object:

  $service_obj->Method(Att1 => { KmsKeyId => $value, ..., Logging => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECS::ExecuteCommandConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->KmsKeyId

=head1 DESCRIPTION

The details of the execute command configuration.

=head1 ATTRIBUTES


=head2 KmsKeyId => Str

Specify an AWS Key Management Service key ID to encrypt the data
between the local client and the container.


=head2 LogConfiguration => L<Paws::ECS::ExecuteCommandLogConfiguration>

The log configuration for the results of the execute command actions.
The logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When
C<logging=OVERRIDE> is specified, a C<logConfiguration> must be
provided.


=head2 Logging => Str

The log setting to use for redirecting logs for your execute command
results. The following log settings are available.

=over

=item *

C<NONE>: The execute command session is not logged.

=item *

C<DEFAULT>: The C<awslogs> configuration in the task definition is
used. If no logging parameter is specified, it defaults to this value.
If no C<awslogs> log driver is configured in the task definition, the
output won't be logged.

=item *

C<OVERRIDE>: Specify the logging details as a part of
C<logConfiguration>. If the C<OVERRIDE> logging option is specified,
the C<logConfiguration> is required.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

