/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Declares the resources each module needs at init time 
 */

#ifndef STK_RSRC_H
#define STK_RSRC_H


#define BYTES_1K       1024            /* 2 ** 10 */

/* Memory management constants */
#ifdef TESTING
#define MM_MEM_POOL_SIZE           2       /* in K bytes */
#else
#define MM_MEM_POOL_SIZE           5       /* in K bytes */
#endif


/* Doubly-linked list management */
#ifdef TESTING
#define DLL_MAX_LIST_BUFFERS       50
#define DLL_MEMORY_POOL_SIZE       2       /* in K bytes */
#else
#define DLL_MAX_LIST_BUFFERS       2500
#define DLL_MEMORY_POOL_SIZE       40      /* in K bytes */
#endif


/* Frame management */
#define MIN_PACKET_LEN             100

#ifdef TESTING
#define FRAME_LIST_SIZE            10
#define FRAME_MEMORY_POOL_SIZE     5       /* K bytes */
#else
#define FRAME_LIST_SIZE            1000 
#define FRAME_MEMORY_POOL_SIZE     40       /* K bytes */
#endif


/* LLC layer management */
#define LLC_LM_COMPONENT_DB_SIZE       10


/* LLC */
/* memory pool_size = 10 + (max_nbr_saps * max_nbr_connections) */


/* NetBEUI command handler */
#ifdef TESTING                 
#define NB_CMD_MEM_POOL        3
#define NB_CMD_LIST_SIZE       2
#else
#define NB_CMD_MEM_POOL       12 
#define NB_CMD_LIST_SIZE      50
#endif


/* NetBEUI Name Table Services */
#ifdef TESTING
#define NB_NAME_TABLE_MEM_POOL_SIZE       2       /* K bytes */
#else
#define NB_NAME_TABLE_MEM_POOL_SIZE       10      /* K bytes */
#endif


/* NetBEUI session table serices */

/* Memory pool size equals 3K bytes per session */


/* NetBEUI layer global default parameters */

#define NB_GLOBAL_DEFAULT_TIMER_t1                 5
#define NB_GLOBAL_DEFAULT_TIMER_t2                 2
#define NB_GLOBAL_DEFAULT_TIMER_ti                 3
#define NB_GLOBAL_DEFAULT_MAXOUT                   2
#define NB_GLOBAL_DEFAULT_MAXIN                    1
#define NB_GLOBAL_DEFAULT_MAXOUT_INCR              1
#define NB_GLOBAL_DEFAULT_MAX_RETRY                8
#define NB_GLOBAL_DEFAULT_ACCESS_PRI               0
#define NB_GLOBAL_DEFAULT_STATIONS                 6
#define NB_GLOBAL_DEFAULT_MAX_NAMES                17
#define NB_GLOBAL_DEFAULT_MAX                      12
#define NB_GLOBAL_DEFAULT_MAX_SESSIONS             10
#define NB_GLOBAL_DEFAULT_OPTIONS                  0x80
#define NB_GLOBAL_DEFAULT_POOL_LENGTH              0
#define NB_GLOBAL_DEFAULT_POOL_ADDRESS             0
#define NB_GLOBAL_DEFAULT_TRANSMIT_TIMEOUT         1
#define NB_GLOBAL_DEFAULT_TRANSMIT_COUNT           6
#define NB_GLOBAL_DEFAULT_FRAME_USER_DATA_SIZE     516
                                                   

/* LLC Layer global default parameters */

#define LLC_GLOBAL_DEFAULT_MAX_NBR_SAPS            4 
#define LLC_GLOBAL_DEFAULT_MAX_NBR_CONNECTIONS     64 
#define LLC_GLOBAL_DEFAULT_MAX_PDU_OCTETS          1000
#define LLC_GLOBAL_DEFAULT_MIN_PDU_OCTETS          500


#endif /* STK_RSRC_H */


