/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
#ifndef LLC_STK_H
#define LLC_STK_H

#include <linux/module.h>
#include <net/cm_bp.h>
#include <net/llc_lm.h>
#include <net/llc_pdu.h>
#include <net/decode.h>
#include <net/llc_sap.h>
#include <net/llc_conn.h>
#include <net/llc_c_ev.h>

extern us16 sap_unassign_conn(sap_t *,void *);

extern us16 conn_ac_send_i_c(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_i_r(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_sabme_c(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_ua_r(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_rej_c(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_rej_r(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_disc_c(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_dm_r(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_rr_c(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_rr_r(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_rnr_c(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_rnr_r(connection_t *,conn_state_event_t *, int);
extern us16 conn_ac_send_frmr_r(connection_t *,conn_state_event_t *, int);

extern us16 llc_connection_rtn(connection_t *);
extern us16 llc_connection_get(connection_t **);
extern us16 sap_assign_conn(sap_t *, void *);
extern us16 conn_get_event(connection_t *, void **);
extern us16 conn_send_event(connection_t *, void *);

static struct symbol_table llc_symbols = {
#include <linux/symtab_begin.h>
X(bp_alloc),
X(dll_match),
X(frame_allocate),
X(llc_lm_exit),
X(llc_sap_close),
X(access_all_devices),
X(pdu_decode_sa),
X(bp_create),
X(dll_initialize),
X(mm_malloc),
// X(mm_inquire),
X(mm_clr_pool),
X(mm_rtn_pool),
X(llc_sap_open),
X(frame_exit),
X(dll_exit),
X(mac_init),
X(dll_remove),
X(llc_lm_init),
X(os_tmr_create),
X(os_tmr_stop),
X(mm_get_subpool),
X(llc_exit),
X(mm_init),
X(frame_init),
X(mm_exit),
X(llc_glob_init),
X(dll_peek),
X(mm_get_pool),
X(llc_init),
X(mac_exit),
X(dll_query),
X(dll_add),
X(dll_init),
X(llc_glob_exit),
X(os_tmr_set),
X(os_tmr_start),
X(frame_free),
X(dll_remove_this),

// LLC decode exports

X(decode_frame_t),
X(decode_prim_if_block_t),
X(decode_connect_event_t),
X(decode_station_event_t),

// X(bp_inquire),

// LLC test exports

X(sap_assign_conn),
X(sap_unassign_conn),
X(llc_connection_rtn),
X(llc_connection_get),
X(conn_get_event),
X(conn_send_event),

X(conn_ac_send_i_c),
X(conn_ac_send_i_r),
X(conn_ac_send_sabme_c),
X(conn_ac_send_ua_r),
X(conn_ac_send_rej_c),
X(conn_ac_send_rej_r),
X(conn_ac_send_rr_c),
X(conn_ac_send_rr_r),
X(conn_ac_send_rnr_c),
X(conn_ac_send_rnr_r),
X(conn_ac_send_disc_c),
X(conn_ac_send_dm_r),
X(conn_ac_send_frmr_r),

#include <linux/symtab_end.h>
};

#ifdef LLC_STK_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_STK_C */

EXTRN us16             llc_layer_deinit (void);
EXTRN us16             llc_layer_init (void);  

#undef EXTRN
#endif /* LLC_STK_H */


