/*
 * automount.h
 *
 * Header file for automounter modules
 *
 */

#ifndef AUTOMOUNT_H
#define AUTOMOUNT_H

#include <paths.h>

#ifndef _PATH_MOUNT
#define _PATH_MOUNT "/bin/mount"
#endif
#ifndef _PATH_UMOUNT
#define _PATH_UMOUNT "/bin/umount"
#endif

/* Standard function used by modules */

int spawnl(char *, ...);


/* Prototype for module functions */

#define AUTOFS_LOOKUP_VERSION 3

#ifdef MODULE_LOOKUP
int lookup_init(char *, int, char **, void **);
int lookup_mount(char *, char *, int, void *);
int lookup_done(void *);
#endif
typedef (*lookup_init_t)(char *, int, char **, void **);
typedef (*lookup_mount_t)(char *, char *, int, void *);
typedef (*lookup_done_t)(void *);

#define AUTOFS_PARSE_VERSION 2

#ifdef MODULE_PARSE
int parse_init(int, char **, void **);
int parse_mount(char *, char *, int, char *, void *);
int parse_done(void *);
#endif
typedef (*parse_init_t)(int, char **, void **);
typedef (*parse_mount_t)(char *, char *, int, char *, void *);
typedef (*parse_done_t)(void *);

#endif
