/*
 * GNU POC (passwords on card) - manage passwords on smartcards
 * Copyright (C) 2001 Henning Koester <henning@crackinghacking.de>
 *
 * Please report bugs to bug-poc@gnu.org
 *
 * This file is part of POC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: rijndael.h,v 1.4 2001/08/18 16:19:12 henning Exp $ */

#ifndef _RIJNDAEL_H_
#define _RIJNDAEL_H_

#include "poc_types.h"

typedef struct {
    int   ROUNDS;                   /* key-length-dependent number of rounds */
    u8  keySched[12+1][4][4];   /* key schedule         */
} RIJNDAEL_context;

void rijndael_setkey(RIJNDAEL_context *, const u8 *, const unsigned); 
void rijndael_encrypt(const RIJNDAEL_context *, u8 *, const u8 *);
void rijndael_wipe(RIJNDAEL_context *);

#endif
