/*
 * GNU POC (passwords on card) - manage passwords on smartcards
 * Copyright (C) 2001 Henning Koester <henning@crackinghacking.de>
 *
 * Please report bugs to bug-poc@gnu.org
 *
 * This file is part of POC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: lang.h,v 1.5 2001/08/18 16:12:20 henning Exp $ */

#ifndef _LANG_H_
#define _LANG_H_

#define ERR_PRFX \
  "%s:%s:%d: %s", PACKAGE, __FILE__, __LINE__,
#define ERR_PRFX_NM \
  "%s:%s:%d: ", PACKAGE, __FILE__, __LINE__

/* main.c */
#define STR_WRONG_CIPHER \
  ERR_PRFX "no such cipher\n"
#define STR_WRONG_CIPHER_ENV \
  ERR_PRFX "no such cipher (ENVIRONMENT POC_CIPHER)\n"
#define STR_WRONG_SEC_LEVEL \
  ERR_PRFX "no such security level\n"
#define STR_WRONG_SEC_LEVEL_ENV \
  ERR_PRFX "no such security level (ENVIRONMENT POC_SL)\n"
#define STR_NO_COMMAND \
  ERR_PRFX "you must specify a COMMAND\n"
#define STR_NO_MULTIPLE_COMMANDS \
  ERR_PRFX "you can only choose one COMMAND\n"
#define STR_NO_BACKUP_AND_RESTORE \
  ERR_PRFX "choose --backup or --restore, but not both\n"
#define STR_NO_LIST_AND_REMOVE \
  ERR_PRFX "you can't choose --list-password and --remove-password\n"
#define STR_BACKUP_FAIL \
  ERR_PRFX "no backup made\n"
#define STR_BACKUP_SUCCESS \
  "Backuped card successfully.\n"
#define STR_CHANGE_KEY_FAIL \
  ERR_PRFX "didn't change key\n"
#define STR_CHANGE_KEY_SUCCESS \
  "Key changed.\n"
#define STR_FORMAT_FAIL \
  ERR_PRFX "didn't format card\n"
#define STR_FORMAT_SUCCESS \
  "Card formated successfully.\n"
#define STR_LIST_PASS_FAIL \
  ERR_PRFX "didn't list password(s)\n"
#define STR_SAVE_PASS_FAIL \
  ERR_PRFX "didn't save password\n"
#define STR_SAVE_PASS_SUCCESS \
  "Password saved.\n"
#define STR_REM_PASS_FAIL \
  ERR_PRFX "didn't remove password\n"
#define STR_REM_PASS_SUCCESS \
  "Password removed.\n"
#define STR_RESTORE_FAIL \
  ERR_PRFX "didn't restore card\n"
#define STR_RESTORE_SUCCESS \
  "Restored card successfully\n"

/* backup_card.c */
#define STR_CREATE_FILE_ERR \
  ERR_PRFX "couldn't create file "
#define STR_OPEN_FILE_ERR \
  ERR_PRFX "couldn't open file "
#define STR_CHMOD_FAIL \
  ERR_PRFX "couldn't change file permissions: "

/* card.c */
#define STR_INIT_TERMINAL_ERR \
  ERR_PRFX "couldn't initialize card terminal\n"
#define STR_RESET_CT_ERR \
  ERR_PRFX "couldn't reset card terminal\n"
#define STR_REQUEST_ICC_ERR \
  ERR_PRFX "couldn't request card\n"
#define STR_SELECT_FILE_ERR \
  ERR_PRFX "couldn't select card's memory\n"
#define STR_READ_BINARY_ERR \
  ERR_PRFX "couldn't access card's memory\n"
#define STR_UPDATE_BINARY_ERR \
  ERR_PRFX "couldn't write to card's memory\n"

/* change.c */
#define STR_CARD_NOT_ENCRYPTED \
  ERR_PRFX "card is not encrypted\n"
#define STR_NEW_KEY_PROMPT \
  "New Key: "

/* format.c */
#define STR_ENTER_CARD_SIZE \
  "Size of card in byte: "
#define STR_ASK_FORMAT \
  "\nWARNING: Really format card? (y/N) "

/* password.c */
#define STR_PASSWORD_PROMPT \
  "Password: "
#define STR_DESCR_PROMPT \
  "Description: "
#define STR_NO_SPACE_LEFT \
  ERR_PRFX "sorry, not enough free space to save password\n"
#define STR_NO_PASSWORD_FOUND \
  ERR_PRFX "no description matched the given one\n"
#define STR_START_MSG_LIST_PASSWORD \
  "Password   : "
#define STR_START_MSG_LIST_DESCR \
  "Description: "
#define STR_WARN_POSSIBLE_WRONG_KEY \
	"\nWARNING: It seems that you entered the wrong key.\n" \
	"\t Proceeding may cause data corruption!\n" "Proceed anyway? (y/N) " 
#define STR_CIPHER_SETKEY_ERR \
  ERR_PRFX "key schedule failed\n"


/* *all* */
#define STR_NO_MEM_CARD \
  ERR_PRFX "couldn't find a memory card\n"
#define STR_EMPTY_CARD \
  ERR_PRFX "card contains no data\n"
#define STR_KEYS_DONT_MATCH \
  ERR_PRFX "keys do not match\n"
#define STR_KEY_PROMPT \
  "Key: "
#define STR_RETYPE_NEW_KEY_PROMPT \
  "Retype Key: "

#endif /* NOT _LANG_H_ */

