/*
 * GNU POC (passwords on card) - manage passwords on smartcards
 * Copyright (C) 2001 Henning Koester <henning@crackinghacking.de>
 *
 * Please report bugs to bug-poc@gnu.org
 *
 * This file is part of POC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: cardinfo.h,v 1.2 2001/08/18 16:07:24 henning Exp $ */

#ifndef _CARDINFO_H_
#define _CARDINFO_H_

/* Tags */
#define DESCRIPTION   		0x80
#define PASSWORD      		0x81

/* size of the tags in byte (DESCRIPTION-TAG + PASSWORD-TAG) */
#define TAG_SIZE        	2

/* the card's size is stored in the first 2 bytes of the card */
#define CARD_SIZE_OFFSET 	0

/* the size of data on the card is written in the 3-4 bytes of the card */
#define DATA_SIZE_OFFSET	2	

/* the "data-area" of the card starts at offset 4 */
#define DATA_AREA_START_OFFSET	4

#endif

