#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# FILE:
# GREngine.py
#
# DESCRIPTION:
# Class that loads and populates a report
#
# NOTES:
#
# HISTORY:
#

import os, sys
import urllib
import GRReport
import GRParser
import GRExceptions
import GRFilters
from gnue.common.apps import GDebug
from gnue.common.utils.FileUtils import openResource, dyn_import
from gnue.common.datasources import GConnections


class GREngine:

  def __init__(self, connectionManager):
    self._connectionManager = connectionManager
    assert gDebug(1,'GREngine instance started: %s' % self._connectionManager)

  #
  # Run the report (reportFile) and generate the XML output.
  # Write the XML output to the outputHandle IOStream
  #
  def processReport(self, reportFile,
                          destination="",
                          destinationOptions="",
                          destinationType="",
                          filter="",
                          batch=0,
                          filterOptions="",
                          parameters={},
                          sortoption=None,
                          includeStructuralComments=0,
                          omitGNUeXML=0):

    if not destination:
      destination = gConfigReports('DefaultDestination')
    if not destinationType:
      destinationType = gConfigReports('DefaultDestinationType')
    if not filter:
      filter = gConfigReports('DefaultFilter')

    self.filters = GRFilters.GRFilters()

    try:
      fileHandle = openResource(reportFile)

      report = GRParser.loadFile(fileHandle, self._connectionManager)

    except IOError, msg:
      raise GRExceptions.ReportUnreadable, \
         "Unable to read the requested report definition\n  (%s)\n\n" % reportFile \
         + "Additional Information:\n  %s" % msg
    except GConnections.NotFoundError, msg:
      raise GRExceptions.ConnectionUndefined, \
         "Unable to process the report\n  (%s)\n\n" % reportFile \
         + "Additional Information:\n  %s" % msg
      


    #
    # Where are we destined for?
    #

    if destinationType == 'file' and destination == '-':
      # Handle the special case of stdout
      destAdapter = dyn_import('gnue.reports.adapters.destinations.file.stdout')
    else:
      # Load a destination adapter
      destAdapter = dyn_import('gnue.reports.adapters.destinations.%s.%s' % \
                      (destinationType, gConfigReports('%sAdapter' % destinationType)))

    # Create a Destination Adapter
    dest = destAdapter.DestinationAdapter(destination, destinationOptions)

    # Hmm... maybe this should be a little cleaner
    namespace = report._namespace

##
## TODO: This is incorrect... it's plausible to not have a namespace.
## TODO: I am leaving it until the SimpleReport wizard is fixed!
##
##    # if no namespace provided set namespace to SimpleTabulation
##    if namespace==None:
##      namespace="GNUe:Reports:SimpleTabulation"

    # Create a Filter Adapter
    filtAdapter = self.filters.loadFilter(namespace,
                                          filter,
                                          dest,
                                          filterOptions)

    report.process(filtAdapter.open(), parameters, sortoption, \
                   includeStructuralComments=includeStructuralComments,
                   omitGNUeXML=omitGNUeXML)

    # Cleanup
    filtAdapter.close()


#    GDebug.printMesg(999, '-'*60)
#    GDebug.printMesg(999, report.dumpXML(1))
#    GDebug.printMesg(999, '-'*60)


