# GNU Enterprise Forms - QT3 UI driver - ScrollBar widgets
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: scrollbar.py 9956 2009-10-11 18:54:57Z reinhard $

from PyQt4 import Qt as qt

from gnue.forms.uidrivers.qt4.widgets._base import UIHelper

# =============================================================================
# The scrollbar widget
# =============================================================================

class UIScrollBar(UIHelper):
    """
    Implementation of the <scrollbar> tag
    """

    # -------------------------------------------------------------------------
    # Create a new widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):

        parent = event.container

        self.widget = qt.QScrollBar(qt.Qt.Vertical, parent)
        self.getParent().add_widgets(self, spacer)

        self.widget.connect(self.widget, qt.SIGNAL('valueChanged(int)'),
                self.__on_value_changed)

        return self.widget


    # -------------------------------------------------------------------------
    # Handle changes of the current value 
    # -------------------------------------------------------------------------

    def __on_value_changed(self, value):

        self._gfObject._event_scrollToRecord(value)


    # -------------------------------------------------------------------------
    # Adjust the scrollbar to a new position
    # -------------------------------------------------------------------------

    def _ui_adjust_scrollbar_(self, position, size, count):

        self.widget.setMaxValue(count)
        self.widget.setPageStep(size)
        self.widget.setValue(position)

# =============================================================================
# Configuration
# =============================================================================

configuration = {
  'baseClass': UIScrollBar,
  'provides' : 'GFScrollBar',
  'container': 0,
}
