#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# FILE:
# uidrivers/html/common.py
#
# DESCRIPTION:
#
# NOTES:
#

import string
from gnue.common import events
from gnue.common.apps import GConfig
from types import UnicodeType, StringType

FIX = 24

_idPos = -1

def getNextId():
    global _idPos
    _idPos += 1
    return _idPos


def textEncode(u_string):
    if type(u_string)==UnicodeType:
        return u_string.encode(gConfig('textEncoding'),'replace')
    else:
        return u_string


def textDecode(string):
    if type(string)==StringType:
        return unicode(string, gConfig('textEncoding'))
    else:
        return string
