# GNU Enterprise Common - Setup Script for py2exe
#
# Copyright 2001-2007 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: setup.py 9746 2007-07-11 08:01:16Z johannes $

import os
import sys
import py2exe
import win32api
import win32con

from distutils.core import setup

# -----------------------------------------------------------------------------
# Constants used by this setup
# -----------------------------------------------------------------------------

# The path where we are creating the build environment for the setup compiler
GNUE_PATH='C:\\GNUE'            
# The config files to rewrite (wrt line-ending)
CFG_FILES = ['gnue.conf', 'connections.conf']
# The InnoSetup configuration file
ISS_FILE = 'gnue-common.iss'


# -----------------------------------------------------------------------------
# Run the setup to create all the exe files in the gnue-common package
# -----------------------------------------------------------------------------
def create_exe_files():
    """
    Create gnue-schema.exe (which is currently the only exe supplied by
    gnue-common.
    """

    setup( \
        console = ['gnue-schema'],
        options = {"py2exe":
            {"dll_excludes": ["msvcp60.dll",
                              "tcl84.dll",
                              "tk84.dll",
                              "oci.dll"],
             "excludes": ["gnue", "wx", "mx", "PIL"]
            }
        }
    )


# -----------------------------------------------------------------------------
# Finalize the build environment
# -----------------------------------------------------------------------------

def finalize_build_env():
    """
    Finalize the build environment ready to be processed by the setup compiler
    """

    for name in CFG_FILES:
        fhd = open(os.path.join(GNUE_PATH, 'etc', 'sample.%s' % name))
        data = [line.strip() for line in fhd.readlines()]
        out = open(os.path.join(GNUE_PATH, 'etc', name), 'wb')
        for line in data:
            out.write('%s%s' % (line, os.linesep))
        out.close()
        fhd.close()


# -----------------------------------------------------------------------------
# Examine the registry to find out where the InnoSetup compiler is located
# -----------------------------------------------------------------------------

def get_istool():
    root = win32con.HKEY_CLASSES_ROOT
    item = "InnoSetupScriptFile\\shell\\OpenWithISTool"
    try:
        path = None
        key = win32api.RegOpenKeyEx(root, item, 0, win32con.KEY_READ)
        value = win32api.RegQueryValue(key, "command")
        if isinstance(value, basestring):
            path = value.split(' ', 1)[0]
    except:
        pass

    return path

# -----------------------------------------------------------------------------
# Compile the setup
# -----------------------------------------------------------------------------

def compile_setup():
    
    istool = get_istool()
    if not istool:
        print "Cannot find ISTool.exe"
        sys.exit(1)

    cmd = '%s -compile %s' % (istool, ISS_FILE)
    os.system(cmd)


# =============================================================================
# Main program
# =============================================================================

create_exe_files()

finalize_build_env()

compile_setup()
