// GNU Enterprise Application Server - List Object
//
// Copyright 2001 Free Software Foundation
//
// This file is part of GNU Enterprise.
//
// GNU Enterprise is free software; you can redistribute it 
// and/or modify it under the terms of the GNU General Public 
// License as published by the Free Software Foundation; either 
// version 3, or (at your option) any later version.
//
// GNU Enterprise is distributed in the hope that it will be 
// useful, but WITHOUT ANY WARRANTY; without even the implied 
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
// PURPOSE. See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public 
// License along with program; see the file COPYING. If not, 
// write to the Free Software Foundation, Inc., 59 Temple Place 
// - Suite 330, Boston, MA 02111-1307, USA.
//
// $Id: gnue-forms.js,v 1.2 2003/09/22 21:50:37 siesel Exp $

var gnue_forms_version = "0.0.4"; 


// TODO: - save/delete/insert (done) 
//       - show "MOD" in toolbar (99%) [missing: update after entrychange]
//       - query mode / queries (done)
//       - visual changes (resize window to fit better)
//       - reactivate WebForm wizard (working great)
//       - rows/buttons
//       - multiple block support (done) / master-slave blocks (70%)
//       - show Message to let the user know that he is logged out/logged in 
//         something like a white field (logged out)+ (login button) [done]
//       - implement better error message parsing
//       - remove deleted entries after pressing commit
//       - allow inserting record at the point
//       - just update parts of a record/single fields
//       - support more entry attributs (f.e. readonly)
//       - add GFBox, GFImage types
//       - use 'count' to fetch real size of resultset 
//       - add error handler for internal errors

// ****************************************************
// BASIC GNUe Common (for javascript/JScript) functions
//    * Typecast, GObj, GParser...
// ****************************************************
var doc;

function getObjById_unsecure(id) {
  if (document.all)   /* MSIE, Konqueror, Opera: --- */
    return eval("document.all."+id);
  else
    val=document.getElementById(id);
  if ((val==undefined) && (doc!=undefined)) {
    val=doc.getElementById(id);
  }
  return val;
}

function getObjById(id) {
  val= getObjById_unsecure(id);
  if (val==undefined) {
    alert("Couldn't access object '"+id+"'! Probably the forms file has errors.");
  };
  return val;
}

function GTypecastF() {
  this.text = function(obj,field,value) {
    obj[field]=value;
  };
  this.name = function(obj,field,value) {
    obj[field]=value;
    //  return string.strip(str(value))
  };
  this.names = function(obj,field,value) {
    obj[field]=STRING.split(value,',');
  };
  this._booleantrue=Array('N','n','F','f','0');
  this._boolean = function(obj,field,value) {     
    obj[field]=(this._booleantrue[value]==null);
  };
  this.whole = function(obj,field,value) {
    obj[field]=Math.abs(value); 
  };
  this.number = function(obj,field,value) {
    obj[field]=parseFloat(value); 
  };
  this.integer = function(obj,field,value) {
    obj[field]=parseInt(value); 
  };
  this.uppername = function(obj,field,value) {
    obj[field]=value.toUpperCase();
  };
  this.lowername = function(obj,field,value) {
    this.name(obj,field,value.toLowerCase());
  };
}
var GTypecast = new GTypecastF();
var id=0;
function GObj(myparent) {
  this._type="GObj";
    
  this._setParent = function(par) {
    this._parent=par;
    if (par!=null) {
      par._children[id]=this;
      id=id+1;
    };
    this._children=Array();
  };
  this._getChildOfType= function(searchtype) {
    if (this._children!=null){  
      for (i in this._children){
        if (this._children[i]._type==searchtype){
          return this._children[i];
	}
      }
    }
    return null;
  }
  this._getParentOfType= function(searchtype) {
    if (this._parent==null){
      return null;
    };
    if (this._parent._type==searchtype){ 
      return this._parent;
    };
    return this._parent._getParentOfType(searchtype);
  };
  this._showTree = function (spaces) {
    // indent
    for (j=0;j<spaces;j++) {
      doc.write("?");  
    }
    
    // type+attributs  
    doc.write("<b>"+this._type+"</b>(");
    for (i in this) {
      if (i.charAt(0)!="_") {
	doc.write(i+"=" + this[i]+",");
      }
    } 
    doc.write("):<br>");
    
    // children
    if (this._children!=null) {
      for (i in this._children) {
	this._children[i]._showTree(spaces+1);
      }
    }
  };
}

// *************************************************
// GParser equivalent in JS
// *************************************************

// just works in Mozilla (Gecko) and IE for now

function getXMLDOMObject(xmlcontent) {
  
  if(isIE){
    obj = new ActiveXObject("microsoft.XMLDOM"); 
    obj.loadXML(xmlcontent);
  } else {
    if(isNS){
      obj = new DOMParser();
      obj = obj.parseFromString(xmlcontent, "text/xml");
    } else{
      this.handleError(new Error("Unknown Object"));
    }
  }
  return obj;
}



//
// process each element in the DOM tree. 
//
function GParser() {
  this.xmlElements={};
  this.processElement=function(elem,myparent) {
    var children, cChildren, child;
    var i, val, results, obj;
    
    setStatus("Parsing ("+elem.tagName+")...");
    
    if (elem == null)
      {
        alert("The passed file is not proper XML");
        window = document;   // Force a run-time error to bail
      }
    
      
    if (this.xmlElements[elem.tagName]) { 
      
      elemdef=this.xmlElements[elem.tagName];
      // build object
      obj = new elemdef.BaseClass(null);
      obj._setParent(myparent);
      // obj._type=elem.tagName    	
	
      // compute all Elements 
      for (j in elemdef.Attributes) {	
	
	// load attribut value 
	val = elem.getAttribute(j.toLowerCase());
	
	// load default
	if (val==null) 
	  if (elemdef.Attributes[j]["Default"]) {
	    val=elemdef.Attributes[j]["Default"];
	  }
	  
	// add attribute to the object
	if ((val != "") && (val != null)) {            
	  elemdef.Attributes[j]['Typecast'](obj,j,val);
	} else {
	    // warn if an element is not provided, but required
	  if (elemdef.Attributes[j]['Required']==1) {
	    alert("Element "+i+" requires Attribute "+ j);
	  }
	}
      }
      
    } 
            
    // If the element has children, process these
    //  children = elem.getElements();  [XMLforScript]
    children = elem.childNodes; // [internal DOM]
    if (children != null)
      {	
        cChildren = children.length;	
        for (i = 0; i < cChildren; i++)
	  {
            child = children[i];
            this.processElement(child,obj);
	  }
      }
    return obj;
  };
    
  // the standart error handler
  this.xmlError=function (e) {
    //there was an error, show the use

    // TODO: parse error string and store error in
    // XMLRPC.error
    alert('The XML Parser has found an error: '+e);
  };
}

// format not quite the same as in GParser.py 
function loadXMLObject(content, handler, rootType,
                      fileType,initialize,attributs) {
    var xmlDoc,rootElem;
    
    setStatus("Creating XML object...");
    xmlDoc = getXMLDOMObject(content);  // [internal DOM]
    // xmlDoc = new XMLDoc(content, handler.xmlError) [XMLforScript]
    
    setStatus("Traverse the DOM tree to build an populated XML object tree.");
    // rootElem=handler.processElement(xmlDoc.docNode,null); [XMLforScript]
    rootElem=handler.processElement(xmlDoc.documentElement,null);//[internal DOM]

    if (rootElem._type!=rootType) {
      alert("XML file has wrong rootType.("+
	    rootType+"!="+rootElem._type+")");
    }
    
    return rootElem;
}

// ******* Forms specific part of the parser

myXMLHandler = new GParser();
myXMLHandler.xmlElements = getXMLDefinition();
  
function loadDefinition(content) {
  return loadXMLObject (content, myXMLHandler, "GFForm", 'gnurpc',
			null,null);
}



//
// Write information to the browser status bar.
//
function setStatus(s)
{
  window.status = s;
}


// ************ Stubs to connect to Appserver ************************

// TODO: use multicall 

XMLRPC.onerror = function(e){
  alert(e);
  return true;
}

XMLRPC.ontimeout = function(){
  alert("This call has timed out, please retry!");
  return true;
}


// ************* Javascript stub *******************

function Appserver_Session(host, proxy){
  this.proxy = proxy;
  XMLRPC.routeServer = proxy;
  //  XMLRPC.DEBUG = true;

  
  this.version = '0.0.2';
  this.rpcinterfacetype = '4.3';
  this.host=host;
  this.open = function (authentification) {
    var x;
    x = XMLRPC.call(this.host,'open',authentification);
    alert(x + x.__rpc_datatype__ + x.__id__);
    if (x.__rpc_datatype__ == 'object') {
       this.rpcinterfacetype = '4.4';
       // return x.__id__;
       return x
    } else {
       return x
    };
  };
  this.close = function (sessionid,commit) {
    if (this.rpcinterfacetype=='4.4') {
      return XMLRPC.call(this.host,'_call',sessionid,'close',commit);
    } else {
      return XMLRPC.call(this.host,'close',sessionid,commit);
    }
  };
  this.commit = function (sessionid) {
    if (this.rpcinterfacetype=='4.4') {
      return XMLRPC.call(this.host,'_call',sessionid,'commit');
    } else {
      return XMLRPC.call(this.host,'commit',sessionid);
    };
  };
  this.rollback = function (sessionid) {
    if (this.rpcinterfacetype=='4.4') {
      return XMLRPC.call(this.host,'_call',sessionid,'rollback');
    } else {
      return XMLRPC.call(this.host,'rollback',sessionid);
    };
  };
  this.request = function (sessionid,classname,conditions,sortorder,propertylist) {
    if (this.rpcinterfacetype=='4.4') {
      return XMLRPC.call(this.host,'_call',sessionid,'request',classname,conditions,sortorder,propertylist);
    } else {
      return XMLRPC.call(this.host,'request',sessionid,classname,conditions,sortorder,propertylist);
    }
  };
  this.count = function (sessionid,listid) {
    if (this.rpcinterfacetype=='4.4') {
      return XMLRPC.call(this.host,'_call',listid,'count');
    } else {
        return XMLRPC.call(this.host,'count',sessionid,listid);
    }
  };
  this.fetch = function (sessionid,listid,start,count) {
    if (this.rpcinterfacetype=='4.4') {
      return XMLRPC.call(this.host,'_call',listid,'fetch',start,count);
    } else {
      return XMLRPC.call(this.host,'fetch',sessionid,listid,start,count);
    }
  };
  this.load = function (sessionid,classname,objids,propertylist) {
    if (this.rpcinterfacetype=='4.4') {
      return XMLRPC.call(this.host,'_call',sessionid,'load',classname,objids,propertylist);
    } else {
      return XMLRPC.call(this.host,'load',sessionid,classname,objids,propertylist);
    };    
  };
  this.store = function (sessionid,classname,objids,propertylist,data) {
    if (this.rpcinterfacetype=='4.4') {
      return XMLRPC.call(this.host,'_call',sessionid,'store',classname,objids,propertylist,data);
    } else {
        return XMLRPC.call(this.host,'store',sessionid,classname,objids,propertylist,data);
    };    
  };
  this.call = function (sessionid,classname,objids,methodname,parameters) {
    if (this.rpcinterfacetype=='4.4') {
       return XMLRPC.call(this.host,'_call',sessionid,'call',classname,objids,methodname,parameters);
    } else {
        return XMLRPC.call(this.host,'call',sessionid,classname,objids,methodname,parameters);
    };    
  };
  this.dodelete = function (sessionid,classname,objids) {
    if (this.rpcinterfacetype=='4.4') {
      return XMLRPC.call(this.host,'_call',sessionid,'delete',classname,objids);
    } else {   
      return XMLRPC.call(this.host,'delete',sessionid,classname,objids);
    };    
  };
  this.getFilters = function (language) {
    return XMLRPC.call(this.host,'getFilters',language);
  }

}
function Management(sess,sessid) {
  this.Restart = function() {
    // TODO: add management interface to appserver
  };
  this.Shutdown = function(timeout) {
  };
  this.Status = function() {
  };
}


// **************** HELPER FUNCTIONS

function GRecord(rset,id,data) {
  this.data=data;
  this.rset=rset;
  this.id=id
  this.is_deleted=0;
  this.is_modified=0;
  this.get=function(fieldname) {
    value=this.data[fieldname];
    if (value==undefined) {
      return "";
    } else {
      return value;
    }

  };
  this.put=function(fieldname,value) {
    if (this.data[fieldname]!=value) {
      this.data[fieldname]=value;
      if ((this.data[fieldname]!=undefined)&&(value!="")) {
	// set modified flag
	this.is_modified=1;
      }
    }
    return this.is_modified;	
  };
  this.toggleDelete=function() {
    if (this.is_deleted==1) {
      this.is_deleted=0;
    } else {
      this.is_deleted=1;
    }
  };
}

function GResultSet(sess,sessid,listid,fields,table,cachesize) {
  this.sess=sess;
  this.sessid=sessid;
  this.listid=listid;
  this.fields=fields;
  this.table=table;
  this.listpos=0;
  this.lastRec=0;
  this.cursor=0;
  this.cachedRec={};
  this.cacheS=cachesize;
  this.populateCache=function() {
    // 1. fetch some data
    this.data=this.sess.fetch(this.sessid,this.listid,this.listpos,this.cacheS);

    // 2. check if still data there
    if ((this.data==0)|| (this.data==undefined))  {
      return 0; 
    }

    // 3. for all new records
    for (x in this.data) {
      if (x!="toXMLRPC") {

	//   a. update listpos
	this.listpos=this.listpos+1;
	this.record=this.data[x];

	// b. convert data(array) into dictornary    
	id=this.record[0];
	rdata={};
	i=1;
	for (f in this.fields) {
	  if (f!="toXMLRPC") {
	    rdata[f]=this.record[i];	
	    i=i+1;
	  }
	}
	  
	// c. build, cache and return GRecord
	this.cachedRec[this.lastRec]=new GRecord(this,id,rdata)

	this.lastRec=this.lastRec+1;
      };
    };
    return 1;
  };

  this.currentRecord=function(){
    if (this.cursor<0) {
      this.cursor=0;
    }
    if (this.cursor<this.lastRec) {
    z="";
    for (x in this.cachedRec) {
      z=z+"#"+this.cachedRec[x]+"#";
    }
      return this.cachedRec[this.cursor];

    } else {
      if (this.populateCache()!=1) {
	this.insertRecord();
      }
    }
    if (this.cursor==this.lastRec) {
      this.cursor=this.lastRec-1;
    }
    z="";
    for (x in this.cachedRec) {
      z=z+"#"+this.cachedRec[x]+"#";
    }
    return this.cachedRec[this.cursor];
  };

  this.nextRecord=function() {
    if (this.cursor+1>=this.lastRec) {
      if (this.populateCache()!=1) {
        // check if the last record is already an new (id=0) and umodidified one
        if ((this.cachedRec[this.cursor].is_modified==0)&&
            (this.cachedRec[this.cursor].id==0)) {
	      return this.cachedRec[this.cursor];
	    }
	return this.insertRecord();
      }
    }
    this.cursor=this.cursor+1;
    return this.cachedRec[this.cursor];
  };

  this.previousRecord=function() {
    if (this.cursor>0) {
      this.cursor=this.cursor-1;
    }
    return this.cachedRec[this.cursor];
  };

  this.lastRecord=function() {
    while (this.populateCache()==1) {
    }
    this.cursor=this.lastRec-1;
    return this.cachedRec[this.cursor];
  };

  this.firstRecord=function() {
    this.cursor=0;
    return this.cachedRec[this.cursor];
  };

  this.insertRecord=function() {
    // TODO: insert new record at cursor pos instead of appending it to the end.
    this.cachedRec[this.lastRec]=new GRecord(this,0,{});
    this.cursor=this.lastRec;
    this.lastRec=this.lastRec+1;
    return this.cachedRec[this.cursor];
  };

  this.RecordCount=function() {
    return this.lastRec;
  };

  this._post=function() {
    // parse all records
    del_list=Array();
    store_list=Array();
    store_values=Array();
    for (pos in this.cachedRec) {
      if (pos!="toXMLRPC") {

	// add deleted (but now newly created) records to delete list
	if (this.cachedRec[pos].is_deleted==1) {
	  id=this.cachedRec[pos].id;
	  if (id!=0) {
	    del_list.push(id);
	  };
	} else {

	  // update modified records
	  if (this.cachedRec[pos].is_modified==1) {
	    id=this.cachedRec[pos].id;
	    data=this.cachedRec[pos].data;
	    
	    values=Array();
	    for (f in this.fields) {
	      if (f!="toXMLRPC") {
		values.push(data[f]);
	      }
	    }
	    store_list.push(id);
	    store_values.push(values);
	    this.cachedRec[pos].is_modified=0;

	  }
	}
      }
    }
    if (del_list.length>0) {
      // delete records
      this.sess.dodelete(this.sessid,this.table,del_list);
    }
    if (store_list.length>0) {
      // build fieldlist, i.e. field which needs to be updated
      fieldO=Array();
      for (fname in this.fields) {
	if (fname!="toXMLRPC") {
	  fieldO.push(fname);
	}
      }
      this.sess.store(this.sessid,this.table,store_list,fieldO,store_values);
    }

  };

};


// ************* Form XML objects **************

GFImport.prototype=new GObj();
function GFImport(myparent) {
  this._type="Import";
}
GFDataSource.prototype=new GObj();
function GFDataSource(myparent) {
  this._type="GFDataSource";
  this.cache=6; // default value
  this.init=function(sess,sessid,fields) {
    this._sess=sess;
    this._sessid=sessid;
    this._fields=fields;
  };
  this.createEmptyResultSet = function() {
    return this.createResultSet(Array(Array("eq",
				      Array("const","1"),
				      Array("const","0"))));
  };
  this.createResultSet = function(condition) {

    sortorder=Array();
    if (this.order_by!=undefined) {
      // TODO: split order_by to support "field1,field2" values 
      sortorder[0]=this.order_by;
    }
    if (condition==undefined) {
      condition = Array(Array("eq",Array("const","0"),Array("const","0")));
    }
    listid=this._sess.request(this._sessid,this.table,
			      condition,sortorder,this.buildPrefetch());
    if (listid==0) {
      alert('Error populating datasource "'+this.name+'"!');
    }
    return new GResultSet(this._sess,this._sessid,listid,this._fields,
                          this.table,this.cache);
  };
  this.buildPrefetch = function() {
    res=Array();
    for (fname in this._fields) {
      if (fname!="toXMLRPC") {
        res.push(fname);
      }
    }
    return res;   
  }

  
}
GFDatabase.prototype=new GObj();
function GFDatabase(myparent) {
  this._type="GFDatabase";
}
GFEntry.prototype=new GObj();
function GFEntry(myparent) {
  this._type="GFEntry";
  this._init=function() {
    // this._block=this._getParentOfType('GFBlock');
    
  }
  this._toHTML=function () {
    this._init();
    r ='<input type="text" id="'+this.block+"_"+this.field+'_field"';
    r+='" onfocus="form.gotoBlock('+"'"+this.block+"');"+'"'
    r+='>';
    return r;
  }
}
GFField.prototype=new GObj();
function GFField(myparent) {
  this._type="GFField";
  this._init=function() {
    this._block=this._getParentOfType('GFBlock');
    
  }
  this._toHTML=function () {
    this._init();
    return '';
  }
}
GFLabel.prototype=new GObj();
function GFLabel(myparent) {
  this._type="GFLabel";
  this._toHTML=function () {
    return this.text;
  }
}
GFBox.prototype=new GObj();
function GFBox(myparent) {
  this._type="GFBox";
  this._toHTML=function () {
    return this.text;
  }
}
GFButton.prototype=new GObj();
function GFButton(myparent) {
  this._type="GFButton";
  this._init=function() {
    this._block=this._getParentOfType('GFBlock');
    
  }
  this._toHTML=function () {
    this._init();
    r ='<input type="button" name="'+this.name+'" value="'+this.label+'"';
    //    r+='" onfocus="form.gotoBlock('+"'"+this._block.name+"');"+'"'
    // set ONCLICK attribute
    r+='>';
    return r;
  }
}
GFTrigger.prototype=new GObj();
function GFTrigger(myparent) {
  this._type="GFTrigger";
}
GFScrollBar.prototype=new GObj();
function GFScrollBar(myparent) {
  this._type="GFScrollbar";
}
GFOptions.prototype=new GObj();
function GFOptions(myparent) {
  this._type="GFOptions";
}
GFOption.prototype=new GObj();
function GFOption(myparent) {
  this._type="GFOption";
}
GFForm.prototype=new GObj();
function GFForm(myparent){
  this._type="GFForm";
  this.version = gnue_forms_version;
  this.blocks = Array();
  this.changed=false;
  this.busy=0; // should be set to one if busy // similar to global lock
  this._children=Array()  
  this.init = function() {
    this._scanpages();
    this._buildBlockList(this);
  }
  this.addBlock = function (block){
    this.cur_block=block;
    return this.blocks[block.name]=block;
  };  
  // run/startup a form
  this.run = function() {
    // 1. check for connection
    if (this.sess==undefined) {
      // 1. try to fetch host+proxy settings from get/set cookies
      rpc_addr=undefined;
      //rpc_addr=fetch_getvar('rpc_addr')

      // 2. if not there use autodetection (use location object)

      if (rpc_addr==undefined) {
        // autodetect connection
        rpc_addr=location.protocol+location.host;
        rpc_addr="http://"+location.host+":8765/";
	    proxy="http://"+location.host+"/cgi-bin/rpcproxy.cgi";
	    if (location.host=='gnue-webfrontend') {
        	rpc_addr='http://localhost:8765/';
        };
      }
      //  3. if that doesnt work, ask user
      // TODO: Implement fetchrpc addr+login test loop

      this.setConnection(new Appserver_Session(rpc_addr,proxy));
    }
    //    setStatus("Show Login Dialog");  // but for the new window
    this.login('hacker','secret');
    //if (this.username==undefined) {
    //
    // show login dialog   
    // ld=getObjById("loginForm");
    // if (ld != undefined) {
    //   ld.style.visibility = "visible";
    // }
  // this.showLoginWindow();
    //}
  };
  this.setConnection = function(sess) {
    this.sess = sess;    
  };
  this.doLogin = function () {
    this.login(getObjById("username").value,getObjById("password").value);
  }
  this.login = function (user,pass) {
    this.sessid = this.sess.open({"user":user,"password":pass});
    if (this.sessid==0) {
      alert("Login not succesful")
	// getObjById("loginmsg").innerHTML="not succesful";
      return false;
    }
    // hide login dialog   
    ld=getObjById_unsecure("loginForm");
    if (ld != undefined) {
      ld.style.visibility = "hidden";
    }
 
    if (this.loginWin!=undefined) {
      this.loginWin.close();
    }
    // redraw form  
    //  getObjById("formarea").innerHTML=this._myformarea;
    this.loggedout=0;
    setStatus("connection set up"+this.sessid);
    this.init()
    setStatus("Building Block list");
    this.cur_block=this.blocks[0];
    for (ib in this.blocks) {
      if (ib!="toXMLRPC") {
	setStatus("Loading Block "+ib);
	blk=this.blocks[ib];

        // HACK ************
        blk.table=blk.datasource;

	blk.init();
	setStatus("Loading Block "+ib+"(finished)");
      }
    }	  
    setStatus("setup cursor position");
    this.cur_block.showState();
    setStatus("Ready for user input");
  }
  this._buildBlockList=function(obj) {
    if (obj._type=="GFBlock") {
      next=this.blocks.length;
      this.blocks[next]=obj;
    } else {
      // just search block in pages etc. (don't support nested blocks)
      if ( obj._children!=null) {
	for (ib in obj._children) {
	  this._buildBlockList(obj._children[ib])
	}
      }
    }
    
  }
  // this function is not called
  this.update = function () {
    for (is in this.blocks) {
      if (is!="toXMLRPC") {
	this.blocks[is].showState();
	this.changed=this.changed || this.blocks[is].changed;
      }
    }
  }
  this.about = function() {
    r="         GNUe Forms\n";
    r+="Version: "+this.version+"\n";
    r+="Name: "+this.name+"\n";
    alert(r);
  }
  this.executeTrigger = function(triggername) {
    alert ("Trigger '"+triggername+"' is executed!");
  }
  this.gotoBlock = function (blockname) {
    if (this.cur_block.name==blockname) {
      return true
    };
    setStatus("Active Block: "+blockname+" (Last Block: "+ this.cur_block.name+ ")");
    this.cur_block.getState();
    this.cur_block.deactivateFields();
    for (ik in this.blocks) {
      if (this.blocks[ik].name==blockname) {
	this.cur_block=this.blocks[ik];
	break;
      }
    }
    this.cur_block.activateFields();
    this.cur_block.showState();
    return true;
  }
  this.gotoPage = function (pgname) {
    //    this.cur_block.update();
    //    this.cur_page.update();    
    // TODO: activate Block
    this.cur_block.deactivateFields();
    pgno=-1;
    for (pi in this._pages) {
      if (pi!="toXMLRPC") {
	if (this._pages[pi].name==pgname) {
	  pgno=pi;
	}
      }
    }
    if (pgno!=-1) {
      this.cur_page.setVisible('hidden');
      this._pages[pgno].setVisible('visible');	
      this.cur_page=this._pages[pgno];
    }
    this.cur_block.activateFields();
  }
  this.newrec = function () {
    this.cur_block.newrec();
  }
  this.next = function () {
    this.cur_block.next();
  }
  this.prev = function () {
    this.cur_block.prev();
  }
  this.execQ = function () {
    this.cur_block.execute_query();    
  }
  this.prepQ = function () {
    this.cur_block.prepare_query();    
  }
  this.del = function () {
    this.cur_block.del();
  }
  this.recordCount = function () {
    this.cur_block.recordCount();
  }
  this.commit = function () {
    for (ci in this.blocks) {
      if (ci!="toXMLRPC") {
	this.blocks[ci].commit();
	this.changed=this.changed || this.blocks[ci].changed;
      }
    }    
    this.sess.commit(this.sessid);      
    this.changed=false;

  }
  this.rollback = function () {
    for (ri in this.blocks) {
      if (ri!="toXMLRPC") {
	this.blocks[ri].rollback();
	this.changed=this.changed || this.blocks[ri].changed;
      }
    }
    this.sess.rollback(this.sessid);
    this.changed=false;
  }
  this.close = function () {
    // first prompt
    // this.cur_block.getState();
    if (this.loggedout == 1) {
      return
    }
    this.loggedout = 1;
    for (i in this.blocks) {
      if (i!="toXMLRPC") {
	this.blocks[i].getState();
	this.changed=this.changed || this.blocks[i].changed;
      }
    }    
    if (this.changed) {
      if (!confirm("Do you want to loose all changes?")) {
	alert("REALLY?")
	return false;
      }
    }
    this.sess.close(this.sessid,0);
    getObjById("status").innerHTML="Logged Out";
    ld=getObjById_unsecure("loginForm");
    if (ld != undefined) {
      ld.style.visibility = "visible";
    }
    // TODO: activate browser back button
      // remove login dialog
      // this.showLoginWindow();
  }
  this._display = function (todoc) {
    // show header
    outp='<DIV ID="formarea">\n';
    outp+=this.showNavigationBar();
    if (this.tabbed) {
      outp+=this.showPageTab();
    }
    page=this._getChildOfType("GFPage");
    outp+='<DIV ID="pagearea">';
    outp+=page._display();
    outp+='</DIV>\n';  // close pagearea
    outp+=this.showStatusBar();
    outp+='</DIV>\n';  // close formarea
    return outp;
  }
  this._scanpages = function () {
    var next,i;    
    this._pages=Array();
    for (i in this._children) {
      if (this._children[i]._type=="GFPage") {
	next=this._pages.length;
	this._pages[next]=this._children[i];
      }
    }
    this.cur_page=this._pages[0]
  }
  this.showPageTab=function() {
    var i,r;
    r='<table align="center" BGCOLOR="#DDDDDD"><TR>'
    for (i=0;i<this._pages.length;i++) {
      r+='<TD onclick="javascript:form.gotoPage('+"'"+i+"'"+')">&nbsp;<BR>';
      r+=this._pages[i].name+'<BR>&nbsp;</TD><TD>&nbsp;</TD>';
    }
    r+='</TR></TD>';
    return r;
  }
  this.showLoginWindow=function() {
    // save form
    //this._myformarea=getObjById("formarea").innerHTML;
    this.loginWin = window.open("", "Appserver Login","width=400,height=250");
    doc = this.loginWin.document;
    doc.writeln("<HTML>");
    doc.writeln("<HEAD><TITLE>Appserver Login</TITLE>");
    doc.writeln("</HEAD><BODY>");
    ret='<table align="center" class="LOGIN" BGCOLOR="#DDDDDD"><tr>\n'+
      '<td colspan="2" align="center"><br><img src="img/gnue.png">\n'+
      '<br><b><div id="loginmsg"></div></b></td></tr><tr><td>User:</td>'+
      '<td><input type="text" id="user" value="hacker"></td></tr><tr><td>Password:</td>'+
      '<td><input type="password" id="password" value="secret"></td></tr><tr><td>'+
      '<a href="javascript:form.login(getObjById('+"'"+"user"+"'"+
      ').value,getObjById('+"'password'"+').value)">'+
      '<div class="button">Login</DIV></a></td></tr></table>';
    doc.writeln(ret);
    doc.writeln("</BODY></HTML>");
    this.loginWin["form"]=this;
    this.loginWin["getObjById"]=getObjById;
    // show loginwindow
    // getObjById("formarea").innerHTML=ret;
    //    this.loginWin=win;
  }
  this.showButton=function(img,name,alt,command,key) {
    b='<img src="images/'+img+'.png" name="'+name+'" alt="'+alt+'" onclick="'+
    command+';" onmouseover="'+name+'_mouseover();">\n';
    return b;
  }
  this.showNavigationBar=function() {
    r = '<center><br><img src="img/gnue.png"><br>?</center>'+
    '<TABLE BGCOLOR="#EEEEEE" ALIGN="CENTER"><TR><TD>'+
    '</TD><TD>'
    r+=this.showButton('tb_save',"commit","Commit","form.commit();",'n');
    r+=this.showButton('tb_new',"newrec","New Record","form.newrec();",'n');
    r+=this.showButton('tb_trash',"trash","Mark for Removal","form.del();",'n');
    r+='</TD><TD>?</TD><TD>'
    r+=this.showButton('tb_left_arrow',"prev","Previous Record","form.prev();",'');
    r+=this.showButton('tb_right_arrow',"next","Next Record","form.next();",'');
    r+='</TD><TD>?</TD><TD>'
    r+=this.showButton('tb_preferences',"prepq","Prepare Query","form.prepQ();",'');
    r+=this.showButton('tb_search',"query","Execute Query","form.execQ();",'');
    r+='</TD><TD>?</TD><TD>'
    r+=this.showButton('tb_undo',"rollback","Rollback","form.rollback();",'');
    r+='</TD><TD>?</TD><TD>'
    r+=this.showButton('tb_help',"help","About","form.about();",'');
    r+='</TD><TD>?</TD><TD>'
    r+=this.showButton('tb_close',"close","","form.close();",'');
    r+='</TD><TD>?</TD></TR><TABLE><BR>';
    return r;
  }  
  this.showStatusBar=function() {
    var r="";
    r+='<BR><TABLE BGCOLOR="#EEEEEE" ALIGN="CENTER">';
    r+='<tr style="border-top-width: 5mm; border-top-style: solid;">';
    r+='<td><div id="status"></div></td><td>?|?</td>';
    r+='<td><div id="pos"></div></td><td>?|?</td>';
    r+='<td><div id="max"></div></td></tr></table>';
    return r;
  }
}
GFBlock.prototype=new GObj()
function GFBlock(name,con){
  this._type="GFBlock"
  this.version = '0.0.1';
  this.table=name;
  this.name=name;
  this.fields = {};
  this.changed=false;
  this.lastinst="";
  this.querymode=0;
  this.detailB={}

  this.addField = function(entryname,fieldname){
    return this.fields[fieldname]=entryname;
  }

  this.addDetailBlock = function(block){
    l=this.detailB.length
    this.detailB[l]=block;
  }

  
  // get the corresponding entry element to a field
  this.getEntryElem = function(fname) {
    return getObjById(this.name+"_"+this.fields[fname]+"_field");
  }
  // get the corresponding entry element to a field
  this.getEntryName = function(fname) {
    return this.fields[fname];
  }
  // fetch entry value 
  this.getEntry = function(fname) {
    e=getObjById_unsecure(this.name+"_"+this.fields[fname]+"_field");
    if (e!=undefined) {
      return e.value;
    } else {
      alert("Field '"+fname+"' not found!")
      return undefined
    }
  }
  this.setEntry = function(fname,newval) {
    getObjById(this.name+"_"+this.fields[fname]+"_field").value=newval;
  }
  this.init = function() {
    // build list of field out of children
    if (this._children!=null) {
      for (i in this._children) {
	if (this._children[i]._type=="GFField") {
	  if (this._children[i].field!=null) {
	    this.addField(this._children[i].name,this._children[i].field);
	  }
	}
      }
    }
    // search connected datasource 
    this._form=this._getParentOfType('GFForm');
    for (i in this._form._children) {
      h=this._form._children[i];
      if ((h._type=="GFDataSource")&&
	  (h.name.toLowerCase()==this.datasource.toLowerCase())) {	      
	this._datasource=h;
	break;
      };
    };  
    if (this._datasource==null) {
      alert('No datasource found for block "'+this.name+'"!');
      // TODO: add fake datasource
      return
    };
    this._datasource.init(this._form.sess,this._form.sessid,this.fields);
    if (this._datasource.master!=undefined) {
      for (i in this._form._children) {
	h=this._form._children[i];
	if ((h._type=="GFBlock")&&
	    (h.datasource.toLowerCase()== this._datasource.master.toLowerCase())) {	      
	  h.addDetailBlock(this);
	  break;
	};
      };        
      if (h._rset==undefined) {
	// MASTER DATASOURCE not yet initialized -> create empty record for now
	this._rset=this._datasource.createEmptyResultSet();
      } else {
	// MASTER DATASOURCE initialized -> fetch masterlink field and compute 
	// client recordset
	this.masterval = h._curRec.get(this._datasource.masterlink);
	cond=Array(Array("eq",Array("field",this._datasource.detaillink),
		   Array("const",this.masterval)));
	this._rset=this._datasource.createResultSet(cond);
      }	
    } else {
      if ((this._datasource.prequery!=undefined)&&
	  (this._datasource.prequery!='0')&&
	  (this._datasource.prequery!='N')) {
	this._rset=this._datasource.createResultSet(undefined);
      } else {
	this._rset=this._datasource.createEmptyResultSet();
      }
    }
    this.updateDetailDts();
    this.showState();
  }
  this.getState = function() {
    //  this._curRec=this._rset.currentRecord();
    // fetch the values from the last record
    if (this.lastinst!="") {
      for (fname in this.fields) {
	if ((fname!="toXMLRPC")&&
	    (fname!=this._datasource.detaillink)) {	     	  
	  res=this.lastinst.put(fname,this.getEntry(fname));
	  this.changed=this.changed || res;
	}
      }
    }
    if (this._datasource.master!=undefined) {
      x=this.lastinst.is_modified;
      this.lastinst.put(this._datasource.detaillink,this.masterval);	  
      this.lastinst.is_modified=x;
    };
  }
  this.showState = function() {
    // 1. Update fields
    this._curRec=this._rset.currentRecord();
    for (fname in this.fields) {
      if (fname!="toXMLRPC") {	     
	this.setEntry(fname,this._curRec.get(fname));
      }
    }
    if (this._datasource.master!=undefined) {
      this.setEntry(this._datasource.detaillink,this.masterval);	  
    };
    this.lastinst=this._curRec;
    // 2. Update Statusbar / this should possibly moved into
    //    the GFForm object
    
    pos=getObjById_unsecure("pos");

    // first check if statusbar exists
    if (pos==undefined) {
      return;
    }
    pos.innerHTML=this._rset.cursor+1;
    getObjById("max").innerHTML=this._rset.RecordCount();
    if (this._curRec.is_deleted==1) {
      getObjById("status").innerHTML="DEL";
    } else {
      if (this._curRec.is_modified==1) {
	getObjById("status").innerHTML="MOD";
      } else {
	getObjById("status").innerHTML="&nbsp;&nbsp;&nbsp;";
      }
    }
  };

  // grey out fields to make it obvious the block is disabled
  this.deactivateFields=function() {
    for (fname in this.fields) {
      if (fname!="toXMLRPC") {	     
	getObjById(this.name+"_"+this.fields[fname]
		   +"_field").style.background="#fbfbfb";
      }
    }
  };

  // grey out fields to make it obvious the block is disabled
  this.activateFields=function() {
    for (fname in this.fields) {
      if (fname!="toXMLRPC") {	     
	getObjById(this.name+"_"+this.fields[fname]
		   +"_field").style.background="#ffffff";
      }
    }
  };

  // MASTER DETAIL STUFF
  this.updateDetailDts = function() {
    if (this.detailB.length==0) return;
    for (d in this.detailB) {      
      if (d!="toXMLRPC") {
	this._curRec=this._rset.currentRecord();
	this.detailB[d].refresh(this._curRec);
      }
    }
  };
  this.refresh = function(masterrec) {
    this.getState()
    if (this.changed) {
      // is this the right way?
      this._rset._post()
    };
    this.masterval = masterrec.get(this._datasource.masterlink);
    cond=Array(Array("eq",Array("field",this._datasource.detaillink),
		Array("const",this.masterval)));
    this._rset=this._datasource.createResultSet(cond);
    this._curRec=this._rset.currentRecord();
    this.updateDetailDts();
    this.showState();        
  }
  this.newrec = function() {
    if (this.querymode==1) return;
    this.getState()        
    this._rset.insertRecord()
    this.updateDetailDts();
    this.showState()        
  }
  this.next = function() {
    if (this.querymode==1) return;
    this.getState()        
    this._rset.nextRecord()
    this.updateDetailDts();
    this.showState()        
  }
  this.prev = function() {
    if (this.querymode==1) return;
    this.getState()        
    this._rset.previousRecord()
    this.updateDetailDts();
    this.showState()        
  }
  this.del = function() {
    if (this.querymode==1) return;
    this._curRec.toggleDelete()
      // this.updateDetailDts();
      // shouldDetailRecords be marked for delete too?
    this.showState()        
  }
  this.recordCount = function() {
    return this._rset.RecordCount();
  }
    
  this.prepare_query = function() {
    // check "changed flag"
    this.getState();
    if (this.changed) {
      alert("Please revert before you start a query!")
      return;
    }

    // set querymode
    this.querymode=1;
    getObjById("status").innerHTML="QUERY";

    // clear entrys (or populate with query defaults)
    for (fname in this.fields) {
      if (fname!="toXMLRPC") {
	this.setEntry(fname,"");
      }
    }    
  }    
  this.execute_query = function() {
    // TODO: fix cond
    cond=Array("and");
    if (this.querymode==1) {
      for (fname in this.fields) {
	if (fname!="toXMLRPC") {	     
          val=this.getEntry(fname);
	  if (val!="") {
	    // 1. check for condition type:
	    if (val[0]=="!") {
	      cond.push(Array("not",""));
	      val=val.substr(1,val.length);
	    }
	    if (val[0]==">") {
	      cond.push(Array("gt",""));
              val=val.substr(1,val.length);
	    } else {
               if (val[0]=="<") {
	          cond.push(Array("lt",""));
		  val=val.substr(1,val.length);
	      } else {
	    //  changed condition behavior
	      cond.push(Array("like",Array("field",fname),Array("const",val)));
                    //use like instead of eq
	      }
	    }
	    //cond.push();
	  }
	}
      }
    }
    if (cond==Array("and")) {
      cond=[];
    }
    this._rset=this._datasource.createResultSet(cond);
    this._curRec=this._rset.currentRecord();
    this.updateDetailDts();
    this.querymode=0;
    this.showState();    
  }    
  this.commit = function() {
    this.getState()
    this._rset._post()
    this.showState()   
    this.changed=false;  // TODO: try to remove this part
  }
  this.rollback = function() {
    this._rset=this._datasource.createEmptyResultSet();
    this._curRec=this._rset.currentRecord();
    this.showState();
    this.changed=false;
  }
}
GFPage.prototype=new GObj();
function GFPage(myparent) {
  this._type="GFPage";
  
  this.setVisible=function(value) {
    for (i in this._children) {
      if (i!="toXMLRPC") {
        child=this._children[i];
	//	alert(child._type+" : "+child.name)
	if (child._type=='GFEntry') {
	  getObjById(child.block+"_"+child.field+"_field").style.visibility=value;
	};
	if (child._type=='GFLabel') {
	  getObjById(child.name+"_label").style.visibility=value;
	};
	if (child._type=='GFButton') {
	  getObjById(child.name+"_button").style.visibility=value;
	};
	if (child._type=='GFBox') {
	  getObjById(child.name+"_box").style.visibility=value;
	};
      };
    }    
  }
  // the next function parses through the XML tree, build a list of
  // parts to show and creates a list of all needed X positions
  this._getElements=function(el) {
    if ((el._type=='GFEntry')||(el._type=='GFLabel')
	||(el._type=='GFButton')) {
      if (el.hidden!="Y") {
	next=this._list.length;
	this._list[next]=el;			

	if (el.y>this._maxY) {
	  this._maxY=el.y;
	}
	if (el.x>this._maxX) {
	  this._maxX=el.x;
	}
	
	if (!el.width) {
	  if (el._type=="GFLabel") {
	    el.width=el.text.length
          } else {
	    el.width=10;  
	  };
	}
	this._xlist[el.x-1+el.width+1]=el.x-1+el.width+1;
	// this.sdbg+='|'+el.x+','+el.width+':'+(el.x-1+el.width+1);
      }
    }
    if (el._children!=null)
    for (i in el._children) {
      this._getElements(el._children[i]);
    }
  }
  // this function build the html code for this page
  this._display=function(out) {
    this._list=Array();
    this._xlist=Array();
    this._xlist[0]=0;
    outp=""
    this._maxY=0;
    this._maxX=0;
    this._getElements(this);
    // do some autocomputing
    xres=30
    yres=30
    xbase=300
    ybase=200

    n = this._list.length;

    for (i=0;i<n;i++) {
      elem=this._list[i];

      outp+="<div style="+'"'+"position:absolute; top:"+
	(elem.y*yres+ybase)+"px; "+
	"left:"+(elem.x*xres+xbase)+"px; width:"+
	((elem.x+elem.width)*xres)+"px; "+
	"height:"+((elem.y+elem.height)*yres)+"px;"+'">';
      
      outp+=elem._toHTML();
    
      outp+="</div>";
     
    }
    // add placeholder
    outp+="<div style="+'"'+"height:"+((this._maxY)*yres)+"px;"+'"><H1>&nbsp;</H1></div>';
    //    outp+="</TR></TABLE>"; // +debg;
    return outp;
  }
}
function PlaceHolder(x,y,width,height) {
  
  this._toHTML=function() {
    return;
  }
}

function getXMLDefinition() {
  var xmlElements;
   xmlElements = {
      'form': {
         'BaseClass':GFForm,
         'Required': 1,
         'SingleInstance': 1,
         'Attributes': {
            'title': {
               'Typecast': GTypecast.text,
               'Default': 'Untitled Form' },
            'readonly': {
               'Typecast': GTypecast._boolean,
               'Default': 0 },
            'tabbed': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                  'left': {},
                  'right': {},
                  'bottom': {},
                  'top': {} },
               'Default': "" },
            'width': {
               'Typecast': GTypecast.whole,
               'Default': 40 },
            'height': {
               'Typecast': GTypecast.whole,
               'Default': 12 } },
         'ParentTags': Array() },

      'import': {
         'BaseClass':GFImport, 
         'Attributes': {
            'library': {
               'Required': 1,
               'Typecast': GTypecast.name },
            'datasources': {
               'Typecast':   GTypecast.name,
               'Default': "" },
            'pages': {
               'Typecast': GTypecast.name,
               'Default': ""  },
            'triggers': {
               'Typecast': GTypecast.name,
               'Default': "" } },
         'ParentTags': ('form') },

      'database': {
         'BaseClass':GFDatabase,
         'Attributes': {
            'name': {
               'Required': 1,
               'Unique': 1,
               'Typecast': GTypecast.name },
            'provider': {
               'Required': 1,
               'Typecast': GTypecast.name },
            'dbname': {
               'Required': 0,
               'Typecast': GTypecast.text },
            'service': {
               'Required': 0,
               'Typecast': GTypecast.text },
            'comment': {
               'Required': 0,
               'Typecast': GTypecast.text },
            'host': {
               'Required': 0,
               'Typecast': GTypecast.text } },
         'Deprecated': 'Use the external connections file format.',
         'ParentTags': ('form') },

      'page': {
         'BaseClass':GFPage, 
         'Required': 1,
         'Attributes': {
            'name': {
               'Unique': 1,
               'Typecast': GTypecast.name },
            'caption': {
               'Typecast': GTypecast.text } },
         'ParentTags': ('form') },

      'block': {
         'BaseClass':GFBlock, 
         'Attributes': {
            'name': {
               'Required': 1,
               'Unique': 1,
               'Typecast': GTypecast.name },
            'rows': {
               'Typecast': GTypecast.whole},
            'rowSpacer': {
               'Typecast': GTypecast.whole },
            'transparentBlock':{
               'Typecast': GTypecast._boolean,
               'Default': 0 },
            'restrictDelete':{
               'Typecast': GTypecast._boolean,
               'Default': 0 },
            'restrictInsert':{
               'Typecast': GTypecast._boolean,
               'Default': 0 },
            'datasource': {
               'References': Array('datasource','name'),
               'Typecast': GTypecast.name } },
         'ParentTags': ('page') },

      'label': {
         'BaseClass':GFLabel, 
         'Attributes': {
            'name': {
               'Unique': 1, 
               'Typecast': GTypecast.name }, 
            'text': {
               'Required': 1, 
               'Typecast': GTypecast.text }, 
            'alignment': {
               'Typecast': GTypecast.name, 
               'ValueSet': { 
                  'left': {}, 
                  'right': {}, 
                  'center': {} }, 
               'Default': "left"}, 
            'width': {
               'Typecast': GTypecast.whole },
            'rows': {
               'Typecast': GTypecast.whole },
            'rowSpacer': {
               'Typecast': GTypecast.whole },
            'x': {
               'Required': 1, 
               'Typecast': GTypecast.whole }, 
            'y': {
               'Required': 1,
               'Typecast': GTypecast.whole } }, 
         'ParentTags': Array('page','block') },

      // If you implement a new entry "style", add to the entryStyles 
      // structure after this list
      'entry': {   // todo: split into field + entry
         'BaseClass':GFEntry, 
         'Attributes': { 
            'name': {
               'Required': 1,
               'Unique': 1, 
               'Typecast': GTypecast.name }, 
            'field': {
               'Typecast': GTypecast.name }, 
            'height': {
               'Typecast': GTypecast.whole, 
               'Default': 1 }, 
            'width': {
               'Typecast': GTypecast.whole }, 
            'max_length': {
               'Typecast': GTypecast.whole }, 
            'visibleCount':{
               'Typecast': GTypecast.whole, 
               'Deprecated': 'Use the <block> "rows" attribute instead.' },
            'rows': {
               'Typecast': GTypecast.whole},
            'rowSpacer': {
               'Typecast': GTypecast.whole },
            'readonly': {
               'Typecast': GTypecast._boolean, 
               'Default': 0   }, 
            'required': {
               'Description': 'This object cannot have an empty value prior '+
                              'to a commit.',
               'Typecast': GTypecast._boolean, 
               'Default': 0   }, 
            'uppercase': {
               'Deprecated': 'Use case="upper" instead.',
               'Typecast': GTypecast._boolean,
               'Default': 0   },
            'lowercase': {
               'Deprecated': 'Use case="lower" instead.',
               'Typecast': GTypecast._boolean,
               'Default': 0   },
            'numeric': {
               'Deprecated': 'Use typecast="number" instead',
               'Typecast': GTypecast._boolean,
               'Default': 0   },
            'hidden': {
               'Typecast': GTypecast._boolean,
               'Default': 0   }, 
            'style': {
               'Typecast': GTypecast.name, 
               'ValueSet': { 
                  'default': {}, 
                  'dropdown': {}, 
                  'checkbox': {}, 
                  'label': {} }, 
               'Default': 'default'}, 
            'case': {
               'Typecast': GTypecast.name, 
               'ValueSet': { 
                  'mixed': {}, 
                  'upper': {}, 
                  'lower': {} }, 
               'Default': 'mixed'},
            'typecast': {
               'Typecast': GTypecast.name, 
               'ValueSet': {
                  'text': {}, 
                  'number': {}, 
                  'date': {} }, 
               'Default': 'text'}, 
            'formatmask': {
               'Typecast': GTypecast.text },
            'inputmask': {
               'Typecast': GTypecast.text },
            'displaymask': {
               'Typecast': GTypecast.text },
            'value': {
               'Typecast': GTypecast.text },
            'foreign_key': {
               'Typecast': GTypecast.name,
               'Deprecated': 'Use fk_source="..." and fk_key="..." instead.' },
            'foreign_key_description': {
               'Typecast': GTypecast.text,
               'Deprecated': 'Use fk_description="..." instead.' },
            'fk_source': {
               'Typecast': GTypecast.name },
            'fk_key': {
               'Typecast': GTypecast.name },
            'fk_description': {
               'Typecast': GTypecast.name },
            'default': {
               'Typecast': GTypecast.text },
            'queryDefault':{
               'Typecast': GTypecast.text },
            'sloppyQuery': {
               'Typecast': GTypecast.text },
            'ignoreCaseOnQuery': {
               'Typecast': GTypecast._boolean, 
               'Default': 0 }, 
            'editOnNull': {
               'Description': 'Only allow this object to be edited if it '+
                              'is currently empty.',
               'Typecast': GTypecast._boolean,
               'Default': 0 },
            'no_ltrim': {
               'Description': 'Suppress trimming of extraneous space at '+
                              'beginning of user input.',
               'Typecast': GTypecast._boolean,
               'Default': 0 },
            'no_rtrim': {
               'Description': 'Suppress trimming of extraneous space at end '+
                              'of user input.',
               'Typecast': GTypecast._boolean,
               'Default': 0 },
            'x': {
               'Required': 1,
               'Typecast': GTypecast.whole },
            'y': {
               'Required': 1,
               'Typecast': GTypecast.whole } },
         'ParentTags': ('block') },

      'scrollbar': {
         'BaseClass':GFScrollBar,
         'Attributes': {
            'width': {
               'Required': 1,
               'Typecast': GTypecast.whole },
            'height': {
               'Required': 1,
               'Typecast': GTypecast.whole },
            'x': {
               'Required': 1,
               'Typecast': GTypecast.whole },
            'y': {
               'Required': 1,
               'Typecast': GTypecast.whole } },
         'ParentTags': Array('page','block') },

      'box': {
         'BaseClass':GFBox, 
         'Attributes': {
            'name': {
               'Unique': 1, 
               'Typecast': GTypecast.name }, 
            'label': {
               'Typecast': GTypecast.text }, 
            'width': {
               'Required': 1, 
               'Typecast': GTypecast.whole }, 
            'height': {
               'Required': 1,
               'Typecast': GTypecast.whole }, 
            'x': {
               'Required': 1,
               'Typecast': GTypecast.whole }, 
            'y': {
               'Required': 1, 
               'Typecast': GTypecast.whole } }, 
         'ParentTags': Array('page','block') },

      'button': {
         'BaseClass':GFButton, 
         'Attributes': {
            'name': {
               'Unique': 1,
               'Typecast': GTypecast.name },
            'trigger': {
               'Typecast': GTypecast.name },
            'label': {
               'Typecast': GTypecast.name },
            'width': {
               'Required': 1, 
               'Typecast': GTypecast.whole }, 
            'height': {
               'Required': 1,
               'Typecast': GTypecast.whole },
            'x': {
               'Required': 1, 
               'Typecast': GTypecast.whole },
            'y': {
               'Required': 1, 
               'Typecast': GTypecast.whole } },  
         'ParentTags': Array('page','block') },

      'trigger': {
         'BaseClass':GFTrigger, 
         'Attributes': {
            'name': {
               'Unique': 1,
               'Typecast': GTypecast.name },
            'id': {
               'Deprecated': 'Use name="..." instead.',   // DEPRECATED: Use name instead
               'Typecast': GTypecast.name },
            'type': {
               'Typecast': GTypecast.uppername },
            'src': {
               'References': Array('trigger','name'),
               'Typecast': GTypecast.name },
            'language': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'python': {} },
               'Default': 'python' } },
         'MixedContent': 1,
         'KeepWhitespace': 1,
         'UsableBySiblings': 1,
         'ParentTags': ('form') },

      'options': {
         'BaseClass':GFOptions, 
         'SingleInstance': 1,
         'UsableBySiblings': 1,
         'ParentTags': ('form') },

      'option': {
         'BaseClass':GFOption, 
         'Attributes': {
            'name': {
               'Required': 1,
               'Typecast': GTypecast.name },
            'value': {
               'Typecast': GTypecast.text } },
         'MixedContent': 1,
         'ParentTags': ('options') },

      'title': {
         'BaseClass':GFOption,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'title': {} },
               'Default': 'title' },
            'value': {
               'Typecast': GTypecast.text } },
         'MixedContent': 1,
         'SingleInstance': 1,
         'Deprecated': 'Use the <form> attribute "title" instead.',
         'ParentTags': ('options') },

      'name': { 
         'BaseClass':GFOption, 
         'Attributes': { 
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'name': {} }, 
               'Default': 'name' },
            'value': {
               'Typecast': GTypecast.text } },
         'MixedContent': 1,
         'SingleInstance': 1, 
         'ParentTags': ('options') },

      'height': {
         'BaseClass':GFOption, //GFObjects.GFOption,
         'Attributes': { 
            'name': {
               'Typecast': GTypecast.name, 
               'ValueSet': {
                   'height': {} },
               'Default': 'height' },
            'value': {
               'Typecast': GTypecast.text } },
         'MixedContent': 1, 
         'SingleInstance': 1, 
         'Deprecated': 'Use the <form> attribute "height" instead.', 
         'ParentTags': Array() },

      'width': {
         'BaseClass':GFOption, 
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'width': {} },
               'Default': 'width' },
            'value': {
               'Typecast': GTypecast.text } },
         'MixedContent': 1,
         'SingleInstance': 1,
         'Deprecated': 'Use the <form> attribute "width" instead.',
         'ParentTags': ('options') },

      'author': {
         'BaseClass':GFOption, 
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'author': {} },
               'Default': 'author' },
            'value': {
               'Typecast': GTypecast.text } },
         'MixedContent': 1,
         'SingleInstance': 1,
         'ParentTags': ('options') },

      'description':{ 
         'BaseClass':GFOption, 
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name, 
               'ValueSet': {
                   'description': {} },
               'Default': 'description' }, 
            'value': {
               'Typecast': GTypecast.text } },
         'MixedContent': 1, 
         'SingleInstance': 1,
         'ParentTags': ('options') },

      'version': {
         'BaseClass':GFOption,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'version': {} },
               'Default': 'version' },
            'value': {
               'Typecast': GTypecast.text } },
         'MixedContent': 1,
         'SingleInstance': 1, 
         'ParentTags': ('options') },

      'tip': { 
         'BaseClass':GFOption,
         'Attributes': { 
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'tip': {} },
               'Default': 'tip' },
            'value': {
               'Typecast': GTypecast.text } },
         'MixedContent': 1,
         'SingleInstance': 1,
         'ParentTags': ('options') },
      'datasource': {
         'BaseClass': GFDataSource,
         'Attributes': {
            'name':        {
               'Required': 1,
               'Unique':   1,
               'Typecast': GTypecast.name },
            'type':        {
               'Typecast': GTypecast.name,
               'Default':  "object" },
            'database':    {
               'Typecast': GTypecast.name },
            'table':       {
               'Typecast': GTypecast.name },
            'cache':       {
               'Typecast': GTypecast.whole,
               'Default':  5 },
            'prequery':    {
               'Typecast': GTypecast._boolean,
               'Default':  0 },
            'order_by':    {
               'Typecast': GTypecast.text },
            'master':      {
               'Typecast': GTypecast.name },
            'masterlink':  {
               'Typecast': GTypecast.text },
            'detaillink':  {
               'Typecast': GTypecast.text },
            
            'explicitfields': {
               'Typecast': GTypecast.text },
            'primarykey': {
               'Typecast': GTypecast.text } },
         'ParentTags': null }
    };
    return  xmlElements;
}

 
