package jacob.tool;

import java.io.File;

import ccl.awt.AWTUtil;
import ccl.util.*;

import jacob.Package;

/**
 * Gets the selected class and creats 
 * a test class template for it.
 * If the class has the name foo.Bar
 * the test class will be names foo.test.BarTest
 * and is extended from ccl.util.Test.
 * 
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: TestWizard.java,v 1.2 1999/02/22 11:44:15 clemens Exp clemens $
 */
public class TestWizard extends WrapperAdapter {
    public TestWizard() {
        super();
    }

    /*
     * --- overwritten methods of class 'jacob.tool.WrapperAdapter' ---
     */

    public void run() {
        // get selected class
        String sClassFullName = _pJacobInterface.getSelectedClass();
        
        // nothing selected
        if (Util.isEmpty(sClassFullName)) {
            AWTUtil.showMessage(_pJacobInterface.getMainFrame(),
                                "Test class wizard: No class selected!");
            _pJacobInterface.stopped(this);
            
            return;
        }
        
        String sClassName = sClassFullName.substring(sClassFullName.lastIndexOf('.') + 1);
        
        // get path of class
        Package pckMain = _pJacobInterface.getMainPackage();
        String sPackage = pckMain.getPackageName(sClassFullName);
        Package pckClass = pckMain.getPackage(sPackage);
        String sClassPath = pckClass.getPath();
        
        // test if File exists already
        String sNewClassName = sClassName + "Test";
        String sNewClassFullFileName = FileUtil.concatPath
               (sClassPath, "test") + File.separator +
               sNewClassName + ".java";
        if (FileUtil.exists(sNewClassFullFileName)) {
            AWTUtil.showMessage(_pJacobInterface.getMainFrame(),
                                "Test class wizard: sorry, file\n'" + 
                                sNewClassFullFileName + "'\n" +
                                "exists already!");
            _pJacobInterface.stopped(this);
            
            return;
        }
        
        // test dir is a file -> error and stop
        String sTestDir = FileUtil.concatPath
               (sClassPath, "test");
        if (FileUtil.existsFile(sTestDir)) {
            AWTUtil.showMessage(_pJacobInterface.getMainFrame(),
                                "Test class wizard: Can't create directory\n'" +
                                sTestDir + "'!\n" +
                                "It exists already as a file. :-(");
            _pJacobInterface.stopped(this);
            
            return;
        }
        
        // Ask user if he/she wants to proceed.
        boolean bOK = AWTUtil.isOKOrCancel(_pJacobInterface.getMainFrame(),
                                           "Test class wizard:\n" + 
                                           "Do you want to create a test class template for\n'" +
                                           sClassFullName + "'?");
        if (!bOK) {
            _pJacobInterface.stopped(this);
            
            return;
        }
        
        // create test if necessary
        if (!FileUtil.existsDir(sTestDir)) {
            boolean bError = FileUtil.md(sTestDir);
            if (bError) {
                AWTUtil.showMessage(_pJacobInterface.getMainFrame(),
                                    "Test class wizard: Sorry, could not create directory\n'" +
                                    sTestDir + "'!");
                _pJacobInterface.stopped(this);
                
                return;
            }
        }
        
        // create test file -------------------------------
        
        // package
        if (sPackage.equals(".")) {
            sPackage = "test";
        } else {
            sPackage += ".test";
        }
        String sTestFileContent = "package " + sPackage + ";\n\n";
        
        // import
        sTestFileContent += "import ccl.util.Test;\n\n";
        if (sPackage.length() > 4) {
            sTestFileContent += "import " + 
                   sPackage.substring(0, sPackage.length() - 4) +
                   "*;\n\n";
        }
        
        // comment
        sTestFileContent += "/**\n * Insert your test code into the _doIt() method and\n" +
               " * test bugs with 'bugIf(boolean expression);' or\n" +
               " * 'bugIf(boolean expression, \"comment about what went wrong\");'.\n" +
               " * Then just run the main routine.\n" +
               " */\n";
        
        // class name
        sTestFileContent += "public class " + sNewClassName + 
               " extends Test {\n";
        
        // constructors
        sTestFileContent += "\tpublic " + sNewClassName + "() {\n" +
               "\t\tsuper();\n" +
               "\t}\n\n" +
               "\tpublic " + sNewClassName +  "(Test pTest_) {\n" +
               "\t\tsuper(pTest_);\n" +
               "\t}\n\n";
        
        // _doIt
        sTestFileContent += "\t/**\n\t * Insert your test code into the _doIt() method and\n" +
               "\t * test bugs with 'bugIf(boolean expression);' or\n" +
               "\t * 'bugIf(boolean expression, \"comment about what went wrong\");'.\n" +
               "\t * Then just run the main routine.\n" +
               "\t */\n";
        sTestFileContent += "\tprotected void _doIt() {\n\t}\n\n";
        
        // main
        sTestFileContent += "\tpublic static void main(String[] asArg_) {\n" +
               "\t\tTest pTest = (Test)(new " + sNewClassName + "());\n" +
               "\t\tpTest.printResult(pTest);\n" +
               "\t\tSystem.exit(0);\n" +
               "\t}\n";
        
        sTestFileContent += "}\n";
        Util.debug("TestWizard.run().sTestFileContent: " + sTestFileContent);
        
        // save -------------------------------------------
        try {
            FileUtil.writeFile(sNewClassFullFileName, sTestFileContent);
        } catch(Exception eWriteFile) {
            AWTUtil.showMessage(_pJacobInterface.getMainFrame(),
                                "Test class wizard: Could not write file\n'" +
                                sNewClassFullFileName + "'!\n");
            _pJacobInterface.stopped(this);
            
            return;
        }
        
        // insert test file and package into project ------
        _pJacobInterface.addClass(sPackage + "." + sNewClassName);
        _pJacobInterface.selectClass(sPackage + "." + sNewClassName);
        
        // editFile ---------------------------------------
        _pJacobInterface.getEditor().editFile(sNewClassFullFileName);
        
        _pJacobInterface.stopped(this);
    }
}
