package jacob.tool;

import ccl.util.*;
import ccl.awt.AWTUtil;

import jacob.Package;

/**
 * This class gives back a list of all
 * classes the current project references
 * (except jdk and swing classes).
 * 
 * It is convenient to use this list to check
 * if some classes should belong to this
 * project but are not yet inserted.
 * 
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: CladepyWrapper.java,v 1.2 1998/09/27 20:14:55 clemens Exp clemens $
 */
public class CladepyWrapper extends WrapperAdapter {
    public CladepyWrapper() {
        super();
    }
    
    /*
     * --- overwritten methods of class 'jacob.tool.WrapperAdapter' ---
     */
    
    public void run() {
        // get main class full path name
        String sMainClass = _pJacobInterface.getMainClass();
        if ( Util.isEmpty( sMainClass ) ) {
            AWTUtil.showMessage( _pJacobInterface.getMainFrame(),
                                 "Class dependencies tree could not be calculated!\n" +
                                 "No main class specified for current project.\n" +
                                 "You might want to take a look at " +
                                 "\"Edit->Project Settings...\"." );
            _pJacobInterface.stopped(this);

            return;
        }

        Package pckMain = _pJacobInterface.getMainPackage();
        String sMainClassFullName = pckMain.getClassFullFileName(sMainClass);
        
        // Args zusammen stellen
        String[] asArg = new String[7];
        asArg[0] = "-nojava";
        asArg[1] = "-noswing";
        asArg[2] = "-output";
        Init pInit = _pJacobInterface.getInit();
        String sOutputFile = FileUtil.concatPath(pInit.getFilePath(),
                                                 pInit.getFileName().toLowerCase()) +
               ".cladepy.txt";
        asArg[3] = sOutputFile;
        asArg[4] = "-classpath";
        asArg[5] = Package.getClassPath();
        asArg[6] = sMainClass;
        
        Util.debug("CladepyWrapper.run().asArg: " + Util.objectsToVector(asArg));
        new cladepy.ClassDependency(asArg, null);
        
        // editFile
        _pJacobInterface.getEditor().editFile(sOutputFile);
        
        _pJacobInterface.stopped(this);
        Util.debug("CladepyWrapper.run().END");
    }
}
