/*
 * gnudoit.c	-- pbreton Thu Jan 25 1996
 *
 * Client code to allow locally and remotely evaluate lisp forms
 * using GNU Emacs.
 *
 * This file is not part of GNU Emacs. 
 * 
 * Copying is permitted under those conditions described by the GNU
 * General Public License.
 *
 * Copyright (C) 1996 Peter Breton
 *
 * Author: Peter Breton (pbreton@cs.umb.edu)
 * Based heavily on Andy Norman's gnuserv (ange@hplb.hpl.hp.com), 
 * which in turn was based on 'etc/emacsclient.c' from the GNU 
 * Emacs 18.52 distribution.
 *
 * Modifications: Nico Francois (nico.francois@scala.nl) 
 *                Mon Jun 3 1996
 * See comment in gnuserv.c.
 *
 * $Log: gnudoit.c,v $
 * Revision 1.2  1996/01/29 05:47:44  peter
 * Fixed typo
 *
 * Revision 1.1  1996/01/29 05:14:56  peter
 * Initial revision
 *
 * Modifications: Nico Francois (nico.francois@scala.nl) Thu Feb 27
 * 1997 Major code cleanup (slightly C++-ified as well).  Added a
 * version number that is printed when usage us requested (-? option).
 * Starting gnudoit without arguments now fails, and usage is printed.
 */

static char version_str[] = "gnudoit 1.3 (27 Feb 1997)";

#include "gnuserv.h" 
#define __STDC__			1
#define __GNU_LIBRARY__		1
#include "getopt.h" 

void main (int argc, char *argv[])
{
	char *hostarg = GNUSERV_DEFAULT_HOST;	// hostname
	BOOL qflg = FALSE;						// quick edit
	BOOL dbgflg = FALSE;					// debug flag
	BOOL errflg = FALSE;					// option error
	BOOL noresult = FALSE;

	// Parse arguments
	int c;
	while ((c = getopt (argc, argv, "h:qd?" )) != EOF) {
		switch (c) {
			case 'q':
				qflg = TRUE;
				break;

			case 'd':
				dbgflg = TRUE;
				break;

			case 'h':
				hostarg = optarg;
				// FIX! We don't support results from a server on another
				// FIX! host just yet.
				noresult = TRUE;
				break;

			case '?':
				errflg = TRUE;
			}
		}

	// Print a usage message and quit
	if (argc <= 1 || errflg) {
		fprintf (stderr,
				"%s\n"
				"Usage: %s [-q] [-d] [-h hostname] [sexpr] ...\n",
				version_str,
				argv[0]);
		exit (1);
		}

	// First create mailslot to receive result
	DWORD clientid = GetCurrentProcessId();
	HANDLE resultslot = CreateGnuServSlot (TRUE, clientid);
	if (INVALID_HANDLE_VALUE == resultslot) {
		exit (1);
		}

	// Try to connect to the mailslot. Dies on failure.
	HANDLE h = ConnectToMailslot (hostarg, FALSE, 0);

	// Send client id...
	char clientidstr[20];
	sprintf (clientidstr, "C:%d ", clientid);
	if (!SendString (h, clientidstr)) {
		exit (1);
		}

	// Then send a lisp command...
	char *basecommand = qflg ?
		"(server-eval-quickly '(progn " : "(server-eval '(progn ";
	SendString (h, basecommand); 
	if (dbgflg) {
		printf (basecommand);
		}

	// ...followed by lisp expressions to the server process
	if (optind < argc) {
		// Sexp on command line
		for (; optind < argc; optind++) {
			SendString (h, argv[optind]);
			SendString (h, " ");
			if (dbgflg) {
				printf ("%s ", argv[optind]);
				}
			}
		} 
	else {
		// No sexp on the command line, so read it from stdin
		char buf[GSERV_BUFSZ];

		HANDLE con_stdin = GetStdHandle (STD_INPUT_HANDLE);
		if (INVALID_HANDLE_VALUE == con_stdin) {
			fprintf(stderr, "Can't get console stdin\n");
			exit (1);
			}

		DWORD bytesread;
		while (ReadFile (con_stdin, buf, GSERV_BUFSZ, &bytesread, 0)) {  
			// Should always be true
			if (bytesread > 0) {
				// Quit if we see an EOT
				if (EOT_CHR == buf[0]) {
					break;
					}

				// Overwrite the CR on the end with a NULL
				buf[bytesread-1] = '\0';
				SendString (h, buf);
				}
			}
		}

	// Finish off the sexp and send an EOT
	SendString (h, "))");
	SendString (h, EOT_STR);
	if (dbgflg) {
		printf("))");
		}

	// Disconnect
	DisconnectFromMailslot (h);

	// Now wait for result, then exit.  The result will be printed,
	// unless the -q flag was used.
	if (!noresult) WaitForServerResult (resultslot, !qflg);
	DisconnectFromMailslot (resultslot);

	exit (0);
}
