/*
 * DrawingFont.cs - Implementation of fonts for System.Drawing.
 *
 * Copyright (C) 2003  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace System.Drawing.Toolkit
{

using System;
using Xsharp;
using DotGNU.Images;

public class DrawingImage : IToolkitImage
{
	// Internal state.
	private Xsharp.Image image;

	// Constructor.
	public DrawingImage(Screen screen, DotGNU.Images.Image image, int frame)
			{
				this.image = new Xsharp.Image(screen, image.GetFrame(frame));
			}

	// Dispose of this image.
	public void Dispose()
			{
				if(image != null)
				{
					image.Destroy();
					image = null;
				}
			}

	// Get the native Xsharp image structure, for drawing purposes.
	public Xsharp.Image GetNativeImage()
			{
				return image;
			}

}; // class DrawingImage

}; // namespace System.Drawing.Toolkit
