/*
 * self.c - Get the current thread identifier.
 *
 * This file is part of the Portable.NET C library.
 * Copyright (C) 2004  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <pthread-support.h>

static __declspec(thread) __pthread_t self;

__pthread_t
__pthread_self (void)
{
  if (!self)
    {
      /* Register the thread object for a foreign thread that
         was created by something other than "pthread_create".
         e.g. the main thread */
      self = __libc_thread_register_foreign (Thread::get_CurrentThread ());
    }
  return self;
}

void
__libc_thread_set_self (__pthread_t id)
{
  self = id;
}
