/*
 * il_meta.h - Definitions related to IL metadata.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef	_IL_META_H
#define	_IL_META_H

#ifdef	__cplusplus
extern	"C" {
#endif

/*
 * Token types.
 */
#define	IL_META_TOKEN_MASK						0xFF000000
#define	IL_META_TOKEN_MODULE					0x00000000
#define	IL_META_TOKEN_TYPE_REF					0x01000000
#define	IL_META_TOKEN_TYPE_DEF					0x02000000
#define	IL_META_TOKEN_FIELD_DEF					0x04000000
#define	IL_META_TOKEN_METHOD_DEF				0x06000000
#define	IL_META_TOKEN_PARAM_DEF					0x08000000
#define	IL_META_TOKEN_INTERFACE_IMPL			0x09000000
#define	IL_META_TOKEN_MEMBER_REF				0x0A000000
#define	IL_META_TOKEN_CONSTANT					0x0B000000
#define	IL_META_TOKEN_CUSTOM_ATTRIBUTE			0x0C000000
#define	IL_META_TOKEN_CUSTOM_VALUE				IL_META_TOKEN_CUSTOM_ATTRIBUTE
#define	IL_META_TOKEN_FIELD_MARSHAL				0x0D000000
#define	IL_META_TOKEN_DECL_SECURITY				0x0E000000
#define	IL_META_TOKEN_CLASS_LAYOUT				0x0F000000
#define	IL_META_TOKEN_FIELD_LAYOUT				0x10000000
#define	IL_META_TOKEN_STAND_ALONE_SIG			0x11000000
#define	IL_META_TOKEN_EVENT_MAP					0x12000000
#define	IL_META_TOKEN_EVENT						0x14000000
#define	IL_META_TOKEN_PROPERTY_MAP				0x15000000
#define	IL_META_TOKEN_PROPERTY					0x17000000
#define	IL_META_TOKEN_METHOD_SEMANTICS			0x18000000
#define	IL_META_TOKEN_METHOD_IMPL				0x19000000
#define	IL_META_TOKEN_MODULE_REF				0x1A000000
#define	IL_META_TOKEN_TYPE_SPEC					0x1B000000
#define	IL_META_TOKEN_IMPL_MAP					0x1C000000
#define	IL_META_TOKEN_FIELD_RVA					0x1D000000
#define	IL_META_TOKEN_ASSEMBLY					0x20000000
#define	IL_META_TOKEN_PROCESSOR_DEF				0x21000000
#define	IL_META_TOKEN_OS_DEF					0x22000000
#define	IL_META_TOKEN_ASSEMBLY_REF				0x23000000
#define	IL_META_TOKEN_PROCESSOR_REF				0x24000000
#define	IL_META_TOKEN_OS_REF					0x25000000
#define	IL_META_TOKEN_FILE						0x26000000
#define	IL_META_TOKEN_EXPORTED_TYPE				0x27000000
#define	IL_META_TOKEN_MANIFEST_RESOURCE			0x28000000
#define	IL_META_TOKEN_NESTED_CLASS				0x29000000
#define	IL_META_TOKEN_GENERIC_PAR				0x2A000000
#define	IL_META_TOKEN_METHOD_SPEC				0x2B000000
#define	IL_META_TOKEN_STRING					0x70000000
#define	IL_META_TOKEN_NAME						0x71000000
#define	IL_META_TOKEN_BASE_TYPE					0x72000000

/*
 * Pseudo types used internally.
 */
#define	IL_META_TOKEN_NESTED_INFO				0x3F000000

/*
 * Type definition flags.
 */
#define	IL_META_TYPEDEF_VISIBILITY_MASK			0x00000007
#define	IL_META_TYPEDEF_NOT_PUBLIC				0x00000000
#define	IL_META_TYPEDEF_PUBLIC					0x00000001
#define	IL_META_TYPEDEF_NESTED_PUBLIC			0x00000002
#define	IL_META_TYPEDEF_NESTED_PRIVATE			0x00000003
#define	IL_META_TYPEDEF_NESTED_FAMILY			0x00000004
#define	IL_META_TYPEDEF_NESTED_ASSEMBLY			0x00000005
#define	IL_META_TYPEDEF_NESTED_FAM_AND_ASSEM	0x00000006
#define	IL_META_TYPEDEF_NESTED_FAM_OR_ASSEM		0x00000007
#define	IL_META_TYPEDEF_LAYOUT_MASK				0x00000018
#define	IL_META_TYPEDEF_AUTO_LAYOUT				0x00000000
#define	IL_META_TYPEDEF_LAYOUT_SEQUENTIAL		0x00000008
#define	IL_META_TYPEDEF_EXPLICIT_LAYOUT			0x00000010
#define	IL_META_TYPEDEF_CLASS_SEMANTICS_MASK	0x00000060
#define	IL_META_TYPEDEF_CLASS					0x00000000
#define	IL_META_TYPEDEF_INTERFACE				0x00000020
#define	IL_META_TYPEDEF_VALUE_TYPE				0x00000040
#define	IL_META_TYPEDEF_UNMANAGED_VALUE_TYPE	0x00000060
#define	IL_META_TYPEDEF_ABSTRACT				0x00000080
#define	IL_META_TYPEDEF_SEALED					0x00000100
#define	IL_META_TYPEDEF_ENUM					0x00000200
#define	IL_META_TYPEDEF_SPECIAL_NAME			0x00000400
#define	IL_META_TYPEDEF_IMPORT					0x00001000
#define	IL_META_TYPEDEF_SERIALIZABLE			0x00002000
#define	IL_META_TYPEDEF_STRING_FORMAT_MASK		0x00030000
#define	IL_META_TYPEDEF_ANSI_CLASS				0x00000000
#define	IL_META_TYPEDEF_UNICODE_CLASS			0x00010000
#define	IL_META_TYPEDEF_AUTO_CLASS				0x00020000
#define	IL_META_TYPEDEF_LATE_INIT				0x00080000
#define	IL_META_TYPEDEF_BEFORE_FIELD_INIT		0x00100000
#define	IL_META_TYPEDEF_RESERVED_MASK			0x00040800
#define	IL_META_TYPEDEF_RT_SPECIAL_NAME			0x00000800
#define	IL_META_TYPEDEF_HAS_SECURITY			0x00040000
#define	IL_META_TYPEDEF_VALID_BITS				0x001FFFFF

/*
 * Field definition flags.
 */
#define	IL_META_FIELDDEF_FIELD_ACCESS_MASK		0x0007
#define	IL_META_FIELDDEF_COMPILER_CONTROLLED	0x0000
#define	IL_META_FIELDDEF_PRIVATE				0x0001
#define	IL_META_FIELDDEF_FAM_AND_ASSEM			0x0002
#define	IL_META_FIELDDEF_ASSEMBLY				0x0003
#define	IL_META_FIELDDEF_FAMILY					0x0004
#define	IL_META_FIELDDEF_FAM_OR_ASSEM			0x0005
#define	IL_META_FIELDDEF_PUBLIC					0x0006
#define	IL_META_FIELDDEF_STATIC					0x0010
#define	IL_META_FIELDDEF_INIT_ONLY				0x0020
#define	IL_META_FIELDDEF_LITERAL				0x0040
#define	IL_META_FIELDDEF_NOT_SERIALIZED			0x0080
#define	IL_META_FIELDDEF_SPECIAL_NAME			0x0200
#define	IL_META_FIELDDEF_PINVOKE_IMPL			0x2000
#define	IL_META_FIELDDEF_RESERVED_MASK			0x9500
#define	IL_META_FIELDDEF_RT_SPECIAL_NAME		0x0400
#define	IL_META_FIELDDEF_HAS_FIELD_MARSHAL		0x1000
#define	IL_META_FIELDDEF_HAS_SECURITY			0x4000
#define	IL_META_FIELDDEF_HAS_DEFAULT			0x8000
#define	IL_META_FIELDDEF_HAS_FIELD_RVA			0x0100

/*
 * Method definition flags.
 */
#define	IL_META_METHODDEF_MEMBER_ACCESS_MASK	0x0007
#define	IL_META_METHODDEF_COMPILER_CONTROLLED	0x0000
#define	IL_META_METHODDEF_PRIVATE				0x0001
#define	IL_META_METHODDEF_FAM_AND_ASSEM			0x0002
#define	IL_META_METHODDEF_ASSEM					0x0003
#define	IL_META_METHODDEF_FAMILY				0x0004
#define	IL_META_METHODDEF_FAM_OR_ASSEM			0x0005
#define	IL_META_METHODDEF_PUBLIC				0x0006
#define	IL_META_METHODDEF_STATIC				0x0010
#define	IL_META_METHODDEF_FINAL					0x0020
#define	IL_META_METHODDEF_VIRTUAL				0x0040
#define	IL_META_METHODDEF_HIDE_BY_SIG			0x0080
#define	IL_META_METHODDEF_VTABLE_LAYOUT_MASK	0x0100
#define	IL_META_METHODDEF_REUSE_SLOT			0x0000
#define	IL_META_METHODDEF_NEW_SLOT				0x0100
#define	IL_META_METHODDEF_ABSTRACT				0x0400
#define	IL_META_METHODDEF_SPECIAL_NAME			0x0800
#define	IL_META_METHODDEF_PINVOKE_IMPL			0x2000
#define	IL_META_METHODDEF_UNMANAGED_EXPORT		0x0008
#define	IL_META_METHODDEF_RESERVED_MASK			0xD000
#define	IL_META_METHODDEF_RT_SPECIAL_NAME		0x1000
#define	IL_META_METHODDEF_HAS_SECURITY			0x4000
#define	IL_META_METHODDEF_REQUIRE_SEC_OBJECT	0x8000

/*
 * Parameter definition flags.
 */
#define	IL_META_PARAMDEF_IN						0x0001
#define	IL_META_PARAMDEF_OUT					0x0002
#define	IL_META_PARAMDEF_OPTIONAL				0x0004
#define	IL_META_PARAMDEF_RETVAL					0x0008
#define	IL_META_PARAMDEF_RESERVED_MASK			0xF000
#define	IL_META_PARAMDEF_HAS_DEFAULT			0x1000
#define	IL_META_PARAMDEF_HAS_FIELD_MARSHAL		0x2000
#define	IL_META_PARAMDEF_RESERVED3				0x4000
#define	IL_META_PARAMDEF_RESERVED4				0x8000

/*
 * Property definition flags.
 */
#define	IL_META_PROPDEF_SPECIAL_NAME			0x0200
#define	IL_META_PROPDEF_RESERVED_MASK			0xF400
#define	IL_META_PROPDEF_RT_SPECIAL_NAME			0x0400
#define	IL_META_PROPDEF_HAS_DEFAULT				0x1000
#define	IL_META_PROPDEF_RESERVED2				0x2000
#define	IL_META_PROPDEF_RESERVED3				0x4000
#define	IL_META_PROPDEF_RESERVED4				0x8000

/*
 * Event definition flags.
 */
#define	IL_META_EVENTDEF_SPECIAL_NAME			0x0200
#define	IL_META_EVENTDEF_RESERVED_MASK			0x0400
#define	IL_META_EVENTDEF_RT_SPECIAL_NAME		0x0400

/*
 * Method semantics flags.
 */
#define	IL_META_METHODSEM_SETTER				0x0001
#define	IL_META_METHODSEM_GETTER				0x0002
#define	IL_META_METHODSEM_OTHER					0x0004
#define	IL_META_METHODSEM_ADD_ON				0x0008
#define	IL_META_METHODSEM_REMOVE_ON				0x0010
#define	IL_META_METHODSEM_FIRE					0x0020

/*
 * Method implementation flags.
 */
#define	IL_META_METHODIMPL_CODE_TYPE_MASK		0x0003
#define	IL_META_METHODIMPL_IL					0x0000
#define	IL_META_METHODIMPL_NATIVE				0x0001
#define	IL_META_METHODIMPL_OPTIL				0x0002
#define	IL_META_METHODIMPL_RUNTIME				0x0003
#define	IL_META_METHODIMPL_MANAGED_MASK			0x0004
#define	IL_META_METHODIMPL_MANAGED				0x0000
#define	IL_META_METHODIMPL_UNMANAGED			0x0004
#define	IL_META_METHODIMPL_NO_INLINING			0x0008
#define	IL_META_METHODIMPL_FORWARD_REF			0x0010
#define	IL_META_METHODIMPL_SYNCHRONIZED			0x0020
#define	IL_META_METHODIMPL_PRESERVE_SIG			0x0080
#define	IL_META_METHODIMPL_INTERNAL_CALL		0x1000

/*
 * Private method implementation flags.
 */
#define	IL_META_METHODIMPL_JAVA_FP_STRICT		0x2000
#define	IL_META_METHODIMPL_JAVA					0x4000

/*
 * Security flags.
 */
#define	IL_META_SECURITY_ACTION_MASK			0x000F
#define	IL_META_SECURITY_ACTION_NIL				0x0000
#define	IL_META_SECURITY_REQUEST				0x0001
#define	IL_META_SECURITY_DEMAND					0x0002
#define	IL_META_SECURITY_ASSERT					0x0003
#define	IL_META_SECURITY_DENY					0x0004
#define	IL_META_SECURITY_PERMIT_ONLY			0x0005
#define	IL_META_SECURITY_LINK_TIME_CHECK		0x0006
#define	IL_META_SECURITY_INHERITANCE_CHECK		0x0007
#define	IL_META_SECURITY_REQUEST_MINIMUM		0x0008
#define	IL_META_SECURITY_REQUEST_OPTIONAL		0x0009
#define	IL_META_SECURITY_REQUEST_REFUSE			0x000A
#define	IL_META_SECURITY_PREJIT_GRANT			0x000B
#define	IL_META_SECURITY_PREJIT_DENIED			0x000C
#define	IL_META_SECURITY_NON_CAS_DEMAND			0x000D
#define	IL_META_SECURITY_NON_CAS_LINK_DEMAND	0x000E
#define	IL_META_SECURITY_NON_CAS_INHERITANCE	0x000F

/*
 * PInvoke flags.
 */
#define	IL_META_PINVOKE_NO_MANGLE				0x0001
#define	IL_META_PINVOKE_CHAR_SET_MASK			0x0006
#define	IL_META_PINVOKE_CHAR_SET_NOT_SPEC		0x0000
#define	IL_META_PINVOKE_CHAR_SET_ANSI			0x0002
#define	IL_META_PINVOKE_CHAR_SET_UNICODE		0x0004
#define	IL_META_PINVOKE_CHAR_SET_AUTO			0x0006
#define	IL_META_PINVOKE_OLE						0x0020
#define	IL_META_PINVOKE_SUPPORTS_LAST_ERROR		0x0040
#define	IL_META_PINVOKE_CALL_CONV_MASK			0x0700
#define	IL_META_PINVOKE_CALL_CONV_WINAPI		0x0100
#define	IL_META_PINVOKE_CALL_CONV_CDECL			0x0200
#define	IL_META_PINVOKE_CALL_CONV_STDCALL		0x0300
#define	IL_META_PINVOKE_CALL_CONV_THISCALL		0x0400
#define	IL_META_PINVOKE_CALL_CONV_FASTCALL		0x0500

/*
 * Assembly flags.
 */
#define	IL_META_ASSEM_PUBLIC_KEY				0x0001
#define	IL_META_ASSEM_COMPATIBILITY_MASK		0x0070
#define	IL_META_ASSEM_SIDE_BY_SIDE_COMPATIBLE	0x0000
#define	IL_META_ASSEM_NON_SIDE_BY_SIDE_APP_DOMAIN 0x0010
#define	IL_META_ASSEM_NON_SIDE_BY_SIDE_PROCESS	0x0020
#define	IL_META_ASSEM_NON_SIDE_BY_SIDE_MACHINE	0x0030
#define	IL_META_ASSEM_ENABLE_JIT_TRACKING		0x8000
#define	IL_META_ASSEM_DISABLE_JIT_OPTIMIZER		0x4000

/*
 * Assembly reference flags.
 */
#define	IL_META_ASSEMREF_FULL_ORIGINATOR		0x0001

/*
 * Manifest resource flags.
 */
#define	IL_META_MANIFEST_VISIBILITY_MASK		0x0007
#define	IL_META_MANIFEST_PUBLIC					0x0001
#define	IL_META_MANIFEST_PRIVATE				0x0002

/*
 * File flags.
 */
#define	IL_META_FILE_CONTAINS_META_DATA			0x0000
#define	IL_META_FILE_CONTAINS_NO_META_DATA		0x0001
#define	IL_META_FILE_WRITEABLE					0x0002

/*
 * Element types.
 */
#define	IL_META_ELEMTYPE_END					0x00
#define	IL_META_ELEMTYPE_VOID					0x01
#define	IL_META_ELEMTYPE_BOOLEAN				0x02
#define	IL_META_ELEMTYPE_CHAR					0x03
#define	IL_META_ELEMTYPE_I1						0x04
#define	IL_META_ELEMTYPE_U1						0x05
#define	IL_META_ELEMTYPE_I2						0x06
#define	IL_META_ELEMTYPE_U2						0x07
#define	IL_META_ELEMTYPE_I4						0x08
#define	IL_META_ELEMTYPE_U4						0x09
#define	IL_META_ELEMTYPE_I8						0x0A
#define	IL_META_ELEMTYPE_U8						0x0B
#define	IL_META_ELEMTYPE_R4						0x0C
#define	IL_META_ELEMTYPE_R8						0x0D
#define	IL_META_ELEMTYPE_STRING					0x0E
#define	IL_META_ELEMTYPE_PTR					0x0F
#define	IL_META_ELEMTYPE_BYREF					0x10
#define	IL_META_ELEMTYPE_VALUETYPE				0x11
#define	IL_META_ELEMTYPE_VALUECLASS				IL_META_ELEMTYPE_VALUETYPE
#define	IL_META_ELEMTYPE_CLASS					0x12
#define	IL_META_ELEMTYPE_VAR					0x13
#define	IL_META_ELEMTYPE_ARRAY					0x14
#define	IL_META_ELEMTYPE_WITH					0x15
#define	IL_META_ELEMTYPE_TYPEDBYREF				0x16
#define	IL_META_ELEMTYPE_VALUEARRAY				0x17
#define	IL_META_ELEMTYPE_I						0x18
#define	IL_META_ELEMTYPE_U						0x19
#define	IL_META_ELEMTYPE_R						0x1A
#define	IL_META_ELEMTYPE_FNPTR					0x1B
#define	IL_META_ELEMTYPE_OBJECT					0x1C
#define	IL_META_ELEMTYPE_SZARRAY				0x1D
#define	IL_META_ELEMTYPE_MVAR					0x1E
#define	IL_META_ELEMTYPE_CMOD_REQD				0x1F
#define	IL_META_ELEMTYPE_CMOD_OPT				0x20
#define	IL_META_ELEMTYPE_INTERNAL				0x21
#define	IL_META_ELEMTYPE_VAR_OLD				0x22
#define	IL_META_ELEMTYPE_NAME					0x23
#define	IL_META_ELEMTYPE_MODIFIER				0x40
#define	IL_META_ELEMTYPE_SENTINEL				0x41
#define	IL_META_ELEMTYPE_PINNED					0x45

/*
 * Serialization types.
 */
#define	IL_META_SERIALTYPE_BOOLEAN				IL_META_ELEMTYPE_BOOLEAN
#define	IL_META_SERIALTYPE_CHAR					IL_META_ELEMTYPE_CHAR
#define	IL_META_SERIALTYPE_I1					IL_META_ELEMTYPE_I1
#define	IL_META_SERIALTYPE_U1					IL_META_ELEMTYPE_U1
#define	IL_META_SERIALTYPE_I2					IL_META_ELEMTYPE_I2
#define	IL_META_SERIALTYPE_U2					IL_META_ELEMTYPE_U2
#define	IL_META_SERIALTYPE_I4					IL_META_ELEMTYPE_I4
#define	IL_META_SERIALTYPE_U4					IL_META_ELEMTYPE_U4
#define	IL_META_SERIALTYPE_I8					IL_META_ELEMTYPE_I8
#define	IL_META_SERIALTYPE_U8					IL_META_ELEMTYPE_U8
#define	IL_META_SERIALTYPE_R4					IL_META_ELEMTYPE_R4
#define	IL_META_SERIALTYPE_R8					IL_META_ELEMTYPE_R8
#define	IL_META_SERIALTYPE_STRING				IL_META_ELEMTYPE_STRING
#define	IL_META_SERIALTYPE_SZARRAY				IL_META_ELEMTYPE_SZARRAY
#define	IL_META_SERIALTYPE_TYPE					0x50
#define	IL_META_SERIALTYPE_VARIANT				0x51
#define	IL_META_SERIALTYPE_FIELD				0x53
#define	IL_META_SERIALTYPE_PROPERTY				0x54
#define	IL_META_SERIALTYPE_ENUM					0x55

/*
 * Calling conventions.
 */
#define	IL_META_CALLCONV_MASK					0x0F
#define	IL_META_CALLCONV_DEFAULT				0x00
#define	IL_META_CALLCONV_C						0x01
#define	IL_META_CALLCONV_STDCALL				0x02
#define	IL_META_CALLCONV_THISCALL				0x03
#define	IL_META_CALLCONV_FASTCALL				0x04
#define	IL_META_CALLCONV_VARARG					0x05
#define	IL_META_CALLCONV_FIELD					0x06
#define	IL_META_CALLCONV_LOCAL_SIG				0x07
#define	IL_META_CALLCONV_PROPERTY				0x08
#define	IL_META_CALLCONV_UNMGD					0x09
#define	IL_META_CALLCONV_INSTANTIATION			0x0A
#define	IL_META_CALLCONV_GENERIC				0x10
#define	IL_META_CALLCONV_HASTHIS				0x20
#define	IL_META_CALLCONV_EXPLICITTHIS			0x40

/*
 * Argument types.
 */
#define	IL_META_ARGTYPE_END						0x00
#define	IL_META_ARGTYPE_VOID					0x01
#define	IL_META_ARGTYPE_I4						0x02
#define	IL_META_ARGTYPE_I8						0x03
#define	IL_META_ARGTYPE_R4						0x04
#define	IL_META_ARGTYPE_R8						0x05
#define	IL_META_ARGTYPE_PTR						0x06
#define	IL_META_ARGTYPE_OBJECT					0x07
#define	IL_META_ARGTYPE_STRUCT4					0x08
#define	IL_META_ARGTYPE_STRUCT32				0x09
#define	IL_META_ARGTYPE_BYVALUE					0x0A

/*
 * Native types.
 */
#define	IL_META_NATIVETYPE_END					0x00
#define	IL_META_NATIVETYPE_VOID					0x01
#define	IL_META_NATIVETYPE_BOOLEAN				0x02
#define	IL_META_NATIVETYPE_I1					0x03
#define	IL_META_NATIVETYPE_U1					0x04
#define	IL_META_NATIVETYPE_I2					0x05
#define	IL_META_NATIVETYPE_U2					0x06
#define	IL_META_NATIVETYPE_I4					0x07
#define	IL_META_NATIVETYPE_U4					0x08
#define	IL_META_NATIVETYPE_I8					0x09
#define	IL_META_NATIVETYPE_U8					0x0A
#define	IL_META_NATIVETYPE_R4					0x0B
#define	IL_META_NATIVETYPE_R8					0x0C
#define	IL_META_NATIVETYPE_SYSCHAR				0x0D
#define	IL_META_NATIVETYPE_VARIANT				0x0E
#define	IL_META_NATIVETYPE_CURRENCY				0x0F
#define	IL_META_NATIVETYPE_PTR					0x10
#define	IL_META_NATIVETYPE_DECIMAL				0x11
#define	IL_META_NATIVETYPE_DATE					0x12
#define	IL_META_NATIVETYPE_BSTR					0x13
#define	IL_META_NATIVETYPE_LPSTR				0x14
#define	IL_META_NATIVETYPE_LPWSTR				0x15
#define	IL_META_NATIVETYPE_LPTSTR				0x16
#define	IL_META_NATIVETYPE_FIXEDSYSSTRING		0x17
#define	IL_META_NATIVETYPE_OBJECTREF			0x18
#define	IL_META_NATIVETYPE_IUNKNOWN				0x19
#define	IL_META_NATIVETYPE_IDISPATCH			0x1A
#define	IL_META_NATIVETYPE_STRUCT				0x1B
#define	IL_META_NATIVETYPE_INTF					0x1C
#define	IL_META_NATIVETYPE_SAFEARRAY			0x1D
#define	IL_META_NATIVETYPE_FIXEDARRAY			0x1E
#define	IL_META_NATIVETYPE_INT					0x1F
#define	IL_META_NATIVETYPE_UINT					0x20
#define	IL_META_NATIVETYPE_NESTEDSTRUCT			0x21
#define	IL_META_NATIVETYPE_BYVALSTR				0x22
#define	IL_META_NATIVETYPE_ANSIBSTR				0x23
#define	IL_META_NATIVETYPE_TBSTR				0x24
#define	IL_META_NATIVETYPE_VARIANTBOOL			0x25
#define	IL_META_NATIVETYPE_FUNC					0x26
#define	IL_META_NATIVETYPE_LPVOID				0x27
#define	IL_META_NATIVETYPE_ASANY				0x28
#define	IL_META_NATIVETYPE_R					0x29
#define	IL_META_NATIVETYPE_ARRAY				0x2A
#define	IL_META_NATIVETYPE_LPSTRUCT				0x2B
#define	IL_META_NATIVETYPE_CUSTOMMARSHALER		0x2C
#define	IL_META_NATIVETYPE_ERROR				0x2D
#define	IL_META_NATIVETYPE_MAX					0x50

/*
 * Variant types.
 */
#define	IL_META_VARIANTTYPE_BASE_TYPE_MASK		0x0FFF
#define	IL_META_VARIANTTYPE_EMPTY				0x0000
#define	IL_META_VARIANTTYPE_NULL				0x0001
#define	IL_META_VARIANTTYPE_I2					0x0002
#define	IL_META_VARIANTTYPE_I4					0x0003
#define	IL_META_VARIANTTYPE_R4					0x0004
#define	IL_META_VARIANTTYPE_R8					0x0005
#define	IL_META_VARIANTTYPE_CY					0x0006
#define	IL_META_VARIANTTYPE_DATE				0x0007
#define	IL_META_VARIANTTYPE_BSTR				0x0008
#define	IL_META_VARIANTTYPE_DISPATCH			0x0009
#define	IL_META_VARIANTTYPE_ERROR				0x000A
#define	IL_META_VARIANTTYPE_BOOL				0x000B
#define	IL_META_VARIANTTYPE_VARIANT				0x000C
#define	IL_META_VARIANTTYPE_UNKNOWN				0x000D
#define	IL_META_VARIANTTYPE_DECIMAL				0x000E
#define	IL_META_VARIANTTYPE_I1					0x0010
#define	IL_META_VARIANTTYPE_UI1					0x0011
#define	IL_META_VARIANTTYPE_UI2					0x0012
#define	IL_META_VARIANTTYPE_UI4					0x0013
#define	IL_META_VARIANTTYPE_I8					0x0014
#define	IL_META_VARIANTTYPE_UI8					0x0015
#define	IL_META_VARIANTTYPE_INT					0x0016
#define	IL_META_VARIANTTYPE_UINT				0x0017
#define	IL_META_VARIANTTYPE_VOID				0x0018
#define	IL_META_VARIANTTYPE_HRESULT				0x0019
#define	IL_META_VARIANTTYPE_PTR					0x001A
#define	IL_META_VARIANTTYPE_SAFEARRAY			0x001B
#define	IL_META_VARIANTTYPE_CARRAY				0x001C
#define	IL_META_VARIANTTYPE_USERDEFINED			0x001D
#define	IL_META_VARIANTTYPE_LPSTR				0x001E
#define	IL_META_VARIANTTYPE_LPWSTR				0x001F
#define	IL_META_VARIANTTYPE_RECORD				0x0024
#define	IL_META_VARIANTTYPE_FILETIME			0x0040
#define	IL_META_VARIANTTYPE_BLOB				0x0041
#define	IL_META_VARIANTTYPE_STREAM				0x0042
#define	IL_META_VARIANTTYPE_STORAGE				0x0043
#define	IL_META_VARIANTTYPE_STREAMED_OBJECT		0x0044
#define	IL_META_VARIANTTYPE_STORED_OBJECT		0x0045
#define	IL_META_VARIANTTYPE_BLOB_OBJECT			0x0046
#define	IL_META_VARIANTTYPE_CF					0x0047
#define	IL_META_VARIANTTYPE_CLSID				0x0048
#define	IL_META_VARIANTTYPE_MAX					0x0048
#define	IL_META_VARIANTTYPE_BSTR_BLOB			0x0FFF
#define	IL_META_VARIANTTYPE_VECTOR				0x1000
#define	IL_META_VARIANTTYPE_ARRAY				0x2000
#define	IL_META_VARIANTTYPE_BYREF				0x4000
#define	IL_META_VARIANTTYPE_RESERVED			0x8000
#define	IL_META_VARIANTTYPE_ILLEGAL				0xFFFF

/*
 * Vtable fixup attributes.
 */
#define	IL_META_VTFIXUP_32BIT					0x01
#define	IL_META_VTFIXUP_64BIT					0x02
#define	IL_META_VTFIXUP_FROM_UNMANAGED			0x04
#define	IL_META_VTFIXUP_CALL_MOST_DERIVED		0x10

/*
 * Hash algorithm codes.
 */
#define	IL_META_HASHALG_NONE					0x0000
#define	IL_META_HASHALG_MD5						0x8003
#define	IL_META_HASHALG_SHA1					0x8004

/*
 * Bit positions for size flags in the metadata header.
 */
#define	IL_META_SIZE_FLAG_STRREF				0x01
#define	IL_META_SIZE_FLAG_GUIDREF				0x02
#define	IL_META_SIZE_FLAG_BLOBREF				0x04

/*
 * Exception type flags for method code sections.
 */
#define	IL_META_EXCEPTION_NONE					0x0000
#define	IL_META_EXCEPTION_CATCH					IL_META_EXCEPTION_NONE
#define	IL_META_EXCEPTION_FILTER				0x0001
#define	IL_META_EXCEPTION_FINALLY				0x0002
#define	IL_META_EXCEPTION_FAULT					0x0004

/*
 * Marshal conversion types that are used internally.
 */
#define	IL_META_MARSHAL_DIRECT					0x0000
#define	IL_META_MARSHAL_ANSI_STRING				0x0001
#define	IL_META_MARSHAL_UTF8_STRING				0x0002
#define	IL_META_MARSHAL_FNPTR					0x0003
#define	IL_META_MARSHAL_ARRAY					0x0004
#define	IL_META_MARSHAL_REF_ANSI_ARRAY			0x0005
#define	IL_META_MARSHAL_REF_UTF8_ARRAY			0x0006
#define	IL_META_MARSHAL_UTF16_STRING			0x0007
#define	IL_META_MARSHAL_CUSTOM					0x0008
#define	IL_META_MARSHAL_ANSI_ARRAY				0x0009
#define	IL_META_MARSHAL_UTF8_ARRAY				0x000A

/*
 * Control data structure for reading from the metadata section.
 */
typedef struct _tagILMetaDataRead
{
	const unsigned char *data;		/* Current data position */
	unsigned long		 len;		/* Length remaining to read */
	int					 error;		/* Set to non-zero if error encountered */

} ILMetaDataRead;

/*
 * Maximum buffer size for compression buffers.
 */
#define	IL_META_COMPRESS_MAX_SIZE	5

/*
 * Uncompress a data item within the metadata section.
 */
unsigned long ILMetaUncompressData(ILMetaDataRead *meta);

/*
 * Uncompress a token from within the metadata section.
 */
unsigned long ILMetaUncompressToken(ILMetaDataRead *meta);

/*
 * Uncompress a signed integer from within the metadata section.
 */
long ILMetaUncompressInt(ILMetaDataRead *meta);

/*
 * Compress a data item within the metadata section into a buffer.
 * Returns the length of the compressed data.
 */
int ILMetaCompressData(unsigned char *buf, unsigned long data);

/*
 * Compress a token within the metadata section into a buffer.
 * Returns the length of the compressed data.  Returns zero if
 * the token does not have a compressed representation.
 */
int ILMetaCompressToken(unsigned char *buf, unsigned long data);

/*
 * Compress a signed integer within the metadata section into a buffer.
 * Returns the length of the compressed data.
 */
int ILMetaCompressInt(unsigned char *buf, long data);

#ifdef	__cplusplus
};
#endif

#endif	/* _IL_META_H */
