/*
** Copyright (C) 1999, 2000, 2001 Lorenzo Bettini <bettini@gnu.org>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


// tags.cc

#include "tags.h"
#include "colors.h"
#include "keys.h"

#include <iostream>

using std::cerr;
using std::endl;

Tags *GlobalTags = 0 ;

Tag::Tag( const string &n, const string &c ) : TagName( n ), color (c), flags( 0 )
{
}

void setTags( Tags *t ) {
  GlobalTags = t ;
}

Tag *getTag( const string &name ) {
  if ( ! GlobalTags )
    createDefaultTags() ;
  return GlobalTags->GetTag( name ) ;
}

void Tag::Print() {
  cerr << TagName << " " << color << " " << flags << endl ;
}

void createDefaultTags() {
  GlobalTags = new Tags ;

  GlobalTags->AddTag( newDefaultTag( KEYWORD, KEYWORD_C ) ) ;
  GlobalTags->AddTag( newDefaultTag( COMMENT, COMMENT_C ) ) ;
  GlobalTags->AddTag( newDefaultTag( STRING, STRING_C ) ) ;
  GlobalTags->AddTag( newDefaultTag( TYPE, BASETYPE_C ) ) ;
  GlobalTags->AddTag( newDefaultTag( NUMBER, NUMBER_C ) ) ;
  GlobalTags->AddTag( newDefaultTag( PREPROC, PREPROC_C ) ) ;
  GlobalTags->AddTag( newDefaultTag( FUNCTION, FUNCTION_C ) ) ;
  GlobalTags->AddTag( newDefaultTag( CBRACKET, CBRACKET_C ) ) ;
}

Tag *newDefaultTag( const string &tag, const string &color ) {
  Tag *tempTag = new Tag( tag ) ;
  tempTag->SetColor( color ) ;

  return tempTag ;
}
