/*
 * search_tl.c - search using time limits
 * (C) 2000 Kir <kir@sever.net>, UdmSearch Developers Team.
 */
#define _GNU_SOURCE
#include <stdlib.h>
#include <ctype.h>
#include <time.h>

#include <udm_utils.h>
#include <udm_os.h>

#include <udm_os.h>

extern int tz_offset;

/******************
 * Data definitions 
 */

/* search with time limits */
struct time_search_type{
	int type;
	char *name;
};

struct time_search_type dt_types[]=
	{{ 1, "back"},
	 { 2, "er"},
	 { 3, "range"},
	 /* add more types just before this line */
	 { 0, ""}};

int getSTLType(char *type_str){
	int i=0;
	int len=0;

	while (dt_types[i].type){
		len=strlen(dt_types[i].name);
		if (type_str[len]=='\0') /* strings are equal in size */
			if ( !strncmp(type_str, dt_types[i].name, len) )
				return dt_types[i].type;
		i++;
	}
	return 0; /* not found */
}

time_t dp2time_t(char * time_str){
	time_t t=0;
	long i;
	char *s, *ts;
	
	ts=time_str;
	do{
		i=strtol(ts, &s, 10);
		if (s==ts){ /* falied to find a number */
			/* FIXME: report error */
			return -1;
		}
		

		/* ignore spaces */
		while (isspace(*s))
			s++;
	    
		switch(*s){
			case 's': /* seconds */
				t+=i; break;
			case 'M': /* minutes */
				t+=i*60; break;
			case 'h': /* hours */
				t+=i*60*60; break;
			case 'd': /* days */
				t+=i*60*60*24; break;
			case 'm': /* months */
				/* I assume month is 30 days */
				t+=i*60*60*24*30; break;
			case 'y': /* years */
				t+=i*60*60*24*365; break;
			default:
				/* FIXME: report error here! */
				return -1;
		}
		/* go to next char */
		ts=++s;
	/* is it end? */
	} while (*s);
	
	return t;
}

time_t dmy2time_t(char *str){
	struct tm t;
	time_t ts;
	
	UDMMEMZERO(&t, sizeof(t));
	strptime(str, "%d/%m/%Y", &t);
	ts=mktime(&t);
/*	printf("dmy2time_t(%s)=%li\n", str, ts); */
	if (ts>0)
		return ts-tz_offset;
	else
		return -1; /* error */
}

time_t d_m_y2time_t(int d, int m, int y){
	struct tm t;
	time_t ts;
	
	UDMMEMZERO(&t, sizeof(t));
	t.tm_mday=d;
	t.tm_mon=m;
	t.tm_year=y-1900;
	ts=mktime(&t);
/*	printf("d_m_y2time_t(%d, %d, %d)=%li\n", d, m, y, ts);*/
	if (ts>0)
		return ts-tz_offset;
	else
		return -1; /* error */
}


/* * * * * * * * * * * * *
 * BELOW IS DEBUG CRAP...
 */

/*
#define TL_DEBUG_DP2TIME
#define TL_DEBUG_GSTLT
*/

#ifdef TL_DEBUG_DP2TIME
int main(int argc, char **argv){

	char *dp;
	
	if (argc>1)
		dp=argv[1];
	else{
		printf("Usage: %s time_string\n", argv[0]);
		return 1;
	}
	
	printf("str='%s'\ttime=%li\n", dp, dp2time_t(dp));
	return 0;
}
#endif /* TL_DEBUG */

#ifdef TL_DEBUG_GSTLT
int main(int argc, char **argv){

	char *str;
	
	if (argc>1)
		str=argv[1];
	else{
		printf("Usage: %s search_type_string\n", argv[0]);
		return 1;
	}
	
	printf("str='%s'\ttype=%i\n", str, getSTLType(str));
	return 0;
}
#endif /* TL_DEBUG_GSTLT */
