#include "udm_config.h"

#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "udm_common.h"
#include "udm_socket.h"
#include "udm_host.h"
#include "udm_proto.h"

#ifndef INADDR_NONE
#define INADDR_NONE ((unsigned long) -1)
#endif

int host_lookup( UDM_CONN *connp ){
	struct hostent *he;
	
	if (!connp->hostname)
		return -1;
		
	/* Check if hostname in standard numbers-and-dots notation */ 
	if ((connp->sin.sin_addr.s_addr = inet_addr(connp->hostname)) == INADDR_NONE) {
    		if ((he = gethostbyname(connp->hostname)) == NULL) {
			connp->err = UDM_NET_CANT_RESOLVE;
			return -1;
		}
		memcpy((char *)&(connp->sin.sin_addr), he->h_addr, he->h_length);
	}

	/*	Set port	*/
	if (connp->port) 
		connp->sin.sin_port = htons(connp->port);
	else 
	    return -1;

    return 0;
}

