#ifndef _UDM_CHARSET_H
#define _UDM_CHARSET_H

#define UDM_CHARSET_DEFAULT		-1
#define UDM_CHARSET_NO			0
#define UDM_CHARSET_KOI8R		1
#define UDM_CHARSET_CP1251		2
#define	UDM_CHARSET_CP866		3
#define UDM_CHARSET_MACCYR		4
#define	UDM_CHARSET_ISO88595		5
#define UDM_CHARSET_CP1250		6
#define UDM_CHARSET_ISO88591		7
#define UDM_CHARSET_ISO88592		8
#define UDM_CHARSET_CP1256		9

extern char * UdmRecode(unsigned char *str,int from,int to);
extern char * UdmTolower(unsigned char *str,int charset);
extern char * UdmToupper(unsigned char *str,int charset);
extern char * UdmGetWord( char *s, char **last, int charset);
extern char * UdmCharsetStr(int id);

extern int    UdmGetCharset(unsigned char *alias);
extern int    UdmGetDefaultCharset();
extern int    UdmSetDefaultCharset(int id);
extern char   UdmSgmlToChar(char *sgml,int charset);
extern int    UdmWordChar(char s, int charset);
#ifdef USE_CHARSET_GUESSER
extern int    UdmGuessCharset(unsigned char *str, int charset);
#endif

extern __INDLIB__ int UdmInitCharset();


#endif
