# copyright (C) 1997-2002 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu
proc echo {args} {foreach argument $args {puts -nonewline "$argument "}; puts {}}

set rcsId {$Id: myhealth.tcl,v 1.4 2002/01/19 11:53:05 jfontain Exp $}


package provide myhealth [lindex {$Revision: 1.4 $} 1]
if {[lsearch -exact $auto_path /usr/lib]<0} {                         ;# in case Tcl/Tk is somewhere else than in the /usr hierarchy
    lappend auto_path /usr/lib
}
package require miscellaneous 1


namespace eval myhealth {

    array set data {
        updates 0
        0,label display 0,type ascii 0,message {per hour values are calculated for the last poll period using the absolute values from the server, and only for variables that make sense (otherwise a ? is displayed in the column)}
        0,0 absolute 1,0 {per hour}
        1,label version 1,type ascii 1,message {The version number for the server.}
        2,label uptime 2,type dictionary 2,message {How many seconds the server has been up.}
        3,label {slow queries} 3,type real 3,message {Number of queries that have taken more than long_query_time.}
        4,label {remaining connections} 4,type integer 4,message {Number of simultaneous connections left before the number of connections reaches the maximum number of simultaneous clients allowed (as defined by the max_connections variable).} 1,4 ?
        5,label {select scan} 5,type real 5,message {Number of joins where we scanned the first table.}
        6,label {select full join} 6,type real 6,message {Number of joins without keys (Should be 0).}
        7,label {aborted connects} 7,type real 7,message {Number of tries to connect to the MySQL server that failed.}
        8,label {created tmp disk tables} 8,type real 8,message {Number of implicit temporary tables on disk created while executing statements.}
        9,label {created tmp files} 9,type real 9,message {How many temporary files mysqld has created.}
        pollTimes {20 10 30 60 120 300}
        switches {--dsn 1 --host 1 --password 1 --port 1 --user 1}
        views {{visibleColumns {0 1 2 3 4 5 6 7 8 9} swap 1}}
    }
    # variable name to column mapping for MySQL changing variables:
    array set nameColumn {
        Uptime 2 Slow_queries 3 Select_scan 5 Select_full_join 6 Aborted_connects 7 Created_tmp_disk_tables 8 Created_tmp_files 9
    }
    # MySQL variables needed for indicators calculations
    array set needed {max_connections {} Max_used_connections {}}
    set file [open myhealth.htm]
    set data(helpText) [read $file]                                                           ;# initialize HTML help data from file
    close $file

    proc initialize {optionsName} {
        upvar $optionsName options
        variable odbc
        variable connection
        variable data
        variable nameColumn

        catch {set user $::env(USER)}                                                                                  ;# by default
        catch {set user $::env(LOGNAME)}                                                          ;# more common in UNIX and even NT
        catch {set user $options(--user)}
        if {[info exists options(--dsn)]} {                                               ;# ODBC mode id data source name specified
            set odbc 1
            package require tclodbc 2                               ;# so that it works with both UNIX 2.2.1 et Windows 2.3 versions
            if {[info exists options(--host)]||[info exists options(--port)]} {
                error {--host and --port options incompatible with ODBC mode}
            }
            set arguments [list $options(--dsn)]
            catch {lappend arguments $user}
            catch {lappend arguments $options(--password)}
            set connection [eval database odbc $arguments]                                           ;# use a unique connection name
            set data(identifier) myhealth($options(--dsn))
            set version [lindex [lindex [$connection {show variables like 'version'}] 0] 1]
        } else {
            set odbc 0
            package require mysqltcl 2
            set arguments {}
            catch {lappend arguments -host $options(--host)}
            catch {lappend arguments -user $user}
            catch {lappend arguments -password $options(--password)}
            catch {lappend arguments -port $options(--port)}
            set connection [eval mysqlconnect $arguments]
            set host [mysqlinfo $connection host]
            set data(identifier) myhealth($host)
            set version [lindex [mysqlsel $connection {show variables like 'version'} -flatlist] 1]
        }
        scan $version %u.%u.%u major minor subMinor
        switch $major {
            3 {
                if {$minor!=23} {error "cannot monitor a server version 3.$minor"}
### update ###
                if {$subMinor<47} {error {cannot monitor a server below version 3.23.47 in the 3.23 series}}
            }
            4 {
                if {$minor!=0} {error "cannot monitor a server version 4.$minor"}
                if {$subMinor<1} {error {cannot monitor a server below version 4.0.1 in the 4.0 series}}
            }
            default {
                error "cannot monitor a server version $major"
            }
        }
        set data(0,1) $version
        set data(1,1) {}
    }

    proc update {} {
        variable odbc
        variable connection
        variable last
        variable data
        variable needed
        variable nameColumn

        set error 0
        if {$odbc} {
            set error [catch {
                $connection statement $connection.query {show status}
                $connection.query execute
            } message]
        } else {
            set error [catch {mysqlsel $connection {show status}} message]
        }
        if {$error} {                                                                                     ;# problem reaching server
            flashMessage "myhealth error: $message"
            invalid
        } else {
            set clock [expr {[clock clicks -milliseconds]/3600000.0}]                                        ;# store clock in hours
            catch {set period [expr {$clock-$last(clock)}]}
            set last(clock) $clock
            while {1} {
                if {$odbc} {
                    set list [$connection.query fetch]
                } else {
                    set list [mysqlnext $connection]
                }
                if {[llength $list]==0} break
                foreach {variable value} $list {}
                if {[info exists needed($variable)]} {
                    set needed($variable) $value                                                ;# for indicators calculations below
                }
                if {[catch {set column $nameColumn($variable)}]} continue                               ;# variable is not displayed
                if {[string equal $variable Uptime]} {
                    set data(0,$column) [formattedTime $value]
                    set data(1,$column) {}
                } else {
                    if {[string equal $data($column,type) real]} {                                 ;# required for per second values
                        set data(0,$column) $value                                   ;# display as is as it really may be an integer
                        if {[info exists period]} {
                            set data(1,$column) [format %.2f [expr {($value-$last($column))/$period}]]
                        } else {
                            set data(1,$column) ?
                        }
                        set last($column) $value
                    } else {
                        set data(0,$column) $value
                    }
                }
            }
        }
        if {$odbc} {
            catch {$connection.query drop}            ;# ignore connection errors at this point (they will be reported at next poll)
        }
        set error 0
        if {$odbc} {
            set error [catch {
                $connection statement $connection.query {show variables}
                $connection.query execute
            } message]
        } else {
            set error [catch {mysqlsel $connection {show variables}} message]
        }
        if {$error} {                                                                                     ;# problem reaching server
            flashMessage "myhealth error: $message"
            invalid
        } else {
            while {1} {
                if {$odbc} {
                    set list [$connection.query fetch]
                } else {
                    set list [mysqlnext $connection]
                }
                if {[llength $list]==0} break
                foreach {variable value} $list {}
                if {[info exists needed($variable)]} {
                    set needed($variable) $value                                                ;# for indicators calculations below
                }
                if {[catch {set column $nameColumn($variable)}]} continue                               ;# variable is not displayed
                set data(0,$column) $value
            }
        }
        if {$odbc} {
            catch {$connection.query drop}            ;# ignore connection errors at this point (they will be reported at next poll)
        }
        set data(0,4) [expr {$needed(max_connections)-$needed(Max_used_connections)}]
        incr data(updates)
    }

    proc invalid {} {                                                                              ;# update data when it is invalid
        variable last
        variable data

        catch {unset last}
        foreach name [array names data *,label] {
            scan $name %u column
            if {$column==0} continue                                                                               ;# headers column
            set data(0,$column) ?
            if {[string equal $data($column,type) real]} {                                         ;# required for per second values
                set data(1,$column) ?
            }
        }
    }

    proc terminate {} {
        variable odbc
        variable connection

        if {$odbc} {
            catch {$connection disconnect}
        } else {
            catch {mysqlclose $connection}
        }
    }

}
