/* --- BEGIN 'top' portion of acconfig.h --- */

/* acconfig.h is here to make autoheader happy and smile. -kir */

#ifndef _UDM_CONFIG_H
#define _UDM_CONFIG_H

/* --- END 'top' portion of acconfig.h --- */
/* @TOP@ */ 




/* Define if you have tm_gmtoff in struct tm */
#undef HAVE_TM_GMTOFF

/* Define if you have POSIX type signal handling routines */
#undef HAVE_POSIX_SIGNALS

/* Define if you want to use threaded indexer */
#undef HAVE_PTHREAD

/* Define if automatic charset guesser is enabled */
#undef USE_CHARSET_GUESSER

/* Define if you want to use syslog for logging indexer messages */
#undef USE_SYSLOG

/* Define if you want to use external parser */
#undef USE_PARSER

/* Define if you want to use exec: and cgi: schemes */
#undef UDM_WITH_EXEC_CGI

/* Define if you want to use AliasProg */
#undef UDM_WITH_ALIASPROG

/* Define if you want mp3 id3 tags support */
#undef USE_MP3

/* Define if you want to support file:// URL schema */
#undef USE_FILE

/* Define if you want to support http:// URL schema */
#undef USE_HTTP

/* Define if you want to support ftp:// URL schema */
#undef USE_FTP

/* Define if you want to support news:// URL schema */
#undef USE_NEWS

/* Define if you want to group weight support */
#undef USE_GROUP

/* Define if you want extended NEWS features */
#undef NEWS_EXT

/* Define if you want to use MySQL */
#undef HAVE_MYSQL

/* Define if you want to use PostgreSQL */
#undef HAVE_PGSQL

/* Define if you want to use mSQL */
#undef HAVE_MSQL

/* Define if you want to use iODBC */
#undef HAVE_IODBC

/* Define if you want to use unixODBC */
#undef HAVE_UNIXODBC

/* Define if you want to use Solid SQL Server */
#undef HAVE_SOLID

/* Define if you want to use OpenLink ODBC (Virtuoso) */
#undef HAVE_VIRT

/* Define if you want to use EasySoft ODBC */
#undef HAVE_EASYSOFT

/* Define if you want to use SAPDB ODBC library */
#undef HAVE_SAPDB

/* Define if you want to use Interbase SQL Server */
#undef HAVE_IBASE

/* Define if you want to use Oracle 8 SQL Server */
#undef HAVE_ORACLE8

/* Define if you want to use Oracle 7 SQL Server */
#undef HAVE_ORACLE7

/* Define if you want to use built-in text file based database */
#undef HAVE_FILES

/* Define if you want fast tag search in cache mode*/
#undef UDM_STORE_CACHE_TAG

/* Define if you want fast category search in cache mode*/
#undef UDM_STORE_CACHE_CATEGORY

/* Define if you want fast site search in cache mode*/
#undef UDM_STORE_CACHE_SITEID

/* Define if you want phrase search in cache mode*/
#undef UDM_STORE_CACHE_WRDPOS

/* Define VERSION_ID */
#undef UDM_VERSION_ID

/* @BOTTOM@ */
/* --- BEGIN 'bottom' portion from acconfig.h --- */

/* Backend */
#if (HAVE_MYSQL||HAVE_PGSQL||HAVE_MSQL||HAVE_IODBC||HAVE_UNIXODBC||HAVE_SOLID||HAVE_VIRT||HAVE_IBASE||HAVE_ORACLE8||HAVE_ORACLE7||HAVE_EASYSOFT||HAVE_SAPDB)
#define HAVE_SQL
/* Define if you want to support htdb:// URL schema */
#undef USE_HTDB
#endif

#if (HAVE_PTHREAD && __linux__)
#define _REENTRANT
#define _P __P
#endif

/* Unix/Windows specific stuff */

#if (WIN32|WINNT)

#include <windows.h>
#define HAVE_WINDOWS_H
#define HAVE_IO_H
#define HAVE_DIRECT_H
#define HAVE_PROCESS_H
#define HAVE_WINSOCK_H
#define __INDLIB__		__declspec(dllexport) /* export functions for DLL  */
#define UDMSLASH		'\\'
#define UDMSLASHSTR		"\\"
#define UDMSLEEP(x)		_sleep(x*1000)
#define UDM_IWRITE		S_IWRITE
#define UDM_BINARY		O_BINARY

#else

#define __INDLIB__
#define UDMSLASH		'/'
#define UDMSLASHSTR		"/"
#define UDMSLEEP(x)		sleep(x)
#define closesocket(x)		close(x)
#define UDM_IWRITE		0644
#define UDM_BINARY		0

#endif


#endif /* _UDM_CONFIG_H */
/* --- END 'bottom' portion from acconfig.h --- */
