#include <string>
#include <fstream>
#include <iostream>
#include <kwm.h>
#include <kapp.h>
#include <qmsgbox.h> 
#include <kmsgbox.h>
#include <qfile.h>
#include <qfileinf.h>
#include <qtstream.h>
#include <qregexp.h>

#include "TableView.h"
#include "globals.h"
#include "my_sql.h"
#include "PatternPair.h"
#include "e_patternpair.h"
#include "MultiTextInput.h"
#include "tabledescr.h"
#include "selectoutfile.h"
#include "converter.h"
#include "stringlist.h"
#include "stringres.h"

#ifndef rcsid
static const char rcsid[]="$Id: TableView.cpp,v 2.23 1999/11/13 07:16:14 ral Exp $";
#endif

#define Inherited CTableViewData

CTableView::CTableView (CMySql*_sql_server,QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    sql_server = _sql_server;
    QString caption;
    caption = CStringRes::get_string(125);caption+=" - ";caption+=CStringRes::get_string(106);
    setCaption(caption);

    KWM::setIcon(winId(),kapp->getIcon());
    KWM::setMiniIcon(winId(),kapp->getMiniIcon());

    Current_Table_Fields.resize(0);
    Current_Displayed_Fields.resize(0);
    CurrentKeys.resize(0);

    RefreshLists();    
    connect(OutputList,SIGNAL(selected(int,int)),this,SLOT(entrySelected(int)));
}

CTableView::~CTableView()
{
}

void CTableView::RefreshLists()
{
    OutputList->clear();
    while (OutputList->count()) {
	OutputList->removeItem(0);
    }
    SelectDB->clear();
    stringlist list;
    sql_server->get_db_list("%",list);
    if (!list.size())
	return;
    for (stringlist::iterator iter = list.begin();iter != list.end();++iter) {
	SelectDB->insertItem(iter->c_str());
    }
    db_select(0);
}

void CTableView::MakeRequest()
{
    _make_fetch_request();
}

void CTableView::OffsetSet(int i)
{
    static int old = 0;

    OffsetDisplay->display(i);
    if (i < 10000 && old >= 10000)
	OffsetSlider->setRange(0,9999);
    else if (i == 9999 && old < 10000)
	OffsetSlider->setRange(0,99999);
    else if (i < 1000 && old >= 1000)
	OffsetSlider->setRange(0,999);
    else if (i == 999 && old < i)
	OffsetSlider->setRange(0,9999);
    else if (i < 100 && old >= 100)
	OffsetSlider->setRange(0,99);
    else if (i == 99 && old < i)
	OffsetSlider->setRange(0,999);
    old = i;
}

void CTableView::CountSet(int i)
{
    static int old = 0;
    CountDisplay->display(i);    
    if (i < 10000 && old >= 10000)
	CountSlider->setRange(0,9999);
    else if (i == 9999 && old < 10000)
	CountSlider->setRange(0,99999);
    else if (i < 1000 && old >= 1000)
	CountSlider->setRange(0,999);
    else if (i == 999 && old < i)
	CountSlider->setRange(0,9999);
    else if (i < 100 && old >= 100)
	CountSlider->setRange(0,99);
    else if (i == 99 && old < i)
	CountSlider->setRange(0,999);
    old = i;
}

void CTableView::show()
{
    QDialog::show();
}

void CTableView::db_select(int i)
{
    QString s;
    s = SelectDB->text(i);
    if (s.isEmpty())
	return;
    stringlist Result;
    sql_server->get_table_list("%",s,Result);
    TableSelect->clear();
    if (Result.size() == 0) {
	TableSelect->insertItem("No Tables");
	table_select(0);
	return;
    }
    if (sql_server->is_system_db(s)) {
	EmptyTableButton->setEnabled(false);
    } else {
	EmptyTableButton->setEnabled(true);
    }
    for (stringlist::iterator iter=Result.begin();iter!=Result.end();++iter) {
	TableSelect->insertItem(iter->c_str());
    }
    table_select(0);
}

void CTableView::table_select(int i)
{
    QString s = TableSelect->text(i);
    QString t = SelectDB->currentText();
    SortListBox->clear();
    ColumnDisplay->clear();
    ColumnList_iterator ergebnis;
    OutputList->clear();
    while (OutputList->count()) {
	OutputList->removeItem(0);
    }
    OutputList->repaint();
    Current_Table_Fields.resize(0);
    Current_Displayed_Fields.resize(0);

    if (s.isEmpty() || t.isEmpty()) {
	SortListBox->insertItem("No Columns found");
	set_buttons(FALSE);
	ColumnDisplay->update();
	return;
    }

    if (s.find("No Tables") > -1) {
	SortListBox->insertItem("No Columns found");
	set_buttons(FALSE);
	ColumnDisplay->update();
	return;
    }
    sql_server->get_table_keys(t,s,CurrentKeys);
    if (!sql_server->get_table_fields(t,s,Current_Table_Fields) || Current_Table_Fields.size()==0) {
	SortListBox->insertItem("No Columns found");
	ColumnDisplay->insertItem("No Columns found");
	set_buttons(FALSE);
	return;
    }
    int count = 0;
    OutputList->setNumCols(Current_Table_Fields.size());
    for (ergebnis = Current_Table_Fields.begin();ergebnis!=Current_Table_Fields.end(); ++ergebnis){
	ColumnDisplay->insertItem(ergebnis->get_name());
	SortListBox->insertItem(ergebnis->get_name());
	OutputList->setColumn(count,ergebnis->get_name());
	++count;
     }
    OutputList->fitAll();
    OutputList->repaint();

    set_buttons(TRUE);
    OutputSelected(-1);
    OutputList->setFocus();
}

void CTableView::addRow()
{
    e_PatternList which;// = new e_PatternList;
    PatternList*result = 0;
    ColumnList_iterator Field;
    int i;
    QString db;
    QString table;
    CMultiTextInput edit(this);
    table = TableSelect->currentText();
    db = SelectDB->currentText();
    for (Field = Current_Table_Fields.begin();Field != Current_Table_Fields.end();++Field) {
	if (!Field->is_AutoIncrement() ) {
	    e_PatternIterator iter;
	    which.push_back(e_patternpair(Field->get_name(),Field->get_default()));
	    iter = which.end();
	    iter--;
	    iter->setIsNumeric(Field->is_Numeric());
	    iter->setLargeText(Field->is_Blob());
	    stringIlist _temp_list = Field->enum_list();
	    if (_temp_list.size()>0) {
		if (!Field->is_NotNull())
		    _temp_list.insert(_temp_list.begin(),"");
		iter->set_enumlist(_temp_list);
	    }
	}
    }
    edit.setCaption(CStringRes::get_string(77));
    edit.build_widgets(&which);
    if (edit.exec())
        result = edit.get_entries(FALSE);
    else
	return;
    if (!result)
	return;
    i = sql_server->insert_row(db,table,result);
    if (i < 0) {
	display_error_box();
    }
    delete result;
}

void CTableView::search_rows()
{
    _make_fetch_request(true);
}

void CTableView::set_buttons(bool how)
{
    searchButton->setEnabled(how);
    saveButton->setEnabled(how);
    AddRow->setEnabled(how); 
    saveButton->setEnabled(how);
    Go_Button->setEnabled(how);
    EmptyTableButton->setEnabled(how);
    DeleteButton->setEnabled(how);
}

void CTableView::OutputSelected(int i)
{
    bool how;
    QString db = SelectDB->currentText();
    how = ( (i > -1) && (KeyDisplayed()) );
    ModifyRow->setEnabled(how);
    DeleteButton->setEnabled(how);
}

void CTableView::modifyRow()
{
    QString Entry;
    QString Breaks;
    e_PatternList BreakList;// =  0;
    PatternList* ModList = 0;
    PatternList KeyList;// = 0;
    PatternList _BreakList;

    CMultiTextInput edit(this);
    int i = 0;

    i = BreakIntoParts(&_BreakList,&KeyList);

    if (i < 0 || _BreakList.size() == 0 || KeyList.size() == 0) {
	return;
    }
    for (unsigned j = 0;j < _BreakList.size();++j) {
	BreakList.push_back(_BreakList[j]);
	for (unsigned a=0;a<Current_Displayed_Fields.size();++a) {
	    if ( strcasecmp(BreakList[j].get_entry(),Current_Displayed_Fields[a].get_name()) == 0) {
		stringIlist _temp_list = Current_Displayed_Fields[a].enum_list();
		if (_temp_list.size()>0) {
		    if (!Current_Displayed_Fields[a].is_NotNull())
			_temp_list.insert(_temp_list.begin(),"");
		    BreakList[j].set_enumlist(_temp_list);
		}
		break;
	    }
	}
    }
    edit.build_widgets(&BreakList);

    edit.setCaption("Modify");
    if (!edit.exec()) {
	return;
    }

    ModList = edit.get_entries(true);

    if (!ModList || ModList->size() == 0) {
	if (ModList)
	    delete ModList;
	return;	
    }
    e_PatternIterator break_iter;
    PatternIterator mod_iter;
    
    break_iter = BreakList.begin();
    mod_iter = ModList->begin();
    while (break_iter!=BreakList.end()) {
	Entry = mod_iter->get_pattern();
	Breaks = break_iter->get_pattern();
	if (Breaks == Entry) {
	    mod_iter =  ModList->erase(mod_iter);
	} else {
	    ++mod_iter;
	}
	++break_iter;
    }
    if (ModList->size() == 0) {
	delete ModList;
	return;	
    }
    i = sql_server->update_row(SelectDB->currentText(),TableSelect->currentText(),
		       ModList,&KeyList);
    delete ModList;

    if (i < 0) {
	display_error_box();
    } else
	MakeRequest();
}

void CTableView::delete_row()
{
    PatternList*KeyList = new PatternList;
    int i = BreakIntoParts(0,KeyList);
    if (i < 0 || KeyList->size() == 0) {
	delete KeyList;
	return;
    }
    i = QMessageBox::warning( this, CStringRes::get_string(79),
			      CStringRes::get_string(80),
			      CStringRes::get_string(16), CStringRes::get_string(17),
			      0, 1 );
    if (i == 1) {
	delete KeyList;
	return;
    }
    i = sql_server->delete_row(SelectDB->currentText(),TableSelect->currentText(),KeyList);
    delete KeyList;
    if (i < 0) {
	display_error_box();
    } else {
	MakeRequest();
    }
}

void CTableView::emptyTable()
{
    QString message;
    message = CStringRes::get_string(81);
    message+="\n";
    message+= CStringRes::get_string(14);
    message+="\n";
    int i = QMessageBox::warning( this, CStringRes::get_string(82),message,
				  CStringRes::get_string(16), CStringRes::get_string(17),0, 1 );
    if (i == 1)
	return;
    i = sql_server->delete_row(SelectDB->currentText(),TableSelect->currentText());
    if (i < 0) {
	display_error_box();
	return;
    }
    OutputList->clear();
    ModifyRow->setEnabled(false);
    DeleteButton->setEnabled(false);
    OutputList->setFocus();
    return;
}

bool CTableView::KeyDisplayed()
{
    if (SelectFields.size()==0) {
	return false;
    }
    return true;
}

CColumnDescriptor*CTableView::FindTableItem(const char*what,bool all_fields)
{
    ColumnList_iterator Entry;
    if (all_fields) {
	for (Entry = Current_Table_Fields.begin();Entry!=Current_Table_Fields.end();++Entry) {
	    if (*Entry == what)
		return Entry;
	}
    } else {
	for (Entry = Current_Displayed_Fields.begin();Entry!=Current_Displayed_Fields.end();++Entry) {
	    if (*Entry == what)
		return Entry;
	}
    }
    return NULL;
}

int CTableView::BreakIntoParts(PatternList*BreakList,PatternList*KeyList,int count,
			       bool no_auto_filter)
{
    QString Entry;
    QString Breaks;
    ColumnList_iterator Field;
    int i = OutputList->currentItem();

    if (i < 0 || Current_Displayed_Fields.size() == 0)
	return -1;
    if (count > -1)
	Entry = OutputList->text(count);
    else
	Entry = OutputList->text(i);

    if (Entry.isEmpty())
	return -1;
    i = 0;
    for (i = Entry.find("\t");i > -1;i=Entry.find("\t")){
	Breaks = Entry.left(i);
	Entry = Entry.mid(i+1,Entry.length());
	Breaks = Breaks.stripWhiteSpace();
	if (BreakList) 
	    BreakList->push_back(CPatternPair("",Breaks));
	if (KeyList)
	    KeyList->push_back(CPatternPair("",Breaks));
    }
    Entry = Entry.stripWhiteSpace();
    if (BreakList)
	BreakList->push_back(CPatternPair("",Entry));
    if (KeyList)
	KeyList->push_back(CPatternPair("",Entry));
    Entry = "";
    PatternIterator break_iterator = 0;
    PatternIterator key_iterator = 0;
    if (BreakList)
	break_iterator = BreakList->begin();
    if (KeyList)
	key_iterator= KeyList->begin();
    for (Field = Current_Displayed_Fields.begin();Field!=Current_Displayed_Fields.end();++Field) {
	if (BreakList) {
	    if (Field->is_AutoIncrement() && !no_auto_filter) {
		break_iterator = BreakList->erase(break_iterator);
	    } else {
		if (break_iterator) {
		    break_iterator->set_entry(Field->get_name());
		    break_iterator->setLargeText(Field->is_Blob());
		    ++break_iterator;
		}
	    }
	}
	if (KeyList) {
	    if (SelectFields.find(Field->get_name())) {
		if (key_iterator) {
		    key_iterator->set_entry(Field->get_name());
		    ++key_iterator;
		}
	    } else {
		key_iterator = KeyList->erase(key_iterator);
	    }
	}
    }
    return 0;
}

void CTableView::saveResult()
{
    CSelectOutFile SelectBox(this);
    QString filename;
    QString message;
    QFileInfo finfo;
    int i;
    if (OutputList->count() == 0)
	return;
    if (!SelectBox.exec())
	return;
    filename = SelectBox.get_name();
    if (filename.isEmpty())
	return;
    finfo.setFile(filename);
    if (finfo.isDir()) {
	QMessageBox::warning(this,CStringRes::get_string(83),
			     CStringRes::get_string(84));
	return;
    }
    if (QFile::exists(filename)) {
	message = CStringRes::get_string(85);
	message+="\n\n";
	message+=filename;message+="\n\n";
	message+=CStringRes::get_string(86);
	message+="\n";
	i = KMsgBox::yesNo( this, CStringRes::get_string(87),
			    message,KMsgBox::QUESTION);
	if (i != 1 )
	    return;

	if (!finfo.isWritable()) {
	    QMessageBox::warning(this,CStringRes::get_string(83),
				CStringRes::get_string(88));
	    return;
	}
    }
    i = SelectBox.get_type();
    switch (i) {
    case 1:
	saveHtml(filename);
	break;
    case 2:
	saveLatex(filename);
	break;
    default:
	saveAscii(filename);
    }
}

void CTableView::saveAscii(const char*filename)
{
    unsigned int i = 0;
    int j = 0;
    QString line = "";
    QString entry;
    QString Breaks;
    if (!filename || strlen(filename) == 0)
	return;
    if (OutputList->count() < 1)
	return;
    QFile outfile(filename);
    outfile.open(IO_WriteOnly|IO_Truncate);
    if (!outfile.isOpen()) 
	return;
    QTextStream st(&outfile);
    entry = OutputList->text(0);
    line = line.leftJustify(entry.length(),'-');
    line = "+-" + line;
    line += "-+";
    st << line << "\n";
    for (i = 0;i < OutputList->count();i++) {
	entry = OutputList->text(i);
	while ( (j = entry.find("\t")) != -1 ) {
	    entry.replace(j,1," ");
	}
	st << "| " << entry << " |\n" << line << "\n";
    }
    outfile.close();
}

void CTableView::saveHtml(const char*filename)
{
    CConverter *converter = CConverter::get_converter(CConverter::HTML);
    if (!converter)
	return;
    PatternList*KeyList = 0;
    PatternIterator key_iterator;
    //    CPatternPair*pair;
    ColumnList_iterator desc;
    QString entry;
    unsigned int i;

    if (!filename || strlen(filename) == 0)
	return;
    if (OutputList->count() < 1)
	return;
    QFile outfile(filename);
    outfile.open(IO_WriteOnly|IO_Truncate);
    if (!outfile.isOpen()) 
	return;
    QTextStream st(&outfile);
    st << "<HTML>\n<HEAD>\n<TITLE>TableOutput</TITLE>\n</HEAD>\n";
    st << "<BODY>\n<TABLE WIDTH=100% BORDER=1 CELLPADDING=3 CELLSPACING=1>\n";
    st << "  <TR VALIGN=TOP>\n";
    for (desc = Current_Displayed_Fields.begin();desc!= Current_Displayed_Fields.end();++desc) {
	st << "    <TH><P>" << desc->get_name() << "</TH>\n";
    }
    st << "  </TR>\n";
    KeyList = new PatternList;
    //    KeyList->setAutoDelete(true);
    for (i = 0; i < OutputList->count();i++) {
	KeyList->resize(0);
	BreakIntoParts(KeyList,0,i,true);
	st << "  <TR>\n";
	desc = Current_Displayed_Fields.begin();
	key_iterator = KeyList->begin();
	for (key_iterator = KeyList->begin();key_iterator != KeyList->end();++key_iterator) {
	    if (desc && desc->is_Numeric())
		st << "    <TD><P ALIGN=RIGHT>";
	    else
		st << "    <TD><P>";
	    entry = key_iterator->get_pattern();
	    if (entry.length() > 0) {
		st << converter->convert(entry);
	    }
	    else {
		entry = "<br>";
		st << entry;
	    }
	    st << "</TD>\n";
	    ++desc;
	}
	st << "  </TR>\n";
    }
    st << "</TABLE>\n<P>\n<FONT SIZE=-1>\n"
	"Document created with KMySqlAdmin\n</FONT>\n</BODY>\n</HTML>\n";
    delete KeyList;
    delete converter;
}

void CTableView::saveLatex(const char*filename)
{
    PatternList BreakList;
    CConverter * converter = CConverter::get_converter(CConverter::LATEX);
    if (!converter)
	return;
    //    CPatternPair*pair;
    ColumnList_iterator desc;
    std::string entry;
    std::string head, head2, head3;
    unsigned int i;
    unsigned int j;
    unsigned int pageoffset = 0;
    
    if (!filename || strlen(filename) == 0)
	return;
    if (OutputList->count() < 1)
	return;
    ofstream st(filename);
    if (!st) {
	QMessageBox::critical(this,CStringRes::get_string(112),CStringRes::get_string(83));
	return;
    }
    unsigned int with = Current_Displayed_Fields.size();
    st << "\\documentclass[10pt,a4paper]{article}\n";
    with = 120/with;
    st << "\\usepackage[latin1]{inputenc}\n";
    st << "\\newcommand{\\tabcenter}[1]{\\multicolumn{1}{|c|}{#1}}\n";
    st << "\\newcommand{\\tabright}[1]{\\multicolumn{1}{|r|}{#1}}\n";
    char Buffer[100];
    sprintf(Buffer,"%u",with);

    head = "\\begin{tabular}{|";
    for (i  = 0;i < Current_Displayed_Fields.size();++i ) {
	head+="p{";
	head+=Buffer;
	head+="mm}|";
    }
    st << "\n\\begin{document}\n";
    st << "{\\Large\n{\\bf Database:} ";
    st << converter->convert(SelectDB->currentText()) << "\n";
    st << "\n{\\bf Table:} ";
    st << converter->convert(TableSelect->currentText()) << "\n";
    st << "}\n\n\\bigskip\n";

    head+="}\\hline\n";
    head2 = head;
    head3 = "";
    for (desc = Current_Displayed_Fields.begin();desc!= Current_Displayed_Fields.end();++desc ) {
        if (desc != Current_Displayed_Fields.begin()) {
	    head3+=" & ";
	}
	string dummy = converter->convert(desc->get_name());
	if (!dummy.empty()) {
	    head3+="\\tabcenter{\\bf ";
	    head3+=dummy;
	    head3+="}";
	}
	else {
	    head3+=" ";
	}
    }
    head3 += "\\\\ \\hline\n";
    st << head << head3;
    PatternIterator break_iterator;
    j = 0;
    for (i = 0; i < OutputList->count();i++) {
	BreakList.resize(0);
	BreakIntoParts(&BreakList,0,i,true);
	for (break_iterator=BreakList.begin();break_iterator!=BreakList.end();++break_iterator) {
	    if (break_iterator != BreakList.begin())
		st << " & ";
	    QString dummy = converter->convert(break_iterator->get_pattern());
	    if (!dummy.isEmpty()) {
		st << dummy;
	    }
	    else {
		st << " ";
	    }
	}
	st << "\\\\ \\hline\n";
	if (j == (35+pageoffset*5)) {
	    st << "\\multicolumn{" << BreakList.size() << "}{|"
		"r|}{\\small\\sl continued on next page}\\\\ \\hline";
	    st << "\\end{tabular}\n%table to long for one side%\n\n" << head2;
	    st << "\\multicolumn{" << BreakList.size() << "}{|l|}"
		"{\\small\\sl continued from previous}\\\\ \\hline" << head3;
	    j = 0;
	    pageoffset = 1;
	}
	else 
	    j++;
    }
    st << "\\end{tabular}\n%ready with table\n\n";
    st << "\\vfill\n{\\small document created with "
	"\\textbf{KMySqlAdmin}}\n\\pagebreak\n";
    st << "\\end{document}\n";
    delete converter;
}

void CTableView::entrySelected(int)
{
    if (ModifyRow->isEnabled())
	modifyRow();
}

void CTableView::build_relevant_keys()
{
    pairIlist e_list;
    bool all_found;
    SelectFields.resize(0);
    unsigned int count;
    if (!Current_Displayed_Fields.size() || !CurrentKeys.size()) {
	return;
    }
    KeyList::iterator k_iterator = CurrentKeys.begin();
    while(k_iterator != CurrentKeys.end()) {
	if (!k_iterator->is_UniqueKey()) {
	    CurrentKeys.erase(k_iterator);
	} else {
	    ++k_iterator;
	}
    }
    if (!CurrentKeys.size()) {
	return;
    }
    for(k_iterator=CurrentKeys.begin();k_iterator!=CurrentKeys.end();++k_iterator) {
	all_found = true;
	e_list = k_iterator->get_ColList();
	for (count = 0;count < e_list.size();++count) {
	    all_found = FindTableItem(e_list[count].first.c_str(),false) != 0;
	    if (!all_found)
		break;
	}
	if (all_found) {
	    for (count = 0; count < e_list.size();++count) {
		if (! SelectFields.find(e_list[count].first)) {
		    SelectFields.push_back(e_list[count].first);
		}
	    }
	}
    }
}

void CTableView::_make_fetch_request(bool search_it) 
{
    stringlist erg;
    ColumnList_iterator Field;
    QString sort;
    QString db;
    QString table;
    QString format;
    unsigned int id;
    int i;

    e_PatternList pattern_list;
    PatternList*result = 0;

    CMultiTextInput edit(this);
    
    table = TableSelect->currentText();
    db = SelectDB->currentText();
    sort = SortListBox->currentText();
    Current_Displayed_Fields.resize(0);
    OutputList->clear();
    //    OutputList->resizeList(0);
    if (sort.find("No Columns") != -1)
	return;
    for (id = 0; id < ColumnDisplay->count();id++) {
	if (ColumnDisplay->isSelected(id)) {
	    erg.push_back(ColumnDisplay->text(id));
	    Field = FindTableItem(ColumnDisplay->text(id));
	    if (Field) {
		//		Current_Displayed_Fields.push_back(CColumnDescriptor(*Field));
		Current_Displayed_Fields.push_back(*Field);
	    }
	}
    }
    OutputList->clear();
    while (OutputList->count()) {
	OutputList->removeItem(0);
    }
    OutputList->repaint();
    if (Current_Displayed_Fields.size() == 0) {
	for (Field = Current_Table_Fields.begin();Field!=Current_Table_Fields.end();++Field) {
	    Current_Displayed_Fields.push_back(CColumnDescriptor(*Field));
	}  
    }
    build_relevant_keys();

    if (search_it) {
	//pattern_list = new PatternList;
	for (Field = Current_Table_Fields.begin();Field != Current_Table_Fields.end();++Field) {
	    e_PatternIterator p_iter;
	    pattern_list.push_back(e_patternpair(Field->get_name(),""));
	    p_iter = pattern_list.end();
	    --p_iter;
	    p_iter->setIsNumeric(Field->is_Numeric());
	    p_iter->setLargeText(Field->is_Blob());
	    stringIlist _temp_enums = Field->enum_list();
	    if (_temp_enums.size() > 0) {
		// we requires the empy one, too
		_temp_enums.insert(_temp_enums.begin(),"");
		p_iter->set_enumlist(_temp_enums);
	    }
	}
	edit.setCaption(CStringRes::get_string(78));
	edit.build_widgets(&pattern_list);
	if (edit.exec()) {
	    result = edit.get_entries(FALSE);
	} else {
	    return;
	}
    }

    i = 0;

    OutputList->setNumCols(Current_Displayed_Fields.size());

    for (Field = Current_Displayed_Fields.begin();Field!=Current_Displayed_Fields.end();++Field) {
	OutputList->setColumn(i,Field->get_name());
	i++;
    }
    stringlist SizePattern;
    KApplication::getKApplication()->processEvents(100);
    i = sql_server->fetch_rows(db,table,sort,&erg,
			       (unsigned)OffsetSlider->value(),
			       (unsigned)CountSlider->value(),result,&SizePattern);

    if (result) {
	delete result;
	result = 0;
    }
    KApplication::getKApplication()->processEvents(100);
    stringlist::iterator erg_iter = erg.begin();
    if (erg.size() > 9) {
	OutputList->setAutoUpdate(false);
    }
    QFont font( "Courier", 12, 50, 0 );
    font.setStyleHint( (QFont::StyleHint)0 );
    font.setCharSet( (QFont::CharSet)0 );
    OutputList->setTableFont( font );
    int updatecounter = 0;
    for (;erg_iter != erg.end();++erg_iter) {
	OutputList->appendItem(erg_iter->c_str());
	++updatecounter;
	if (updatecounter == 500) {
	    KApplication::getKApplication()->processEvents(10);
	    updatecounter = 0;
	}
    }
    if (erg.size() > 9) {
	OutputList->setAutoUpdate(true);
	OutputList->repaint();
    }
    unsigned int counter=0;
    unsigned int col_counter = OutputList->numCols();
    const char*__pat = 0;
    for (counter = 0; counter < col_counter; counter++){
	if (SizePattern.size() > counter && (__pat = SizePattern[counter].c_str()) ) {
	    int res = atoi(__pat);
	    res = res < 1?10:res;
	    res *= 8;
	    res = res < 50?50:res;
	    OutputList->setColumnWidth(counter, res);
	}
    }
    OutputList->repaint();

    //hope you'll never see it
    if (i < 0) {
	display_error_box();
    }
    if (OutputList->count() > 0)
	OutputList->setCurrentItem(0);
    else
	OutputSelected(-1);
    OutputList->setFocus();
}
