#include <qstring.h>
#include <qlist.h>
#include <kmsgbox.h>
#include <kapp.h>
#include <qmessagebox.h>

#include "createtable.h"
#include "tabledescr.h"
#include "globals.h"
#include "compoundkeydlg.h"
#include "stringres.h"
#include "my_sql.h"

#ifndef rcsid
static const char rcsid[]="$Id: createtable.cpp,v 2.17 1999/11/07 16:12:50 ral Exp $";
//const char*createtable_rcs(){return rcsid;}
#endif

#define Inherited CModifyTable

CCreateTable::CCreateTable(CMySql*_sql_server, QWidget* parent, const char* name )
    :Inherited( _sql_server,parent, name )
{
    QString Caption = CStringRes::get_string(125);
    Caption+= " - ";
    Caption+=CStringRes::get_string(126);
    setCaption(Caption);
    TableNameEdit = new QLineEdit(this);
    TableNameEdit->setGeometry( 280, 5, 210, 25 );
    TableNameEdit->setMinimumSize( 0, 0 );
    TableNameEdit->setMaximumSize( 32767, 32767 );
    TableNameEdit->setText( "" );
    TableNameEdit->setMaxLength( 32767 );
    TableNameEdit->setFrame( TRUE );
    TableNameEdit->setFocus();
    connect(TableNameEdit,SIGNAL(textChanged(const char*)),SLOT(TableTextChanged(const char*)));
    connect( CreateTableButton, SIGNAL(clicked()), SLOT(CreateTable()) );
    TopMostLayout->addWidget(TableNameEdit);
}


CCreateTable::~CCreateTable()
{

}

void CCreateTable::TableTextChanged(const char*text)
{
    bool how =  (text &&
		 strlen(text) &&
		 (CurrentTables.find(text) == 0) );
    if (sql_server->is_system_db(DBList->currentText())) {
	how = false;
    }
    ColumnNameEdit->setEnabled(how);
    AddButton->setEnabled( how && strlen(ColumnNameEdit->text()) );
}

void CCreateTable::TableTextActivate()
{
}

void CCreateTable::SetDBString(const char*text)
{
    CurrentTables.resize(0);
    if (!sql_server->get_table_list("%",DBList->currentText(),CurrentTables)) {
	return;
    }
    TableTextChanged(TableNameEdit->text());
}

void CCreateTable::AddColumn()
{
    CKeyDescriptor Key;
    QString text;

    CColumnDescriptor Desc;
    Desc.set_name(ColumnNameEdit->text());
    if (desc_list.find(Desc)!=0) {
	QMessageBox::critical(this,CStringRes::get_string(6),
			      CStringRes::get_string(7));
	return;
    }
    if (Primary_Key->isEnabled() && Primary_Key->isChecked()) {
	Key.set_name("PRIMARY");
	if (key_list.find(Key)) {
	    QMessageBox::critical(this,CStringRes::get_string(6),
				  CStringRes::get_string(8));
	    return;
	}
    }
    if (!ReadDescriptor(&Desc,&text,&Key))
	return;

    ColumnsList->clearSelection();
    ColumnsList->insertItem(text,-1);
    DeleteButton->setEnabled(FALSE);
    ModifyButton->setEnabled(FALSE);
    desc_list.push_back(Desc);
    CreateTableButton->setEnabled(TRUE);
    if (desc_list.size() > 1) {
	CompoundKeyButton->setEnabled(TRUE);
    }
    if (!Key_None->isChecked()) {
	key_list.push_back(Key);
    }
}

void CCreateTable::Delete_Column()
{
    int Index = ColumnsList->currentItem();
    int counter = 0;
    if (Index == -1) {
	debug("index -1");
	return;
    }
    CColumnDescriptor desc;
    desc = desc_list[Index];
    RemoveFromKey(desc.get_name());
    ColumnsList->removeItem(Index);
    counter = 0;
    for (ColumnList_iterator col_iter = desc_list.begin();col_iter != desc_list.end();++col_iter) {
	if (counter == Index) {
	    desc_list.erase(col_iter);
	    break;
	}
	++counter;
    }
    if (desc_list.size() < 2) {
	CompoundKeyButton->setEnabled(FALSE);
    }
    if (ColumnsList->count() == 0) {
	CreateTableButton->setEnabled(FALSE);
    }
    if (ColumnsList->currentItem() == -1 || ColumnsList->count() == 0) {
	DeleteButton->setEnabled(FALSE);
	ModifyButton->setEnabled(FALSE);
    }
}

void CCreateTable::CreateTable()
{
    if (sql_server->create_table(DBList->currentText(),TableNameEdit->text(),&desc_list,&key_list) == false) {
	QMessageBox::critical(this,CStringRes::get_string(121),
			      CStringRes::get_string(10));
	return;
    }
    close();
}
