//-*-Mode: C++;-*-
/***************************************************************************
                          altertable.h  -  description                              
                             -------------------                                         
    begin                : Mon Aug 9 1999                                           
    copyright            : (C) 1999 by Rajko Albrecht                         
    email                : Rajko.Albrecht@informatik.tu-chemnitz.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// $Id: altertable.h,v 2.9 1999/11/07 15:42:05 ral Exp $


#ifndef ALTERTABLE_H
#define ALTERTABLE_H

#include <qwidget.h>
#include "modifytable.h"
#include "change_type.h"

class CMySql;

/**Class which will generate an 
   "Alter Table" statement.
   *@author Rajko Albrecht
   */

class CAlterTable : public CModifyTable  {
    Q_OBJECT
public: 
    CAlterTable(CMySql*_sql_server,QWidget *parent=0, const char *name=0);
    ~CAlterTable();

protected:
    QComboBox* TableNameEdit;
    KeyList CurrentKeys;
    ColumnList CurrentColumns;
    change_list DescrChanges;
    change_list KeyChanges;
    
    virtual void build_strings();

protected slots:
    virtual void SetDBString(const char*);
    virtual void SetTableString(int);
    virtual void NameChanged(const char*);
    virtual void TableTextChanged(const char*);
    virtual void Modify_Column();
    virtual void AddColumn();
    virtual void Delete_Column();
    virtual void AlterTable();

private:
#ifndef NO_DEBUG
    void debug_change();
#endif
};

#endif
