// -*-Mode: C++;-*-
/**
 * This class is designed to create an dialog with variables
 * counts of text-input fields.
 *
 * @short Textinputdialog
 * @see QWidget
 * @see QDialog
 */
#ifndef CMultiTextInput_included
#define CMultiTextInput_included

#include <qstrlist.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qlayout.h>

#include "PatternPair.h"
#include "e_patternpair.h"
#include "MultiTextInputData.h"

class CMultiTextInput : public CMultiTextInputData
{
    Q_OBJECT
public:
    CMultiTextInput(QWidget* parent = NULL,const char* name = NULL);
    virtual ~CMultiTextInput();
    void build_widgets(e_PatternList*which);
    PatternList*get_entries(bool emptys_too=FALSE);

private:
    QList<QWidget>*EditList;
    QBoxLayout * EditLayout;
    int min_x;
    int min_y;

private slots:
    void change_focus();

protected slots:
    void keyPressEvent(QKeyEvent*e);
    virtual void resizeEvent ( QResizeEvent * );

};
#endif // CMultiTextInput_included
