/****************************************************************
Copyright (C) Lucent Technologies 1997
All Rights Reserved

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that the copyright notice and this
permission notice and warranty disclaimer appear in supporting
documentation, and that the name Lucent Technologies or any of
its entities not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.

LUCENT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
IN NO EVENT SHALL LUCENT OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.
****************************************************************/

#ifndef PROTO_H_
#define PROTO_H_	20081006

extern	int	yywrap(void);
extern	void	setfname(awk_t *, awkcell_t *);
extern	int	constnode(awknode_t *);
extern	char	*strnode(awknode_t *);
extern	awknode_t	*notnull(awk_t *, awknode_t *);

extern	void	startreg(awk_t *);
extern	int	input(awk_t *);
extern	void	unput(awk_t *, int);
extern	void	unputstr(awk_t *, const char *);
extern	int	yylook(void);
extern	int	yyback(int *, int);
extern	int	yyinput(void);

fa_t	*awklib_makedfa(awk_t *, const char *, int);
int	awklib_match(awk_t *, fa_t *, const char *);
int	awklib_pmatch(awk_t *, fa_t *, const char *);
int	awklib_nematch(awk_t *, fa_t *, const char *);

extern	awknode_t	*awklib_exptostat(awknode_t *);
awknode_t	*awklib_stat3(awk_t *, int, awknode_t *, awknode_t *, awknode_t *);
awknode_t	*awklib_op2(awk_t *, int, awknode_t *, awknode_t *);
awknode_t	*awklib_op1(awk_t *, int, awknode_t *);
awknode_t	*stat1(awk_t *, int, awknode_t *);
awknode_t	*awklib_op3(awk_t *, int, awknode_t *, awknode_t *, awknode_t *);
awknode_t	*awklib_op4(awk_t *, int, awknode_t *, awknode_t *, awknode_t *, awknode_t *);
awknode_t	*awklib_op5(awk_t *, int, awknode_t *, awknode_t *, awknode_t *, awknode_t *, awknode_t *);
awknode_t	*awklib_stat2(awk_t *, int, awknode_t *, awknode_t *);
awknode_t	*awklib_stat4(awk_t *, int, awknode_t *, awknode_t *, awknode_t *, awknode_t *);
awknode_t	*awklib_celltonode(awk_t *, awkcell_t *, int);
awknode_t	*awklib_rectonode(awk_t *);
awknode_t	*awklib_makearr(awk_t *, awknode_t *);
awknode_t	*awklib_pa2stat(awk_t *, awknode_t *, awknode_t *, awknode_t *);
awknode_t	*awklib_linkum(awk_t *, awknode_t *, awknode_t *);
void	awklib_defn(awk_t *, awkcell_t *, awknode_t *, awknode_t *);
int	awklib_isarg(awk_t *, const char *);
extern	const char	*awklib_tokname(int);
extern awkcell_t	*(*awklib_proctab[])(awk_t *, awknode_t **, int);
extern	int	awklib_ptoi(void *);
extern	awknode_t	*awklib_itonp(int);

awkarray_t	*awklib_makesymtab(awk_t *, int);
void	awklib_freesymtab(awk_t *, awkcell_t *);
extern	void	awklib_freeelem(awkcell_t *, const char *);
awkcell_t	*setawkvar(awk_t *, const char *, const char *, double, unsigned int, awkarray_t *);
extern	int	awklib_hash(const char *, int);
extern	awkcell_t	*awklib_lookup(const char *, awkarray_t *);
extern	double	awklib_setfval(awk_t *, awkcell_t *, double);
extern	void	awklib_funnyvar(awk_t *, awkcell_t *, const char *);
extern	char	*awklib_setsval(awk_t *, awkcell_t *, const char *);
extern	double	awklib_getfval(awk_t *, awkcell_t *);
extern	char	*awklib_getsval(awk_t *, awkcell_t *);
extern	char	*awklib_getpssval(awk_t *, awkcell_t *);     /* for print */
char	*awklib_tostring(awk_t *, const char *);
char	*awklib_tostringN(awk_t *, const char *, size_t);
char	*awklib_qstring(awk_t *, const char *, int);

extern	int	awklib_getrec(awk_t *, uint8_t **, int *, int);
extern	void	awklib_nextfile(awk_t *);
extern	int	awklib_readrec(awk_t *, uint8_t **, int *, FILE *);
extern	void	awklib_setclvar(awk_t *, char *);
extern	void	awklib_fldbld(awk_t *);
extern	void	awklib_newfld(awk_t *, int);
extern	void	awklib_recbld(awk_t *);
extern	awkcell_t	*awklib_fieldadr(awk_t *, int);
extern	void	awklib_fpecatch(int);
extern	void	SYNTAX(awk_t *, const char *, ...);
extern	void	FATAL(awk_t *, const char *, ...);
extern	void	WARNING(awk_t *, const char *, ...);
extern	double	errcheck(awk_t *, double, const char *);
extern	int	awklib_isclvar(const char *);
extern	int	awklib_is_number(const char *);

int	awklib_adjbuf(awk_t *, uint8_t **pb, int *sz, int min, int q, uint8_t **pbp, const char *what);
awkcell_t	*awklib_execute(awk_t *, awknode_t *);
awkcell_t	*awklib_program(awk_t *, awknode_t **, int);
awkcell_t	*awklib_call(awk_t *, awknode_t **, int);
awkcell_t	*awklib_copycell(awk_t *, awkcell_t *);
awkcell_t	*awklib_arg(awk_t *, awknode_t **, int);
awkcell_t	*awklib_jump(awk_t *, awknode_t **, int);
awkcell_t	*awklib_getline(awk_t *, awknode_t **, int);
awkcell_t	*awklib_getnf(awk_t *, awknode_t **, int);
awkcell_t	*awklib_array(awk_t *, awknode_t **, int);
awkcell_t	*awklib_delete(awk_t *, awknode_t **, int);
awkcell_t	*awklib_intest(awk_t *, awknode_t **, int);
awkcell_t	*awklib_matchop(awk_t *, awknode_t **, int);
awkcell_t	*awklib_boolop(awk_t *, awknode_t **, int);
awkcell_t	*awklib_relop(awk_t *, awknode_t **, int);
awkcell_t	*awklib_gettemp(awk_t *);
awkcell_t	*awklib_indirect(awk_t *, awknode_t **, int);
awkcell_t	*awklib_substr(awk_t *, awknode_t **, int);
awkcell_t	*awklib_index(awk_t *, awknode_t **, int);
awkcell_t	*awklib_sprintf(awk_t *, awknode_t **, int);
awkcell_t	*awklib_printf(awk_t *, awknode_t **, int);
awkcell_t	*awklib_arith(awk_t *, awknode_t **, int);
double	awklib_ipow(double, int);
awkcell_t	*awklib_incrdecr(awk_t *, awknode_t **, int);
awkcell_t	*awklib_assign(awk_t *, awknode_t **, int);
awkcell_t	*awklib_cat(awk_t *, awknode_t **, int);
awkcell_t	*awklib_pastat(awk_t *, awknode_t **, int);
awkcell_t	*awklib_dopa2(awk_t *, awknode_t **, int);
awkcell_t	*awklib_split(awk_t *, awknode_t **, int);
awkcell_t	*awklib_condexpr(awk_t *, awknode_t **, int);
awkcell_t	*awklib_ifstat(awk_t *, awknode_t **, int);
awkcell_t	*awklib_whilestat(awk_t *, awknode_t **, int);
awkcell_t	*awklib_dostat(awk_t *, awknode_t **, int);
awkcell_t	*awklib_forstat(awk_t *, awknode_t **, int);
awkcell_t	*awklib_instat(awk_t *, awknode_t **, int);
awkcell_t	*awklib_bltin(awk_t *, awknode_t **, int);
awkcell_t	*awklib_print(awk_t *, awknode_t **, int);
awkcell_t	*awklib_nullproc(awk_t *, awknode_t **, int);
FILE	*awklib_redirect(awk_t *, int, awknode_t *);
awkcell_t	*awklib_closefile(awk_t *, awknode_t **, int);
awkcell_t	*awklib_sub(awk_t *, awknode_t **, int);
awkcell_t	*awklib_gsub(awk_t *, awknode_t **, int);
awkcell_t	*awklib_gensub(awk_t *, awknode_t **, int);

awkcell_t	*awklib_dlopen(awk_t *, awknode_t **, int);
awkcell_t	*awklib_dlcall(awk_t *, awknode_t **, int);
awkcell_t	*awklib_dlclose(awk_t *, awknode_t **, int);
awkcell_t	*awklib_dlproto(awk_t *, awknode_t **, int);
awkcell_t	*awklib_dlalloc(awk_t *, awknode_t **, int);
awkcell_t	*awklib_dlfree(awk_t *, awknode_t **, int);
awkcell_t	*awklib_dlfield(awk_t *, awknode_t **, int);
awkcell_t	*awklib_shift(awk_t *, awknode_t **, int);

#define	XFREE(a)	do {						\
	if ((a) != NULL) {						\
		free((void *) (a));					\
		(a) = NULL;						\
	}								\
} while (/* CONSTCOND */ 0)

#define	NN(p)	((p) ? (p) : "(null)")	/* guaranteed non-null for DPRINTF */

#define	DEBUG

#ifdef	DEBUG
/* uses have to be doubly parenthesized */
#	define	DPRINTF(awkp, x)	if ((awkp)->dbg) printf x
#else
#	define	DPRINTF(x)
#endif


#endif
