/****************************************************************
Copyright (C) Lucent Technologies 1997
All Rights Reserved

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that the copyright notice and this
permission notice and warranty disclaimer appear in supporting
documentation, and that the name Lucent Technologies or any of
its entities not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.

LUCENT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
IN NO EVENT SHALL LUCENT OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.
****************************************************************/

#define DEBUG
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "awklib.h"
#include "awkgram.h"
#include "proto.h"


static awknode_t *
nodealloc(awk_t *awkp, int n)
{
	awknode_t *x;

	x = (awknode_t *) malloc(sizeof(awknode_t) + (n-1)*sizeof(awknode_t *));
	if (x == NULL)
		FATAL(awkp, "out of space in nodealloc");
	x->nnext = NULL;
	x->lineno = awkp->lineno;
	return(x);
}

awknode_t *
awklib_exptostat(awknode_t *a)
{
	a->ntype = NSTAT;
	return(a);
}

static awknode_t *
node1(awk_t *awkp, int a, awknode_t *b)
{
	awknode_t *x;

	x = nodealloc(awkp, 1);
	x->nobj = a;
	x->narg[0]=b;
	return(x);
}

static awknode_t *
node2(awk_t *awkp, int a, awknode_t *b, awknode_t *c)
{
	awknode_t *x;

	x = nodealloc(awkp, 2);
	x->nobj = a;
	x->narg[0] = b;
	x->narg[1] = c;
	return(x);
}

static awknode_t *
node3(awk_t *awkp, int a, awknode_t *b, awknode_t *c, awknode_t *d)
{
	awknode_t *x;

	x = nodealloc(awkp, 3);
	x->nobj = a;
	x->narg[0] = b;
	x->narg[1] = c;
	x->narg[2] = d;
	return(x);
}

static awknode_t *
node4(awk_t *awkp, int a, awknode_t *b, awknode_t *c, awknode_t *d, awknode_t *e)
{
	awknode_t *x;

	x = nodealloc(awkp, 4);
	x->nobj = a;
	x->narg[0] = b;
	x->narg[1] = c;
	x->narg[2] = d;
	x->narg[3] = e;
	return(x);
}

static awknode_t *
node5(awk_t *awkp, int a, awknode_t *b, awknode_t *c, awknode_t *d, awknode_t *e, awknode_t *f)
{
	awknode_t *x;

	x = nodealloc(awkp, 5);
	x->nobj = a;
	x->narg[0] = b;
	x->narg[1] = c;
	x->narg[2] = d;
	x->narg[3] = e;
	x->narg[4] = f;
	return(x);
}

awknode_t *
stat1(awk_t *awkp, int a, awknode_t *b)
{
	awknode_t *x;

	x = node1(awkp, a,b);
	x->ntype = NSTAT;
	return(x);
}

awknode_t *
awklib_stat2(awk_t *awkp, int a, awknode_t *b, awknode_t *c)
{
	awknode_t *x;

	x = node2(awkp, a,b,c);
	x->ntype = NSTAT;
	return(x);
}

awknode_t *
awklib_stat3(awk_t *awkp, int a, awknode_t *b, awknode_t *c, awknode_t *d)
{
	awknode_t *x;

	x = node3(awkp, a,b,c,d);
	x->ntype = NSTAT;
	return(x);
}

awknode_t *
awklib_stat4(awk_t *awkp, int a, awknode_t *b, awknode_t *c, awknode_t *d, awknode_t *e)
{
	awknode_t *x;

	x = node4(awkp, a,b,c,d,e);
	x->ntype = NSTAT;
	return(x);
}

awknode_t *
awklib_op1(awk_t *awkp, int a, awknode_t *b)
{
	awknode_t *x;

	x = node1(awkp, a,b);
	x->ntype = NEXPR;
	return(x);
}

awknode_t *
awklib_op2(awk_t *awkp, int a, awknode_t *b, awknode_t *c)
{
	awknode_t *x;

	x = node2(awkp, a,b,c);
	x->ntype = NEXPR;
	return(x);
}

awknode_t *
awklib_op3(awk_t *awkp, int a, awknode_t *b, awknode_t *c, awknode_t *d)
{
	awknode_t *x;

	x = node3(awkp, a,b,c,d);
	x->ntype = NEXPR;
	return(x);
}

awknode_t *
awklib_op4(awk_t *awkp, int a, awknode_t *b, awknode_t *c, awknode_t *d, awknode_t *e)
{
	awknode_t *x;

	x = node4(awkp, a,b,c,d,e);
	x->ntype = NEXPR;
	return(x);
}

awknode_t *
awklib_op5(awk_t *awkp, int a, awknode_t *b, awknode_t *c, awknode_t *d, awknode_t *e, awknode_t *f)
{
	awknode_t *x;

	x = node5(awkp, a,b,c,d,e, f);
	x->ntype = NEXPR;
	return(x);
}

awknode_t *
awklib_celltonode(awk_t *awkp, awkcell_t *a, int b)
{
	awknode_t *x;

	a->ctype = OCELL;
	a->csub = b;
	x = node1(awkp, 0, (awknode_t *) a);
	x->ntype = NVALUE;
	return(x);
}

/* make $0 into a awknode_t */
awknode_t *
awklib_rectonode(awk_t *awkp)
{
	return awklib_op1(awkp, INDIRECT, awklib_celltonode(awkp, awkp->literal0, CUNK));
}

awknode_t *
awklib_makearr(awk_t *awkp, awknode_t *p)
{
	awkcell_t *cp;

	if (ISVALUE(p)) {
		cp = (awkcell_t *) (p->narg[0]);
		if (ISFCN(cp))
			SYNTAX(awkp,  "%s is a function, not an array", cp->nval );
		else if (!ISARR(cp)) {
			XFREE(cp->sval);
			cp->sval = (char *) awklib_makesymtab(awkp, NSYMTAB);
			cp->tval = ARR;
		}
	}
	return p;
}

/* pat, pat {...} */
awknode_t *
awklib_pa2stat(awk_t *awkp, awknode_t *a, awknode_t *b, awknode_t *c)
{
	awknode_t *x;

	x = node4(awkp, PASTAT2, a, b, c, awklib_itonp(awkp->paircnt));
	if (awkp->paircnt++ >= PA2NUM)
		SYNTAX(awkp,  "limited to %d pat,pat statements", PA2NUM );
	x->ntype = NSTAT;
	return(x);
}

awknode_t *
awklib_linkum(awk_t *awkp, awknode_t *a, awknode_t *b)
{
	awknode_t *c;

	if (awkp->errorflag)	/* don't link things that are wrong */
		return a;
	if (a == NULL)
		return(b);
	else if (b == NULL)
		return(a);
	for (c = a; c->nnext != NULL; c = c->nnext)
		;
	c->nnext = b;
	return(a);
}

/* turn on FCN bit in definition, */
/*  body of function, arglist */
void
awklib_defn(awk_t *awkp, awkcell_t *v, awknode_t *vl, awknode_t *st)
{
	awknode_t *p;
	int n;

	if (ISARR(v)) {
		SYNTAX(awkp,  "`%s' is an array name and a function name", v->nval );
		return;
	}
	if (awklib_isarg(awkp, v->nval) != -1) {
		SYNTAX(awkp,  "`%s' is both function name and argument name", v->nval );
		return;
	}

	v->tval = FCN;
	v->sval = (char *) st;
	n = 0;	/* count arguments */
	for (p = vl; p; p = p->nnext)
		n++;
	v->fval = n;
	DPRINTF(awkp, ("defining func %s (%d args)\n", v->nval, n) );
}

/* is s in argument list for current function? */
int
awklib_isarg(awk_t *awkp, const char *s)
{
	/* return -1 if not, otherwise arg # */
	awknode_t *p = awkp->arglist;
	int n;

	for (n = 0; p != 0; p = p->nnext, n++)
		if (strcmp(((awkcell_t *)(p->narg[0]))->nval, s) == 0)
			return n;
	return -1;
}

int
awklib_ptoi(void *p)	/* convert pointer to integer */
{
	return (int) (long) p;	/* swearing that p fits, of course */
}

awknode_t *
awklib_itonp(int i)	/* and vice versa */
{
	return (awknode_t *) (long) i;
}
