/*
    KDE Icon Editor - a small graphics drawing program for the KDE
    Copyright (C) 1998  Thomas Tanghus (tanghus@kde.org)

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <kconfig.h>
#include <kdebug.h>

#include "properties.h"

KIconEditProperties* KIconEditProperties::m_self = 0;

KIconEditProperties* KIconEditProperties::self()
{
    if (!m_self)
        m_self = new KIconEditProperties();
    return m_self;
}

KIconEditProperties::KIconEditProperties() : QObject()
{
    kdDebug() << "KIconEditProperties: reading properties" << endl;

    pprops = new Properties;

    pprops->keys = new KAccel(0);
    KConfig *config = kapp->config();

    config->setGroup( "Appearance" );

    // restore geometry settings
    QString geom = config->readEntry( "Geometry", "620x450" );

    // #### Rewrite to use readSizeEntry
    if ( !geom.isEmpty() )
        sscanf( geom.ascii(), "%dx%d", &pprops->winwidth, &pprops->winheight );

    pprops->maintoolbartext = config->readNumEntry( "MainToolBarText", 0 );
    pprops->drawtoolbartext = config->readNumEntry( "DrawToolBarText", 0 );

    pprops->maintoolbarstat = config->readBoolEntry( "ShowMainToolBar", true );
    pprops->drawtoolbarstat = config->readBoolEntry( "ShowDrawToolBar", true );
    pprops->statusbarstat = config->readBoolEntry( "ShowStatusBar", true );

    pprops->maintoolbarpos = (KToolBar::BarPosition)config->readNumEntry( "MainToolBarPos", KToolBar::Top);
    pprops->drawtoolbarpos = (KToolBar::BarPosition)config->readNumEntry( "DrawToolBarPos", KToolBar::Left);
    //statusbarpos = config->readNumEntry( "StatusBarPos", KStatusBar::Bottom);

    pprops->backgroundmode = (QWidget::BackgroundMode)config->readNumEntry( "BackgroundMode", QWidget::FixedPixmap);
    kdDebug() << "Reading bgmode: " << (int)pprops->backgroundmode << endl;
    pprops->backgroundcolor = config->readColorEntry( "BackgroundColor", &gray);
    pprops->backgroundpixmap = config->readEntry("BackgroundPixmap", "");
    kdDebug() << "BackgroundPixmap: " << pprops->backgroundpixmap << endl;

    config->setGroup( "Grid" );
    pprops->pastetransparent = config->readBoolEntry( "PasteTransparent", false );
    pprops->showgrid = config->readBoolEntry( "ShowGrid", true );
    pprops->gridscaling = config->readNumEntry( "GridScaling", 10 );
    pprops->showrulers = config->readBoolEntry( "ShowRulers", true );
}

KIconEditProperties::~KIconEditProperties()
{
  kdDebug() << "KIconEditProperties: Deleting properties" << endl;
  delete pprops->keys;
  delete pprops;
  m_self = 0;
}

struct Properties *KIconEditProperties::properties()
{
    return pprops;
}

void KIconEditProperties::saveProperties()
{
    KConfig *config = kapp->config();

    pprops->keys->writeSettings(config);

    config->setGroup( "Appearance" );
    QString geom;
    geom.sprintf( "%dx%d", pprops->winwidth, pprops->winheight );
    config->writeEntry( "Geometry", geom );

    kdDebug() << "Writing bgmode: " << (int)pprops->backgroundmode << endl;
    config->writeEntry("BackgroundMode", (int)pprops->backgroundmode);
    config->writeEntry("BackgroundColor", pprops->backgroundcolor);
    config->writeEntry("BackgroundPixmap", pprops->backgroundpixmap);

    config->writeEntry("MainToolBarText", pprops->maintoolbartext);
    config->writeEntry("DrawToolBarText", pprops->drawtoolbartext);

    config->setGroup( "Grid" );
    config->writeEntry("PasteTransparent", pprops->pastetransparent);
    config->writeEntry("ShowGrid", pprops->showgrid);
    config->writeEntry("GridScaling", pprops->gridscaling);
    config->writeEntry("ShowRulers", pprops->showrulers);
    kapp->config()->sync();
}

