/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-obj.h Dvd object header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_OBJ_H__
#define __DVD_OBJ_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_TYPE		(dvd_get_type())
#define DVD(o)			(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_TYPE, Dvd))
#define DVD_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST    (k, DVD_TYPE, DvdClass))
#define DVD_IS_DVD(o)		(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_TYPE))
#define DVD_IS_DVD_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_TYPE))

/* --- typedefs & structures --- */
/** Object representing a DVD video */
typedef struct	_Dvd		Dvd;
/** Object class representing a DVD video */
typedef struct	_DvdClass	DvdClass;

/* DvdRegion is the 36th byte of VIDEO_TS.IFO and */
/* "0" bits are on ("1" bit means not set) in the file */
/* for example VIDEO_TS.IFO[35] = ~region */
typedef enum _DvdRegion {
	DVD_REGION_NOT_SET	= 0,
	DVD_REGION_1		= (1 << 0),
	DVD_REGION_2		= (1 << 1),
	DVD_REGION_3		= (1 << 2),
	DVD_REGION_4		= (1 << 3),
	DVD_REGION_5		= (1 << 4),
	DVD_REGION_6		= (1 << 5),
	DVD_REGION_RESERVED	= (1 << 6),
	DVD_REGION_INERNATIONAL	= (1 << 7),
	DVD_REGION_ALL		= DVD_REGION_1 | DVD_REGION_2 |
				  DVD_REGION_3 | DVD_REGION_4 |
				  DVD_REGION_5 | DVD_REGION_6 |
				  DVD_REGION_RESERVED | DVD_REGION_INERNATIONAL
} DvdRegion;

struct _Dvd {
	GObject	 parent;
	
	DvdSource   source;
	DvdRegion   region;
	gchar	   *name;
	gchar	   *volume_set;
	gchar	   *provider_id;
	guint8	    title_count;
	GSList     *titles;
};

struct _DvdClass {
	GObjectClass	parent;
};

/* --- prototypes --- */
GType		dvd_get_type		 (void);
DvdSource	dvd_get_source		 (Dvd		*dvd);
void		dvd_set_region		 (Dvd	        *dvd,
					  DvdRegion	 region);
DvdRegion	dvd_get_region		 (Dvd	        *dvd);
void		dvd_set_name		 (Dvd	        *dvd,
					  const gchar	*name);
G_CONST_RETURN
gchar*		dvd_get_name		 (Dvd	        *dvd);
void		dvd_set_volume_set	 (Dvd	        *dvd,
					  const gchar	*volume_set);
G_CONST_RETURN
gchar*		dvd_get_volume_set	 (Dvd	        *dvd);
void		dvd_set_provider	 (Dvd	        *dvd,
					  const gchar	*provider);
G_CONST_RETURN
gchar*		dvd_get_provider	 (Dvd	        *dvd);
void		dvd_append_title	 (Dvd	        *dvd,
					  DvdTitle	*title);
void		dvd_delete_all		 (Dvd	        *dvd);
guint8		dvd_get_title_count	 (Dvd	        *dvd);
DvdTitle*	dvd_get_title		 (Dvd	        *dvd,
					  guint8         title_id);
guint8		dvd_get_feature_title_id (Dvd	        *dvd);

G_END_DECLS

#endif /*__DVD_OBJ_H__*/
