/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-language.h DvdLanguage header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_LANGUAGE_H__
#define __DVD_LANGUAGE_H__


G_BEGIN_DECLS


/** Dvd audio Languages */
typedef enum _DvdLanguage {
	DVD_LANG_UNDEFINED = 0,
	DVD_LANG_AFAR,
	DVD_LANG_ABKHAZIAN,
	DVD_LANG_AFRIKAANS,
	DVD_LANG_AMHARIC,
	DVD_LANG_ARABIC,
	DVD_LANG_ASSAMESE,
	DVD_LANG_AYMARA,
	DVD_LANG_AZERBAIJANI,
	DVD_LANG_BASHKIR,
	DVD_LANG_BYELORUSSIAN,
	DVD_LANG_BULGARIAN,
	DVD_LANG_BIHARI,
	DVD_LANG_BISLAMA,
	DVD_LANG_BENGALI_BANGLA,
	DVD_LANG_TIBETAN,
	DVD_LANG_BRETON,
	DVD_LANG_CATALAN,
	DVD_LANG_CORSICAN,
	DVD_LANG_CZECH,
	DVD_LANG_WELSH,
	DVD_LANG_DANSK,
	DVD_LANG_DEUTSCH,
	DVD_LANG_BHUTANI,
	DVD_LANG_GREEK,
	DVD_LANG_ENGLISH,
	DVD_LANG_ESPERANTO,
	DVD_LANG_ESPANOL,
	DVD_LANG_ESTONIAN,
	DVD_LANG_BASQUE,
	DVD_LANG_PERSIAN,
	DVD_LANG_SUOMI,
	DVD_LANG_FIJI,
	DVD_LANG_FAROESE,
	DVD_LANG_FRANCAIS,
	DVD_LANG_FRISIAN,
	DVD_LANG_GAELIC,
	DVD_LANG_SCOTS_GAELIC,
	DVD_LANG_GALICIAN,
	DVD_LANG_GUARANI,
	DVD_LANG_GUJARATI,
	DVD_LANG_HAUSA,
	DVD_LANG_HEBREW,
	DVD_LANG_HINDI,
	DVD_LANG_HRVATSKI,
	DVD_LANG_MAGYAR,
	DVD_LANG_ARMENIAN,
	DVD_LANG_INTERLINGUA,
	DVD_LANG_INDONESIAN,
	DVD_LANG_INTERLINGUE,
	DVD_LANG_INUPIAK,
	DVD_LANG_INDONESIAN_IN,
	DVD_LANG_ISLENSKA,
	DVD_LANG_ITALIANO,
	DVD_LANG_INUKTITUT,
	DVD_LANG_HEBREW_IW,
	DVD_LANG_JAPANESE,
	DVD_LANG_YIDDISH_JI,
	DVD_LANG_JAVANESE,
	DVD_LANG_GEORGIAN,
	DVD_LANG_KAZAKH,
	DVD_LANG_GREENLANDIC,
	DVD_LANG_CAMBODIAN,
	DVD_LANG_KANNADA,
	DVD_LANG_KOREAN,
	DVD_LANG_KASHMIRI,
	DVD_LANG_KURDISH,
	DVD_LANG_KIRGHIZ,
	DVD_LANG_LATIN,
	DVD_LANG_LINGALA,
	DVD_LANG_LAOTHIAN,
	DVD_LANG_LITHUANIAN,
	DVD_LANG_LATVIAN_OR_LETTISH,
	DVD_LANG_MALAGASY,
	DVD_LANG_MAORI,
	DVD_LANG_MACEDONIAN,
	DVD_LANG_MALAYALAM,
	DVD_LANG_MONGOLIAN,
	DVD_LANG_MOLDAVIAN,
	DVD_LANG_MARATHI,
	DVD_LANG_MALAY,
	DVD_LANG_MALTESE,
	DVD_LANG_BURMESE,
	DVD_LANG_NAURU,
	DVD_LANG_NEPALI,
	DVD_LANG_NEDERLANDS,
	DVD_LANG_NORSK,
	DVD_LANG_OCCITAN,
	DVD_LANG_OROMO,
	DVD_LANG_ORIYA,
	DVD_LANG_PUNJABI,
	DVD_LANG_POLISH,
	DVD_LANG_PASHTO_OR_PUSHTO,
	DVD_LANG_PORTUGUES,
	DVD_LANG_QUECHUA,
	DVD_LANG_RHAETO_ROMANCE,
	DVD_LANG_KIRUNDI,
	DVD_LANG_ROMANIAN,
	DVD_LANG_RUSSIAN,
	DVD_LANG_KINYARWANDA,
	DVD_LANG_SANSKRIT,
	DVD_LANG_SINDHI,
	DVD_LANG_SANGHO,
	DVD_LANG_SERBO_CROATIAN,
	DVD_LANG_SINHALESE,
	DVD_LANG_SLOVAK,
	DVD_LANG_SLOVENIAN,
	DVD_LANG_SAMOAN,
	DVD_LANG_SHONA,
	DVD_LANG_SOMALI,
	DVD_LANG_ALBANIAN,
	DVD_LANG_SERBIAN,
	DVD_LANG_SISWATI,
	DVD_LANG_SESOTHO,
	DVD_LANG_SUNDANESE,
	DVD_LANG_SVENSKA,
	DVD_LANG_SWAHILI,
	DVD_LANG_TAMIL,
	DVD_LANG_TELUGU,
	DVD_LANG_TAJIK,
	DVD_LANG_THAI,
	DVD_LANG_TIGRINYA,
	DVD_LANG_TURKMEN,
	DVD_LANG_TAGALOG,
	DVD_LANG_SETSWANA,
	DVD_LANG_TONGA,
	DVD_LANG_TURKISH,
	DVD_LANG_TSONGA,
	DVD_LANG_TATAR,
	DVD_LANG_TWI,
	DVD_LANG_UIGHUR,
	DVD_LANG_UKRAINIAN,
	DVD_LANG_URDU,
	DVD_LANG_UZBEK,
	DVD_LANG_VIETNAMESE,
	DVD_LANG_VOLAPUK,
	DVD_LANG_WOLOF,
	DVD_LANG_XHOSA,
	DVD_LANG_YIDDISH,
	DVD_LANG_YORUBA,
	DVD_LANG_ZHUANG,
	DVD_LANG_CHINESE,
	DVD_LANG_ZULU,
	DVD_LANG_UNKNOWN
} DvdLanguage;

DvdLanguage	dvd_language_get_from_code	(const guchar	*code);
DvdLanguage	dvd_language_get_from_code16	(guint16	 code16);
const gchar*	dvd_language_get_code		(DvdLanguage	 lang);
const gchar*	dvd_language_get_name		(DvdLanguage	 lang);

G_END_DECLS

#endif /*__DVD_LANGUAGE_H__*/
