
from xutilities import message

from os import getenv

pyqt_module_name = getenv("PYQT_MODULE")

if pyqt_module_name is not None:
    if pyqt_module_name not in ['qt', 'PyQt4']:
        msg  = "\n"
        msg += "The variable PYQT_MODULE must be in : qt, PyQt4\n"
        msg += "got %s instead"%(pyqt_module_name)
        raise ValueError(msg)
    pass
else:
    try:
        import PyQt4
        pyqt_module_name = "PyQt4"
    except ImportError:
        pyqt_module_name = "qt"
        pass
    pass

if pyqt_module_name == "qt":
    from qt import *
else:
    from PyQt4.QtGui import *
    from PyQt4.QtCore import *
    
    # ----------------------------------------------------------------------
    # redefinitions
    # ---------------------
    
    PYSIGNAL = SIGNAL
    
    # ----------------------------------------------------------------------
    # add-ons to Qt namespace
    # ---------------------
    
    Qt.WDestructiveClose = Qt.WA_DeleteOnClose
    Qt.waitCursor = Qt.WaitCursor
    
    # ----------------------------------------------------------------------
    # add-ons to QString namespace
    # ---------------------
    
    QString.null = QString()
    
    # ----------------------------------------------------------------------
    # add-ons to QApplication
    # ---------------------
    
    QApplication.exec_loop = QApplication.exec_
    QApplication.setMainWidget = lambda self, mx: None
    
    # ----------------------------------------------------------------------
    # add-ons to QMessageBox
    # -------------------------
    
    def __x_exec_loop(self):
        return self.exec_()
    QMessageBox.exec_loop = __x_exec_loop
    
    # ----------------------------------------------------------------------
    # add-ons to QObject
    # ----------------------
    
    def __x_emit(self, sig, *args):
        # print "******** __x_emit", sig, args
        if len(args) == 1:
            if isinstance(args[0], tuple):
                args = args[0]
                pass
            pass
        QObject.emit_orig(self, sig, *args)
        return
    QObject.emit_orig = QObject.emit
    QObject.emit = __x_emit
    
    # ----------------------------------------------------------------------
    # add-ons to QWidget
    # ---------------------
    
    def __x_setWFlags(self, flag):
        if flag == Qt.WDestructiveClose:
            return self.setAttribute(Qt.WA_DeleteOnClose)
        # return self.setWindowFlags(flag)
        raise "Unknown flag : %s"%(flag)
    QWidget.setWFlags = __x_setWFlags
    
    def __x_setTracking(self, val):
        return self.setMouseTracking(val)
    QWidget.setTracking = __x_setTracking
    
    def __x_setCaption(self, text):
        return self.setWindowTitle(text)
    QWidget.setCaption = __x_setCaption
    
    # ----------------------------------------------------------------------
    # add-ons to QScrollView = QScrollArea
    # ---------------------
    
    QScrollView = QScrollArea
    
    QScrollView.AlwaysOn = Qt.ScrollBarAlwaysOn
    
    # ----------------------------------------------------------------------
    # add-ons to QListView = QTreeWidget
    # ---------------------
    
    QListView = QTreeWidget
    
    QListView.Extended = QTreeWidget.ExtendedSelection
    QListView.Single = QTreeWidget.SingleSelection
    QListView.AllColumns = QHeaderView.Stretch
    
    def __x_setResizeMode(self, mode):
        self.header().setResizeMode(mode)
        return
    QListView.setResizeMode = __x_setResizeMode
    
    def __x_setSorting(self, *args, **kwargs):
        return self.sortByColumn(*args, **kwargs)
    QListView.setSorting = __x_setSorting
    
    def __x_setVScrollBarMode(self, policy):
        return self.setVerticalScrollBarPolicy(policy)
    QListView.setVScrollBarMode = __x_setVScrollBarMode
    
    def __x_addColumn(self, name):
        try:
            self.__x_columns__.append(name)
        except AttributeError:
            self.__x_columns__ = [name]
            pass
        result = self.setHeaderLabels(self.__x_columns__)
        return result
    QListView.addColumn = __x_addColumn
    
    def __x_mouseReleaseEvent(self, event):
        index = self.indexAt(event.pos())
        if (not index.isValid()):
            self.clearSelection()
            pass
        QListView.mouseReleaseEvent_orig(self, event)
        return
    QListView.mouseReleaseEvent_orig = QListView.mouseReleaseEvent
    QListView.mouseReleaseEvent = __x_mouseReleaseEvent
    
    def __x_setSelected(self, item, val):
        return item.setSelected(val)
    QListView.setSelected = __x_setSelected
    
    def __x_isSelected(self, item):
        return item.isSelected()
    QListView.isSelected = __x_isSelected
    
    def __x_takeItem(self, item):
        index = self.indexOfTopLevelItem(item)
        return self.takeTopLevelItem(index)
    QListView.takeItem = __x_takeItem
    
    # ----------------------------------------------------------------------
    # add-ons to QListViewItem
    # -------------------------
    
    QListViewItem = QTreeWidgetItem
    
    def __x_listView(self):
        return self.treeWidget()
    QListViewItem.listView = __x_listView
    
    def __x_setOpen(self, val):
        return self.setExpanded(val)
    QListViewItem.setOpen = __x_setOpen
    
    def __x_isOpen(self):
        return self.isExpanded()
    QListViewItem.isOpen = __x_isOpen
    
    def __x_firstChild(self):
        child = self.child(0)
        message(child)
        return child
    QListViewItem.firstChild = __x_firstChild
    
    def __x_nextSibling(self):
        message("self =", self)
        parent = QListViewItem.parent(self)
        message("parent =", parent)
        index = parent.indexOfChild(self)
        message("index of self :", index)
        child = parent.child(index+1)
        message(child)
        return child
    QListViewItem.nextSibling = __x_nextSibling
    
    def __x_setVisible(self, val):
        return self.setHidden(not val)
    QListViewItem.setVisible = __x_setVisible
    
    # ----------------------------------------------------------------------
    # add-ons to QHeaderView
    # -------------------------
    
    def __x_setMovingEnabled(self, val):
        result = self.setMovable(val)
        return result
    QHeaderView.setMovingEnabled = __x_setMovingEnabled
    
    # ----------------------------------------------------------------------
    # add-ons to QStatusBar
    # -------------------------
    
    def __x_message(self, *args, **kwargs):
        return self.showMessage(*args, **kwargs)
    QStatusBar.message = __x_message
    
    # ----------------------------------------------------------------------
    
    def toto1(*args):
        print "toto1", args
        return
    def toto2(*args):
        print "toto2", args
        return
    def toto3(*args):
        print "toto3", args
        return
    def toto4(*args):
        print "toto4", args
        return
    def toto66(*args):
        print "toto66", args
        return
    def toto77(*args):
        print "toto77", args
        return
    def toto88(*args):
        print "toto88", args
        return
    
    # ----------------------------------------------------------------------
    # add-ons to QPopupMenu == QMenu
    # -------------------------
    
    QPopupMenu = QMenu
    
    def __x_insertSeparator(self, pos_id=-1):
        message(pos_id)
        before = self.getBefore(pos_id)
        result = QPopupMenu.insertSeparator_orig(self, before)
        return result
    QPopupMenu.insertSeparator_orig = QPopupMenu.insertSeparator
    QPopupMenu.insertSeparator = __x_insertSeparator
    
    def __x_count(self):
        return len(self.actions())
    QPopupMenu.count = __x_count
    
    def __x_indexOf(self, item_id):
        message("item_id =", item_id)
        if item_id == -1:
            return -1
        d = self.__item_id__to__action__
        action = d[item_id]
        actions = self.actions()
        for i in range(len(actions)):
            a = actions[i]
            if a is action:
                return i
            pass
        return -1
    QPopupMenu.indexOf = __x_indexOf
    
    def __x_removeItem(self, item_id):
        # message("item_id =", item_id)
        pos_id = self.indexOf(item_id)
        if pos_id >= 0:
            action = self.actions()[pos_id]
            self.removeAction(action)
            d = self.__item_id__to__action__
            del d[item_id]
            pass
        return
    QPopupMenu.removeItem = __x_removeItem
    
    def __x_getBefore(self, pos_id):
        if pos_id == -1:
            before = None
        else:
            try:
                before = self.actions()[pos_id]
            except IndexError:
                before = None
                pass
            pass
        return before
    QPopupMenu.getBefore = __x_getBefore
    
    def __x_insertItem(self, text, *args):
        message(text, args)
        # --
        target = None
        accel = None
        item_id = -1
        pos_id = -1
        if len(args) == 0:
            pass
        elif len(args) == 1:
            target = args[0]
        elif len(args) == 2:
            item_id, pos_id = args
        elif len(args) == 3:
            target, item_id, pos_id = args
        elif len(args) == 4:
            target, accel, item_id, pos_id = args
            pass
        else:
            raise Exception("Strange !!!!!!!")
        # --
        before = self.getBefore(pos_id)
        # message(before)
        if isinstance(target, QMenu):
            menu = target
            qaction = self.insertMenu(before, menu)
            qaction.setText(text)
            qaction.__qfather__ = self
            # menu.connect(menu, SIGNAL('aboutToShow()'), toto66)
            # menu.connect(menu, SIGNAL('hovered(QAction*)'), toto77)
            # menu.connect(menu, SIGNAL('triggered(QAction*)'), toto88)
            # qaction.connect(qaction, SIGNAL("changed()"), toto1)
            # qaction.connect(qaction, SIGNAL("hovered()"), toto2)
            # qaction.connect(qaction, SIGNAL("toggled(bool)"), toto3)
            # qaction.connect(qaction, SIGNAL("triggered(bool)"), toto4)
            menu.connect(menu, SIGNAL('aboutToShow()'), qaction.aboutToShow)
        else:
            qaction = QAction(text, self)
            if accel: qaction.setShortcut(accel)
            self.insertAction(before, qaction)
            if target:
                qaction.__target__ = target
                qaction.connect(qaction, SIGNAL('triggered()'), qaction.sendActionToTarget)
                pass
            # menu = self
            # menu.connect(menu, SIGNAL('aboutToShow()'), toto66)
            # menu.connect(menu, SIGNAL('hovered(QAction*)'), toto77)
            # menu.connect(menu, SIGNAL('triggered(QAction*)'), toto88)
            # qaction.connect(qaction, SIGNAL("changed()"), toto1)
            # qaction.connect(qaction, SIGNAL("hovered()"), toto2)
            # qaction.connect(qaction, SIGNAL("toggled(bool)"), toto3)
            # qaction.connect(qaction, SIGNAL("triggered(bool)"), toto4)
            pass
        #
        try:
            d = self.__item_id__to__action__
        except AttributeError:
            self.__item_id__to__action__={}
            d = self.__item_id__to__action__
            pass
        d[item_id] = qaction
        #
        return qaction
    QPopupMenu.insertItem = __x_insertItem
    
    def __x_connectItem(self, qaction, target):
        res = qaction.connect(qaction, SIGNAL('triggered()'), target)
        return res
    QPopupMenu.connectItem = __x_connectItem
    
    def __x_text(self, val):
        return val.text()
    QPopupMenu.text = __x_text
    
    def __x_idAt(self, i):
        return self.actions()[i]
    QPopupMenu.idAt = __x_idAt
    
    def __x_removeItemAt(self, i):
        qaction = self.idAt(i)
        self.removeAction(qaction)
        return
    QPopupMenu.removeItemAt = __x_removeItemAt
    
    # ----------------------------------------------------------------------
    # add-ons to QMenuBar
    # ----------------------
    
    QMenuBar.getBefore = __x_getBefore
    QMenuBar.insertItem = __x_insertItem
    QMenuBar.indexOf = __x_indexOf
    QMenuBar.removeItem = __x_removeItem
    
    # ----------------------------------------------------------------------
    # add-ons to QAction
    # ------------------------
    
    def __x_setMenuText(self, text):
        return
    QAction.setMenuText = __x_setMenuText
    
    def __x_setAccel(self, accel):
        result = self.setShortcut(accel)
        return result
    QAction.setAccel = __x_setAccel
    
    def __x_addTo(self, receiver):
        result = receiver.addAction(self)
        return result
    QAction.addTo = __x_addTo
    
    def __x_sendActionToTarget(self):
        # print "__x_sendActionToTarget", self
        target = self.__target__
        # print "__x_sendActionToTarget", target
        try:
            res = target(self)
        except TypeError:
            res = target()
            pass
        return res
    QAction.sendActionToTarget = __x_sendActionToTarget

    def __x_aboutToShow(self):
        qaction, qfather = self, self.__qfather__
        qfather.emit(SIGNAL("x_highlighted(QAction*)"), qaction)
        return
    QAction.aboutToShow = __x_aboutToShow
    
    # ----------------------------------------------------------------------
    # add-ons to QFileDialog
    # ------------------------
    
    def __x_getOpenFileName(cls, startWith=QString.null, filter=QString.null, parent=None, name="", caption=QString.null):
        result = cls.getOpenFileName_orig(parent, caption, startWith, filter)
        return result
    QFileDialog.getOpenFileName_orig = QFileDialog.getOpenFileName
    QFileDialog.getOpenFileName = classmethod(__x_getOpenFileName)
    
    def __x_getSaveFileName(cls, startWith=QString.null, filter=QString.null, parent=None, name="", caption=QString.null):
        result = cls.getSaveFileName_orig(parent, caption, startWith, filter)
        return result
    QFileDialog.getSaveFileName_orig = QFileDialog.getSaveFileName
    QFileDialog.getSaveFileName = classmethod(__x_getSaveFileName)
    
    def __x_getExistingDirectory(cls, dir=QString.null, parent=None, name="", caption=QString.null):
        result = cls.getExistingDirectory_orig(parent, caption, dir)
        return result
    QFileDialog.getExistingDirectory_orig = QFileDialog.getExistingDirectory
    QFileDialog.getExistingDirectory = classmethod(__x_getExistingDirectory)
    
    # ----------------------------------------------------------------------
    # add-ons to QProgressDialog
    # ------------------------
    
    def __x_QProgressDialog__init__(self, creator, name, modal, f):
        QProgressDialog.__init__orig(self, creator)
        self.setWFlags(f)
        return
    QProgressDialog.__init__orig = QProgressDialog.__init__
    QProgressDialog.__init__ = __x_QProgressDialog__init__
    
    def __x_totalSteps(self):
        return self.maximum()
    QProgressDialog.totalSteps = __x_totalSteps
    
    def __x_setProgress(self, val):
        return self.setValue(val)
    QProgressDialog.setProgress = __x_setProgress
    
    # ----------------------------------------------------------------------
    # add-ons to QPushButton
    # ------------------------
    
    def __x_QPushButton__init__(self, *args):
        if len(args) == 2:
            if isinstance(args[0], QWidget):
                args = (args[1], args[0], )
                pass
            pass
        QPushButton.__init__orig(self, *args)
        return
    QPushButton.__init__orig = QPushButton.__init__
    QPushButton.__init__ = __x_QPushButton__init__
    
    # ----------------------------------------------------------------------
    # add-ons to QGridLayout
    # ------------------------
    
    def __x_QGridLayout__init__(self, *args):
        if len(args) >= 2:
            args = (args[0], )
            pass
        QGridLayout.__init__orig(self, *args)
        return
    QGridLayout.__init__orig = QGridLayout.__init__
    QGridLayout.__init__ = __x_QGridLayout__init__
    
    # ----------------------------------------------------------------------
    # add-ons to QLineEdit
    # ---------------------
    
    def __x_createPopupMenu(self):
        message("Hello")
        menu = self.createStandardContextMenu()
        return menu
    QLineEdit.createPopupMenu = __x_createPopupMenu
    
##    def __x_event(self, event):
##        print "AAAAA", event
##        return QLineEdit.event_orig(self, event)
##    QLineEdit.event_orig = QLineEdit.event
##    QLineEdit.event = __x_event
    
    # ----------------------------------------------------------------------
    # add-ons to QComboBox
    # ---------------------
    
    def __x_insertItem(self, text, index=-1):
        result = QComboBox.insertItem_orig(self, index, text)
        return result
    QComboBox.insertItem_orig = QComboBox.insertItem
    QComboBox.insertItem = __x_insertItem
    
    # ----------------------------------------------------------------------
    # add-ons to QMouseEvent
    # ---------------------
    
    QMouseEvent.RightButton = Qt.RightButton
    
    # ----------------------------------------------------------------------
    
    pass
