# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from QVTKRenderWindowInteractor import *

class QVtkWindow(QVTKRenderWindowInteractor):
    def __init__(self, parent):
        QVTKRenderWindowInteractor.__init__(self, parent)
        ren = vtk.vtkRenderer()
        
        renWin = self.GetRenderWindow()
        renWin.AddRenderer(ren)
        
        style = vtk.vtkInteractorStyleTrackballCamera()
        iren = self._Iren
        iren.SetInteractorStyle(style)
        
        self.iren = iren
        self.ren = ren
        #
        # triedron 
        #
        from vtktriedron import Triedron
        self.triedron = Triedron()
        self.triedron.addToRender(ren)
        self.triedron.setSize(1., ren)

        self.ren.ResetCamera()
        self.iren.Render()

        return
    #
    # general tools from tool bar
    #
    def onViewTriedron(self):
        if not self.triedron.isVisible():
            self.triedron.show(self.ren)
        else:
            self.triedron.hide(self.ren)
            pass
        self.update()
        return
    
    def onViewFront(self):
        camera = self.ren.GetActiveCamera()
        camera.SetPosition(1,0,0)
        camera.SetViewUp(0,0,1)
        camera.SetFocalPoint(0,0,0)
        self.ren.ResetCameraClippingRange()
        self.update()
        return
    
    def onViewBack(self):
        camera = self.ren.GetActiveCamera()
        camera.SetPosition(-1,0,0)
        camera.SetViewUp(0,0,1)
        camera.SetFocalPoint(0,0,0)
        self.ren.ResetCameraClippingRange()
        self.update()
        return
    
    def onViewTop(self):
        camera = self.ren.GetActiveCamera()
        camera.SetPosition(0,0,1)
        camera.SetViewUp(0,1,0)
        camera.SetFocalPoint(0,0,0)
        self.ren.ResetCameraClippingRange()
        self.update()
        return

    def onViewBottom(self):
        camera = self.ren.GetActiveCamera()
        camera.SetPosition(0,0,-1)
        camera.SetViewUp(0,1,0)
        camera.SetFocalPoint(0,0,0)
        self.ren.ResetCameraClippingRange()
        self.update()
        return
        
    def onViewLeft(self):
        camera = self.ren.GetActiveCamera()
        camera.SetPosition(0,1,0)
        camera.SetViewUp(0,0,1)
        camera.SetFocalPoint(0,0,0)
        self.ren.ResetCameraClippingRange()
        self.update()
        return
        
    def onViewRight(self):
        camera = self.ren.GetActiveCamera()
        camera.SetPosition(0,-1,0)
        camera.SetViewUp(0,0,1)
        camera.SetFocalPoint(0,0,0)
        self.ren.ResetCameraClippingRange()
        self.update()
        return
        
    def onViewReset(self):
        camera = self.ren.GetActiveCamera()
        camera.SetPosition(1,-1,1)
        camera.SetViewUp(0,0,1)
        camera.SetFocalPoint(0,0,0)
        self.ren.ResetCameraClippingRange()
        self.update()
        return
    #
    # mouse events
    #    
    def mousePressEvent(self,ev):
        ctrl, shift = self._GetCtrlShift(ev)
        if shift:
            return
        if ctrl:
            self.ctrlMousePressEvent(ev)
            return
        if ev.button() == qt.Qt.RightButton:
            self.right_click(ev)
            return
        return
    
    def ctrlMousePressEvent(self,ev):
        ctrl, shift = 0, 0
        self._Iren.SetEventInformationFlipY(ev.x(), ev.y(),
                                            ctrl, shift, chr(0), 0, None)
        self._ActiveButton = 0
        # --
        # Inverse 1 and 4 button
        left, right, middle = 2, 1, 4
        if ev.button() == left:
            self._Iren.LeftButtonPressEvent()
            self._ActiveButton = 'Left'
        elif ev.button() == right:
            self._Iren.RightButtonPressEvent()
            self._ActiveButton = 'Right'
        elif ev.button() == middle:
            self._Iren.MiddleButtonPressEvent()
            self._ActiveButton = 'Middle'
            pass
        return
    
    def right_click(self, ev):
        menu = qt.QPopupMenu(self)
        menu.insertItem("VTK Test", self.test)
        menu.popup(ev.globalPos(), 0)
        menu.show()
        return
    def test(self):
        print "VTK Test"
        return

    def addActor(self,actor):
        self.ren.AddActor(actor)
        return
    
    pass
