# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

#
from xsalome import XSalomeSession
salome = XSalomeSession(modules=["DATATEST1"])
#

class TestCase(unittest.TestCase):
    def testGroup(self):
        from ponikarov import Group
        g_none = Group()
        g_list = Group([1, 2, 3])
        #
        self.failUnlessEqual(g_none.getItems(), None)
        self.failUnlessEqual(g_list.getItems(), [1, 2, 3])
        # The corba stuff
        items = g_none.__corba__object__.getItems()
        self.failUnlessEqual(items, None)
        items = g_list.__corba__object__.getItems()
        items = items.value()
        self.failUnlessEqual(items, [1, 2, 3])
        #
        return
    def testComposedObject(self):
        from ponikarov import Group
        g1 = Group([1])
        g2 = Group([2, 2])
        from ponikarov import ComposedObject
        groups = {g1: [], g2: []}
        groups2 = {g1: groups}
        groups3 = {g1: groups}
        # print 10*'\n'
        p = ComposedObject(groups, groups2, groups3)
        self.failUnless(p.groups2)
        self.failUnless(p.groups4)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
