# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

__xdata__items__ = [
    "KalifSolver", # ? virtuel
    "KalifLauncher",
    "KalifOptimizer",
    "KalifMultiOptimizer",
    ]

from xdata import *

class Plan: pass
class SimplexBis: pass
class Bfgs: pass
class LBfgsB: pass
class VizirMono: pass
class Optim: pass
class Vizir: pass

string_list = XList(sequence=XString())
float_vector = XList(sequence=XFloat())
float_array = XList(sequence=XList(sequence=XFloat()))


domain_list = XList(sequence=XTuple(sequence=XFloat(), len=2))

calcul_param = XTuple(sequence=[XInt(), XString(), float_vector], len = 3)

subcost_list = XList(sequence=XList(sequence=XTuple(sequence=XInt(), len=4), len_min=1), len_min=1)

result = XTuple(sequence=[float_vector, float_array], len=2)
plan = XList(sequence=result)

cost = XTuple(sequence=[float_vector, XFloat()], len = 2)
chemin = XList(sequence=cost)

multicost = XTuple(sequence=[float_vector, float_vector], len = 2)
paretozone = XList(sequence=multicost)

class KalifSolver(XObject) :
    
    __object__xmethods__ = [
        XMethod('solve'),
        XMethod('isFinished',
                out_xtype = XInt(into=[0,1]),
                ),
        XMethod('stop'),
        ]
    
##    def solve(self) :
##        self.optimiser()
##        self.maestro.dist.end()
##        return

    def solve(self):
        print "KalifLauncher.solve"
        return
    
    pass

class KalifLauncher(KalifSolver) :
    
    __object__xmethods__ = [
        XMethod('getPlan',
                out_xtype = plan
                ),
        ]

    pass

class KalifOptimizer(KalifSolver) :
    
    __object__xmethods__ = [
        XMethod('setInitPoint',
                in_xattributes=[ XAttribute('point', xtype=float_vector),
                                 ]
                ),
        XMethod('setMaxCall',
                in_xattributes=[ XAttribute('max', xtype=XInt()),
                                 ]
                ),
        XMethod('getOptimumValue',
                out_xtype=XFloat(),
                ),
        XMethod('getOptimum',
                out_xtype=cost
                ),
        ]
    
    def solve(self) :
        self.opt, self.optim = self.optimiser(self.getInitPoint())
        self.maestro.dist.end()
        return
    
    pass

class KalifMultiOptimizer(KalifSolver) :
    __object__xmethods__ = [
        XMethod('setMaxCall',
                in_xattributes=[ XAttribute('max', xtype=XInt()),
                                 ]
                ),
        XMethod('getParetoZone',
                out_xtype=paretozone,
                ),
        ]
    pass

class KalifPlan(KalifLauncher, Plan) :
    def __init__(self, log) :
        Plan.__init__(self, log)
        return
    pass

class KalifSimplex(KalifOptimizer, SimplexBis) :
    def __init__(self, log) :
        SimplexBis.__init__(log)
        return
    pass

class KalifBfgs(KalifOptimizer, Bfgs) :
    def __init__(self, log) :
        Bfgs.__init__(self, log)
        return
    pass

class KalifLbfgsb(KalifOptimizer, LBfgsB) :
    def __init__(self, log) :
        LBfgsB.__init__(self, log)
        return
    pass

class KalifGenetic(KalifOptimizer, VizirMono) :
    def __init__(self, log) :
        VizirMono.__init__(self, log)
        return
    pass

class KalifVizir(KalifMultiOptimizer, Vizir) :
    def __init__(self, log) :
        Vizir.__init__(self, log)
        return
    pass

