# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

class XDataItemTree(object):
    
    def __init__(self, xdata_name=None, depth=0, parent_module=None, parent=None):
        #
        self.xdata_name = xdata_name
        self.depth = depth
        self.parent_module = parent_module
        self.parent = parent
        #
        self.children = []
        self.is_final = 0
        #
        if depth == 0:
            self.insertItem(xdata_name+"_xdata", parent_module)
            pass
        #
        return
    
    def insertItem(self, name, parent_module):
        #
        name = name.strip()
        #
        names = [ c.xdata_name for c in self.children ]
        if ( name ) and ( name in names ) :
            msg  = ""
            msg += "duplicate keyword %s in item %s is forbiden ..."%(name.__repr__(), self.xdata_name.__repr__())
            raise Exception(msg)
        #
        module = None
        if name :
            if not hasattr(parent_module, name):
                try:
                    from xutilities import getModule
                    module = getModule(name)
                except ImportError, e:
                    if str(e) != "No module named %s"%(name):
                        raise e
                    pass
                pass
            pass
        #
        if module is None:
            child = self.__class__(name, self.depth+1, parent_module, self)
            module, target = parent_module, name
            if hasattr(module, target):
                target = getattr(module, target)
                if hasattr(target, '__xdata__name__'):
                    child.user_xdata_name = getattr(target, '__xdata__name__')
                    pass
                pass
            child.target = target
            child.is_final = 1
            self.children.append(child)
            return
        #
        try:
            xdata_name = module.__xdata__name__
        except AttributeError:
            xdata_name = module.__name__.capitalize()
            pass
        # --
        # Looking if a precedent child have the same xdata_name.
        # If so, replace self by the precedent child ...
        # It authorizes to define a menu in several times
        child = None
        for c in self.children:
            if xdata_name == c.xdata_name:
                child = c
                break
            pass
        # -----
        if child is None:
            if parent_module is None:
                child = self
            else:
                child = self.__class__(xdata_name, self.depth+1, parent_module, self)
                self.children.append(child)
                pass
            pass
        #
        if hasattr(module, "__xdata__items__"):
            xdata_items = getattr(module, "__xdata__items__")
        else:
            from xutilities import getClasses
            from xdata import XObject
            classes = getClasses(module, XObject)
            xdata_items = []
            xdata = __import__("xdata")
            for c in classes:
                if hasattr(xdata, c.__name__):
                    c_in_xdata = getattr(xdata, c.__name__)
                    if c is c_in_xdata: continue
                    pass
                from xsomething import XSomething
                if issubclass(c, XSomething): continue
                xdata_items.append(c.__name__)
                pass
            pass
        #
        for item in xdata_items:
            child.insertItem(item, module)
            pass
        #
        return
    
    def getPresentation(self):
        stream  = ''
        if self.depth > 0:
            stream += "%s'%s'"%(self.depth*'   ', self.xdata_name)
            stream += " ... %s .. %s .. %s"%(self.parent_module.__name__, self.is_final, self.parent.xdata_name)
        else:
            stream += "%s%s"%(self.depth*'   ', self.xdata_name)
            pass
        stream += "\n"
        for child in self.children:
            stream += child.getPresentation()
            pass
        return stream
    
    def getItem(self, name):
        l = name.split('/')
        name = l[0]
        if len(l) == 1:
            for x in self.children:
                if x.xdata_name == name:
                    return x
                pass
            return
        x = self.getItem(name)
        if x:
            name = "/".join(l[1:])
            return x.getItem(name)
        return

    pass
