# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

class XAccessor(object):
    
    def __init__(self, name, xattr, real_attribute, class_id):
        self.name = name
        self.hidden_name = "__%s"%(name)
        self.xattr = xattr
        self.real_attribute = real_attribute
        self.class_id = class_id
        return
    
    pass

class GetXAccessor(XAccessor):
    
    def __call__(self, *args, **kwargs):
        obj, args = args[0], args[1:]
        
        name = self.name
        
        if hasattr(obj, "__corba__object__"):
            from xutilities import message
            message()
            message(name, cls="GetXAccessor")
            corba_object = getattr(obj, "__corba__object__")
            message("corba_object:", corba_object, cls="GetXAccessor")
            from xutilities import name2capname
            accessor = "get"+name2capname(name)
            method = getattr(corba_object, accessor)
            message('calling corba_object.%s() ...'%(accessor))
            corba_object = method()
            message("corba_result:", corba_object, cls="GetXAccessor")
            xtype = getattr(self.xattr, '__xtype')
            if xtype.getIdlType() == "boolean":
                return not not corba_object
            from xsalome import corba2python
            python_object = corba2python(corba_object)
            message("python_result:", python_object, cls="GetXAccessor")
            message()
            return python_object
        
        accessor = self.real_attribute
        
        if accessor:
            from xutilities import name2capname
            recursion_flag = "__%s__%s__recursion__flag__"%(self.class_id, "get"+name2capname(name))
            if not hasattr(obj, recursion_flag):
                setattr(obj, recursion_flag, 1)
                try_false = 1
                try:
                    result = accessor(obj, *args, **kwargs)
                    try_false = 0
                finally:
                    delattr(obj, recursion_flag)
                    pass
                # xtype = getattr(self.xattr, '__xtype')
                # result = xtype(result)
                return result
            pass
        
        result = getattr(obj, self.hidden_name)
        #        if isinstance(result, list):
        #            xtype = getattr(self.xattr, '__xtype')
        #            # result = xtype(result)
        #            pass
        
        return result
    
    pass

class SetXAccessor(XAccessor):
    
    def __set__check__(self, obj, value):
        xattr = self.xattr
        #
        mode = getattr(xattr, '__mode')
        if mode == "r":
            if obj.__xcontext__ is None:
                msg = '%s is a readonly attribute'%(self.name)
                from xexceptions import XAttributeError
                raise XAttributeError(msg)
            pass
        #
        xtype = getattr(xattr, '__xtype')
        value = xtype(value)
        return value
    
    def __call__(self, *args, **kwargs):
        try:
            check = kwargs['_check']
            del kwargs['_check']
        except KeyError:
            check = 1
            pass
        
        obj, args = args[0], args[1:]
        
        name = self.name
        
        # --
        #
        
        val = args[0]
        if check:
            val = self.__set__check__(obj, val)
            pass
        
        # --
        #
        
        if name == "name":
            typ = type(obj)
            if typ.__xnamedobject__:
                if hasattr(obj, "__name"):
                    if val == getattr(obj, "__name"):
                        return
                    pass
                pass
            pass
        
        # --
        #
        
        if hasattr(obj, "__corba__object__"):
            from xutilities import message
            corba_object = getattr(obj, "__corba__object__")
            from xutilities import name2capname
            accessor = "set"+name2capname(name)
            method = getattr(corba_object, accessor)
            from xsalome import python2corba
            message("val:", val, cls="SetXAccessor")
            #
            xtype = getattr(self.xattr, '__xtype')
            val = python2corba(val, corba_object.getCorbaComponent(), xtype)
            message("val:", val, cls="SetXAccessor")
            #
            try:
                result = method(val)
            except Exception, e:
                from xsalome import corba2python
                e = corba2python(e)
                message(e, cls="SetXAccessor")
                raise e
            #
            from xsalome import corba2python
            result = corba2python(result)
        else:
            accessor = self.real_attribute
            if accessor:
                try:
                    old_value = getattr(obj, self.hidden_name)
                    old_value_exists = 1
                except AttributeError:
                    old_value_exists = 0
                    pass
                result = setattr(obj, self.hidden_name, val)
                from xutilities import name2capname
                recursion_flag = "__%s__%s__recursion__flag__"%(self.class_id, "set"+name2capname(name))
                if not hasattr(obj, recursion_flag):
                    setattr(obj, recursion_flag, 1)
                    try_false = 1
                    try:
                        result = accessor(obj, *args, **kwargs)
                        try_false = 0
                    finally:
                        if try_false:
                            if old_value_exists:
                                setattr(obj, self.hidden_name, old_value)
                                pass
                            pass
                        delattr(obj, recursion_flag)
                        pass
                    pass
                pass
            else:
                result = setattr(obj, self.hidden_name, val)
                pass
            pass
        
        if not hasattr(obj, '__xsomething__'):
            if hasattr(obj, "__init__ok__") and obj.__init__ok__:
                from xcontext import getInterface
                interface = getInterface()
                if ( interface in ("gui", "tui", ) ) :
                    try:
                        import xqt
                        qt_ok = 1
                    except:
                        qt_ok = 0
                        pass
                    if qt_ok:
                        from xdatagui import getMainWindow
                        mw = getMainWindow()
                        if mw:
                            mw.oldObjectModified(obj)
                            pass
                        pass
                    pass
                pass
            pass
        
        return result
    
    pass
