# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XListTestCase(unittest.TestCase):
    def test(self):
        x = XList()
        self.failUnlessEqual(x(3.2), [3.2])
        self.failUnlessEqual(x([]), [])
        return
    def test_len_len_min_len_max(self):
        self.failUnlessRaises(XValueError, XList, len=3.2)
        x = XList(len=2)
        self.failUnlessRaises(XValueError, x, ["toto"])
        self.failUnlessEqual(x([1, 2]), [1, 2])
        x = XList(len_min=3, len_max=5)
        self.failUnlessRaises(XValueError, x, [1,2])
        self.failUnlessRaises(XValueError, x, [1,2,3,4,5,6])
        self.failUnlessEqual(x([1,2,3]), [1,2,3])
        return
    def test_sequence(self):
        #
        self.failUnlessRaises(XValueError, XList, sequence="toto")
        #
        x = XList(sequence=XInt(min=0))
        self.failUnlessRaises(XValueError, x, ["toto"])
        self.failUnlessRaises(XValueError, x, [-1])
        self.failUnlessEqual(x(["1"]), [1])
        #
        x = XList(sequence=XTuple(sequence=XInt(), len=2))
        self.failUnlessEqual(x([(1, 1), (2, 2)]), [(1, 1), (2, 2)])
        self.failUnlessRaises(XValueError, x, [(3, 1, 0)])
        #
        x = XList(sequence=(XString(), XInt()))
        self.failUnlessRaises(XValueError, x, ["a"])
        self.failUnlessEqual(x(["a", "1"]), ["a", 1])
        self.failUnlessRaises(XValueError, x, ["a", 1, "b"])
        self.failUnlessEqual(x(["a", "1", "b", "2"]), ["a", 1, "b", 2])
        self.failUnlessRaises(XValueError, x, ["a", 3.2, "b", 12])
        self.failUnlessRaises(XValueError, x, ["a", "toto", "b", 12])
        #
        return
    def test_sequence_tolist(self):
        x = XList(sequence=XInt())
        self.failUnlessEqual(x(1), [1])
        return
    def test_string_with_comma_tolist(self):
        x = XList(sequence=XInt())
        self.failUnlessEqual(x('1, 2, 3, 4'), [1, 2, 3, 4])
        return
    def test_len_multiple(self):
        x = XList(sequence=(XInt(), XFloat()), len_multiple=1)
        x = XList(len_multiple=1, sequence=(XInt(), XFloat()))
        self.failUnlessEqual(x([1]), [1])
        self.failUnlessEqual(x([1, 2.3]), [1, 2.3])
        self.failUnlessEqual(x([1, 2.3, 2]), [1, 2.3, 2])
        return
    pass

class A(XObject):
    __init__xattributes__ = [
        XAttribute("l", xtype=XList(), default_value=None),
        ]
    pass

class ATestCase(unittest.TestCase):
    def test(self):
        a = A(None)
        self.failUnlessEqual(a.l, None)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
