# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XPropertyTestCase(unittest.TestCase):
    def test_name(self):
        self.failUnlessRaises(XValueError, XProperty, 2.3)
        self.failUnlessRaises(XValueError, XProperty, "")
        name = "x"
        x = XProperty(name, default_value=None)
        self.failUnlessEqual(name, x.name)
        return
    def test_args(self):
        self.failUnlessRaises(XAttributeError, XProperty, "x", "toto")
        return
    def test_noargs(self):
        from xdata import XString
        x = XProperty("aaa", xtype=XString())
        self.failUnlessEqual(x.hasDefaultValue(), 0)
        self.failUnlessRaises(ValueError, x.getDefaultValue)
        self.failUnlessEqual(x.xtype("toto"), "toto")
        return
    def test_default_value_without_xtype(self):
        default_value = 123
        x = XProperty("aaa", default_value=default_value)
        self.failUnlessEqual(x.hasDefaultValue(), 1)
        self.failUnlessEqual(x.getDefaultValue(), default_value)
        self.failUnlessEqual(x.xtype("256"), 256)
        self.failUnlessEqual(x.xtype(default_value), default_value)
        self.failUnlessRaises(XValueError, x.xtype, 1.2)
        self.failUnlessRaises(XValueError, x.xtype, "toto")
        #
        x = XProperty("a", default_value=None)
        self.failUnlessEqual(x.hasDefaultValue(), 1)
        self.failUnlessEqual(x.getDefaultValue(), None)
        #
        return
    def test_xtype(self):
        self.failUnlessRaises(XValueError, XProperty, "aa", xtype="toto")
        name = "toto"
        from xdata import XFloat
        x = XProperty(name, xtype=XFloat(min=0.5))
        self.failUnlessRaises(XValueError, x.xtype, "toto")
        self.failUnlessRaises(XValueError, x.xtype, -2.3)
        return
    def test_default_value_with_types(self):
        # particuliar case when default_value is None
        from xdata import XString
        x = XProperty("x", default_value=None, xtype=XString())
        self.failUnlessEqual(x.xtype("toto"), "toto")
        self.failUnlessEqual(x.xtype("None"), None)
        # imcompatibility between "toto" and XFloat()
        from xdata import XFloat
        self.failUnlessRaises(XValueError, XProperty, "x", default_value="toto", xtype=XFloat())
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
