# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class Circle(XNamedObject):
    __init__xattributes__ = [
        XAttribute("radius", xtype=XFloat(open_min=0.0)),
        ]
    __object__xattributes__ = [
        XAttribute("diameter", xtype=XFloat(open_min=0.0)),
        XAttribute("test_init", xtype=XFloat(open_min=0.0)),
        XAttribute("test_method", xtype=XFloat(open_min=0.0)),
        ]
    def __init__(self, *args, **kwargs):
        self.test_init = 1.0
        return
    def setRadius(self, value):
        self.diameter = 2*self.radius
        return
    def method(self):
        self.test_method = 1.0
        return
    pass

class CircleTestCase(unittest.TestCase):
    def test(self):
        c = Circle(1.0)
        self.failUnlessEqual(c.radius, 1.0)
        self.failUnlessEqual(c.diameter, 2.0)
        c.setRadius(2.0)
        self.failUnlessEqual(c.getRadius(), 2.0)
        self.failUnlessEqual(c.getDiameter(), 4.0)
        return
    def test_readonly(self):
        c = Circle(1.0)
        self.failUnlessRaises(AttributeError, c.setDiameter, 2.0)
        self.failUnlessRaises(AttributeError, c.__setattr__, "diameter", 2.0)
        self.failUnlessRaises(AttributeError, setattr, c, "diameter", 2.0)
        #
        c.method()
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
