//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  File   : VVTK_SegmentationCursorDlg.h
//  Author : Oleg Uvarov
//  Module : VISU
//
#ifndef VVTK_SEGMENTATIONCURSORDLG_H
#define VVTK_SEGMENTATIONCURSORDLG_H

#include "VVTK.h"

#include "VISU_GaussPtsDeviceActor.h"

#include <QDialog>

#include <vtkObject.h>
#include <vtkSmartPointer.h>

class vtkActorCollection;
class vtkCallbackCommand;
class vtkImageData;

class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;
class QTabWidget;
class QGroupBox;
class QWidget;
//class QVBox;

class QtxAction;
class QtxDoubleSpinBox;
class QtxIntSpinBox;

class VISU_GaussPtsAct1;
class VISU_InsideCursorSettings;
class VISU_OutsideCursorSettings;
class VISU_WidgetCtrl;

class VVTK_PrimitiveBox;
class VVTK_SizeBox;

class SVTK_RenderWindowInteractor;


//! Segmentation Cursor Dialog.
/*!
 * Uses for set up Segmentation and Outside Cursor Gauss Points preferenses
 * and apply them to all actors in the current renderer.
 */
class VVTK_SegmentationCursorDlg : public QDialog
{
  Q_OBJECT

public:
  VVTK_SegmentationCursorDlg( QWidget* parent = 0, const char* name = 0 );
  ~VVTK_SegmentationCursorDlg();

  void             SetWidgetCtrl( VISU_WidgetCtrl* );
  void             SetPlaneAction( QtxAction* theAction ) { myPlaneAction = theAction; }
  void             SetSphereAction( QtxAction* theAction ) { mySphereAction = theAction; }

  bool             GetIsPlaneSegmentation() const { return myIsPlaneSegmentation; }
  void             SetIsPlaneSegmentation( bool on ) { myIsPlaneSegmentation = on; }

  //! Update contents of the Segmentation tab.
  void             UpdateSegmentation();
  void             UpdateInsideGaussPoints();
  void             UpdateOutsideGaussPoints();

  //! Update contents of the Outside Cursor tab.
  void             UpdateOutsideCursor();

  VISU_InsideCursorSettings*  GetInsideCursorSettings();
  VISU_OutsideCursorSettings* GetOutsideCursorSettings();

  vtkSmartPointer<vtkCallbackCommand> GetEventCallbackCommand() { return myEventCallbackCommand; }

  void             SetInteractor( SVTK_RenderWindowInteractor* theInteractor ) { myInteractor = theInteractor; }

public:
  float            getMagnification() const;
  void             setMagnification( float );

  float            getIncrement() const;
  void             setIncrement( float );

protected:
  void             ApplySegmentationCursor();
  void             ApplyInsideGaussPoints();
  void             ApplyOutsideGaussPoints();

  bool             CheckNumberOfFaces();

  VISU::TTextureValue
  MakeImageData( bool theInside,
		 const QString& theMainTexture, 
		 const QString& theAlphaTexture );

private:
  static void      ProcessEvents(vtkObject* theObject, 
				 unsigned long theEvent,
				 void* theClientData, 
				 void* theCallData);
  
  void             keyPressEvent( QKeyEvent* e );

protected slots:
  virtual void     done( int );
  void             onParentShow();
  void             onParentHide();

  void             onClickApply();
  void             onClickClose();
  void             onClickHelp();

signals:
  void             scgClose();

private:
  SVTK_RenderWindowInteractor* myInteractor;

  QTabWidget*       myTabBox;

  // Segmentation cursor
  QWidget*          mySegmentationCursorBox;

  QGroupBox*        myOriginGroup;
  QtxDoubleSpinBox* myXOriginSpinBox;
  QtxDoubleSpinBox* myYOriginSpinBox;
  QtxDoubleSpinBox* myZOriginSpinBox;

  QGroupBox*        myDirectionGroup;
  QtxDoubleSpinBox* myDXDirectionSpinBox;
  QtxDoubleSpinBox* myDYDirectionSpinBox;
  QtxDoubleSpinBox* myDZDirectionSpinBox;

  QGroupBox*        myDepthGroup;
  QtxDoubleSpinBox* myDepthSpinBox;

  QGroupBox*        myRadiusGroup;
  QtxDoubleSpinBox* myRadiusSpinBox;
  QtxDoubleSpinBox* myRatioSpinBox;

  bool              myIsPlaneSegmentation;

  float             myPriority;
  vtkSmartPointer<vtkCallbackCommand> myEventCallbackCommand;

  VISU_WidgetCtrl*  myWidgetCtrl;
  QtxAction*        myPlaneAction;
  QtxAction*        mySphereAction;

  // Gauss Points
  QWidget*          myGaussPointsBox;

  VVTK_PrimitiveBox* myInsidePrimitiveBox;
  VVTK_SizeBox*     myInsideSizeBox;

  QString           myInsideMainTexture;
  QString           myInsideAlphaTexture;

  vtkSmartPointer<VISU_InsideCursorSettings> myInsideCursorSettings;

  VVTK_PrimitiveBox* myOutsidePrimitiveBox;
  VVTK_SizeBox*     myOutsideSizeBox;

  QString           myOutsideMainTexture;
  QString           myOutsideAlphaTexture;

  vtkSmartPointer<VISU_OutsideCursorSettings> myOutsideCursorSettings;

  QLabel*           myMagnificationLabel;
  QtxIntSpinBox*    myMagnificationSpinBox;
  QLabel*           myIncrementLabel;
  QtxDoubleSpinBox* myIncrementSpinBox;
};

#endif
