//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  VISU VISUGUI : GUI of VISU component
//  File   : VVTK_RecorderDlg.cxx
//  Author : Oleg UVAROV
//  Module : VISU
//
#include "VVTK_RecorderDlg.h"
#include "VVTK_Recorder.h"

#include "SUIT_FileDlg.h"
#include "SUIT_MessageBox.h"
#include "SUIT_ResourceMgr.h"
#include "SUIT_Session.h"

#include "QtxDoubleSpinBox.h"
#include "QtxIntSpinBox.h"

#include "LightApp_Application.h"

#include "CAM_Module.h"

#include <QCheckBox>
#include <QComboBox>
#include <QGroupBox>
#include <QKeyEvent>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QPushButton>

/*!
 * Constructor
 */
VVTK_RecorderDlg::VVTK_RecorderDlg( QWidget* theParent, VVTK_Recorder* theRecorder ):
  QDialog( theParent ),
  myRecorder( theRecorder )
{
  setWindowTitle( tr( "DLG_RECORDER_TITLE" ) );

  SUIT_ResourceMgr* aResourceMgr = SUIT_Session::session()->resourceMgr();

  QVBoxLayout* aTopLayout = new QVBoxLayout( this );
  aTopLayout->setSpacing( 6 );
  aTopLayout->setMargin( 6 );
  //aTopLayout->setAutoAdd( true );

  // Settings
  QGroupBox* mySettingsBox = new QGroupBox( tr( "SETTINGS" ), this );
  //mySettingsBox->setColumnLayout( 0, Qt::Vertical );
  //mySettingsBox->layout()->setSpacing( 0 );
  //mySettingsBox->layout()->setMargin( 0 );

  QGridLayout* aSettingsLayout = new QGridLayout( mySettingsBox );
  aSettingsLayout->setSpacing( 6 );
  aSettingsLayout->setMargin( 11 );

  QLabel* aFileNameLabel = new QLabel( tr( "FILE_NAME" ), mySettingsBox );
  myFileNameLineEdit = new QLineEdit( mySettingsBox );
  myFileNameLineEdit->setMinimumWidth( 250 );
  myFileNameLineEdit->setReadOnly( true );

  QLabel* aRecordingModeLabel = new QLabel( tr( "RECORDING_MODE" ), mySettingsBox );
  myRecordingModeComboBox = new QComboBox( mySettingsBox );
  myRecordingModeComboBox->addItem( tr( "SKIPPED_FRAMES" ) );
  myRecordingModeComboBox->addItem( tr( "ALL_DISLPAYED_FRAMES" ) );
  myRecordingModeComboBox->setCurrentIndex( aResourceMgr->integerValue( "VISU", "recorder_mode", 1 ) );

  QLabel* aFPSLabel = new QLabel( tr( "FPS" ), mySettingsBox );
  myFPSSpinBox = new QtxDoubleSpinBox( 0.1, 100.0, 1.0, mySettingsBox );
  myFPSSpinBox->setValue( aResourceMgr->doubleValue( "VISU", "recorder_fps", 10.0 ) );

  QLabel* aQualityLabel = new QLabel( tr( "QUALITY" ), mySettingsBox );
  myQualitySpinBox = new QtxIntSpinBox( 1, 100, 1, mySettingsBox );
  myQualitySpinBox->setValue( aResourceMgr->integerValue( "VISU", "recorder_quality", 80 ) );

  myProgressiveCheckBox = new QCheckBox( tr( "PROGRESSIVE" ), mySettingsBox );
  myProgressiveCheckBox->setChecked( aResourceMgr->booleanValue( "VISU", "recorder_progressive", false ) );

  aSettingsLayout->addWidget( aFileNameLabel, 0, 0 );
  aSettingsLayout->addWidget( myFileNameLineEdit, 1, 0, 1, 2 );
  //aSettingsLayout->addWidget( aFileNameButton, 1, 2 );
  aSettingsLayout->addWidget( aRecordingModeLabel, 2, 0 );
  aSettingsLayout->addWidget( myRecordingModeComboBox, 2, 1 );
  aSettingsLayout->addWidget( aFPSLabel, 3, 0 );
  aSettingsLayout->addWidget( myFPSSpinBox, 3, 1 );
  aSettingsLayout->addWidget( aQualityLabel, 4, 0 );
  aSettingsLayout->addWidget( myQualitySpinBox, 4, 1 );
  aSettingsLayout->addWidget( myProgressiveCheckBox, 5, 0 );

  aTopLayout->addWidget( mySettingsBox );

  // Start / Close
  QGroupBox* CommonGroup = new QGroupBox( this );
  //CommonGroup->setColumnLayout(0, Qt::Vertical );
  //CommonGroup->layout()->setSpacing( 0 );
  //CommonGroup->layout()->setMargin( 0 );
  QGridLayout* CommonGroupLayout = new QGridLayout( CommonGroup );
  CommonGroupLayout->setAlignment( Qt::AlignTop );
  CommonGroupLayout->setSpacing( 6 );
  CommonGroupLayout->setMargin( 11 );

  QPushButton* aStartButton = new QPushButton( tr( "START" ), CommonGroup );
  aStartButton->setAutoDefault( true );
  aStartButton->setDefault( true );
  CommonGroupLayout->addWidget( aStartButton, 0, 0 );
  CommonGroupLayout->addItem( new QSpacerItem( 5, 5, QSizePolicy::Expanding, QSizePolicy::Minimum ), 0, 1 );

  QPushButton* aCloseButton = new QPushButton( tr( "CLOSE" ), CommonGroup );
  aCloseButton->setAutoDefault( true );
  CommonGroupLayout->addWidget( aCloseButton, 0, 2 );

  QPushButton* aHelpButton = new QPushButton( tr( "HELP" ), CommonGroup );
  aHelpButton->setAutoDefault( true );
  CommonGroupLayout->addWidget( aHelpButton, 0, 3 );

  aTopLayout->addWidget( CommonGroup );

  connect( aStartButton, SIGNAL( clicked() ), this, SLOT( onStart() ) );
  connect( aCloseButton, SIGNAL( clicked() ), this, SLOT( onClose() ) );
  connect( aHelpButton,  SIGNAL( clicked() ), this, SLOT( onHelp() ) );
}

VVTK_RecorderDlg::~VVTK_RecorderDlg()
{
}

void VVTK_RecorderDlg::onStart()
{
  if( myFileName.isNull() )
    return;

  myRecorder->SetName( (const char*)myFileName.toLatin1() );

  myRecorder->SetUseSkippedFrames( myRecordingModeComboBox->currentIndex() == 0 );
  myRecorder->SetNbFPS( myFPSSpinBox->value() );
  myRecorder->SetQuality( myQualitySpinBox->value() );
  myRecorder->SetProgressiveMode( myProgressiveCheckBox->isChecked() );

  accept();

}

void VVTK_RecorderDlg::onClose()
{
  reject();
}

void VVTK_RecorderDlg::onHelp()
{
  QString aHelpFileName = "animation_in_gauss_viewer.htm";
  LightApp_Application* app = (LightApp_Application*)(SUIT_Session::session()->activeApplication());
  if (app)
    app->onHelpContextModule(app->activeModule() ? app->moduleName(app->activeModule()->moduleName()) : QString(""), aHelpFileName);
  else {
		QString platform;
#ifdef WIN32
		platform = "winapplication";
#else
		platform = "application";
#endif
    SUIT_MessageBox::warning(0, QObject::tr("WRN_WARNING"),
			     QObject::tr("EXTERNAL_BROWSER_CANNOT_SHOW_PAGE").
			     arg(app->resourceMgr()->stringValue("ExternalBrowser", platform)).arg(aHelpFileName) );
  }
}

bool VVTK_RecorderDlg::onBrowseFile()
{
  QString aRootDir = QString( getenv( "VISU_ROOT_DIR") );

  QStringList aFilter;
  aFilter.append( tr( "FLT_AVI_FILES" ) );
  aFilter.append( tr( "FLT_ALL_FILES" ) );

  QString aFileName = SUIT_FileDlg::getFileName( this, getenv( "HOME" ), aFilter,
						 tr( "FILE_NAME" ), false );

  if( aFileName.isNull() )
    return false;

  myFileName = aFileName;
  myFileNameLineEdit->setText( aFileName.section( '/', -1 ) );

  return true;
}

int VVTK_RecorderDlg::exec()
{
  if( !onBrowseFile() )
  {
    reject();
    return 0;
  }
  return QDialog::exec();
}

void VVTK_RecorderDlg::keyPressEvent( QKeyEvent* e )
{
  QDialog::keyPressEvent( e );
  if ( e->isAccepted() )
    return;

  if ( e->key() == Qt::Key_F1 )
    {
      e->accept();
      onHelp();
    }
}
