//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  File   : VisuGUI_TableDlg.h
//  Author : Vadim SANDLER
//  Module : VISU
//
#ifndef VisuGUI_TABLE_DLG_H
#define VisuGUI_TABLE_DLG_H

#include <QDialog>
#include <QLineEdit>
#include <QPushButton>
#include <QItemDelegate>

class QTableWidget;
class VisuGUI_TableWidget;

#include <SALOMEDSClient_SObject.hxx>

#include "VisuGUITools.h"

class VISU_GUITOOLS_EXPORT VisuGUI_TableDlg : public QDialog
{ 
  Q_OBJECT

public:

  enum { ttNone, ttInt, ttReal, ttBoth, ttAuto };

  VisuGUI_TableDlg( QWidget* parent, 
		    _PTR(SObject) obj, 
		    bool edit = false,
		    int which = ttAuto, 
		    Qt::Orientation orient = Qt::Horizontal,
		    bool showColumnTitles = true );
  ~VisuGUI_TableDlg();

private:
  void keyPressEvent( QKeyEvent* e );

public slots:
  void onOK();
  void onHelp(); 

private:
  void initDlg();

private:
  VisuGUI_TableWidget*   myIntTable;
  VisuGUI_TableWidget*   myRealTable;
  QPushButton*           myOKBtn;
  QPushButton*           myCancelBtn;
  QPushButton*           myHelpBtn;

  _PTR(SObject) myObject;
};
 
class VISU_GUITOOLS_EXPORT VisuGUI_TableWidget : public QWidget
{
  Q_OBJECT
public:
  VisuGUI_TableWidget( QWidget* parent = 0, 
		       const char* name = 0, 
		       bool edit = false, 
		       Qt::Orientation orient = Qt::Horizontal,
		       bool showColumnTitles = true );
  ~VisuGUI_TableWidget();

  void    setTableTitle( const QString& title );
  QString getTableTitle();
  void    setNumRows( const int num );
  int     getNumRows();
  void    setNumCols( const int num );
  int     getNumCols();
  void    setRowTitles( QStringList& tlts );
  void    getRowTitles( QStringList& tlts );
  void    setColTitles( QStringList& tlts );
  void    getColTitles( QStringList& tlts );
  void    setUnitsTitle( const QString& tlt );
  void    setUnits( QStringList& units );
  void    getUnits( QStringList& units );
  void    setRowData( int row, QStringList& data );
  void    getRowData( int row, QStringList& data );

  QTableWidget*     getTable()     { return myTable; } 
  QLineEdit*       getTitleEdit() { return myTitleEdit; }

  bool    eventFilter( QObject* o, QEvent* e);

public slots:
  void updateButtonsState();
  void addRow();
  void addCol();
  void delRow();
  void delCol();
  void adjustTable();
  void selectAll();
  void clearTable();

private:
  QLineEdit*       myTitleEdit;
  QTableWidget*    myTable;
  QPushButton*     myAddRowBtn;
  QPushButton*     myAddColBtn;
  QPushButton*     myDelRowBtn;
  QPushButton*     myDelColBtn;
  QPushButton*     myAdjustBtn;
  QPushButton*     mySelectAllBtn;
  QPushButton*     myClearBtn;
  Qt::Orientation  myOrientation;
};

class VISU_GUITOOLS_EXPORT NumDelegateItem: public QItemDelegate
{
public:
  enum NumValidator{ NV_Int, NV_Real };

  NumDelegateItem( QObject* parent, NumValidator mode = NV_Int );
  virtual ~NumDelegateItem();

  virtual QWidget * createEditor( QWidget * parent,
				  const QStyleOptionViewItem & option,
				  const QModelIndex & index ) const;
  virtual void setEditorData( QWidget * editor,
			      const QModelIndex & index ) const;
private:
  int         myMode;
};

#endif // VisuGUI_TABLE_DLG_H

