#  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
#
#  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
#  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
#
# Generated python file of Graph GraphMacroNodes
#
from SuperV import *

# Graph creation of GraphMacroNodes
def DefGraphMacroNodes() :
    GraphMacroNodes = Graph( 'GraphMacroNodes' )
    GraphMacroNodes.SetName( 'GraphMacroNodes' )
    GraphMacroNodes.SetAuthor( '' )
    GraphMacroNodes.SetComment( '' )
    GraphMacroNodes.Coords( 0 , 0 )
    
    # Creation of Factory Nodes
    
    Add = GraphMacroNodes.FNode( 'AddComponent' , 'AddComponent' , 'Add' )
    Add.SetName( 'Add' )
    Add.SetAuthor( '' )
    Add.SetContainer( 'FactoryServer' )
    Add.SetComment( 'Add from AddComponent' )
    Add.Coords( 9 , 293 )
    IAddx = Add.GetInPort( 'x' )
    IAddy = Add.GetInPort( 'y' )
    IAddGate = Add.GetInPort( 'Gate' )
    OAddFuncValue = Add.GetOutPort( 'FuncValue' )
    OAddz = Add.GetOutPort( 'z' )
    OAddGate = Add.GetOutPort( 'Gate' )
    
    Sub = GraphMacroNodes.FNode( 'SubComponent' , 'SubComponent' , 'Sub' )
    Sub.SetName( 'Sub' )
    Sub.SetAuthor( '' )
    Sub.SetContainer( 'FactoryServer' )
    Sub.SetComment( 'Sub from SubComponent' )
    Sub.Coords( 227 , 99 )
    ISubx = Sub.GetInPort( 'x' )
    ISuby = Sub.GetInPort( 'y' )
    ISubGate = Sub.GetInPort( 'Gate' )
    OSubz = Sub.GetOutPort( 'z' )
    OSubGate = Sub.GetOutPort( 'Gate' )
    
    Mul = GraphMacroNodes.FNode( 'MulComponent' , 'MulComponent' , 'Mul' )
    Mul.SetName( 'Mul' )
    Mul.SetAuthor( '' )
    Mul.SetContainer( 'FactoryServer' )
    Mul.SetComment( 'Mul from MulComponent' )
    Mul.Coords( 443 , 278 )
    IMulx = Mul.GetInPort( 'x' )
    IMuly = Mul.GetInPort( 'y' )
    IMulGate = Mul.GetInPort( 'Gate' )
    OMulz = Mul.GetOutPort( 'z' )
    OMulGate = Mul.GetOutPort( 'Gate' )
    
    Div = GraphMacroNodes.FNode( 'DivComponent' , 'DivComponent' , 'Div' )
    Div.SetName( 'Div' )
    Div.SetAuthor( '' )
    Div.SetContainer( 'FactoryServer' )
    Div.SetComment( 'Div from DivComponent' )
    Div.Coords( 634 , 97 )
    IDivx = Div.GetInPort( 'x' )
    IDivy = Div.GetInPort( 'y' )
    IDivGate = Div.GetInPort( 'Gate' )
    ODivz = Div.GetOutPort( 'z' )
    ODivGate = Div.GetOutPort( 'Gate' )
    
    # Creation of Macro Nodes
    SyrStruct_1 = DefSyrStruct_1()
    Macro_SyrStruct = GraphMacroNodes.GraphMNode( SyrStruct_1 )
    Macro_SyrStruct.SetCoupled( 'SyrStruct_1' )
    Macro_SyrStruct.SetName( 'Macro_SyrStruct' )
    Macro_SyrStruct.SetAuthor( '' )
    Macro_SyrStruct.SetComment( 'Macro Node' )
    Macro_SyrStruct.Coords( 13 , 6 )
    IMacro_SyrStructSyrComponent__aContainer = Macro_SyrStruct.GetInPort( 'SyrComponent__aContainer' )
    IMacro_SyrStructSyrComponent__aComponent = Macro_SyrStruct.GetInPort( 'SyrComponent__aComponent' )
    IMacro_SyrStructforN__N = Macro_SyrStruct.GetInPort( 'forN__N' )
    IMacro_SyrStructforN__K = Macro_SyrStruct.GetInPort( 'forN__K' )
    IMacro_SyrStructforN__min = Macro_SyrStruct.GetInPort( 'forN__min' )
    IMacro_SyrStructforN__max = Macro_SyrStruct.GetInPort( 'forN__max' )
    IMacro_SyrStructfori__i = Macro_SyrStruct.GetInPort( 'fori__i' )
    IMacro_SyrStructGate = Macro_SyrStruct.GetInPort( 'Gate' )
    OMacro_SyrStructEndOfforN__N = Macro_SyrStruct.GetOutPort( 'EndOfforN__N' )
    OMacro_SyrStructEndOfforN__K = Macro_SyrStruct.GetOutPort( 'EndOfforN__K' )
    OMacro_SyrStructEndOfforN__SyrComponent = Macro_SyrStruct.GetOutPort( 'EndOfforN__SyrComponent' )
    OMacro_SyrStructEndOfforN__min = Macro_SyrStruct.GetOutPort( 'EndOfforN__min' )
    OMacro_SyrStructEndOfforN__max = Macro_SyrStruct.GetOutPort( 'EndOfforN__max' )
    OMacro_SyrStructEndOfwhileNotOne__SyrComponent = Macro_SyrStruct.GetOutPort( 'EndOfwhileNotOne__SyrComponent' )
    OMacro_SyrStructEndOfwhileNotOne__N = Macro_SyrStruct.GetOutPort( 'EndOfwhileNotOne__N' )
    OMacro_SyrStructEndOffori__i = Macro_SyrStruct.GetOutPort( 'EndOffori__i' )
    OMacro_SyrStructEndOfwhileEven__SyrComponent = Macro_SyrStruct.GetOutPort( 'EndOfwhileEven__SyrComponent' )
    OMacro_SyrStructGate = Macro_SyrStruct.GetOutPort( 'Gate' )
    
    SyrStruct_1_1 = DefSyrStruct_1_1()
    Macro_SyrStruct_1 = GraphMacroNodes.GraphMNode( SyrStruct_1_1 )
    Macro_SyrStruct_1.SetCoupled( 'SyrStruct_1_1' )
    Macro_SyrStruct_1.SetName( 'Macro_SyrStruct_1' )
    Macro_SyrStruct_1.SetAuthor( '' )
    Macro_SyrStruct_1.SetComment( 'Macro Node' )
    Macro_SyrStruct_1.Coords( 8 , 441 )
    IMacro_SyrStruct_1SyrComponent__aContainer = Macro_SyrStruct_1.GetInPort( 'SyrComponent__aContainer' )
    IMacro_SyrStruct_1SyrComponent__aComponent = Macro_SyrStruct_1.GetInPort( 'SyrComponent__aComponent' )
    IMacro_SyrStruct_1forN__N = Macro_SyrStruct_1.GetInPort( 'forN__N' )
    IMacro_SyrStruct_1forN__K = Macro_SyrStruct_1.GetInPort( 'forN__K' )
    IMacro_SyrStruct_1forN__min = Macro_SyrStruct_1.GetInPort( 'forN__min' )
    IMacro_SyrStruct_1forN__max = Macro_SyrStruct_1.GetInPort( 'forN__max' )
    IMacro_SyrStruct_1fori__i = Macro_SyrStruct_1.GetInPort( 'fori__i' )
    IMacro_SyrStruct_1Gate = Macro_SyrStruct_1.GetInPort( 'Gate' )
    OMacro_SyrStruct_1EndOfforN__N = Macro_SyrStruct_1.GetOutPort( 'EndOfforN__N' )
    OMacro_SyrStruct_1EndOfforN__K = Macro_SyrStruct_1.GetOutPort( 'EndOfforN__K' )
    OMacro_SyrStruct_1EndOfforN__SyrComponent = Macro_SyrStruct_1.GetOutPort( 'EndOfforN__SyrComponent' )
    OMacro_SyrStruct_1EndOfforN__min = Macro_SyrStruct_1.GetOutPort( 'EndOfforN__min' )
    OMacro_SyrStruct_1EndOfforN__max = Macro_SyrStruct_1.GetOutPort( 'EndOfforN__max' )
    OMacro_SyrStruct_1EndOfwhileNotOne__SyrComponent = Macro_SyrStruct_1.GetOutPort( 'EndOfwhileNotOne__SyrComponent' )
    OMacro_SyrStruct_1EndOfwhileNotOne__N = Macro_SyrStruct_1.GetOutPort( 'EndOfwhileNotOne__N' )
    OMacro_SyrStruct_1EndOffori__i = Macro_SyrStruct_1.GetOutPort( 'EndOffori__i' )
    OMacro_SyrStruct_1EndOfwhileEven__SyrComponent = Macro_SyrStruct_1.GetOutPort( 'EndOfwhileEven__SyrComponent' )
    OMacro_SyrStruct_1Gate = Macro_SyrStruct_1.GetOutPort( 'Gate' )
    
    # Creation of Links
    LAddzSuby = GraphMacroNodes.Link( OAddz , ISuby )
    
    LAddzMuly = GraphMacroNodes.Link( OAddz , IMuly )
    
    LSubzMulx = GraphMacroNodes.Link( OSubz , IMulx )
    
    LSubzDivx = GraphMacroNodes.Link( OSubz , IDivx )
    
    LMulzDivy = GraphMacroNodes.Link( OMulz , IDivy )
    
    # Input datas
    IAddx.Input( 3 )
    IAddy.Input( 4.5 )
    ISubx.Input( 1.5 )
    IMacro_SyrStructSyrComponent__aContainer.Input( 'FactoryServer' )
    IMacro_SyrStructSyrComponent__aComponent.Input( 'SyrComponent' )
    IMacro_SyrStructforN__N.Input( 0 )
    IMacro_SyrStructforN__K.Input( 0 )
    IMacro_SyrStructforN__min.Input( 5 )
    IMacro_SyrStructforN__max.Input( 9 )
    IMacro_SyrStructfori__i.Input( 0 )
    IMacro_SyrStruct_1SyrComponent__aContainer.Input( 'FactoryServer' )
    IMacro_SyrStruct_1SyrComponent__aComponent.Input( 'SyrComponent' )
    IMacro_SyrStruct_1forN__N.Input( 0 )
    IMacro_SyrStruct_1forN__K.Input( 0 )
    IMacro_SyrStruct_1forN__min.Input( 5 )
    IMacro_SyrStruct_1forN__max.Input( 9 )
    IMacro_SyrStruct_1fori__i.Input( 0 )
    
    # Output Ports of the graph
    #OAddFuncValue = Add.GetOutPort( 'FuncValue' )
    #ODivz = Div.GetOutPort( 'z' )
    #OMacro_SyrStructEndOfforN__N = Macro_SyrStruct.GetOutPort( 'EndOfforN__N' )
    #OMacro_SyrStructEndOfforN__K = Macro_SyrStruct.GetOutPort( 'EndOfforN__K' )
    #OMacro_SyrStructEndOfforN__SyrComponent = Macro_SyrStruct.GetOutPort( 'EndOfforN__SyrComponent' )
    #OMacro_SyrStructEndOfforN__min = Macro_SyrStruct.GetOutPort( 'EndOfforN__min' )
    #OMacro_SyrStructEndOfforN__max = Macro_SyrStruct.GetOutPort( 'EndOfforN__max' )
    #OMacro_SyrStructEndOfwhileNotOne__SyrComponent = Macro_SyrStruct.GetOutPort( 'EndOfwhileNotOne__SyrComponent' )
    #OMacro_SyrStructEndOfwhileNotOne__N = Macro_SyrStruct.GetOutPort( 'EndOfwhileNotOne__N' )
    #OMacro_SyrStructEndOffori__i = Macro_SyrStruct.GetOutPort( 'EndOffori__i' )
    #OMacro_SyrStructEndOfwhileEven__SyrComponent = Macro_SyrStruct.GetOutPort( 'EndOfwhileEven__SyrComponent' )
    #OMacro_SyrStruct_1EndOfforN__N = Macro_SyrStruct_1.GetOutPort( 'EndOfforN__N' )
    #OMacro_SyrStruct_1EndOfforN__K = Macro_SyrStruct_1.GetOutPort( 'EndOfforN__K' )
    #OMacro_SyrStruct_1EndOfforN__SyrComponent = Macro_SyrStruct_1.GetOutPort( 'EndOfforN__SyrComponent' )
    #OMacro_SyrStruct_1EndOfforN__min = Macro_SyrStruct_1.GetOutPort( 'EndOfforN__min' )
    #OMacro_SyrStruct_1EndOfforN__max = Macro_SyrStruct_1.GetOutPort( 'EndOfforN__max' )
    #OMacro_SyrStruct_1EndOfwhileNotOne__SyrComponent = Macro_SyrStruct_1.GetOutPort( 'EndOfwhileNotOne__SyrComponent' )
    #OMacro_SyrStruct_1EndOfwhileNotOne__N = Macro_SyrStruct_1.GetOutPort( 'EndOfwhileNotOne__N' )
    #OMacro_SyrStruct_1EndOffori__i = Macro_SyrStruct_1.GetOutPort( 'EndOffori__i' )
    #OMacro_SyrStruct_1EndOfwhileEven__SyrComponent = Macro_SyrStruct_1.GetOutPort( 'EndOfwhileEven__SyrComponent' )
    return GraphMacroNodes

# Graph creation of SyrStruct_1
def DefSyrStruct_1() :
    SyrStruct_1 = Graph( 'SyrStruct_1' )
    SyrStruct_1.SetCoupled( 'Macro_SyrStruct' )
    SyrStruct_1.SetName( 'SyrStruct_1' )
    SyrStruct_1.SetAuthor( 'JR' )
    SyrStruct_1.SetComment( 'Syracuse algorithm' )
    SyrStruct_1.Coords( 0 , 0 )
    
    # Creation of Factory Nodes
    
    m3 = SyrStruct_1.FNode( 'SyrComponent' , 'SyrComponent' , 'C_M3' )
    m3.SetName( 'm3' )
    m3.SetAuthor( '' )
    m3.SetContainer( 'localhost/FactoryServer' )
    m3.SetComment( 'C_M3 from SyrComponent' )
    m3.Coords( 672 , 28 )
    Im3anOddInteger = m3.GetInPort( 'anOddInteger' )
    Im3Gate = m3.GetInPort( 'Gate' )
    Om3anInteger = m3.GetOutPort( 'anInteger' )
    Om3Gate = m3.GetOutPort( 'Gate' )
    
    m3incr = SyrStruct_1.FNode( 'SyrComponent' , 'SyrComponent' , 'C_INCR' )
    m3incr.SetName( 'm3incr' )
    m3incr.SetAuthor( '' )
    m3incr.SetContainer( 'localhost/FactoryServer' )
    m3incr.SetComment( 'C_INCR from SyrComponent' )
    m3incr.Coords( 898 , 29 )
    Im3incraCount = m3incr.GetInPort( 'aCount' )
    Im3incrGate = m3incr.GetInPort( 'Gate' )
    Om3incraNewCount = m3incr.GetOutPort( 'aNewCount' )
    Om3incrGate = m3incr.GetOutPort( 'Gate' )
    
    incra = SyrStruct_1.FNode( 'SyrComponent' , 'SyrComponent' , 'C_INCR' )
    incra.SetName( 'incra' )
    incra.SetAuthor( '' )
    incra.SetContainer( 'localhost/FactoryServer' )
    incra.SetComment( 'C_INCR from SyrComponent' )
    incra.Coords( 803 , 195 )
    IincraaCount = incra.GetInPort( 'aCount' )
    IincraGate = incra.GetInPort( 'Gate' )
    OincraaNewCount = incra.GetOutPort( 'aNewCount' )
    OincraGate = incra.GetOutPort( 'Gate' )
    
    div2 = SyrStruct_1.FNode( 'SyrComponent' , 'SyrComponent' , 'C_DIV2' )
    div2.SetName( 'div2' )
    div2.SetAuthor( '' )
    div2.SetContainer( 'localhost/FactoryServer' )
    div2.SetComment( 'C_DIV2 from SyrComponent' )
    div2.Coords( 810 , 435 )
    Idiv2anEvenInteger = div2.GetInPort( 'anEvenInteger' )
    Idiv2Gate = div2.GetInPort( 'Gate' )
    Odiv2anInteger = div2.GetOutPort( 'anInteger' )
    Odiv2Gate = div2.GetOutPort( 'Gate' )
    
    incrb = SyrStruct_1.FNode( 'SyrComponent' , 'SyrComponent' , 'C_INCR' )
    incrb.SetName( 'incrb' )
    incrb.SetAuthor( '' )
    incrb.SetContainer( 'localhost/FactoryServer' )
    incrb.SetComment( 'C_INCR from SyrComponent' )
    incrb.Coords( 809 , 574 )
    IincrbaCount = incrb.GetInPort( 'aCount' )
    IincrbGate = incrb.GetInPort( 'Gate' )
    OincrbaNewCount = incrb.GetOutPort( 'aNewCount' )
    OincrbGate = incrb.GetOutPort( 'Gate' )
    
    # Creation of InLine Nodes
    PySyrComponent = []
    PySyrComponent.append( 'from LifeCycleCORBA import * ' )
    PySyrComponent.append( 'def SyrComponent( aContainer , aComponent ) : ' )
    PySyrComponent.append( '    orb = CORBA.ORB_init([], CORBA.ORB_ID) ' )
    PySyrComponent.append( '    lcc = LifeCycleCORBA(orb) ' )
    PySyrComponent.append( '    ComponentRef = lcc.FindOrLoadComponent( aContainer , aComponent ) ' )
    PySyrComponent.append( '    return ComponentRef ' )
    SyrComponent = SyrStruct_1.INode( 'SyrComponent' , PySyrComponent )
    SyrComponent.SetName( 'SyrComponent' )
    SyrComponent.SetAuthor( '' )
    SyrComponent.SetComment( 'SyrComponent( aContainer , aComponent )' )
    SyrComponent.Coords( 0 , 0 )
    ISyrComponentaContainer = SyrComponent.InPort( 'aContainer' , 'string' )
    ISyrComponentaComponent = SyrComponent.InPort( 'aComponent' , 'string' )
    ISyrComponentGate = SyrComponent.GetInPort( 'Gate' )
    OSyrComponentSyrComponentobjref = SyrComponent.OutPort( 'SyrComponentobjref' , 'objref' )
    OSyrComponentGate = SyrComponent.GetOutPort( 'Gate' )
    
    # Creation of Loop Nodes
    PyforN = []
    PyforN.append( 'def InitN( NN , K , SyrComponent , min , max ) : ' )
    PyforN.append( '    N = max ' )
    PyforN.append( '    if min > 0 : ' )
    PyforN.append( '        if max >= min : ' )
    PyforN.append( '            N = min ' )
    PyforN.append( '    return N,K,SyrComponent,min,max ' )
    PyMoreforN = []
    PyMoreforN.append( 'def MoreN( NN , KK , SyrComponent , min , max ) : ' )
    PyMoreforN.append( '    N = NN ' )
    PyMoreforN.append( '    OutLoop = 0 ' )
    PyMoreforN.append( '    if max > NN : ' )
    PyMoreforN.append( '        OutLoop = 1 ' )
    PyMoreforN.append( '    return OutLoop,N,0,SyrComponent,min,max ' )
    PyNextforN = []
    PyNextforN.append( 'def NextN( NN , KK , SyrComponent , min , max ) : ' )
    PyNextforN.append( '    N = NN + 1 ' )
    PyNextforN.append( '    K = KK ' )
    PyNextforN.append( '    return N,K,SyrComponent,min,max ' )
    forN,EndOfforN = SyrStruct_1.LNode( 'InitN' , PyforN , 'MoreN' , PyMoreforN , 'NextN' , PyNextforN )
    EndOfforN.SetName( 'EndOfforN' )
    EndOfforN.SetAuthor( '' )
    EndOfforN.SetComment( '' )
    EndOfforN.Coords( 1535 , 332 )
    PyEndOfforN = []
    EndOfforN.SetPyFunction( '' , PyEndOfforN )
    IforNDoLoop = forN.GetInPort( 'DoLoop' )
    IforNN = forN.InPort( 'N' , 'long' )
    IforNK = forN.InPort( 'K' , 'long' )
    IforNSyrComponent = forN.InPort( 'SyrComponent' , 'objref' )
    IforNmin = forN.InPort( 'min' , 'long' )
    IforNmax = forN.InPort( 'max' , 'long' )
    IforNGate = forN.GetInPort( 'Gate' )
    OforNDoLoop = forN.GetOutPort( 'DoLoop' )
    OforNN = forN.GetOutPort( 'N' )
    OforNK = forN.GetOutPort( 'K' )
    OforNSyrComponent = forN.GetOutPort( 'SyrComponent' )
    OforNmin = forN.GetOutPort( 'min' )
    OforNmax = forN.GetOutPort( 'max' )
    IEndOfforNDoLoop = EndOfforN.GetInPort( 'DoLoop' )
    IEndOfforNN = EndOfforN.GetInPort( 'N' )
    IEndOfforNK = EndOfforN.GetInPort( 'K' )
    IEndOfforNSyrComponent = EndOfforN.GetInPort( 'SyrComponent' )
    IEndOfforNmin = EndOfforN.GetInPort( 'min' )
    IEndOfforNmax = EndOfforN.GetInPort( 'max' )
    IEndOfforNGate = EndOfforN.GetInPort( 'Gate' )
    OEndOfforNDoLoop = EndOfforN.GetOutPort( 'DoLoop' )
    OEndOfforNN = EndOfforN.GetOutPort( 'N' )
    OEndOfforNK = EndOfforN.GetOutPort( 'K' )
    OEndOfforNSyrComponent = EndOfforN.GetOutPort( 'SyrComponent' )
    OEndOfforNmin = EndOfforN.GetOutPort( 'min' )
    OEndOfforNmax = EndOfforN.GetOutPort( 'max' )
    OEndOfforNGate = EndOfforN.GetOutPort( 'Gate' )
    forN.SetName( 'forN' )
    forN.SetAuthor( '' )
    forN.SetComment( 'InitN , MoreN , NextN' )
    forN.Coords( 20 , 302 )
    
    PywhileNotOne = []
    PywhileNotOne.append( 'import threading' )
    PywhileNotOne.append( 'import SyrComponent_idl' )
    PywhileNotOne.append( 'def InitNotOne( SyrComponent , N , K ) :' )
    PywhileNotOne.append( '    return SyrComponent,N,K' )
    PyMorewhileNotOne = []
    PyMorewhileNotOne.append( 'import SyrComponent_idl' )
    PyMorewhileNotOne.append( 'def MoreNotOne( SyrComponent , N , K ) :' )
    PyMorewhileNotOne.append( '    OutLoop = 1 - SyrComponent.C_ISONE( N )' )
    PyMorewhileNotOne.append( '    return OutLoop,SyrComponent,N,K ' )
    PyNextwhileNotOne = []
    PyNextwhileNotOne.append( 'import SyrComponent_idl' )
    PyNextwhileNotOne.append( 'def NextNotOne( SyrComponent , N , K ) :' )
    PyNextwhileNotOne.append( '    return SyrComponent,N,K' )
    whileNotOne,EndOfwhileNotOne = SyrStruct_1.LNode( 'InitNotOne' , PywhileNotOne , 'MoreNotOne' , PyMorewhileNotOne , 'NextNotOne' , PyNextwhileNotOne )
    EndOfwhileNotOne.SetName( 'EndOfwhileNotOne' )
    EndOfwhileNotOne.SetAuthor( '' )
    EndOfwhileNotOne.SetComment( '' )
    EndOfwhileNotOne.Coords( 1366 , 303 )
    PyEndOfwhileNotOne = []
    EndOfwhileNotOne.SetPyFunction( '' , PyEndOfwhileNotOne )
    IwhileNotOneDoLoop = whileNotOne.GetInPort( 'DoLoop' )
    IwhileNotOneSyrComponent = whileNotOne.InPort( 'SyrComponent' , 'objref' )
    IwhileNotOneN = whileNotOne.InPort( 'N' , 'long' )
    IwhileNotOneK = whileNotOne.InPort( 'K' , 'long' )
    IwhileNotOneGate = whileNotOne.GetInPort( 'Gate' )
    OwhileNotOneDoLoop = whileNotOne.GetOutPort( 'DoLoop' )
    OwhileNotOneSyrComponent = whileNotOne.GetOutPort( 'SyrComponent' )
    OwhileNotOneN = whileNotOne.GetOutPort( 'N' )
    OwhileNotOneK = whileNotOne.GetOutPort( 'K' )
    IEndOfwhileNotOneDoLoop = EndOfwhileNotOne.GetInPort( 'DoLoop' )
    IEndOfwhileNotOneSyrComponent = EndOfwhileNotOne.GetInPort( 'SyrComponent' )
    IEndOfwhileNotOneN = EndOfwhileNotOne.GetInPort( 'N' )
    IEndOfwhileNotOneK = EndOfwhileNotOne.GetInPort( 'K' )
    IEndOfwhileNotOneGate = EndOfwhileNotOne.GetInPort( 'Gate' )
    OEndOfwhileNotOneDoLoop = EndOfwhileNotOne.GetOutPort( 'DoLoop' )
    OEndOfwhileNotOneSyrComponent = EndOfwhileNotOne.GetOutPort( 'SyrComponent' )
    OEndOfwhileNotOneN = EndOfwhileNotOne.GetOutPort( 'N' )
    OEndOfwhileNotOneK = EndOfwhileNotOne.GetOutPort( 'K' )
    OEndOfwhileNotOneGate = EndOfwhileNotOne.GetOutPort( 'Gate' )
    whileNotOne.SetName( 'whileNotOne' )
    whileNotOne.SetAuthor( '' )
    whileNotOne.SetComment( 'InitNotOne , MoreNotOne , NextNotOne' )
    whileNotOne.Coords( 212 , 274 )
    
    Pyfori = []
    Pyfori.append( 'def Initfori( ii , K ) :' )
    Pyfori.append( '    return 1,0,K' )
    PyMorefori = []
    PyMorefori.append( 'def Morefori( ii , K ) :' )
    PyMorefori.append( '    OutLoop = 0' )
    PyMorefori.append( '    if 2 > ii :' )
    PyMorefori.append( '        OutLoop = 1' )
    PyMorefori.append( '    return OutLoop,ii,K' )
    PyNextfori = []
    PyNextfori.append( 'def Nextfori( ii , K ) :' )
    PyNextfori.append( '    ii = ii + 1' )
    PyNextfori.append( '    return ii,K' )
    fori,EndOffori = SyrStruct_1.LNode( 'Initfori' , Pyfori , 'Morefori' , PyMorefori , 'Nextfori' , PyNextfori )
    EndOffori.SetName( 'EndOffori' )
    EndOffori.SetAuthor( '' )
    EndOffori.SetComment( '' )
    EndOffori.Coords( 976 , 212 )
    PyEndOffori = []
    EndOffori.SetPyFunction( '' , PyEndOffori )
    IforiDoLoop = fori.GetInPort( 'DoLoop' )
    Iforii = fori.InPort( 'i' , 'long' )
    IforiK = fori.InPort( 'K' , 'long' )
    IforiGate = fori.GetInPort( 'Gate' )
    OforiDoLoop = fori.GetOutPort( 'DoLoop' )
    Oforii = fori.GetOutPort( 'i' )
    OforiK = fori.GetOutPort( 'K' )
    IEndOfforiDoLoop = EndOffori.GetInPort( 'DoLoop' )
    IEndOfforii = EndOffori.GetInPort( 'i' )
    IEndOfforiK = EndOffori.GetInPort( 'K' )
    IEndOfforiGate = EndOffori.GetInPort( 'Gate' )
    OEndOfforiDoLoop = EndOffori.GetOutPort( 'DoLoop' )
    OEndOfforii = EndOffori.GetOutPort( 'i' )
    OEndOfforiK = EndOffori.GetOutPort( 'K' )
    OEndOfforiGate = EndOffori.GetOutPort( 'Gate' )
    fori.SetName( 'fori' )
    fori.SetAuthor( '' )
    fori.SetComment( 'Initfori, Morefori, Nextfori' )
    fori.Coords( 635 , 212 )
    
    PywhileEven = []
    PywhileEven.append( 'import SyrComponent_idl' )
    PywhileEven.append( 'def InitEven( SyrComponent , N , K ) :' )
    PywhileEven.append( '    return SyrComponent,N,K' )
    PyMorewhileEven = []
    PyMorewhileEven.append( 'import SyrComponent_idl' )
    PyMorewhileEven.append( 'def MoreEven( SyrComponent , N , K ) :' )
    PyMorewhileEven.append( '    OutLoop = SyrComponent.C_ISEVEN( N )' )
    PyMorewhileEven.append( '    return OutLoop,SyrComponent,N,K ' )
    PyNextwhileEven = []
    PyNextwhileEven.append( 'import SyrComponent_idl' )
    PyNextwhileEven.append( 'def NextEven( SyrComponent , N , K ) :' )
    PyNextwhileEven.append( '    return SyrComponent,N,K' )
    whileEven,EndOfwhileEven = SyrStruct_1.LNode( 'InitEven' , PywhileEven , 'MoreEven' , PyMorewhileEven , 'NextEven' , PyNextwhileEven )
    EndOfwhileEven.SetName( 'EndOfwhileEven' )
    EndOfwhileEven.SetAuthor( '' )
    EndOfwhileEven.SetComment( '' )
    EndOfwhileEven.Coords( 988 , 451 )
    PyEndOfwhileEven = []
    EndOfwhileEven.SetPyFunction( '' , PyEndOfwhileEven )
    IwhileEvenDoLoop = whileEven.GetInPort( 'DoLoop' )
    IwhileEvenSyrComponent = whileEven.InPort( 'SyrComponent' , 'objref' )
    IwhileEvenN = whileEven.InPort( 'N' , 'long' )
    IwhileEvenK = whileEven.InPort( 'K' , 'long' )
    IwhileEvenGate = whileEven.GetInPort( 'Gate' )
    OwhileEvenDoLoop = whileEven.GetOutPort( 'DoLoop' )
    OwhileEvenSyrComponent = whileEven.GetOutPort( 'SyrComponent' )
    OwhileEvenN = whileEven.GetOutPort( 'N' )
    OwhileEvenK = whileEven.GetOutPort( 'K' )
    IEndOfwhileEvenDoLoop = EndOfwhileEven.GetInPort( 'DoLoop' )
    IEndOfwhileEvenSyrComponent = EndOfwhileEven.GetInPort( 'SyrComponent' )
    IEndOfwhileEvenN = EndOfwhileEven.GetInPort( 'N' )
    IEndOfwhileEvenK = EndOfwhileEven.GetInPort( 'K' )
    IEndOfwhileEvenGate = EndOfwhileEven.GetInPort( 'Gate' )
    OEndOfwhileEvenDoLoop = EndOfwhileEven.GetOutPort( 'DoLoop' )
    OEndOfwhileEvenSyrComponent = EndOfwhileEven.GetOutPort( 'SyrComponent' )
    OEndOfwhileEvenN = EndOfwhileEven.GetOutPort( 'N' )
    OEndOfwhileEvenK = EndOfwhileEven.GetOutPort( 'K' )
    OEndOfwhileEvenGate = EndOfwhileEven.GetOutPort( 'Gate' )
    whileEven.SetName( 'whileEven' )
    whileEven.SetAuthor( '' )
    whileEven.SetComment( 'InitEven, MoreEven, NextEven' )
    whileEven.Coords( 632 , 451 )
    
    # Creation of Switch Nodes
    PyifNotEven = []
    PyifNotEven.append( 'import SyrComponent_idl' )
    PyifNotEven.append( 'def ifNotEven( SyrComponent , N , K ) :' )
    PyifNotEven.append( '    Even = SyrComponent.C_ISEVEN( N )' )
    PyifNotEven.append( '    Odd = 1 - Even' )
    PyifNotEven.append( '    return Odd,Even,SyrComponent,N,K' )
    ifNotEven,EndOfifNotEven = SyrStruct_1.SNode( 'ifNotEven' , PyifNotEven )
    EndOfifNotEven.SetName( 'EndOfifNotEven' )
    EndOfifNotEven.SetAuthor( '' )
    EndOfifNotEven.SetComment( '' )
    EndOfifNotEven.Coords( 1205 , 331 )
    PyEndOfifNotEven = []
    EndOfifNotEven.SetPyFunction( '' , PyEndOfifNotEven )
    IEndOfifNotEvenN = EndOfifNotEven.InPort( 'N' , 'long' )
    IEndOfifNotEvenK = EndOfifNotEven.InPort( 'K' , 'long' )
    IEndOfifNotEvenDefault = EndOfifNotEven.GetInPort( 'Default' )
    OEndOfifNotEvenN = EndOfifNotEven.OutPort( 'N' , 'long' )
    OEndOfifNotEvenK = EndOfifNotEven.OutPort( 'K' , 'long' )
    OEndOfifNotEvenGate = EndOfifNotEven.GetOutPort( 'Gate' )
    ifNotEven.SetName( 'ifNotEven' )
    ifNotEven.SetAuthor( '' )
    ifNotEven.SetComment( 'ifNotEven' )
    ifNotEven.Coords( 418 , 274 )
    IifNotEvenSyrComponent = ifNotEven.InPort( 'SyrComponent' , 'objref' )
    IifNotEvenN = ifNotEven.InPort( 'N' , 'long' )
    IifNotEvenK = ifNotEven.InPort( 'K' , 'long' )
    IifNotEvenGate = ifNotEven.GetInPort( 'Gate' )
    OifNotEvenOdd = ifNotEven.OutPort( 'Odd' , 'long' )
    OifNotEvenEven = ifNotEven.OutPort( 'Even' , 'long' )
    OifNotEvenSyrComponent = ifNotEven.OutPort( 'SyrComponent' , 'objref' )
    OifNotEvenN = ifNotEven.OutPort( 'N' , 'long' )
    OifNotEvenK = ifNotEven.OutPort( 'K' , 'long' )
    OifNotEvenDefault = ifNotEven.GetOutPort( 'Default' )
    
    # Creation of Links
    Lm3anIntegerm3incraCount = SyrStruct_1.Link( Om3anInteger , Im3incraCount )
    
    Lm3incraNewCountEndOfifNotEvenN = SyrStruct_1.Link( Om3incraNewCount , IEndOfifNotEvenN )
    Lm3incraNewCountEndOfifNotEvenN.AddCoord( 1 , 1190 , 366 )
    Lm3incraNewCountEndOfifNotEvenN.AddCoord( 2 , 1191 , 109 )
    
    LincraaNewCountEndOfforiK = SyrStruct_1.Link( OincraaNewCount , IEndOfforiK )
    
    Ldiv2anIntegerEndOfwhileEvenN = SyrStruct_1.Link( Odiv2anInteger , IEndOfwhileEvenN )
    
    LincrbaNewCountEndOfwhileEvenK = SyrStruct_1.Link( OincrbaNewCount , IEndOfwhileEvenK )
    LincrbaNewCountEndOfwhileEvenK.AddCoord( 1 , 988 , 543 )
    LincrbaNewCountEndOfwhileEvenK.AddCoord( 2 , 988 , 654 )
    
    LSyrComponentSyrComponentobjrefforNSyrComponent = SyrStruct_1.Link( OSyrComponentSyrComponentobjref , IforNSyrComponent )
    LSyrComponentSyrComponentobjrefforNSyrComponent.AddCoord( 1 , 13 , 394 )
    LSyrComponentSyrComponentobjrefforNSyrComponent.AddCoord( 2 , 12 , 181 )
    LSyrComponentSyrComponentobjrefforNSyrComponent.AddCoord( 3 , 196 , 181 )
    LSyrComponentSyrComponentobjrefforNSyrComponent.AddCoord( 4 , 197 , 81 )
    
    LforNNwhileNotOneN = SyrStruct_1.Link( OforNN , IwhileNotOneN )
    
    LforNNEndOfforNN = SyrStruct_1.Link( OforNN , IEndOfforNN )
    
    LforNKwhileNotOneK = SyrStruct_1.Link( OforNK , IwhileNotOneK )
    
    LforNSyrComponentEndOfforNSyrComponent = SyrStruct_1.Link( OforNSyrComponent , IEndOfforNSyrComponent )
    
    LforNSyrComponentwhileNotOneSyrComponent = SyrStruct_1.Link( OforNSyrComponent , IwhileNotOneSyrComponent )
    LforNSyrComponentwhileNotOneSyrComponent.AddCoord( 1 , 192 , 309 )
    LforNSyrComponentwhileNotOneSyrComponent.AddCoord( 2 , 191 , 394 )
    
    LforNminEndOfforNmin = SyrStruct_1.Link( OforNmin , IEndOfforNmin )
    
    LforNmaxEndOfforNmax = SyrStruct_1.Link( OforNmax , IEndOfforNmax )
    
    LwhileNotOneSyrComponentEndOfwhileNotOneSyrComponent = SyrStruct_1.Link( OwhileNotOneSyrComponent , IEndOfwhileNotOneSyrComponent )
    
    LwhileNotOneSyrComponentifNotEvenSyrComponent = SyrStruct_1.Link( OwhileNotOneSyrComponent , IifNotEvenSyrComponent )
    
    LwhileNotOneNifNotEvenN = SyrStruct_1.Link( OwhileNotOneN , IifNotEvenN )
    
    LwhileNotOneKifNotEvenK = SyrStruct_1.Link( OwhileNotOneK , IifNotEvenK )
    
    LEndOfwhileNotOneKEndOfforNK = SyrStruct_1.Link( OEndOfwhileNotOneK , IEndOfforNK )
    
    LforiiEndOfforii = SyrStruct_1.Link( Oforii , IEndOfforii )
    
    LforiKincraaCount = SyrStruct_1.Link( OforiK , IincraaCount )
    
    LEndOfforiKEndOfifNotEvenK = SyrStruct_1.Link( OEndOfforiK , IEndOfifNotEvenK )
    LEndOfforiKEndOfifNotEvenK.AddCoord( 1 , 1170 , 396 )
    LEndOfforiKEndOfifNotEvenK.AddCoord( 2 , 1169 , 275 )
    
    LwhileEvenSyrComponentEndOfwhileEvenSyrComponent = SyrStruct_1.Link( OwhileEvenSyrComponent , IEndOfwhileEvenSyrComponent )
    
    LwhileEvenNdiv2anEvenInteger = SyrStruct_1.Link( OwhileEvenN , Idiv2anEvenInteger )
    
    LwhileEvenKincrbaCount = SyrStruct_1.Link( OwhileEvenK , IincrbaCount )
    LwhileEvenKincrbaCount.AddCoord( 1 , 796 , 655 )
    LwhileEvenKincrbaCount.AddCoord( 2 , 795 , 543 )
    
    LEndOfwhileEvenNEndOfifNotEvenN = SyrStruct_1.Link( OEndOfwhileEvenN , IEndOfifNotEvenN )
    LEndOfwhileEvenNEndOfifNotEvenN.AddCoord( 1 , 1191 , 366 )
    LEndOfwhileEvenNEndOfifNotEvenN.AddCoord( 2 , 1191 , 513 )
    
    LEndOfwhileEvenKEndOfifNotEvenK = SyrStruct_1.Link( OEndOfwhileEvenK , IEndOfifNotEvenK )
    LEndOfwhileEvenKEndOfifNotEvenK.AddCoord( 1 , 1169 , 395 )
    LEndOfwhileEvenKEndOfifNotEvenK.AddCoord( 2 , 1170 , 543 )
    
    LifNotEvenOddm3Gate = SyrStruct_1.Link( OifNotEvenOdd , Im3Gate )
    LifNotEvenOddm3Gate.AddCoord( 1 , 593 , 141 )
    LifNotEvenOddm3Gate.AddCoord( 2 , 593 , 307 )
    
    LifNotEvenOddforiGate = SyrStruct_1.Link( OifNotEvenOdd , IforiGate )
    
    LifNotEvenEvenwhileEvenGate = SyrStruct_1.Link( OifNotEvenEven , IwhileEvenGate )
    LifNotEvenEvenwhileEvenGate.AddCoord( 1 , 593 , 576 )
    LifNotEvenEvenwhileEvenGate.AddCoord( 2 , 592 , 339 )
    
    LifNotEvenSyrComponentwhileEvenSyrComponent = SyrStruct_1.Link( OifNotEvenSyrComponent , IwhileEvenSyrComponent )
    LifNotEvenSyrComponentwhileEvenSyrComponent.AddCoord( 1 , 586 , 486 )
    LifNotEvenSyrComponentwhileEvenSyrComponent.AddCoord( 2 , 587 , 367 )
    
    LifNotEvenNwhileEvenN = SyrStruct_1.Link( OifNotEvenN , IwhileEvenN )
    LifNotEvenNwhileEvenN.AddCoord( 1 , 604 , 513 )
    LifNotEvenNwhileEvenN.AddCoord( 2 , 603 , 397 )
    
    LifNotEvenNm3anOddInteger = SyrStruct_1.Link( OifNotEvenN , Im3anOddInteger )
    LifNotEvenNm3anOddInteger.AddCoord( 1 , 604 , 107 )
    LifNotEvenNm3anOddInteger.AddCoord( 2 , 604 , 395 )
    
    LifNotEvenKwhileEvenK = SyrStruct_1.Link( OifNotEvenK , IwhileEvenK )
    LifNotEvenKwhileEvenK.AddCoord( 1 , 621 , 544 )
    LifNotEvenKwhileEvenK.AddCoord( 2 , 622 , 426 )
    
    LifNotEvenKforiK = SyrStruct_1.Link( OifNotEvenK , IforiK )
    LifNotEvenKforiK.AddCoord( 1 , 622 , 275 )
    LifNotEvenKforiK.AddCoord( 2 , 622 , 426 )
    
    LifNotEvenDefaultEndOfifNotEvenDefault = SyrStruct_1.Link( OifNotEvenDefault , IEndOfifNotEvenDefault )
    LifNotEvenDefaultEndOfifNotEvenDefault.AddCoord( 1 , 1204 , 429 )
    LifNotEvenDefaultEndOfifNotEvenDefault.AddCoord( 2 , 1203 , 12 )
    LifNotEvenDefaultEndOfifNotEvenDefault.AddCoord( 3 , 581 , 13 )
    LifNotEvenDefaultEndOfifNotEvenDefault.AddCoord( 4 , 581 , 458 )
    
    LEndOfifNotEvenNEndOfwhileNotOneN = SyrStruct_1.Link( OEndOfifNotEvenN , IEndOfwhileNotOneN )
    
    LEndOfifNotEvenKEndOfwhileNotOneK = SyrStruct_1.Link( OEndOfifNotEvenK , IEndOfwhileNotOneK )
    
    # Input Ports of the graph
    #ISyrComponentaContainer = SyrComponent.GetInPort( 'aContainer' )
    #ISyrComponentaComponent = SyrComponent.GetInPort( 'aComponent' )
    #IforNN = forN.GetInPort( 'N' )
    #IforNK = forN.GetInPort( 'K' )
    #IforNmin = forN.GetInPort( 'min' )
    #IforNmax = forN.GetInPort( 'max' )
    #Iforii = fori.GetInPort( 'i' )
    
    # Output Ports of the graph
    #OEndOfforNN = EndOfforN.GetOutPort( 'N' )
    #OEndOfforNK = EndOfforN.GetOutPort( 'K' )
    #OEndOfforNSyrComponent = EndOfforN.GetOutPort( 'SyrComponent' )
    #OEndOfforNmin = EndOfforN.GetOutPort( 'min' )
    #OEndOfforNmax = EndOfforN.GetOutPort( 'max' )
    #OEndOfwhileNotOneSyrComponent = EndOfwhileNotOne.GetOutPort( 'SyrComponent' )
    #OEndOfwhileNotOneN = EndOfwhileNotOne.GetOutPort( 'N' )
    #OEndOfforii = EndOffori.GetOutPort( 'i' )
    #OEndOfwhileEvenSyrComponent = EndOfwhileEven.GetOutPort( 'SyrComponent' )
    return SyrStruct_1

# Graph creation of SyrStruct_1_1
def DefSyrStruct_1_1() :
    SyrStruct_1_1 = Graph( 'SyrStruct_1_1' )
    SyrStruct_1_1.SetCoupled( 'Macro_SyrStruct_1' )
    SyrStruct_1_1.SetName( 'SyrStruct_1_1' )
    SyrStruct_1_1.SetAuthor( 'JR' )
    SyrStruct_1_1.SetComment( 'Syracuse algorithm' )
    SyrStruct_1_1.Coords( 0 , 0 )
    
    # Creation of Factory Nodes
    
    m3 = SyrStruct_1_1.FNode( 'SyrComponent' , 'SyrComponent' , 'C_M3' )
    m3.SetName( 'm3' )
    m3.SetAuthor( '' )
    m3.SetContainer( 'localhost/FactoryServer' )
    m3.SetComment( 'C_M3 from SyrComponent' )
    m3.Coords( 672 , 28 )
    Im3anOddInteger = m3.GetInPort( 'anOddInteger' )
    Im3Gate = m3.GetInPort( 'Gate' )
    Om3anInteger = m3.GetOutPort( 'anInteger' )
    Om3Gate = m3.GetOutPort( 'Gate' )
    
    m3incr = SyrStruct_1_1.FNode( 'SyrComponent' , 'SyrComponent' , 'C_INCR' )
    m3incr.SetName( 'm3incr' )
    m3incr.SetAuthor( '' )
    m3incr.SetContainer( 'localhost/FactoryServer' )
    m3incr.SetComment( 'C_INCR from SyrComponent' )
    m3incr.Coords( 898 , 29 )
    Im3incraCount = m3incr.GetInPort( 'aCount' )
    Im3incrGate = m3incr.GetInPort( 'Gate' )
    Om3incraNewCount = m3incr.GetOutPort( 'aNewCount' )
    Om3incrGate = m3incr.GetOutPort( 'Gate' )
    
    incra = SyrStruct_1_1.FNode( 'SyrComponent' , 'SyrComponent' , 'C_INCR' )
    incra.SetName( 'incra' )
    incra.SetAuthor( '' )
    incra.SetContainer( 'localhost/FactoryServer' )
    incra.SetComment( 'C_INCR from SyrComponent' )
    incra.Coords( 803 , 195 )
    IincraaCount = incra.GetInPort( 'aCount' )
    IincraGate = incra.GetInPort( 'Gate' )
    OincraaNewCount = incra.GetOutPort( 'aNewCount' )
    OincraGate = incra.GetOutPort( 'Gate' )
    
    div2 = SyrStruct_1_1.FNode( 'SyrComponent' , 'SyrComponent' , 'C_DIV2' )
    div2.SetName( 'div2' )
    div2.SetAuthor( '' )
    div2.SetContainer( 'localhost/FactoryServer' )
    div2.SetComment( 'C_DIV2 from SyrComponent' )
    div2.Coords( 810 , 435 )
    Idiv2anEvenInteger = div2.GetInPort( 'anEvenInteger' )
    Idiv2Gate = div2.GetInPort( 'Gate' )
    Odiv2anInteger = div2.GetOutPort( 'anInteger' )
    Odiv2Gate = div2.GetOutPort( 'Gate' )
    
    incrb = SyrStruct_1_1.FNode( 'SyrComponent' , 'SyrComponent' , 'C_INCR' )
    incrb.SetName( 'incrb' )
    incrb.SetAuthor( '' )
    incrb.SetContainer( 'localhost/FactoryServer' )
    incrb.SetComment( 'C_INCR from SyrComponent' )
    incrb.Coords( 809 , 574 )
    IincrbaCount = incrb.GetInPort( 'aCount' )
    IincrbGate = incrb.GetInPort( 'Gate' )
    OincrbaNewCount = incrb.GetOutPort( 'aNewCount' )
    OincrbGate = incrb.GetOutPort( 'Gate' )
    
    # Creation of InLine Nodes
    PySyrComponent = []
    PySyrComponent.append( 'from LifeCycleCORBA import * ' )
    PySyrComponent.append( 'def SyrComponent( aContainer , aComponent ) : ' )
    PySyrComponent.append( '    orb = CORBA.ORB_init([], CORBA.ORB_ID) ' )
    PySyrComponent.append( '    lcc = LifeCycleCORBA(orb) ' )
    PySyrComponent.append( '    ComponentRef = lcc.FindOrLoadComponent( aContainer , aComponent ) ' )
    PySyrComponent.append( '    return ComponentRef ' )
    SyrComponent = SyrStruct_1_1.INode( 'SyrComponent' , PySyrComponent )
    SyrComponent.SetName( 'SyrComponent' )
    SyrComponent.SetAuthor( '' )
    SyrComponent.SetComment( 'SyrComponent( aContainer , aComponent )' )
    SyrComponent.Coords( 0 , 0 )
    ISyrComponentaContainer = SyrComponent.InPort( 'aContainer' , 'string' )
    ISyrComponentaComponent = SyrComponent.InPort( 'aComponent' , 'string' )
    ISyrComponentGate = SyrComponent.GetInPort( 'Gate' )
    OSyrComponentSyrComponentobjref = SyrComponent.OutPort( 'SyrComponentobjref' , 'objref' )
    OSyrComponentGate = SyrComponent.GetOutPort( 'Gate' )
    
    # Creation of Loop Nodes
    PyforN = []
    PyforN.append( 'def InitN( NN , K , SyrComponent , min , max ) : ' )
    PyforN.append( '    N = max ' )
    PyforN.append( '    if min > 0 : ' )
    PyforN.append( '        if max >= min : ' )
    PyforN.append( '            N = min ' )
    PyforN.append( '    return N,K,SyrComponent,min,max ' )
    PyMoreforN = []
    PyMoreforN.append( 'def MoreN( NN , KK , SyrComponent , min , max ) : ' )
    PyMoreforN.append( '    N = NN ' )
    PyMoreforN.append( '    OutLoop = 0 ' )
    PyMoreforN.append( '    if max > NN : ' )
    PyMoreforN.append( '        OutLoop = 1 ' )
    PyMoreforN.append( '    return OutLoop,N,0,SyrComponent,min,max ' )
    PyNextforN = []
    PyNextforN.append( 'def NextN( NN , KK , SyrComponent , min , max ) : ' )
    PyNextforN.append( '    N = NN + 1 ' )
    PyNextforN.append( '    K = KK ' )
    PyNextforN.append( '    return N,K,SyrComponent,min,max ' )
    forN,EndOfforN = SyrStruct_1_1.LNode( 'InitN' , PyforN , 'MoreN' , PyMoreforN , 'NextN' , PyNextforN )
    EndOfforN.SetName( 'EndOfforN' )
    EndOfforN.SetAuthor( '' )
    EndOfforN.SetComment( '' )
    EndOfforN.Coords( 1535 , 332 )
    PyEndOfforN = []
    EndOfforN.SetPyFunction( '' , PyEndOfforN )
    IforNDoLoop = forN.GetInPort( 'DoLoop' )
    IforNN = forN.InPort( 'N' , 'long' )
    IforNK = forN.InPort( 'K' , 'long' )
    IforNSyrComponent = forN.InPort( 'SyrComponent' , 'objref' )
    IforNmin = forN.InPort( 'min' , 'long' )
    IforNmax = forN.InPort( 'max' , 'long' )
    IforNGate = forN.GetInPort( 'Gate' )
    OforNDoLoop = forN.GetOutPort( 'DoLoop' )
    OforNN = forN.GetOutPort( 'N' )
    OforNK = forN.GetOutPort( 'K' )
    OforNSyrComponent = forN.GetOutPort( 'SyrComponent' )
    OforNmin = forN.GetOutPort( 'min' )
    OforNmax = forN.GetOutPort( 'max' )
    IEndOfforNDoLoop = EndOfforN.GetInPort( 'DoLoop' )
    IEndOfforNN = EndOfforN.GetInPort( 'N' )
    IEndOfforNK = EndOfforN.GetInPort( 'K' )
    IEndOfforNSyrComponent = EndOfforN.GetInPort( 'SyrComponent' )
    IEndOfforNmin = EndOfforN.GetInPort( 'min' )
    IEndOfforNmax = EndOfforN.GetInPort( 'max' )
    IEndOfforNGate = EndOfforN.GetInPort( 'Gate' )
    OEndOfforNDoLoop = EndOfforN.GetOutPort( 'DoLoop' )
    OEndOfforNN = EndOfforN.GetOutPort( 'N' )
    OEndOfforNK = EndOfforN.GetOutPort( 'K' )
    OEndOfforNSyrComponent = EndOfforN.GetOutPort( 'SyrComponent' )
    OEndOfforNmin = EndOfforN.GetOutPort( 'min' )
    OEndOfforNmax = EndOfforN.GetOutPort( 'max' )
    OEndOfforNGate = EndOfforN.GetOutPort( 'Gate' )
    forN.SetName( 'forN' )
    forN.SetAuthor( '' )
    forN.SetComment( 'InitN , MoreN , NextN' )
    forN.Coords( 20 , 302 )
    
    PywhileNotOne = []
    PywhileNotOne.append( 'import threading' )
    PywhileNotOne.append( 'import SyrComponent_idl' )
    PywhileNotOne.append( 'def InitNotOne( SyrComponent , N , K ) :' )
    PywhileNotOne.append( '    return SyrComponent,N,K' )
    PyMorewhileNotOne = []
    PyMorewhileNotOne.append( 'import SyrComponent_idl' )
    PyMorewhileNotOne.append( 'def MoreNotOne( SyrComponent , N , K ) :' )
    PyMorewhileNotOne.append( '    OutLoop = 1 - SyrComponent.C_ISONE( N )' )
    PyMorewhileNotOne.append( '    return OutLoop,SyrComponent,N,K ' )
    PyNextwhileNotOne = []
    PyNextwhileNotOne.append( 'import SyrComponent_idl' )
    PyNextwhileNotOne.append( 'def NextNotOne( SyrComponent , N , K ) :' )
    PyNextwhileNotOne.append( '    return SyrComponent,N,K' )
    whileNotOne,EndOfwhileNotOne = SyrStruct_1_1.LNode( 'InitNotOne' , PywhileNotOne , 'MoreNotOne' , PyMorewhileNotOne , 'NextNotOne' , PyNextwhileNotOne )
    EndOfwhileNotOne.SetName( 'EndOfwhileNotOne' )
    EndOfwhileNotOne.SetAuthor( '' )
    EndOfwhileNotOne.SetComment( '' )
    EndOfwhileNotOne.Coords( 1366 , 303 )
    PyEndOfwhileNotOne = []
    EndOfwhileNotOne.SetPyFunction( '' , PyEndOfwhileNotOne )
    IwhileNotOneDoLoop = whileNotOne.GetInPort( 'DoLoop' )
    IwhileNotOneSyrComponent = whileNotOne.InPort( 'SyrComponent' , 'objref' )
    IwhileNotOneN = whileNotOne.InPort( 'N' , 'long' )
    IwhileNotOneK = whileNotOne.InPort( 'K' , 'long' )
    IwhileNotOneGate = whileNotOne.GetInPort( 'Gate' )
    OwhileNotOneDoLoop = whileNotOne.GetOutPort( 'DoLoop' )
    OwhileNotOneSyrComponent = whileNotOne.GetOutPort( 'SyrComponent' )
    OwhileNotOneN = whileNotOne.GetOutPort( 'N' )
    OwhileNotOneK = whileNotOne.GetOutPort( 'K' )
    IEndOfwhileNotOneDoLoop = EndOfwhileNotOne.GetInPort( 'DoLoop' )
    IEndOfwhileNotOneSyrComponent = EndOfwhileNotOne.GetInPort( 'SyrComponent' )
    IEndOfwhileNotOneN = EndOfwhileNotOne.GetInPort( 'N' )
    IEndOfwhileNotOneK = EndOfwhileNotOne.GetInPort( 'K' )
    IEndOfwhileNotOneGate = EndOfwhileNotOne.GetInPort( 'Gate' )
    OEndOfwhileNotOneDoLoop = EndOfwhileNotOne.GetOutPort( 'DoLoop' )
    OEndOfwhileNotOneSyrComponent = EndOfwhileNotOne.GetOutPort( 'SyrComponent' )
    OEndOfwhileNotOneN = EndOfwhileNotOne.GetOutPort( 'N' )
    OEndOfwhileNotOneK = EndOfwhileNotOne.GetOutPort( 'K' )
    OEndOfwhileNotOneGate = EndOfwhileNotOne.GetOutPort( 'Gate' )
    whileNotOne.SetName( 'whileNotOne' )
    whileNotOne.SetAuthor( '' )
    whileNotOne.SetComment( 'InitNotOne , MoreNotOne , NextNotOne' )
    whileNotOne.Coords( 212 , 274 )
    
    Pyfori = []
    Pyfori.append( 'def Initfori( ii , K ) :' )
    Pyfori.append( '    return 1,0,K' )
    PyMorefori = []
    PyMorefori.append( 'def Morefori( ii , K ) :' )
    PyMorefori.append( '    OutLoop = 0' )
    PyMorefori.append( '    if 2 > ii :' )
    PyMorefori.append( '        OutLoop = 1' )
    PyMorefori.append( '    return OutLoop,ii,K' )
    PyNextfori = []
    PyNextfori.append( 'def Nextfori( ii , K ) :' )
    PyNextfori.append( '    ii = ii + 1' )
    PyNextfori.append( '    return ii,K' )
    fori,EndOffori = SyrStruct_1_1.LNode( 'Initfori' , Pyfori , 'Morefori' , PyMorefori , 'Nextfori' , PyNextfori )
    EndOffori.SetName( 'EndOffori' )
    EndOffori.SetAuthor( '' )
    EndOffori.SetComment( '' )
    EndOffori.Coords( 976 , 212 )
    PyEndOffori = []
    EndOffori.SetPyFunction( '' , PyEndOffori )
    IforiDoLoop = fori.GetInPort( 'DoLoop' )
    Iforii = fori.InPort( 'i' , 'long' )
    IforiK = fori.InPort( 'K' , 'long' )
    IforiGate = fori.GetInPort( 'Gate' )
    OforiDoLoop = fori.GetOutPort( 'DoLoop' )
    Oforii = fori.GetOutPort( 'i' )
    OforiK = fori.GetOutPort( 'K' )
    IEndOfforiDoLoop = EndOffori.GetInPort( 'DoLoop' )
    IEndOfforii = EndOffori.GetInPort( 'i' )
    IEndOfforiK = EndOffori.GetInPort( 'K' )
    IEndOfforiGate = EndOffori.GetInPort( 'Gate' )
    OEndOfforiDoLoop = EndOffori.GetOutPort( 'DoLoop' )
    OEndOfforii = EndOffori.GetOutPort( 'i' )
    OEndOfforiK = EndOffori.GetOutPort( 'K' )
    OEndOfforiGate = EndOffori.GetOutPort( 'Gate' )
    fori.SetName( 'fori' )
    fori.SetAuthor( '' )
    fori.SetComment( 'Initfori, Morefori, Nextfori' )
    fori.Coords( 635 , 212 )
    
    PywhileEven = []
    PywhileEven.append( 'import SyrComponent_idl' )
    PywhileEven.append( 'def InitEven( SyrComponent , N , K ) :' )
    PywhileEven.append( '    return SyrComponent,N,K' )
    PyMorewhileEven = []
    PyMorewhileEven.append( 'import SyrComponent_idl' )
    PyMorewhileEven.append( 'def MoreEven( SyrComponent , N , K ) :' )
    PyMorewhileEven.append( '    OutLoop = SyrComponent.C_ISEVEN( N )' )
    PyMorewhileEven.append( '    return OutLoop,SyrComponent,N,K ' )
    PyNextwhileEven = []
    PyNextwhileEven.append( 'import SyrComponent_idl' )
    PyNextwhileEven.append( 'def NextEven( SyrComponent , N , K ) :' )
    PyNextwhileEven.append( '    return SyrComponent,N,K' )
    whileEven,EndOfwhileEven = SyrStruct_1_1.LNode( 'InitEven' , PywhileEven , 'MoreEven' , PyMorewhileEven , 'NextEven' , PyNextwhileEven )
    EndOfwhileEven.SetName( 'EndOfwhileEven' )
    EndOfwhileEven.SetAuthor( '' )
    EndOfwhileEven.SetComment( '' )
    EndOfwhileEven.Coords( 988 , 451 )
    PyEndOfwhileEven = []
    EndOfwhileEven.SetPyFunction( '' , PyEndOfwhileEven )
    IwhileEvenDoLoop = whileEven.GetInPort( 'DoLoop' )
    IwhileEvenSyrComponent = whileEven.InPort( 'SyrComponent' , 'objref' )
    IwhileEvenN = whileEven.InPort( 'N' , 'long' )
    IwhileEvenK = whileEven.InPort( 'K' , 'long' )
    IwhileEvenGate = whileEven.GetInPort( 'Gate' )
    OwhileEvenDoLoop = whileEven.GetOutPort( 'DoLoop' )
    OwhileEvenSyrComponent = whileEven.GetOutPort( 'SyrComponent' )
    OwhileEvenN = whileEven.GetOutPort( 'N' )
    OwhileEvenK = whileEven.GetOutPort( 'K' )
    IEndOfwhileEvenDoLoop = EndOfwhileEven.GetInPort( 'DoLoop' )
    IEndOfwhileEvenSyrComponent = EndOfwhileEven.GetInPort( 'SyrComponent' )
    IEndOfwhileEvenN = EndOfwhileEven.GetInPort( 'N' )
    IEndOfwhileEvenK = EndOfwhileEven.GetInPort( 'K' )
    IEndOfwhileEvenGate = EndOfwhileEven.GetInPort( 'Gate' )
    OEndOfwhileEvenDoLoop = EndOfwhileEven.GetOutPort( 'DoLoop' )
    OEndOfwhileEvenSyrComponent = EndOfwhileEven.GetOutPort( 'SyrComponent' )
    OEndOfwhileEvenN = EndOfwhileEven.GetOutPort( 'N' )
    OEndOfwhileEvenK = EndOfwhileEven.GetOutPort( 'K' )
    OEndOfwhileEvenGate = EndOfwhileEven.GetOutPort( 'Gate' )
    whileEven.SetName( 'whileEven' )
    whileEven.SetAuthor( '' )
    whileEven.SetComment( 'InitEven, MoreEven, NextEven' )
    whileEven.Coords( 632 , 451 )
    
    # Creation of Switch Nodes
    PyifNotEven = []
    PyifNotEven.append( 'import SyrComponent_idl' )
    PyifNotEven.append( 'def ifNotEven( SyrComponent , N , K ) :' )
    PyifNotEven.append( '    Even = SyrComponent.C_ISEVEN( N )' )
    PyifNotEven.append( '    Odd = 1 - Even' )
    PyifNotEven.append( '    return Odd,Even,SyrComponent,N,K' )
    ifNotEven,EndOfifNotEven = SyrStruct_1_1.SNode( 'ifNotEven' , PyifNotEven )
    EndOfifNotEven.SetName( 'EndOfifNotEven' )
    EndOfifNotEven.SetAuthor( '' )
    EndOfifNotEven.SetComment( '' )
    EndOfifNotEven.Coords( 1205 , 331 )
    PyEndOfifNotEven = []
    EndOfifNotEven.SetPyFunction( '' , PyEndOfifNotEven )
    IEndOfifNotEvenN = EndOfifNotEven.InPort( 'N' , 'long' )
    IEndOfifNotEvenK = EndOfifNotEven.InPort( 'K' , 'long' )
    IEndOfifNotEvenDefault = EndOfifNotEven.GetInPort( 'Default' )
    OEndOfifNotEvenN = EndOfifNotEven.OutPort( 'N' , 'long' )
    OEndOfifNotEvenK = EndOfifNotEven.OutPort( 'K' , 'long' )
    OEndOfifNotEvenGate = EndOfifNotEven.GetOutPort( 'Gate' )
    ifNotEven.SetName( 'ifNotEven' )
    ifNotEven.SetAuthor( '' )
    ifNotEven.SetComment( 'ifNotEven' )
    ifNotEven.Coords( 418 , 274 )
    IifNotEvenSyrComponent = ifNotEven.InPort( 'SyrComponent' , 'objref' )
    IifNotEvenN = ifNotEven.InPort( 'N' , 'long' )
    IifNotEvenK = ifNotEven.InPort( 'K' , 'long' )
    IifNotEvenGate = ifNotEven.GetInPort( 'Gate' )
    OifNotEvenOdd = ifNotEven.OutPort( 'Odd' , 'long' )
    OifNotEvenEven = ifNotEven.OutPort( 'Even' , 'long' )
    OifNotEvenSyrComponent = ifNotEven.OutPort( 'SyrComponent' , 'objref' )
    OifNotEvenN = ifNotEven.OutPort( 'N' , 'long' )
    OifNotEvenK = ifNotEven.OutPort( 'K' , 'long' )
    OifNotEvenDefault = ifNotEven.GetOutPort( 'Default' )
    
    # Creation of Links
    Lm3anIntegerm3incraCount = SyrStruct_1_1.Link( Om3anInteger , Im3incraCount )
    
    Lm3incraNewCountEndOfifNotEvenN = SyrStruct_1_1.Link( Om3incraNewCount , IEndOfifNotEvenN )
    Lm3incraNewCountEndOfifNotEvenN.AddCoord( 1 , 1190 , 366 )
    Lm3incraNewCountEndOfifNotEvenN.AddCoord( 2 , 1191 , 109 )
    
    LincraaNewCountEndOfforiK = SyrStruct_1_1.Link( OincraaNewCount , IEndOfforiK )
    
    Ldiv2anIntegerEndOfwhileEvenN = SyrStruct_1_1.Link( Odiv2anInteger , IEndOfwhileEvenN )
    
    LincrbaNewCountEndOfwhileEvenK = SyrStruct_1_1.Link( OincrbaNewCount , IEndOfwhileEvenK )
    LincrbaNewCountEndOfwhileEvenK.AddCoord( 1 , 988 , 543 )
    LincrbaNewCountEndOfwhileEvenK.AddCoord( 2 , 988 , 654 )
    
    LSyrComponentSyrComponentobjrefforNSyrComponent = SyrStruct_1_1.Link( OSyrComponentSyrComponentobjref , IforNSyrComponent )
    LSyrComponentSyrComponentobjrefforNSyrComponent.AddCoord( 1 , 13 , 394 )
    LSyrComponentSyrComponentobjrefforNSyrComponent.AddCoord( 2 , 12 , 181 )
    LSyrComponentSyrComponentobjrefforNSyrComponent.AddCoord( 3 , 196 , 181 )
    LSyrComponentSyrComponentobjrefforNSyrComponent.AddCoord( 4 , 197 , 81 )
    
    LforNNwhileNotOneN = SyrStruct_1_1.Link( OforNN , IwhileNotOneN )
    
    LforNNEndOfforNN = SyrStruct_1_1.Link( OforNN , IEndOfforNN )
    
    LforNKwhileNotOneK = SyrStruct_1_1.Link( OforNK , IwhileNotOneK )
    
    LforNSyrComponentEndOfforNSyrComponent = SyrStruct_1_1.Link( OforNSyrComponent , IEndOfforNSyrComponent )
    
    LforNSyrComponentwhileNotOneSyrComponent = SyrStruct_1_1.Link( OforNSyrComponent , IwhileNotOneSyrComponent )
    LforNSyrComponentwhileNotOneSyrComponent.AddCoord( 1 , 192 , 309 )
    LforNSyrComponentwhileNotOneSyrComponent.AddCoord( 2 , 191 , 394 )
    
    LforNminEndOfforNmin = SyrStruct_1_1.Link( OforNmin , IEndOfforNmin )
    
    LforNmaxEndOfforNmax = SyrStruct_1_1.Link( OforNmax , IEndOfforNmax )
    
    LwhileNotOneSyrComponentEndOfwhileNotOneSyrComponent = SyrStruct_1_1.Link( OwhileNotOneSyrComponent , IEndOfwhileNotOneSyrComponent )
    
    LwhileNotOneSyrComponentifNotEvenSyrComponent = SyrStruct_1_1.Link( OwhileNotOneSyrComponent , IifNotEvenSyrComponent )
    
    LwhileNotOneNifNotEvenN = SyrStruct_1_1.Link( OwhileNotOneN , IifNotEvenN )
    
    LwhileNotOneKifNotEvenK = SyrStruct_1_1.Link( OwhileNotOneK , IifNotEvenK )
    
    LEndOfwhileNotOneKEndOfforNK = SyrStruct_1_1.Link( OEndOfwhileNotOneK , IEndOfforNK )
    
    LforiiEndOfforii = SyrStruct_1_1.Link( Oforii , IEndOfforii )
    
    LforiKincraaCount = SyrStruct_1_1.Link( OforiK , IincraaCount )
    
    LEndOfforiKEndOfifNotEvenK = SyrStruct_1_1.Link( OEndOfforiK , IEndOfifNotEvenK )
    LEndOfforiKEndOfifNotEvenK.AddCoord( 1 , 1170 , 396 )
    LEndOfforiKEndOfifNotEvenK.AddCoord( 2 , 1169 , 275 )
    
    LwhileEvenSyrComponentEndOfwhileEvenSyrComponent = SyrStruct_1_1.Link( OwhileEvenSyrComponent , IEndOfwhileEvenSyrComponent )
    
    LwhileEvenNdiv2anEvenInteger = SyrStruct_1_1.Link( OwhileEvenN , Idiv2anEvenInteger )
    
    LwhileEvenKincrbaCount = SyrStruct_1_1.Link( OwhileEvenK , IincrbaCount )
    LwhileEvenKincrbaCount.AddCoord( 1 , 796 , 655 )
    LwhileEvenKincrbaCount.AddCoord( 2 , 795 , 543 )
    
    LEndOfwhileEvenNEndOfifNotEvenN = SyrStruct_1_1.Link( OEndOfwhileEvenN , IEndOfifNotEvenN )
    LEndOfwhileEvenNEndOfifNotEvenN.AddCoord( 1 , 1191 , 366 )
    LEndOfwhileEvenNEndOfifNotEvenN.AddCoord( 2 , 1191 , 513 )
    
    LEndOfwhileEvenKEndOfifNotEvenK = SyrStruct_1_1.Link( OEndOfwhileEvenK , IEndOfifNotEvenK )
    LEndOfwhileEvenKEndOfifNotEvenK.AddCoord( 1 , 1169 , 395 )
    LEndOfwhileEvenKEndOfifNotEvenK.AddCoord( 2 , 1170 , 543 )
    
    LifNotEvenOddm3Gate = SyrStruct_1_1.Link( OifNotEvenOdd , Im3Gate )
    LifNotEvenOddm3Gate.AddCoord( 1 , 593 , 141 )
    LifNotEvenOddm3Gate.AddCoord( 2 , 593 , 307 )
    
    LifNotEvenOddforiGate = SyrStruct_1_1.Link( OifNotEvenOdd , IforiGate )
    
    LifNotEvenEvenwhileEvenGate = SyrStruct_1_1.Link( OifNotEvenEven , IwhileEvenGate )
    LifNotEvenEvenwhileEvenGate.AddCoord( 1 , 593 , 576 )
    LifNotEvenEvenwhileEvenGate.AddCoord( 2 , 592 , 339 )
    
    LifNotEvenSyrComponentwhileEvenSyrComponent = SyrStruct_1_1.Link( OifNotEvenSyrComponent , IwhileEvenSyrComponent )
    LifNotEvenSyrComponentwhileEvenSyrComponent.AddCoord( 1 , 586 , 486 )
    LifNotEvenSyrComponentwhileEvenSyrComponent.AddCoord( 2 , 587 , 367 )
    
    LifNotEvenNwhileEvenN = SyrStruct_1_1.Link( OifNotEvenN , IwhileEvenN )
    LifNotEvenNwhileEvenN.AddCoord( 1 , 604 , 513 )
    LifNotEvenNwhileEvenN.AddCoord( 2 , 603 , 397 )
    
    LifNotEvenNm3anOddInteger = SyrStruct_1_1.Link( OifNotEvenN , Im3anOddInteger )
    LifNotEvenNm3anOddInteger.AddCoord( 1 , 604 , 107 )
    LifNotEvenNm3anOddInteger.AddCoord( 2 , 604 , 395 )
    
    LifNotEvenKwhileEvenK = SyrStruct_1_1.Link( OifNotEvenK , IwhileEvenK )
    LifNotEvenKwhileEvenK.AddCoord( 1 , 621 , 544 )
    LifNotEvenKwhileEvenK.AddCoord( 2 , 622 , 426 )
    
    LifNotEvenKforiK = SyrStruct_1_1.Link( OifNotEvenK , IforiK )
    LifNotEvenKforiK.AddCoord( 1 , 622 , 275 )
    LifNotEvenKforiK.AddCoord( 2 , 622 , 426 )
    
    LifNotEvenDefaultEndOfifNotEvenDefault = SyrStruct_1_1.Link( OifNotEvenDefault , IEndOfifNotEvenDefault )
    LifNotEvenDefaultEndOfifNotEvenDefault.AddCoord( 1 , 1204 , 429 )
    LifNotEvenDefaultEndOfifNotEvenDefault.AddCoord( 2 , 1203 , 12 )
    LifNotEvenDefaultEndOfifNotEvenDefault.AddCoord( 3 , 581 , 13 )
    LifNotEvenDefaultEndOfifNotEvenDefault.AddCoord( 4 , 581 , 458 )
    
    LEndOfifNotEvenNEndOfwhileNotOneN = SyrStruct_1_1.Link( OEndOfifNotEvenN , IEndOfwhileNotOneN )
    
    LEndOfifNotEvenKEndOfwhileNotOneK = SyrStruct_1_1.Link( OEndOfifNotEvenK , IEndOfwhileNotOneK )
    
    # Input Ports of the graph
    #ISyrComponentaContainer = SyrComponent.GetInPort( 'aContainer' )
    #ISyrComponentaComponent = SyrComponent.GetInPort( 'aComponent' )
    #IforNN = forN.GetInPort( 'N' )
    #IforNK = forN.GetInPort( 'K' )
    #IforNmin = forN.GetInPort( 'min' )
    #IforNmax = forN.GetInPort( 'max' )
    #Iforii = fori.GetInPort( 'i' )
    
    # Output Ports of the graph
    #OEndOfforNN = EndOfforN.GetOutPort( 'N' )
    #OEndOfforNK = EndOfforN.GetOutPort( 'K' )
    #OEndOfforNSyrComponent = EndOfforN.GetOutPort( 'SyrComponent' )
    #OEndOfforNmin = EndOfforN.GetOutPort( 'min' )
    #OEndOfforNmax = EndOfforN.GetOutPort( 'max' )
    #OEndOfwhileNotOneSyrComponent = EndOfwhileNotOne.GetOutPort( 'SyrComponent' )
    #OEndOfwhileNotOneN = EndOfwhileNotOne.GetOutPort( 'N' )
    #OEndOfforii = EndOffori.GetOutPort( 'i' )
    #OEndOfwhileEvenSyrComponent = EndOfwhileEven.GetOutPort( 'SyrComponent' )
    return SyrStruct_1_1


GraphMacroNodes = DefGraphMacroNodes()
